/*
 * Decompiled with CFR 0.152.
 */
package multilizer;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import multilizer.FileDictionary;
import multilizer.StreamEventObject;
import multilizer.Translation;

public class BinaryDictionary
extends FileDictionary {
    private transient int version;
    private transient int byteOrder;
    private transient int languageCount;
    private transient int languageOffset;
    private transient int translationCount;
    private transient int translationOffset;
    private transient DataInputStream stream;

    public BinaryDictionary() {
        super(".mld");
    }

    private void openStream() throws Exception {
        Object object;
        if (this.translationStreamListener != null) {
            object = new StreamEventObject(this);
            this.translationStreamListener.getTranslationStream((StreamEventObject)object);
            this.stream = new DataInputStream(((StreamEventObject)object).getStream());
        } else {
            this.stream = new DataInputStream(new FileInputStream(this.getBundleFileName()));
        }
        try {
            object = new byte[3];
            this.stream.read((byte[])object);
            if (object[0] != 77 || object[1] != 76 || object[2] != 68) {
                throw new RuntimeException(String.valueOf(this.getBundleFileName()) + " is not a valid MLD file");
            }
            this.version = this.stream.readByte();
            this.byteOrder = this.stream.readByte();
            byte by = this.stream.readByte();
            if (by != 0) {
                throw new RuntimeException(String.valueOf(this.getBundleFileName()) + " is not a Unicode MLD file");
            }
            this.stream.skipBytes(6);
            this.languageCount = this.stream.readShort();
            this.languageOffset = this.stream.readInt();
            this.translationCount = this.stream.readShort();
            this.translationOffset = this.stream.readInt();
            this.stream.skipBytes(18);
            return;
        }
        catch (Exception exception) {
            this.stream.close();
            throw exception;
        }
    }

    private String readChars(int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            char c = this.stream.readChar();
            if (this.byteOrder == 1) {
                c = (char)((c & 0xFF) << 8 | (c & 0xFF00) >> 8);
            }
            cArray[n2] = c;
            ++n2;
        }
        return new String(cArray);
    }

    private String readString() throws IOException {
        return this.readChars(this.stream.readShort());
    }

    protected void loadTranslation() throws Exception {
        this.translations.removeAllElements();
        this.openStream();
        try {
            this.stream.skip(this.translationOffset - this.languageOffset);
            int n = 0;
            while (n < this.translationCount) {
                Translation translation = new Translation();
                translation.nativeStr = this.readChars(this.stream.readShort());
                translation.currentStr = this.readChars(this.stream.readShort());
                this.translations.addElement(translation);
                ++n;
            }
            this.sortTranslations(0, this.translations.size() - 1);
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.stream.close();
            throw throwable;
        }
        Object var2_3 = null;
        this.stream.close();
    }

    private void closeStream() throws IOException {
        this.stream.close();
    }
}

