/*
 * Decompiled with CFR 0.152.
 */
package multilizer;

import java.awt.Frame;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;
import multilizer.DictionaryEventObject;
import multilizer.DictionaryListener;
import multilizer.EvaluationDialog;
import multilizer.Language;

public abstract class Dictionary
implements Serializable {
    static final int TEST_C = 1;
    public static final int MT_USE_NATIVE = 0;
    public static final int MT_USE_EMPTY = 1;
    public static final int MT_TAG_NATIVE = 2;
    public static final int MT_THROW_EXCEPTION = 3;
    private transient Frame frame = new Frame();
    private transient boolean open = false;
    private transient Vector languageChangeListeners = new Vector();
    private transient Locale languageLocale = new Locale("", "");
    private transient Language languageData;
    private transient int activeLanguage;
    private transient Locale activeLocale = new Locale("", "");
    private boolean bindLocale = true;
    private boolean autoTranslate = true;
    private boolean checkLanguage = true;
    private boolean updateDefaultLocale = true;
    private int missingTranslation = 0;
    private int language = -1;
    private Locale locale = new Locale("", "");

    public boolean isLanguageEuropean() {
        return !this.isLanguageBidirectional() && !this.isLanguageFarEastern();
    }

    public boolean isLanguageBidirectional() {
        String string = this.languageData.language;
        return string.equalsIgnoreCase("ar") || string.equalsIgnoreCase("he") || string.equalsIgnoreCase("fa");
    }

    public boolean isLanguageFarEastern() {
        return this.isLanguageFarEastern(this.languageData.language);
    }

    private boolean isLanguageBidirectional(String string) {
        return string.equalsIgnoreCase("ar") || string.equalsIgnoreCase("he") || string.equalsIgnoreCase("fa");
    }

    private boolean isLanguageFarEastern(String string) {
        return string.equalsIgnoreCase("zh") || string.equalsIgnoreCase("ja") || string.equalsIgnoreCase("ko") || string.equalsIgnoreCase("th") || string.equalsIgnoreCase("vi");
    }

    private void initLanguage(int n) throws Exception {
        this.activeLanguage = n == -1 ? this.localeToLanguage(Locale.getDefault()) : n;
        if (this.activeLanguage == -1) {
            this.activeLanguage = this.getDefaultLanguage();
        }
        this.languageData = this.getLanguageData(this.activeLanguage);
        this.languageLocale = this.languageData.getLocale();
        Locale locale = this.languageData.getLocale();
        if (this.checkLanguage && !Dictionary.doesSystemSupportLocale(locale)) {
            throw new RuntimeException("The language (" + locale + ") is not supported by the system.");
        }
        String string = locale.getLanguage();
        if (string.equalsIgnoreCase("ar") || string.equalsIgnoreCase("he") || string.equalsIgnoreCase("fa") || false || this.isLanguageFarEastern(locale.getLanguage())) {
            this.activeLanguage = 0;
            this.languageData = null;
            throw new RuntimeException("The standard edition of Multilizer does not support " + locale.getDisplayLanguage(Locale.ENGLISH) + ".");
        }
        new EvaluationDialog(this.frame).show();
    }

    private void initLocale(Locale locale) {
        this.activeLocale = locale.toString().length() == 0 ? Locale.getDefault() : locale;
    }

    public void finalize() {
        if (this.open) {
            this.close();
        }
    }

    protected abstract String translateString(String var1);

    protected boolean doesSupportLocale(Locale locale) throws Exception {
        return locale.getLanguage().equals("") || this.localeToLanguage(locale) >= 0;
    }

    public static boolean doesSystemSupportLocale(Locale locale) {
        Locale[] localeArray = NumberFormat.getAvailableLocales();
        int n = 0;
        while (n < localeArray.length) {
            if (locale.equals(localeArray[n])) {
                return true;
            }
            ++n;
        }
        String string = locale.getLanguage();
        int n2 = 0;
        while (n2 < localeArray.length) {
            if (string.equals(localeArray[n2].getLanguage())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static Locale decodeLocale(Locale locale) {
        if (locale.toString().length() == 0) {
            return Locale.getDefault();
        }
        return locale;
    }

    protected int localeToLanguage(Locale locale) throws Exception {
        int n;
        if (locale.toString().length() == 0) {
            return this.getDefaultLanguage();
        }
        Language[] languageArray = this.getLanguageDatas();
        int n2 = 0;
        while (n2 < languageArray.length) {
            Language language = languageArray[n2];
            if (language.language.equals(locale.getLanguage())) {
                if (language.defaultCountry.equals(locale.getCountry())) {
                    return n2;
                }
                n = language.getCountryCount();
                int n3 = 0;
                while (n3 < n) {
                    if (locale.getCountry().equals(language.getCountry(n3))) {
                        return n2;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        int n4 = 0;
        while (n4 < languageArray.length) {
            Language language = languageArray[n4];
            if (language.language.equals(locale.getLanguage()) && language.getCountryCount() == 0) {
                return n4;
            }
            ++n4;
        }
        n = 0;
        while (n < languageArray.length) {
            Language language = languageArray[n];
            if (language.language.equals(locale.getLanguage())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected int getDefaultLanguage() throws Exception {
        String string = this.getLanguageData((int)0).language;
        if (string.length() == 0 || string.equals("  ")) {
            return 1;
        }
        return 0;
    }

    public void open() throws Exception {
        Locale locale;
        Locale locale2;
        if (this.open) {
            return;
        }
        this.initLanguage(this.language);
        this.activeLocale = this.bindLocale ? ((locale2 = this.languageData.getLocale()).toString().length() == 0 ? Locale.getDefault() : locale2) : ((locale = this.locale).toString().length() == 0 ? Locale.getDefault() : locale);
        this.languageChanged(true, true);
        this.open = true;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
        this.open = false;
    }

    public String translate(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.translateString(string);
        if (string2.length() > 0) {
            return string2;
        }
        switch (this.missingTranslation) {
            case 0: {
                return string;
            }
            case 1: {
                return "";
            }
            case 2: {
                return "@" + string + "@";
            }
        }
        throw new RuntimeException("Translation for the world '" + string + "' is missing");
    }

    public void setUpdateDefaultLocale(boolean bl) {
        this.updateDefaultLocale = bl;
    }

    public boolean getUpdateDefaultLocale() {
        return this.updateDefaultLocale;
    }

    public void setAutoTranslate(boolean bl) throws Exception {
        if (this.autoTranslate != bl) {
            this.autoTranslate = bl;
            if (this.autoTranslate) {
                this.setLanguage(this.language);
            }
        }
    }

    public boolean getAutoTranslate() {
        return this.autoTranslate;
    }

    public boolean getBidirectional() {
        String string = this.languageData.language;
        return string.equalsIgnoreCase("ar") || string.equalsIgnoreCase("he") || string.equalsIgnoreCase("fa");
    }

    public void setMissingTranslation(int n) {
        this.missingTranslation = n;
    }

    public int getMissingTranslation() {
        return this.missingTranslation;
    }

    public void setCheckLanguage(boolean bl) {
        this.checkLanguage = bl;
    }

    public boolean getCheckLanguage() {
        return this.checkLanguage;
    }

    public void setBindLocale(boolean bl) throws Exception {
        if (bl != this.bindLocale) {
            this.bindLocale = bl;
            if (this.bindLocale && this.isOpen()) {
                Locale locale = (Locale)this.activeLocale.clone();
                Locale locale2 = this.languageData.getLocale();
                Locale locale3 = this.activeLocale = locale2.toString().length() == 0 ? Locale.getDefault() : locale2;
                if (!this.activeLocale.equals(locale)) {
                    this.languageChanged(false, true);
                }
            }
        }
    }

    public boolean getBindLocale() {
        return this.bindLocale;
    }

    public void setLanguage(int n) throws Exception {
        if (!this.open) {
            this.language = n;
            return;
        }
        if (n < 0 || n >= this.getLanguageCount()) {
            throw new RuntimeException("Language index " + n + " is out of range");
        }
        if (n != this.language) {
            this.language = n;
            this.initLanguage(this.language);
            Locale locale = (Locale)this.activeLocale.clone();
            if (this.bindLocale) {
                Locale locale2 = this.languageData.getLocale();
                this.activeLocale = locale2.toString().length() == 0 ? Locale.getDefault() : locale2;
            }
            this.languageChanged(true, !locale.equals(this.activeLocale));
        }
    }

    public int getLanguage() {
        return this.language;
    }

    public int getActiveLanguage() {
        return this.activeLanguage;
    }

    public abstract int getLanguageCount() throws Exception;

    public abstract Language getLanguageData(int var1) throws Exception;

    public Language getLanguageData() {
        return this.languageData;
    }

    public Language[] getLanguageDatas() throws Exception {
        int n = this.getLanguageCount();
        Language[] languageArray = new Language[n];
        int n2 = 0;
        while (n2 < n) {
            languageArray[n2] = this.getLanguageData(n2);
            ++n2;
        }
        return languageArray;
    }

    public void setLocale(Locale locale) throws Exception {
        if (!this.open) {
            this.locale = locale;
            return;
        }
        this.locale = locale;
        Locale locale2 = this.locale;
        this.activeLocale = locale2.toString().length() == 0 ? Locale.getDefault() : locale2;
        int n = this.activeLanguage;
        if (this.bindLocale) {
            int n2 = this.localeToLanguage(this.activeLocale);
            if (n2 < 0) {
                this.initLanguage(this.getDefaultLanguage());
            } else {
                this.initLanguage(n2);
                this.languageLocale = this.activeLocale;
            }
        }
        this.languageChanged(n != this.activeLanguage, true);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Locale getActiveLocale() {
        return this.activeLocale;
    }

    public Locale getLanguageLocale() {
        return this.languageLocale;
    }

    public synchronized void addLanguageChangeListener(DictionaryListener dictionaryListener) {
        this.languageChangeListeners.addElement(dictionaryListener);
    }

    public synchronized void removeLanguageChangeListener(DictionaryListener dictionaryListener) {
        this.languageChangeListeners.removeElement(dictionaryListener);
    }

    protected void languageChanged(boolean bl, boolean bl2) throws Exception {
        Vector vector;
        if (bl2 && this.updateDefaultLocale) {
            Locale.setDefault(this.getActiveLocale());
        }
        DictionaryEventObject dictionaryEventObject = new DictionaryEventObject(this, bl, bl2);
        Dictionary dictionary = this;
        synchronized (dictionary) {
            vector = (Vector)this.languageChangeListeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            ((DictionaryListener)vector.elementAt(n)).languageChanged(dictionaryEventObject);
            ++n;
        }
    }
}

