/*
 * Decompiled with CFR 0.152.
 */
package multilizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.io.Serializable;
import multilizer.BidiBorderLayout;
import multilizer.BidiGridBagLayout;
import multilizer.Dictionary;
import multilizer.Translator;

public class BidiTranslator
extends Translator {
    protected static final int MAXGRIDSIZE = 512;
    private transient boolean mirrored = false;
    private boolean mirror = true;

    public BidiTranslator() {
    }

    public BidiTranslator(Dictionary dictionary) {
        super(dictionary);
    }

    private void mirrorNullLayout(Container container) {
        int n = container.getBounds().width;
        int n2 = container.getComponentCount();
        int n3 = 0;
        while (n3 < n2) {
            Component component = container.getComponent(n3);
            Point point = component.getLocation();
            component.setLocation(n - point.x - component.getSize().width, point.y);
            ++n3;
        }
    }

    private void mirrorFlowLayout(FlowLayout flowLayout, Container container) {
        int n = container.getComponentCount();
        Component[] componentArray = new Component[n];
        int n2 = 0;
        while (n2 < n) {
            componentArray[n2] = container.getComponent(n2);
            ++n2;
        }
        container.removeAll();
        int n3 = n - 1;
        while (n3 >= 0) {
            container.add(componentArray[n3]);
            --n3;
        }
        switch (flowLayout.getAlignment()) {
            case 0: {
                flowLayout.setAlignment(2);
                return;
            }
            case 2: {
                flowLayout.setAlignment(0);
                return;
            }
        }
    }

    private void mirrorGridLayout(GridLayout gridLayout, Container container) {
        int n = gridLayout.getColumns();
        if (n <= 1) {
            return;
        }
        int n2 = container.getComponentCount();
        Component[] componentArray = new Component[n2];
        int n3 = 0;
        while (n3 < n2) {
            componentArray[n3] = container.getComponent(n3);
            ++n3;
        }
        container.removeAll();
        int n4 = gridLayout.getRows();
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n - 1;
            while (n6 >= 0) {
                int n7 = n5 * n + n6;
                if (n7 < n2) {
                    container.add(componentArray[n7]);
                }
                --n6;
            }
            ++n5;
        }
    }

    private void mirrorGridBagLayout(GridBagLayout gridBagLayout, Container container) {
        Serializable serializable;
        int[] nArray = new int[512];
        int[] nArray2 = new int[512];
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        Component[] componentArray = container.getComponents();
        int n5 = 0;
        while (n5 < componentArray.length) {
            Component component = componentArray[n5];
            if (component.isVisible()) {
                int n6;
                serializable = gridBagLayout.getConstraints(component);
                int n7 = ((GridBagConstraints)serializable).gridx;
                int n8 = ((GridBagConstraints)serializable).gridy;
                int n9 = ((GridBagConstraints)serializable).gridwidth;
                if (n9 <= 0) {
                    n9 = 1;
                }
                if ((n6 = ((GridBagConstraints)serializable).gridheight) <= 0) {
                    n6 = 1;
                }
                if (n7 < 0 && n8 < 0) {
                    throw new RuntimeException("The constraint position is not absolute");
                }
                int n10 = n7 + n9;
                while (n3 < n10) {
                    ++n3;
                }
                int n11 = n8 + n6;
                while (n4 < n11) {
                    ++n4;
                }
                int n12 = n7;
                while (n12 < n7 + n9) {
                    nArray2[n12] = n11;
                    ++n12;
                }
                int n13 = n8;
                while (n13 < n8 + n6) {
                    nArray[n13] = n10;
                    ++n13;
                }
                if (((GridBagConstraints)serializable).gridheight == 0 && ((GridBagConstraints)serializable).gridwidth == 0) {
                    n2 = -1;
                    n = -1;
                }
                if (((GridBagConstraints)serializable).gridheight == 0 && n < 0) {
                    n2 = n7 + n9;
                } else if (((GridBagConstraints)serializable).gridwidth == 0 && n2 < 0) {
                    n = n8 + n6;
                }
            }
            ++n5;
        }
        int n14 = 0;
        while (n14 < componentArray.length) {
            serializable = componentArray[n14];
            GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints((Component)serializable);
            if (gridBagConstraints != null) {
                gridBagConstraints.gridx = n3 - gridBagConstraints.gridx - 1;
                switch (gridBagConstraints.anchor) {
                    case 12: {
                        gridBagConstraints.anchor = 18;
                        break;
                    }
                    case 18: {
                        gridBagConstraints.anchor = 12;
                        break;
                    }
                    case 13: {
                        gridBagConstraints.anchor = 17;
                        break;
                    }
                    case 17: {
                        gridBagConstraints.anchor = 13;
                        break;
                    }
                    case 14: {
                        gridBagConstraints.anchor = 16;
                        break;
                    }
                    case 16: {
                        gridBagConstraints.anchor = 14;
                    }
                }
                gridBagLayout.setConstraints((Component)serializable, gridBagConstraints);
            }
            ++n14;
        }
    }

    protected void checkLayout(Container container) {
        if (this.mirror && this.mirrored != this.getDictionary().getBidirectional()) {
            this.mirrorContainer(container);
        }
    }

    protected void hostTranslated() {
        this.mirrored = this.getDictionary().getBidirectional();
    }

    protected void mirrorContainer(Container container) {
        if (container.getLayout() == null) {
            this.mirrorNullLayout(container);
            return;
        }
        if (container.getLayout() instanceof BidiBorderLayout) {
            ((BidiBorderLayout)container.getLayout()).mirror();
            return;
        }
        if (container.getLayout() instanceof BidiGridBagLayout) {
            ((BidiGridBagLayout)container.getLayout()).mirror(container);
            return;
        }
        if (container.getLayout() instanceof FlowLayout) {
            this.mirrorFlowLayout((FlowLayout)container.getLayout(), container);
            return;
        }
        if (container.getLayout() instanceof GridLayout) {
            this.mirrorGridLayout((GridLayout)container.getLayout(), container);
            return;
        }
        if (container.getLayout() instanceof GridBagLayout) {
            this.mirrorGridBagLayout((GridBagLayout)container.getLayout(), container);
        }
    }

    public void setMirror(boolean bl) {
        this.mirror = bl;
    }

    public boolean getMirror() {
        return this.mirror;
    }
}

