/*
 * Decompiled with CFR 0.152.
 */
package multilizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;
import multilizer.BidiGridBagConstraints;
import multilizer.BidiGridBagLayoutInfo;

public class BidiGridBagLayout
implements LayoutManager2,
Serializable {
    protected static final int MAXGRIDSIZE = 512;
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    protected Hashtable comptable = new Hashtable();
    protected BidiGridBagConstraints defaultConstraints = new BidiGridBagConstraints();
    protected BidiGridBagLayoutInfo layoutInfo;
    protected boolean leftToRight = true;
    public int[] columnWidths;
    public int[] rowHeights;
    public double[] columnWeights;
    public double[] rowWeights;

    public void mirror(Container container) {
        this.leftToRight = !this.leftToRight;
        this.ArrangeGrid(container);
    }

    public void setConstraints(Component component, BidiGridBagConstraints bidiGridBagConstraints) {
        this.comptable.put(component, bidiGridBagConstraints.clone());
    }

    public BidiGridBagConstraints getConstraints(Component component) {
        BidiGridBagConstraints bidiGridBagConstraints = (BidiGridBagConstraints)this.comptable.get(component);
        if (bidiGridBagConstraints == null) {
            this.setConstraints(component, this.defaultConstraints);
            bidiGridBagConstraints = (BidiGridBagConstraints)this.comptable.get(component);
        }
        return (BidiGridBagConstraints)bidiGridBagConstraints.clone();
    }

    protected BidiGridBagConstraints lookupConstraints(Component component) {
        BidiGridBagConstraints bidiGridBagConstraints = (BidiGridBagConstraints)this.comptable.get(component);
        if (bidiGridBagConstraints == null) {
            this.setConstraints(component, this.defaultConstraints);
            bidiGridBagConstraints = (BidiGridBagConstraints)this.comptable.get(component);
        }
        return bidiGridBagConstraints;
    }

    public Point getLayoutOrigin() {
        Point point = new Point(0, 0);
        if (this.layoutInfo != null) {
            point.x = this.layoutInfo.startx;
            point.y = this.layoutInfo.starty;
        }
        return point;
    }

    public int[][] getLayoutDimensions() {
        if (this.layoutInfo == null) {
            return new int[2][0];
        }
        int[][] nArray = new int[][]{new int[this.layoutInfo.width], new int[this.layoutInfo.height]};
        System.arraycopy(this.layoutInfo.minWidth, 0, nArray[0], 0, this.layoutInfo.width);
        System.arraycopy(this.layoutInfo.minHeight, 0, nArray[1], 0, this.layoutInfo.height);
        return nArray;
    }

    public double[][] getLayoutWeights() {
        if (this.layoutInfo == null) {
            return new double[2][0];
        }
        double[][] dArray = new double[][]{new double[this.layoutInfo.width], new double[this.layoutInfo.height]};
        System.arraycopy(this.layoutInfo.weightX, 0, dArray[0], 0, this.layoutInfo.width);
        System.arraycopy(this.layoutInfo.weightY, 0, dArray[1], 0, this.layoutInfo.height);
        return dArray;
    }

    public Point location(int n, int n2) {
        Point point = new Point(0, 0);
        if (this.layoutInfo == null) {
            return point;
        }
        int n3 = this.layoutInfo.startx;
        int n4 = 0;
        while (n4 < this.layoutInfo.width) {
            if ((n3 += this.layoutInfo.minWidth[n4]) > n) break;
            ++n4;
        }
        point.x = n4;
        n3 = this.layoutInfo.starty;
        n4 = 0;
        while (n4 < this.layoutInfo.height) {
            if ((n3 += this.layoutInfo.minHeight[n4]) > n2) break;
            ++n4;
        }
        point.y = n4;
        return point;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof BidiGridBagConstraints) {
            this.setConstraints(component, (BidiGridBagConstraints)object);
            return;
        }
        if (object != null) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a BidiGridBagConstraint");
        }
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        BidiGridBagLayoutInfo bidiGridBagLayoutInfo = this.GetLayoutInfo(container, 2);
        return this.GetMinSize(container, bidiGridBagLayoutInfo);
    }

    public Dimension minimumLayoutSize(Container container) {
        BidiGridBagLayoutInfo bidiGridBagLayoutInfo = this.GetLayoutInfo(container, 1);
        return this.GetMinSize(container, bidiGridBagLayoutInfo);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        this.ArrangeGrid(container);
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected BidiGridBagLayoutInfo GetLayoutInfo(Container container, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        BidiGridBagConstraints bidiGridBagConstraints;
        Component component;
        BidiGridBagLayoutInfo bidiGridBagLayoutInfo = new BidiGridBagLayoutInfo();
        Component[] componentArray = container.getComponents();
        bidiGridBagLayoutInfo.height = 0;
        bidiGridBagLayoutInfo.width = 0;
        int n9 = -1;
        int n10 = -1;
        int[] nArray = new int[512];
        int[] nArray2 = new int[512];
        int n11 = 0;
        while (n11 < componentArray.length) {
            component = componentArray[n11];
            if (component.isVisible()) {
                bidiGridBagConstraints = this.lookupConstraints(component);
                n8 = bidiGridBagConstraints.gridx;
                n7 = bidiGridBagConstraints.gridy;
                n6 = bidiGridBagConstraints.gridwidth;
                if (n6 <= 0) {
                    n6 = 1;
                }
                if ((n5 = bidiGridBagConstraints.gridheight) <= 0) {
                    n5 = 1;
                }
                if (n8 < 0 && n7 < 0) {
                    if (n10 >= 0) {
                        n7 = n10;
                    } else if (n9 >= 0) {
                        n8 = n9;
                    } else {
                        n7 = 0;
                    }
                }
                if (n8 < 0) {
                    n4 = 0;
                    n3 = n7;
                    while (n3 < n7 + n5) {
                        n4 = Math.max(n4, nArray[n3]);
                        ++n3;
                    }
                    if ((n8 = n4 - n8 - 1) < 0) {
                        n8 = 0;
                    }
                } else if (n7 < 0) {
                    n2 = 0;
                    n3 = n8;
                    while (n3 < n8 + n6) {
                        n2 = Math.max(n2, nArray2[n3]);
                        ++n3;
                    }
                    if ((n7 = n2 - n7 - 1) < 0) {
                        n7 = 0;
                    }
                }
                n4 = n8 + n6;
                while (bidiGridBagLayoutInfo.width < n4) {
                    ++bidiGridBagLayoutInfo.width;
                }
                n2 = n7 + n5;
                while (bidiGridBagLayoutInfo.height < n2) {
                    ++bidiGridBagLayoutInfo.height;
                }
                n3 = n8;
                while (n3 < n8 + n6) {
                    nArray2[n3] = n2;
                    ++n3;
                }
                n3 = n7;
                while (n3 < n7 + n5) {
                    nArray[n3] = n4;
                    ++n3;
                }
                Dimension dimension = n == 2 ? component.getPreferredSize() : component.getMinimumSize();
                bidiGridBagConstraints.minWidth = dimension.width;
                bidiGridBagConstraints.minHeight = dimension.height;
                if (bidiGridBagConstraints.gridheight == 0 && bidiGridBagConstraints.gridwidth == 0) {
                    n9 = -1;
                    n10 = -1;
                }
                if (bidiGridBagConstraints.gridheight == 0 && n10 < 0) {
                    n9 = n8 + n6;
                } else if (bidiGridBagConstraints.gridwidth == 0 && n9 < 0) {
                    n10 = n7 + n5;
                }
            }
            ++n11;
        }
        if (this.columnWidths != null && bidiGridBagLayoutInfo.width < this.columnWidths.length) {
            bidiGridBagLayoutInfo.width = this.columnWidths.length;
        }
        if (this.rowHeights != null && bidiGridBagLayoutInfo.height < this.rowHeights.length) {
            bidiGridBagLayoutInfo.height = this.rowHeights.length;
        }
        n9 = -1;
        n10 = -1;
        nArray = new int[512];
        nArray2 = new int[512];
        n11 = 0;
        while (n11 < componentArray.length) {
            component = componentArray[n11];
            if (component.isVisible()) {
                bidiGridBagConstraints = this.lookupConstraints(component);
                n8 = bidiGridBagConstraints.gridx;
                n7 = bidiGridBagConstraints.gridy;
                n6 = bidiGridBagConstraints.gridwidth;
                n5 = bidiGridBagConstraints.gridheight;
                if (n8 < 0 && n7 < 0) {
                    if (n10 >= 0) {
                        n7 = n10;
                    } else if (n9 >= 0) {
                        n8 = n9;
                    } else {
                        n7 = 0;
                    }
                }
                if (n8 < 0) {
                    if (n5 <= 0 && (n5 += bidiGridBagLayoutInfo.height - n7) < 1) {
                        n5 = 1;
                    }
                    n4 = 0;
                    n3 = n7;
                    while (n3 < n7 + n5) {
                        n4 = Math.max(n4, nArray[n3]);
                        ++n3;
                    }
                    if ((n8 = n4 - n8 - 1) < 0) {
                        n8 = 0;
                    }
                } else if (n7 < 0) {
                    if (n6 <= 0 && (n6 += bidiGridBagLayoutInfo.width - n8) < 1) {
                        n6 = 1;
                    }
                    n2 = 0;
                    n3 = n8;
                    while (n3 < n8 + n6) {
                        n2 = Math.max(n2, nArray2[n3]);
                        ++n3;
                    }
                    if ((n7 = n2 - n7 - 1) < 0) {
                        n7 = 0;
                    }
                }
                if (n6 <= 0 && (n6 += bidiGridBagLayoutInfo.width - n8) < 1) {
                    n6 = 1;
                }
                if (n5 <= 0 && (n5 += bidiGridBagLayoutInfo.height - n7) < 1) {
                    n5 = 1;
                }
                n4 = n8 + n6;
                n2 = n7 + n5;
                n3 = n8;
                while (n3 < n8 + n6) {
                    nArray2[n3] = n2;
                    ++n3;
                }
                n3 = n7;
                while (n3 < n7 + n5) {
                    nArray[n3] = n4;
                    ++n3;
                }
                if (bidiGridBagConstraints.gridheight == 0 && bidiGridBagConstraints.gridwidth == 0) {
                    n9 = -1;
                    n10 = -1;
                }
                if (bidiGridBagConstraints.gridheight == 0 && n10 < 0) {
                    n9 = n8 + n6;
                } else if (bidiGridBagConstraints.gridwidth == 0 && n9 < 0) {
                    n10 = n7 + n5;
                }
                bidiGridBagConstraints.tempX = n8;
                bidiGridBagConstraints.tempY = n7;
                bidiGridBagConstraints.tempWidth = n6;
                bidiGridBagConstraints.tempHeight = n5;
            }
            ++n11;
        }
        if (this.columnWidths != null) {
            System.arraycopy(this.columnWidths, 0, bidiGridBagLayoutInfo.minWidth, 0, this.columnWidths.length);
        }
        if (this.rowHeights != null) {
            System.arraycopy(this.rowHeights, 0, bidiGridBagLayoutInfo.minHeight, 0, this.rowHeights.length);
        }
        if (this.columnWeights != null) {
            System.arraycopy(this.columnWeights, 0, bidiGridBagLayoutInfo.weightX, 0, this.columnWeights.length);
        }
        if (this.rowWeights != null) {
            System.arraycopy(this.rowWeights, 0, bidiGridBagLayoutInfo.weightY, 0, this.rowWeights.length);
        }
        int n12 = Integer.MAX_VALUE;
        n3 = 1;
        while (n3 != Integer.MAX_VALUE) {
            n11 = 0;
            while (n11 < componentArray.length) {
                component = componentArray[n11];
                if (component.isVisible()) {
                    int n13;
                    double d;
                    double d2;
                    double d3;
                    int n14;
                    double d4;
                    bidiGridBagConstraints = this.lookupConstraints(component);
                    if (bidiGridBagConstraints.tempWidth == n3) {
                        n4 = bidiGridBagConstraints.tempX + bidiGridBagConstraints.tempWidth;
                        d4 = bidiGridBagConstraints.weightx;
                        n14 = bidiGridBagConstraints.tempX;
                        while (n14 < n4) {
                            d4 -= bidiGridBagLayoutInfo.weightX[n14];
                            ++n14;
                        }
                        if (d4 > 0.0) {
                            d3 = 0.0;
                            n14 = bidiGridBagConstraints.tempX;
                            while (n14 < n4) {
                                d3 += bidiGridBagLayoutInfo.weightX[n14];
                                ++n14;
                            }
                            n14 = bidiGridBagConstraints.tempX;
                            while (d3 > 0.0 && n14 < n4) {
                                d2 = bidiGridBagLayoutInfo.weightX[n14];
                                d = d2 * d4 / d3;
                                int n15 = n14++;
                                bidiGridBagLayoutInfo.weightX[n15] = bidiGridBagLayoutInfo.weightX[n15] + d;
                                d4 -= d;
                                d3 -= d2;
                            }
                            int n16 = n4 - 1;
                            bidiGridBagLayoutInfo.weightX[n16] = bidiGridBagLayoutInfo.weightX[n16] + d4;
                        }
                        n13 = bidiGridBagConstraints.minWidth + bidiGridBagConstraints.ipadx + bidiGridBagConstraints.insets.left + bidiGridBagConstraints.insets.right;
                        n14 = bidiGridBagConstraints.tempX;
                        while (n14 < n4) {
                            n13 -= bidiGridBagLayoutInfo.minWidth[n14];
                            ++n14;
                        }
                        if (n13 > 0) {
                            d3 = 0.0;
                            n14 = bidiGridBagConstraints.tempX;
                            while (n14 < n4) {
                                d3 += bidiGridBagLayoutInfo.weightX[n14];
                                ++n14;
                            }
                            n14 = bidiGridBagConstraints.tempX;
                            while (d3 > 0.0 && n14 < n4) {
                                d2 = bidiGridBagLayoutInfo.weightX[n14];
                                int n17 = (int)(d2 * (double)n13 / d3);
                                int n18 = n14++;
                                bidiGridBagLayoutInfo.minWidth[n18] = bidiGridBagLayoutInfo.minWidth[n18] + n17;
                                n13 -= n17;
                                d3 -= d2;
                            }
                            int n19 = n4 - 1;
                            bidiGridBagLayoutInfo.minWidth[n19] = bidiGridBagLayoutInfo.minWidth[n19] + n13;
                        }
                    } else if (bidiGridBagConstraints.tempWidth > n3 && bidiGridBagConstraints.tempWidth < n12) {
                        n12 = bidiGridBagConstraints.tempWidth;
                    }
                    if (bidiGridBagConstraints.tempHeight == n3) {
                        n2 = bidiGridBagConstraints.tempY + bidiGridBagConstraints.tempHeight;
                        d4 = bidiGridBagConstraints.weighty;
                        n14 = bidiGridBagConstraints.tempY;
                        while (n14 < n2) {
                            d4 -= bidiGridBagLayoutInfo.weightY[n14];
                            ++n14;
                        }
                        if (d4 > 0.0) {
                            d3 = 0.0;
                            n14 = bidiGridBagConstraints.tempY;
                            while (n14 < n2) {
                                d3 += bidiGridBagLayoutInfo.weightY[n14];
                                ++n14;
                            }
                            n14 = bidiGridBagConstraints.tempY;
                            while (d3 > 0.0 && n14 < n2) {
                                d2 = bidiGridBagLayoutInfo.weightY[n14];
                                d = d2 * d4 / d3;
                                int n20 = n14++;
                                bidiGridBagLayoutInfo.weightY[n20] = bidiGridBagLayoutInfo.weightY[n20] + d;
                                d4 -= d;
                                d3 -= d2;
                            }
                            int n21 = n2 - 1;
                            bidiGridBagLayoutInfo.weightY[n21] = bidiGridBagLayoutInfo.weightY[n21] + d4;
                        }
                        n13 = bidiGridBagConstraints.minHeight + bidiGridBagConstraints.ipady + bidiGridBagConstraints.insets.top + bidiGridBagConstraints.insets.bottom;
                        n14 = bidiGridBagConstraints.tempY;
                        while (n14 < n2) {
                            n13 -= bidiGridBagLayoutInfo.minHeight[n14];
                            ++n14;
                        }
                        if (n13 > 0) {
                            d3 = 0.0;
                            n14 = bidiGridBagConstraints.tempY;
                            while (n14 < n2) {
                                d3 += bidiGridBagLayoutInfo.weightY[n14];
                                ++n14;
                            }
                            n14 = bidiGridBagConstraints.tempY;
                            while (d3 > 0.0 && n14 < n2) {
                                d2 = bidiGridBagLayoutInfo.weightY[n14];
                                int n22 = (int)(d2 * (double)n13 / d3);
                                int n23 = n14++;
                                bidiGridBagLayoutInfo.minHeight[n23] = bidiGridBagLayoutInfo.minHeight[n23] + n22;
                                n13 -= n22;
                                d3 -= d2;
                            }
                            int n24 = n2 - 1;
                            bidiGridBagLayoutInfo.minHeight[n24] = bidiGridBagLayoutInfo.minHeight[n24] + n13;
                        }
                    } else if (bidiGridBagConstraints.tempHeight > n3 && bidiGridBagConstraints.tempHeight < n12) {
                        n12 = bidiGridBagConstraints.tempHeight;
                    }
                }
                ++n11;
            }
            n3 = n12;
            n12 = Integer.MAX_VALUE;
        }
        return bidiGridBagLayoutInfo;
    }

    protected void AdjustForGravity(BidiGridBagConstraints bidiGridBagConstraints, Rectangle rectangle) {
        rectangle.x += bidiGridBagConstraints.insets.left;
        rectangle.width -= bidiGridBagConstraints.insets.left + bidiGridBagConstraints.insets.right;
        rectangle.y += bidiGridBagConstraints.insets.top;
        rectangle.height -= bidiGridBagConstraints.insets.top + bidiGridBagConstraints.insets.bottom;
        int n = 0;
        if (bidiGridBagConstraints.fill != 2 && bidiGridBagConstraints.fill != 1 && rectangle.width > bidiGridBagConstraints.minWidth + bidiGridBagConstraints.ipadx) {
            n = rectangle.width - (bidiGridBagConstraints.minWidth + bidiGridBagConstraints.ipadx);
            rectangle.width = bidiGridBagConstraints.minWidth + bidiGridBagConstraints.ipadx;
        }
        int n2 = 0;
        if (bidiGridBagConstraints.fill != 3 && bidiGridBagConstraints.fill != 1 && rectangle.height > bidiGridBagConstraints.minHeight + bidiGridBagConstraints.ipady) {
            n2 = rectangle.height - (bidiGridBagConstraints.minHeight + bidiGridBagConstraints.ipady);
            rectangle.height = bidiGridBagConstraints.minHeight + bidiGridBagConstraints.ipady;
        }
        switch (bidiGridBagConstraints.anchor) {
            case 10: {
                rectangle.x += n / 2;
                rectangle.y += n2 / 2;
                return;
            }
            case 11: {
                rectangle.x += n / 2;
                return;
            }
            case 12: {
                rectangle.x += n;
                return;
            }
            case 13: {
                rectangle.x += n;
                rectangle.y += n2 / 2;
                return;
            }
            case 14: {
                rectangle.x += n;
                rectangle.y += n2;
                return;
            }
            case 15: {
                rectangle.x += n / 2;
                rectangle.y += n2;
                return;
            }
            case 16: {
                rectangle.y += n2;
                return;
            }
            case 17: {
                rectangle.y += n2 / 2;
                return;
            }
            default: {
                throw new IllegalArgumentException("illegal anchor value");
            }
            case 18: 
        }
    }

    protected Dimension GetMinSize(Container container, BidiGridBagLayoutInfo bidiGridBagLayoutInfo) {
        Dimension dimension = new Dimension();
        Insets insets = container.getInsets();
        int n = 0;
        int n2 = 0;
        while (n2 < bidiGridBagLayoutInfo.width) {
            n += bidiGridBagLayoutInfo.minWidth[n2];
            ++n2;
        }
        dimension.width = n + insets.left + insets.right;
        n = 0;
        n2 = 0;
        while (n2 < bidiGridBagLayoutInfo.height) {
            n += bidiGridBagLayoutInfo.minHeight[n2];
            ++n2;
        }
        dimension.height = n + insets.top + insets.bottom;
        return dimension;
    }

    protected void ArrangeGrid(Container container) {
        int n;
        int n2;
        double d;
        Insets insets = container.getInsets();
        Component[] componentArray = container.getComponents();
        Rectangle rectangle = new Rectangle();
        if (!(componentArray.length != 0 || this.columnWidths != null && this.columnWidths.length != 0 || this.rowHeights != null && this.rowHeights.length != 0)) {
            return;
        }
        BidiGridBagLayoutInfo bidiGridBagLayoutInfo = this.GetLayoutInfo(container, 2);
        Dimension dimension = this.GetMinSize(container, bidiGridBagLayoutInfo);
        Dimension dimension2 = container.getSize();
        if (dimension2.width < dimension.width || dimension2.height < dimension.height) {
            bidiGridBagLayoutInfo = this.GetLayoutInfo(container, 1);
            dimension = this.GetMinSize(container, bidiGridBagLayoutInfo);
        }
        this.layoutInfo = bidiGridBagLayoutInfo;
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        int n3 = dimension2.width - rectangle.width;
        if (n3 != 0) {
            d = 0.0;
            n2 = 0;
            while (n2 < bidiGridBagLayoutInfo.width) {
                d += bidiGridBagLayoutInfo.weightX[n2];
                ++n2;
            }
            if (d > 0.0) {
                n2 = 0;
                while (n2 < bidiGridBagLayoutInfo.width) {
                    n = (int)((double)n3 * bidiGridBagLayoutInfo.weightX[n2] / d);
                    int n4 = n2;
                    bidiGridBagLayoutInfo.minWidth[n4] = bidiGridBagLayoutInfo.minWidth[n4] + n;
                    rectangle.width += n;
                    if (bidiGridBagLayoutInfo.minWidth[n2] < 0) {
                        rectangle.width -= bidiGridBagLayoutInfo.minWidth[n2];
                        bidiGridBagLayoutInfo.minWidth[n2] = 0;
                    }
                    ++n2;
                }
            }
            n3 = dimension2.width - rectangle.width;
        } else {
            n3 = 0;
        }
        int n5 = dimension2.height - rectangle.height;
        if (n5 != 0) {
            d = 0.0;
            n2 = 0;
            while (n2 < bidiGridBagLayoutInfo.height) {
                d += bidiGridBagLayoutInfo.weightY[n2];
                ++n2;
            }
            if (d > 0.0) {
                n2 = 0;
                while (n2 < bidiGridBagLayoutInfo.height) {
                    n = (int)((double)n5 * bidiGridBagLayoutInfo.weightY[n2] / d);
                    int n6 = n2;
                    bidiGridBagLayoutInfo.minHeight[n6] = bidiGridBagLayoutInfo.minHeight[n6] + n;
                    rectangle.height += n;
                    if (bidiGridBagLayoutInfo.minHeight[n2] < 0) {
                        rectangle.height -= bidiGridBagLayoutInfo.minHeight[n2];
                        bidiGridBagLayoutInfo.minHeight[n2] = 0;
                    }
                    ++n2;
                }
            }
            n5 = dimension2.height - rectangle.height;
        } else {
            n5 = 0;
        }
        bidiGridBagLayoutInfo.startx = n3 / 2 + insets.left;
        bidiGridBagLayoutInfo.starty = n5 / 2 + insets.top;
        n = container.getSize().width;
        int n7 = 0;
        while (n7 < componentArray.length) {
            Component component = componentArray[n7];
            if (component.isVisible()) {
                Rectangle rectangle2 = component.getBounds();
                BidiGridBagConstraints bidiGridBagConstraints = this.lookupConstraints(component);
                rectangle.x = bidiGridBagLayoutInfo.startx;
                n2 = 0;
                while (n2 < bidiGridBagConstraints.tempX) {
                    rectangle.x += bidiGridBagLayoutInfo.minWidth[n2];
                    ++n2;
                }
                rectangle.y = bidiGridBagLayoutInfo.starty;
                n2 = 0;
                while (n2 < bidiGridBagConstraints.tempY) {
                    rectangle.y += bidiGridBagLayoutInfo.minHeight[n2];
                    ++n2;
                }
                rectangle.width = 0;
                n2 = bidiGridBagConstraints.tempX;
                while (n2 < bidiGridBagConstraints.tempX + bidiGridBagConstraints.tempWidth) {
                    rectangle.width += bidiGridBagLayoutInfo.minWidth[n2];
                    ++n2;
                }
                rectangle.height = 0;
                n2 = bidiGridBagConstraints.tempY;
                while (n2 < bidiGridBagConstraints.tempY + bidiGridBagConstraints.tempHeight) {
                    rectangle.height += bidiGridBagLayoutInfo.minHeight[n2];
                    ++n2;
                }
                this.AdjustForGravity(bidiGridBagConstraints, rectangle);
                if (rectangle.width <= 0 || rectangle.height <= 0) {
                    component.setBounds(0, 0, 0, 0);
                } else {
                    if (!this.leftToRight) {
                        rectangle.x = n - rectangle.x - rectangle.width;
                    }
                    if (rectangle2.x != rectangle.x || rectangle2.y != rectangle.y || rectangle2.width != rectangle.width || rectangle2.height != rectangle.height) {
                        component.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                }
            }
            ++n7;
        }
    }
}

