// This is a sample DCALC frame using the text dictionary.
//
// Text dictionary gets the dictionary data from two Unicode files.
// They are the language and the translation table files.
// The user has two choices to access these files. Either he or she can
// give the file names or he or she can implement the TextStreamListener
// interface that contains two events to get the streams to the table data.
//
// By default this sample uses the event streams. They have the advantage to
// work in applications and applets. The file names only work in applications.
// If you choose to use the file names you can comment out the
// TextStreamListener implematation.

import java.io.*;
import java.net.*;
import java.applet.*;
import multilizer.*;

public class TextMainFrame extends MainFrame implements
  LanguageStreamListener, TranslationStreamListener
{
  public TextMainFrame(Applet applet)
  {
    super(applet);

    TextDictionary dictionary = new TextDictionary();

    dictionary.addLanguageStreamListener(this);
    dictionary.addTranslationStreamListener(this);
    //dictionary.setDictionaryName("text");

    translate(dictionary);
  }

  // The TextDictionary calls this event every time it need to get the stream
  // to the language data

  public void getLanguageStream(StreamEventObject e) throws IOException
  {
    // Gets the stream containing the language data.

    if (applet == null)
      e.setStream(new FileInputStream("text.languages"));
    else
      e.setStream(new URL(applet.getDocumentBase(), "text.languages").openStream());
  }

  // The TextDictionary calls this event every time it need to get the stream
  // to the translation data

  public void getTranslationStream(StreamEventObject e) throws IOException
  {
    // Gets the stream containing the translation data.

    String fileName = "text" + e.getBundleExtension() + ".translations";

    if (applet == null)
      e.setStream(new FileInputStream(fileName));
    else
      e.setStream(new URL(applet.getDocumentBase(), fileName).openStream());
  }
}
