/*
 * Decompiled with CFR 0.152.
 */
package multilizer;

import java.io.FileInputStream;
import multilizer.Dictionary;
import multilizer.Language;
import multilizer.LanguageStreamListener;
import multilizer.StreamEventObject;
import multilizer.StringParser;
import multilizer.UnicodeStream;

public abstract class BundleDictionary
extends Dictionary {
    public static final String LANGUAGES_C = ".languages";
    private String dictionaryName = new String();
    private LanguageStreamListener languageStreamListener;

    protected UnicodeStream getLanguageStream() throws Exception {
        if (this.languageStreamListener != null) {
            StreamEventObject streamEventObject = new StreamEventObject((Dictionary)this);
            this.languageStreamListener.getLanguageStream(streamEventObject);
            return new UnicodeStream(streamEventObject.getStream());
        }
        return new UnicodeStream(new FileInputStream(String.valueOf(this.getDictionaryName()) + LANGUAGES_C));
    }

    public int getLanguageCount() throws Exception {
        int n;
        UnicodeStream unicodeStream = this.getLanguageStream();
        try {
            int n2 = 0;
            while (unicodeStream.readUnicodeLine() != null) {
                ++n2;
            }
            n = n2;
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            unicodeStream.close();
            throw throwable;
        }
        unicodeStream.close();
        return n;
    }

    protected Language readLanguage(UnicodeStream unicodeStream) throws Exception {
        String string = unicodeStream.readUnicodeLine();
        if (string == null) {
            throw new Exception("Language is out of language range");
        }
        Language language = new Language();
        StringParser stringParser = new StringParser(string, '\t');
        language.englishName = stringParser.getStr();
        language.nativeName = stringParser.getStr();
        stringParser.getInt();
        stringParser.getStr();
        stringParser.getInt();
        stringParser.getStr();
        stringParser.getStr();
        language.test = (stringParser.getInt() & 1) != 0;
        stringParser.getInt();
        stringParser.getInt();
        language.language = stringParser.getStr();
        language.setCountries(stringParser.getStr());
        language.defaultCountry = stringParser.getStr();
        return language;
    }

    public Language getLanguageData(int n) throws Exception {
        Language language;
        Language language2 = null;
        UnicodeStream unicodeStream = this.getLanguageStream();
        try {
            int n2 = 0;
            while (n2 <= n) {
                language2 = this.readLanguage(unicodeStream);
                ++n2;
            }
            language = language2;
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            unicodeStream.close();
            throw throwable;
        }
        unicodeStream.close();
        return language;
    }

    public Language[] getLanguageDatas() throws Exception {
        Language[] languageArray;
        int n = this.getLanguageCount();
        Language[] languageArray2 = new Language[n];
        UnicodeStream unicodeStream = this.getLanguageStream();
        try {
            int n2 = 0;
            while (n2 < n) {
                languageArray2[n2] = this.readLanguage(unicodeStream);
                ++n2;
            }
            languageArray = languageArray2;
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            unicodeStream.close();
            throw throwable;
        }
        unicodeStream.close();
        return languageArray;
    }

    public void setDictionaryName(String string) {
        this.dictionaryName = string;
    }

    public String getDictionaryName() {
        return this.dictionaryName;
    }

    public synchronized void addLanguageStreamListener(LanguageStreamListener languageStreamListener) {
        this.languageStreamListener = languageStreamListener;
    }

    public synchronized void removeLanguageStreamListener(LanguageStreamListener languageStreamListener) {
        this.languageStreamListener = null;
    }
}

