/*
 * Decompiled with CFR 0.152.
 */
package multilizer;

import java.util.Vector;
import multilizer.BundleDictionary;
import multilizer.Translation;
import multilizer.TranslationStreamListener;

public abstract class FileDictionary
extends BundleDictionary {
    protected TranslationStreamListener translationStreamListener;
    protected String extension = new String();
    protected transient Vector translations = new Vector();

    public FileDictionary(String string) {
        this.extension = string;
    }

    protected String getBundleFileName() {
        return String.valueOf(this.getDictionaryName()) + "_" + this.getLanguageData().getLanguageLocale().toString() + this.extension;
    }

    protected void disconnect() {
        this.translations = null;
    }

    protected String translateString(String string) {
        int n = 0;
        int n2 = this.translations.size() - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            Translation translation = (Translation)this.translations.elementAt(n3);
            int n4 = string.compareTo(translation.nativeStr);
            if (n4 == 0) {
                return translation.currentStr;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        return "";
    }

    protected abstract void loadTranslation() throws Exception;

    protected void languageChanged(boolean bl, boolean bl2) throws Exception {
        if (bl) {
            this.loadTranslation();
        }
        super.languageChanged(bl, bl2);
    }

    protected void sortTranslations(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        String string = ((Translation)this.translations.elementAt((int)((n + n2) / 2))).nativeStr;
        while (true) {
            if (string.compareTo(((Translation)this.translations.elementAt((int)n3)).nativeStr) > 0) {
                ++n3;
                continue;
            }
            while (string.compareTo(((Translation)this.translations.elementAt((int)n4)).nativeStr) < 0) {
                --n4;
            }
            if (n3 <= n4) {
                Translation translation = (Translation)this.translations.elementAt(n4);
                this.translations.setElementAt(this.translations.elementAt(n3), n4);
                this.translations.setElementAt(translation, n3);
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            this.sortTranslations(n, n4);
        }
        if (n3 < n2) {
            this.sortTranslations(n3, n2);
        }
    }

    public synchronized void addTranslationStreamListener(TranslationStreamListener translationStreamListener) {
        this.translationStreamListener = translationStreamListener;
    }

    public synchronized void removeTranslationStreamListener(TranslationStreamListener translationStreamListener) {
        this.translationStreamListener = null;
    }
}

