/*
 * Decompiled with CFR 0.152.
 */
package multilizer;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import multilizer.Target;
import multilizer.Translator;

public class MessageDialog
extends Dialog
implements ActionListener {
    static final int WIDTH = 400;
    static final int HEIGHT = 110;
    public static final int NONE = 0;
    public static final int OK = 1;
    public static final String OK_COMMAND = "ok";
    public static final int CANCEL = 2;
    public static final String CANCEL_COMMAND = "cancel";
    public static final int YES = 4;
    public static final String YES_COMMAND = "yes";
    public static final int NO = 8;
    public static final String NO_COMMAND = "no";
    public static final int OK_CANCEL = 3;
    public static final int YES_NO = 12;
    private int result = 0;
    private Label label = new Label();
    private Panel buttonPanel = new Panel();
    private Translator translator;

    public MessageDialog(Frame frame, String string, String string2, int n, Translator translator) {
        super(frame, string, true);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0));
        this.label.setText(string2);
        panel.add(this.label);
        this.add("Center", panel);
        if ((1 & n) != 0) {
            this.addButton("OK", OK_COMMAND);
        }
        if ((2 & n) != 0) {
            this.addButton("Cancel", CANCEL_COMMAND);
        }
        if ((4 & n) != 0) {
            this.addButton("Yes", YES_COMMAND);
        }
        if ((8 & n) != 0) {
            this.addButton("No", NO_COMMAND);
        }
        this.add("South", this.buttonPanel);
        ((Component)this).setSize(400, 110);
        if (translator != null) {
            this.translator = translator;
            this.translator.addTarget(new Target("", "title", true));
            this.translator.addTarget(new Target("", "text", true));
            this.translator.addTarget(new Target("", "label", true));
            this.translator.setHost(this);
            this.translator.translate();
        }
    }

    public void dispose() {
        this.translator.dispose();
    }

    private void addButton(String string, String string2) {
        Button button = new Button();
        button.setLabel(string);
        button.setActionCommand(string2);
        button.addActionListener(this);
        this.buttonPanel.add(button);
    }

    public int getResult() {
        return this.result;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(OK_COMMAND)) {
            this.result = 1;
        } else if (actionEvent.getActionCommand().equals(CANCEL_COMMAND)) {
            this.result = 2;
        } else if (actionEvent.getActionCommand().equals(YES_COMMAND)) {
            this.result = 4;
        } else if (actionEvent.getActionCommand().equals(NO_COMMAND)) {
            this.result = 8;
        }
        if (this.result != 0) {
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    public static int messageBox(Frame frame, String string, String string2, int n, Translator translator) {
        Point point;
        Dimension dimension;
        Frame frame2 = null;
        if (frame == null) {
            frame = frame2 = new Frame();
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
            point = new Point(0, 0);
        } else {
            dimension = frame.getSize();
            point = frame.getLocation();
        }
        MessageDialog messageDialog = new MessageDialog(frame, string, string2, n, translator);
        Dimension dimension2 = new Dimension(400, 110);
        ((Component)messageDialog).setLocation((dimension.width - dimension2.width) / 2 + point.x, (dimension.height - dimension2.height) / 2 + point.y);
        messageDialog.show();
        if (frame2 != null) {
            frame2.dispose();
        }
        return messageDialog.getResult();
    }

    public static void messageBox(String string, String string2) {
        MessageDialog.messageBox(null, string, string2, 1, null);
    }
}

