/*
 * Decompiled with CFR 0.152.
 */
package multilizer;

import java.text.MessageFormat;
import java.util.Locale;
import multilizer.Dictionary;

public class Utils {
    public static final int METRIC_MEASUREMENT = 0;
    public static final int US_MEASUREMENT = 1;
    public static final int INCH_IN_FEET_C = 12;
    public static final int FEET_IN_YARD_C = 3;
    public static final int YARDS_IN_FURLONG_C = 220;
    public static final int FURLONGS_IN_MILE_C = 8;
    public static final double INCH_IN_METERS_C = 0.0254;
    public static final double FOOT_IN_METERS_C = 0.3048;
    public static final double YARD_IN_METERS_C = 0.9144;
    public static final double FURLONG_IN_METERS_C = 201.2;
    public static final double MILE_IN_METERS = 1609.3;
    public static final double OUNCES_IN_POUND_C = 16.0;
    public static final double POUNDS_IN_TON_C = 2000.0;
    public static final double OUNCE_IN_KILOGRAMS_C = 0.02835;
    public static final double POUND_IN_KILOGRAMS_C = 0.453;
    public static final double TON_IN_KILOGRAMS_C = 907.0;

    public static String getLocaleName(Locale locale, Dictionary dictionary) {
        return String.valueOf(dictionary.translate(locale.getDisplayLanguage(Locale.ENGLISH))) + " (" + dictionary.translate(locale.getDisplayCountry(Locale.ENGLISH)) + ")";
    }

    public static int getMeasurementSystem(Locale locale) {
        if (locale.getCountry().equals("US") || locale.getCountry().equals("JM")) {
            return 1;
        }
        return 0;
    }

    public static String formatMessage(String string, String[] stringArray, Dictionary dictionary) {
        MessageFormat messageFormat = new MessageFormat(dictionary.translate(string));
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = dictionary.translate(stringArray[n]);
            ++n;
        }
        return messageFormat.format(stringArray);
    }
}

