/*
 * Decompiled with CFR 0.152.
 */
package multilizer;

import com.sun.java.swing.DefaultListModel;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JList;
import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.JTree;
import com.sun.java.swing.tree.DefaultMutableTreeNode;
import com.sun.java.swing.tree.TreeNode;
import multilizer.MComboBoxModel;
import multilizer.MListModel;
import multilizer.MTableModel;
import multilizer.Target;
import multilizer.Translator;

public class SwingTranslator
extends Translator {
    private void translateJMenu(JMenu jMenu) {
        this.processObject(jMenu);
        int n = 0;
        while (n < jMenu.getItemCount()) {
            this.processObject(jMenu.getItem(n));
            ++n;
        }
    }

    private void translateJMenuBar(JFrame jFrame) {
        JMenuBar jMenuBar = jFrame.getJMenuBar();
        if (jMenuBar != null) {
            int n = 0;
            while (n < jMenuBar.getMenuCount()) {
                JMenu jMenu = jMenuBar.getMenu(n);
                this.translateJMenu(jMenu);
                ++n;
            }
        }
    }

    private void translateNode(TreeNode treeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (treeNode instanceof DefaultMutableTreeNode && (defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode).getUserObject() instanceof String) {
            defaultMutableTreeNode.setUserObject((Object)this.doTranslateString(defaultMutableTreeNode, "items", (String)defaultMutableTreeNode.getUserObject()));
        }
        int n = 0;
        while (n < treeNode.getChildCount()) {
            this.translateNode(treeNode.getChildAt(n));
            ++n;
        }
    }

    protected void translateObject(Object object) {
        if (object instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)object;
            int n = 0;
            while (n < jTabbedPane.getTabCount()) {
                jTabbedPane.setTitleAt(n, this.doTranslateString(object, "label", jTabbedPane.getTitleAt(n)));
                ++n;
            }
        } else if (object instanceof JList) {
            JList jList = (JList)object;
            if (jList.getModel() instanceof MListModel) {
                MListModel mListModel = (MListModel)jList.getModel();
                int n = 0;
                while (n < mListModel.getSize()) {
                    if (mListModel.getElementAt(n) instanceof String) {
                        mListModel.setElementAt(this.doTranslateString(object, "items", (String)mListModel.getElementAt(n)), n);
                    }
                    ++n;
                }
            } else if (jList.getModel() instanceof DefaultListModel) {
                DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
                int n = 0;
                while (n < defaultListModel.getSize()) {
                    if (defaultListModel.getElementAt(n) instanceof String) {
                        defaultListModel.setElementAt((Object)this.doTranslateString(object, "items", (String)defaultListModel.getElementAt(n)), n);
                    }
                    ++n;
                }
            }
        } else if (object instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)object;
            if (jComboBox.getModel() instanceof MComboBoxModel) {
                MComboBoxModel mComboBoxModel = (MComboBoxModel)jComboBox.getModel();
                int n = 0;
                while (n < mComboBoxModel.getSize()) {
                    if (mComboBoxModel.getElementAt(n) instanceof String) {
                        mComboBoxModel.setElementAt(this.doTranslateString(object, "items", (String)mComboBoxModel.getElementAt(n)), n);
                    }
                    ++n;
                }
            }
        } else if (object instanceof JTable) {
            JTable jTable = (JTable)object;
            if (jTable.getModel() instanceof MTableModel) {
                MTableModel mTableModel = (MTableModel)jTable.getModel();
                int n = 0;
                while (n < mTableModel.getColumnCount()) {
                    mTableModel.setColumnName(this.doTranslateString(object, "items", mTableModel.getColumnName(n)), n);
                    ++n;
                }
            }
        } else if (object instanceof JTree) {
            this.translateNode((TreeNode)((JTree)object).getModel().getRoot());
        }
        super.translateObject(object);
    }

    protected void translateMenu() {
        super.translateMenu();
        if (this.getHost() instanceof JFrame) {
            this.translateJMenuBar((JFrame)this.getHost());
        }
    }

    public void addDefaultTargets() {
        super.addDefaultTargets();
        this.addTarget(new Target("", "toolTipText"));
    }
}

