/*
 * Decompiled with CFR 0.152.
 */
package multilizer;

import java.beans.PropertyEditorSupport;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import multilizer.StringParser;

public class LocaleEditor
extends PropertyEditorSupport {
    private static String DEFAULT = "Default";

    private String getDisplayString(Locale locale) {
        String string = locale.toString();
        int n = string.length();
        if (n == 0) {
            return DEFAULT;
        }
        if (n == 2) {
            return String.valueOf(locale.getDisplayLanguage(Locale.US)) + " [" + string + "]";
        }
        return String.valueOf(locale.getDisplayName(Locale.US)) + " [" + string + "]";
    }

    public String[] getTags() {
        Locale[] localeArray = NumberFormat.getAvailableLocales();
        String[] stringArray = new String[localeArray.length + 1];
        stringArray[0] = DEFAULT;
        int n = 0;
        while (n < localeArray.length) {
            stringArray[n + 1] = this.getDisplayString(localeArray[n]);
            ++n;
        }
        return stringArray;
    }

    public String getAsText() {
        return this.getDisplayString((Locale)this.getValue());
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string.equals(DEFAULT)) {
            this.setValue(new Locale("", ""));
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[]");
        stringTokenizer.nextToken();
        StringParser stringParser = new StringParser(stringTokenizer.nextToken(), '_');
        String string2 = stringParser.getStr();
        String string3 = stringParser.getStr();
        this.setValue(new Locale(string2, string3));
    }

    public String getJavaInitializationString() {
        Locale locale = (Locale)this.getValue();
        return "new java.util.Locale(\"" + locale.getLanguage() + "\", \"" + locale.getCountry() + "\")";
    }
}

