/*
 * Decompiled with CFR 0.152.
 */
package multilizer;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import multilizer.Language;
import multilizer.RemoteDictionary;

public class DatabaseDictionary
extends RemoteDictionary {
    private Connection connection;
    private Statement statement;
    private String driver = new String();
    private String languageTable = new String();
    private String translationTable = new String();
    public final int ENGLISH_NAME_C = 0;
    public final int NATIVE_NAME_C = 1;
    public final int TEST_C = 7;
    public final int ISO_LANGUAGE_C = 10;
    public final int ISO_COUNTRIES_C = 11;
    public final int ISO_DEFAULT_COUNTRY_C = 12;

    public void open() throws Exception {
        if (!this.driver.equals("")) {
            Class.forName(this.driver);
        }
        this.connection = DriverManager.getConnection(this.getURL(), this.getUser(), this.getPassword());
        this.statement = this.connection.createStatement();
        super.open();
    }

    public void close() {
        super.close();
        try {
            this.statement.close();
            this.connection.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public int getLanguageCount() {
        try {
            int n = 0;
            ResultSet resultSet = this.statement.executeQuery("SELECT * FROM " + this.languageTable);
            while (resultSet.next()) {
                ++n;
            }
            resultSet.close();
            return n;
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not get the language count");
        }
    }

    protected Language getLanguage(ResultSet resultSet) throws Exception {
        return new Language(resultSet.getString(1), resultSet.getString(2), resultSet.getString(11), resultSet.getString(12), resultSet.getString(13));
    }

    public Language getLanguageData(int n) throws Exception {
        Language language;
        ResultSet resultSet = this.statement.executeQuery("SELECT * FROM " + this.languageTable);
        try {
            int n2 = 0;
            while (n2 <= n) {
                resultSet.next();
                ++n2;
            }
            language = this.getLanguage(resultSet);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            resultSet.close();
            throw throwable;
        }
        resultSet.close();
        return language;
    }

    public Language[] getLanguageDatas() throws Exception {
        Language[] languageArray;
        ResultSet resultSet = this.statement.executeQuery("SELECT * FROM " + this.languageTable);
        try {
            Vector<Language> vector = new Vector<Language>();
            while (resultSet.next()) {
                vector.addElement(this.getLanguage(resultSet));
            }
            Language[] languageArray2 = new Language[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                languageArray2[n] = (Language)vector.elementAt(n);
                ++n;
            }
            languageArray = languageArray2;
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            resultSet.close();
            throw throwable;
        }
        resultSet.close();
        return languageArray;
    }

    protected String translateString(String string) {
        try {
            ResultSet resultSet = this.statement.executeQuery("SELECT * FROM " + this.translationTable + " WHERE Native = '" + string + "'");
            string = resultSet.next() ? resultSet.getString(this.getActiveLanguage() + 1) : "";
            resultSet.close();
        }
        catch (Exception exception) {
            string = "";
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setLanguageTable(String string) {
        this.languageTable = string;
    }

    public String getLanguageTable() {
        return this.languageTable;
    }

    public void setTranslationTable(String string) {
        this.translationTable = string;
    }

    public String getTranslationTable() {
        return this.translationTable;
    }
}

