/*
 * Decompiled with CFR 0.152.
 */
package multilizer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import multilizer.Language;
import multilizer.RemoteDictionary;
import multilizer.StringParser;

public class ServerDictionary
extends RemoteDictionary {
    private Socket socket;
    private DataInputStream is;
    private DataOutputStream os;
    private int port = 1099;
    private String dictionaryName = new String();
    private int userType = 0;

    public int getLanguageCount() throws IOException {
        return new Integer(this.transaction("GET" + ' ' + "LANGUAGECOUNT"));
    }

    public Language getLanguageData(int n) throws IOException {
        String string = this.transaction("GET" + ' ' + "LANGUAGEDATA" + ' ' + n);
        StringParser stringParser = new StringParser(string, '\u007f');
        Language language = new Language();
        stringParser.getInt();
        stringParser.getStr();
        stringParser.getInt();
        language.language = stringParser.getStr();
        language.setCountries(stringParser.getStr());
        language.defaultCountry = stringParser.getStr();
        stringParser.getInt();
        language.englishName = stringParser.getStr();
        language.nativeName = stringParser.getStr();
        stringParser.getStr();
        stringParser.getStr();
        language.test = stringParser.getBoolean();
        return language;
    }

    protected String translateString(String string) {
        try {
            return this.transaction("TRANSLATE" + ' ' + string);
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected void languageChanged(boolean bl, boolean bl2) throws Exception {
        try {
            this.transaction("SET" + ' ' + "LANGUAGE" + ' ' + this.getActiveLanguage() + '\u007f' + "0" + '\u007f' + this.getActiveLocale());
        }
        catch (Exception exception) {}
        super.languageChanged(bl, bl2);
    }

    public void open() throws Exception {
        if (this.isOpen()) {
            return;
        }
        this.socket = new Socket(this.getURL(), this.port);
        this.is = new DataInputStream(this.socket.getInputStream());
        this.os = new DataOutputStream(this.socket.getOutputStream());
        String string = this.transaction("LOGIN" + ' ' + 9 + '\u007f' + this.getUser() + '\u007f' + this.getPassword() + '\u007f' + 5 + '\u007f' + '0' + '\u007f' + '1');
        this.userType = new Integer(string);
        this.transaction("OPEN" + ' ' + this.dictionaryName + '\u007f' + "1");
        super.open();
    }

    public void close() {
        super.close();
        try {
            this.transaction("LOGOUT");
            this.socket.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void send(String string) throws IOException {
        int n = 0;
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[2 * (string.length() + 1)];
        int n2 = 0;
        while (n2 < string.length()) {
            char c = cArray[n2];
            byArray[n] = (byte)(c >>> 8 & 0xFF);
            byArray[++n] = (byte)(c & 0xFF);
            ++n;
            ++n2;
        }
        byArray[n] = 0;
        byArray[++n] = 0;
        this.os.write(byArray);
    }

    protected String read() throws IOException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            char c = this.is.readChar();
            while (c != ' ' && c != '\u0000') {
                n = 10 * n + (c - 48);
                c = this.is.readChar();
            }
            if (c == ' ') {
                int n2 = 0;
                char[] cArray = new char[64];
                while (true) {
                    if (n2 == 64) {
                        stringBuffer.append(cArray, 0, 64);
                        n2 = 0;
                    }
                    if ((c = this.is.readChar()) == '\u0000') break;
                    cArray[n2] = c;
                    ++n2;
                }
                stringBuffer.append(cArray, 0, n2);
            }
        }
        catch (EOFException eOFException) {
            n = 3;
        }
        if (n != 0) {
            throw new RuntimeException("MLTP error " + n);
        }
        return stringBuffer.toString();
    }

    protected String transaction(String string) throws IOException {
        this.send(string);
        return this.read();
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getPort() {
        return this.port;
    }

    public void setDictionaryName(String string) {
        this.dictionaryName = string;
    }

    public String getDictionaryName() {
        return this.dictionaryName;
    }
}

