/*
 * Decompiled with CFR 0.152.
 */
package multilizer;

import java.io.FileInputStream;
import multilizer.FileDictionary;
import multilizer.StreamEventObject;
import multilizer.StringParser;
import multilizer.Translation;
import multilizer.UnicodeStream;

public class TextDictionary
extends FileDictionary {
    public TextDictionary() {
        super(".translations");
    }

    protected void loadTranslation() throws Exception {
        UnicodeStream unicodeStream;
        this.translations.removeAllElements();
        if (this.translationStreamListener != null) {
            StreamEventObject streamEventObject = new StreamEventObject(this);
            this.translationStreamListener.getTranslationStream(streamEventObject);
            unicodeStream = new UnicodeStream(streamEventObject.getStream());
        } else {
            unicodeStream = new UnicodeStream(new FileInputStream(this.getBundleFileName()));
        }
        try {
            String string;
            while ((string = unicodeStream.readUnicodeLine()) != null) {
                Translation translation = new Translation();
                StringParser stringParser = new StringParser(string, '\t');
                translation.nativeStr = stringParser.getStr();
                translation.currentStr = stringParser.getStr();
                this.translations.addElement(translation);
            }
            this.sortTranslations(0, this.translations.size() - 1);
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            unicodeStream.close();
            throw throwable;
        }
        Object var3_7 = null;
        unicodeStream.close();
    }
}

