

TYPE UseCaseInhKind : ENUM {extends LABEL ""|"enrichit", uses LABEL ""|"utilise"} LABEL "Use Case Inheritance Kind"|"Genre d'Hritage de Cas d'Utilisation";


/* System : abstract class for systems RootSystem and SubSystem */

System : NameSpace -abstract
{
	use_cases: UseCase [0..*] INVERSE system -agg LABEL "use cases"|"cas d'utilisation";
} LABEL "Package"|"Paquetage";


Actor : Class
{
	ass_use_cases: Actor_UseCase [0..*] INVERSE actor;
} LABEL ""|"Acteur";


UseCase : Entity
{
	name: Identifier -id;
	system: System INVERSE use_cases -id;
	ass_actors: Actor_UseCase [0..*] INVERSE use_case -agg LABEL "relationships with actors"|"relations avec acteurs";
	specializations: UseCaseInheritance [0..*] INVERSE super_use_case -agg LABEL ""|"spcialisations";
	generalizations: UseCaseInheritance [0..*] INVERSE sub_use_case LABEL ""|"gnralisations";
} LABEL "Use Case"|"Use Case";


Actor_UseCase : Entity
{
	actor: Actor INVERSE ass_use_cases -id;
	use_case: UseCase INVERSE ass_actors -id LABEL "use case"|"cas d'utilisation";
} LABEL "Actor-Use Case"|"Acteur-Use Case";


UseCaseInheritance : Entity
{
	inheritance_kind: UseCaseInhKind LABEL "inheritance kind"|"genre d'hritage";
	super_use_case: UseCase INVERSE specializations -id LABEL "super use case"|"super cas d'utilisation";
	sub_use_case: UseCase INVERSE generalizations -id LABEL "sub use case"|"sous cas d'utilisation";
} LABEL "Use Case Inheritance"|"Hritage Use Case";