


/* AtomicType : abstract class for predefined types (integer, ...), enum types,  type definitions, ... */

AtomicType : TypingObject -abstract
{
} LABEL "Atomic Type"|"Type Atomique";


/* PredefinedType : class for predefined types (integer, float,  ...) */

PredefinedType : AtomicType
{
} LABEL "Primitive Type"|"Type Primitif";


/* TypingObject : abstract class for classes and atomic types */

TypingObject : InstanciableEntity -abstract
{
	type_definitions: TypeDefinition [0..*] INVERSE type LABEL "type definitions"|"dfinitions de type";
} LABEL "Typing Object"|"Objet Typant";


/* TypeDefinition : class for type definitions; a type definition is built on other atomic types, and the multiplicity point can be precised with the cardMin, cardMax and collectionKind attributes */

TypeDefinition : AtomicType
{
	card_min: Integer LABEL "min card"|"card min";
	card_max: Integer LABEL "max card"|"card max";
	collection_kind: CollectionKind LABEL "collection type"|"genre de collection";
	type: TypingObject INVERSE type_definitions -id LABEL "type"|"type";
} LABEL "Synonym Type"|"Type Synonyme";


/* EnumType : class for enum types */

EnumType : AtomicType
{
	elements: EnumElement [0..*] INVERSE type -agg LABEL "elements"|"lments";
		/* EnumElement instances composing the enum type */
} LABEL "Enum Type"|"Type Enumr";


/* EnumElement : element in an enum type */

EnumElement : Entity
{
	name: Identifier -id LABEL "name"|"nom";
	type: EnumType INVERSE elements -id LABEL "type"|"type";
		/* type the EnumElement belongs to */
} LABEL "Enum Element"|"Elment d'numration";