


Class : TypingObject
{
	visibility: Visibility LABEL "visibility"|"visibilit";
		/* defines visibility of the class for other systems */
	is_required: Boolean LABEL "required"|"requis";
	system: System INVERSE local_classes -id LABEL "system"|"systme";
		/* system defining the class instance */
	importing_systems: System [0..*] INVERSE imported_classes LABEL "importing systems"|"systmes importeurs";
} LABEL "Class"|"Classe";


/* AtomicType : abstract class for predefined types (integer, ...), enum types,  type definitions, ... */

AtomicType : TypingObject -abstract
{
	system_definer: System INVERSE types LABEL "system"|"systme";
		/* system defining the type */
	root_system: RootSystem [0..1] INVERSE default_type LABEL "root system"|"systme racine";
} LABEL "Atomic Type"|"Type Atomique";


Service : TypedObject
{
	implemented_by: Service [0..1] INVERSE implements LABEL "implemented by"|"implment par";
	implements: Service [0..*] INVERSE implemented_by LABEL "implements"|"implmente";
	use: Use [0..1] INVERSE external_events;
};


/* Project : a Project instance includes RootSystem instances */

Project : Entity -cluster
{
	name: Identifier -id LABEL "name"|"nom";
	systems: RootSystem [1..*] INVERSE project -agg LABEL "root systems"|"systmes racines";
		/* a Project instance has several RootSystem instances */
} LABEL ""|"Projet";


/* NameSpace : class for work spaces */

NameSpace : Entity -abstract
{
	name: Identifier -id LABEL "name"|"nom";
} LABEL "Name Space"|"Espace De Nommage";


/* System : abstract class for systems RootSystem and SubSystem */

System : NameSpace -abstract
{
	current_phase: Integer LABEL "current phase"|"phase courante";
	types: AtomicType [0..*] INVERSE system_definer -agg;
		/* AtomicType instances defined by the system */
	local_classes: Class [0..*] INVERSE system -agg LABEL "local classes"|"classes locales";
		/* class instances defined in the system */
	subsystems: SubSystem [0..*] INVERSE supersystem -agg LABEL "subsystems"|"sous-systmes";
	needs: Use [0..*] INVERSE user_system -agg LABEL ""|"besoins";
	users: Use [0..*] INVERSE used_system LABEL ""|"utilisateurs";
	imported_classes: Class [0..*] INVERSE importing_systems LABEL "imported classes"|"classes importes";
} LABEL "Package"|"Paquetage";


/* RootSystem : RootSystem instances are roots in a project, attached to a unique project */

RootSystem : System -cluster
{
	default_type: AtomicType [0..1] INVERSE root_system LABEL "default type"|"type par dfaut";
	project: Project INVERSE systems LABEL "project"|"projet";
		/* a RootSystem instance belongs to one project */
} LABEL "Root Package"|"Paquetage Racine";


/* SubSystem : class to build systems trees */

SubSystem : System
{
	supersystem: System INVERSE subsystems -id LABEL "super system"|"systme pre";
} LABEL "Package"|"Paquetage";


Use : Entity
{
	user_system: System INVERSE needs -id LABEL "user system"|"systme utilisateur";
	used_system: System INVERSE users -id LABEL "used system"|"systme utilis";
	external_events: Service [0..*] INVERSE use LABEL "external events"|"evts externes";
} LABEL ""|"Utilisation";