

TYPE StateKind : ENUM {normal, final} LABEL "State Kind"|"Genre d'Etat";

TYPE ActionKind : ENUM {event LABEL ""|"vnement", no_event LABEL "none"|"nant", entry, do, exit} LABEL "Action Kind"|"Type Action";

TYPE EventKind : ENUM {signal, call LABEL ""|"appel", time LABEL "time expression"|"expression de temps", class_signal LABEL "evt implemented by class"|"evt implment par une classe"} LABEL "Event Kind"|"Type d'Evnement";


StateModel : Entity -abstract
{
	states: State [0..*] INVERSE state_model -agg LABEL ""|"tats";
} LABEL "State Model"|"Modle d'Etat";


ClassStateModel : StateModel
{
	class: Class INVERSE class_state_model -id LABEL ""|"classe";
} LABEL "State Model"|"Modle d'Etat";


RegionStateModel : StateModel
{
	name: Identifier -id;
	state: State INVERSE region_state_model -id LABEL "macrostate"|"macro-tat";
} LABEL "Substates Model"|"Modle de Sous-tats";


Class : TypingObject
{
	class_state_model: ClassStateModel [0..1] INVERSE class -agg LABEL "class state model"|"modle d'tat";
	send_events: Service [0..*] INVERSE senders LABEL "send events"|"vnements envoys";
	data_actions: Action_Activity [0..*] INVERSE data LABEL "actions carrying data"|"actions portant la donne";
} LABEL "Class"|"Classe";


Service : TypedObject
{
	event_kind: EventKind LABEL "event kind"|"type d'vnement";
	time_expression: Text LABEL "time expression"|"expression de temps";
	is_event: Boolean LABEL "is event"|"est un evt";
	triggered_actions: Action_Activity [0..*] INVERSE trigger LABEL "triggered actions"|"actions dclenches";
	senders: Class [0..*] INVERSE send_events LABEL "senders classes"|"classes mettrices";
	block: Block [0..1] INVERSE coded_service LABEL ""|"bloc";
	block_senders: Block [0..*] INVERSE send_services LABEL "blocks senders"|"blocs metteurs";
};


/* Attribute : class for basic attributes (not issued from an association) */

Attribute : AbstractAttribute
{
	defined_states: State [0..*] INVERSE state_attributes LABEL "defined states"|"tats caractriss";
} LABEL ""|"Attribut";


State : Entity
{
	name: Identifier -id LABEL "name"|"nom";
	identification_function: Text LABEL "identification function"|"fonction caractristique";
	update_function: Text LABEL "state attributes updating function"|"fonction de mise  jour des attributs d'tat";
	state_kind: StateKind LABEL "state kind"|"genre d'tat";
	region_state_model: RegionStateModel [0..*] INVERSE state -agg LABEL "state submodel"|"sous-modle d'tat";
	trans_firing: Transition [0..*] INVERSE source -agg LABEL "outgoing transitions"|"transitions sortantes";
		/* collection of transitions starting from the state */
	trans_ending: Transition [0..*] INVERSE target LABEL "incoming transitions"|"transitions entrantes";
	state_attributes: Attribute [0..*] INVERSE defined_states LABEL "state attributes"|"attributs d'tat";
	actions: Action_Activity [0..*] INVERSE state -agg LABEL "actions"|"actions";
	state_model: StateModel INVERSE states -id LABEL "state model"|"modle d'tat";
	initial_action: Action_Activity [0..*] INVERSE initial_state -agg LABEL "creation event"|"vnement de cration";
} LABEL ""|"Etat";


Transition : Entity
{
	source: State INVERSE trans_firing LABEL "source"|"source";
		/* source state for the transition */
	target: State INVERSE trans_ending LABEL "target"|"cible";
	action: Action_Activity [0..1] INVERSE transition -agg;
};


Action_Activity : Entity
{
	action_kind: ActionKind LABEL "action kind"|"type action";
	state: State [0..1] INVERSE actions LABEL "state"|"tat";
	trigger: Service [0..1] INVERSE triggered_actions LABEL "triggering event"|"vnement dclencheur";
	transition: Transition [0..1] INVERSE action;
	data: Class [0..1] INVERSE data_actions LABEL ""|"donne";
	blocks: Block [0..*] INVERSE coded_action LABEL ""|"blocs";
	condition: Block [0..1] INVERSE tested_action;
	initial_state: State [0..1] INVERSE initial_action LABEL "initial state"|"tat initial";
} LABEL "Action"|"Action";


Block
{
	code: Text;
	target_code: Text LABEL "target code"|"code cible";
	send_services: Service [0..*] INVERSE block_senders LABEL "send services"|"services mis";
	coded_action: Action_Activity [0..1] INVERSE blocks LABEL "coded action"|"action code";
	coded_service: Service [0..1] INVERSE block LABEL "coded service"|"service cod";
	tested_action: Action_Activity [0..1] INVERSE condition;
} LABEL ""|"Bloc";