

TYPE SourceType : ENUM {text LABEL ""|"texte", diagram LABEL ""|"diagramme"} LABEL "Source Type"|"Type Source";

TYPE RequirementType : ENUM {functional LABEL "functional (FUNC)"|"fonctionnel (FUNC)", performance LABEL "performance (PERF)"|"performance (PERF)", interface LABEL "interface (INTF)"|"interface (INTF)", operational LABEL "operational (OPER)"|"oprationnel (OPER)", resource LABEL "resource (RES)"|"ressource (RES)", verification LABEL "verification (VER)"|"vrification (VER)", acceptance_testing LABEL "acceptance testing (ATST)"|"acceptation (ATST)", documentation LABEL "documentation (DOC)"|"documentation (DOC)", security LABEL "security (SEC)"|"scurit (SEC)", portability LABEL "portability (PORT)"|"portabilit (PORT)", quality LABEL "quality (QUAL)"|"qualit (QUAL)", reliability LABEL "reliability (REL)"|"fiabilit (REL)", maintainability LABEL "maintainability (MAIN)"|"maintenabilit (MAIN)", safety LABEL "safety (SAFE)"|"sret (SAFE)"} LABEL "Requirement Type"|"Type Exigence";


Class : TypingObject
{
	req_objects: RequirementObject [0..*] INVERSE classes;
} LABEL "Class"|"Classe";


Service : TypedObject
{
	req_objects: RequirementObject [0..*] INVERSE services;
};


/* Attribute : class for basic attributes (not issued from an association) */

Attribute : AbstractAttribute
{
	req_objects: RequirementObject [0..*] INVERSE attributes;
} LABEL ""|"Attribut";


Association : Relation
{
	req_objects: RequirementObject [0..*] INVERSE associations;
};


/* RootSystem : RootSystem instances are roots in a project, attached to a unique project */

RootSystem : System -cluster
{
	requirement_model: RequirementModel [0..1] INVERSE system -agg LABEL "requirements model"|"modle des besoins";
} LABEL "Root Package"|"Paquetage Racine";


RequirementObject : Entity -abstract
{
	attributes: Attribute [0..*] INVERSE req_objects;
	services: Service [0..*] INVERSE req_objects;
	classes: Class [0..*] INVERSE req_objects;
	associations: Association [0..*] INVERSE req_objects;
	assos_n: Asso_N [0..*] INVERSE req_objects;
} LABEL "Requirement Object"|"Objet de Besoin";


RequirementModel : Entity
{
	system: RootSystem INVERSE requirement_model -id LABEL ""|"systme";
	sources: SourceDocument [0..*] INVERSE requirement_model -agg LABEL "source documents"|"documents source";
	terms: Term [0..*] INVERSE requirement_model -agg LABEL ""|"termes";
	requirements: Requirement [0..*] INVERSE requirement_model -agg LABEL ""|"exigences";
} LABEL "Requirements Model"|"Modle Besoins";


Term : RequirementObject
{
	number: Integer LABEL ""|"numro";
	term: String -id LABEL ""|"terme";
	requirement_model: RequirementModel INVERSE terms -id LABEL "requirements model"|"modle des besoins";
	sourceref: SourceRef [0..*] INVERSE terms LABEL "references"|"rfrences";
} LABEL ""|"Terme";


Requirement : RequirementObject
{
	number: Integer LABEL ""|"numro";
	type: RequirementType;
	label: String -id;
	requirement_model: RequirementModel INVERSE requirements -id LABEL "requirements model"|"modle des besoins";
	sourceref: SourceRef [0..*] INVERSE requirements LABEL "references"|"rfrences";
} LABEL ""|"Exigence";


SourceDocument : Entity
{
	number: Integer LABEL ""|"numro";
	name: String -id LABEL ""|"nom";
	requirement_model: RequirementModel INVERSE sources LABEL "requirements model"|"modle des besoins";
	sourcerefs: SourceRef [0..*] INVERSE source -agg LABEL "references"|"rfrences";
} LABEL "Source Document"|"Document Source";


SourceRef : Entity
{
	reference: String -id LABEL ""|"rfrence";
	type: SourceType;
	number: Integer LABEL ""|"numro";
	terms: Term [0..*] INVERSE sourceref LABEL ""|"termes";
	requirements: Requirement [0..*] INVERSE sourceref LABEL ""|"exigences";
	source: SourceDocument INVERSE sourcerefs -id LABEL "source document"|"document source";
} LABEL "Source Reference"|"Rfrence Source";


Asso_N : Relation
{
	req_objects: RequirementObject [0..*] INVERSE assos_n;
} LABEL "N-ary Association"|"Association N-aire";