

TYPE SystemKind : ENUM {application, service, architecture, implementation} LABEL ""|"GenreDomaine";

TYPE ReferencePlace : ENUM {none LABEL ""|"nant", source LABEL "source"|"source", target LABEL "target"|"cible", associative} LABEL ""|"PlaceRfrence";

TYPE ReferenceKind : ENUM {id_1 LABEL "*"|"*", id_2 LABEL "*2"|"*2", id_3 LABEL "*3"|"*3", role LABEL "role"|"rle"} LABEL ""|"GenreRfrence";

TYPE InheritanceFormalization : ENUM {if_none LABEL "none"|"nant", if_id_1 LABEL "*"|"*", if_id_2 LABEL "*2"|"*2", if_id_3 LABEL "*3"|"*3"} LABEL "Inheritance Formalization"|"Formalisation Hritage";

TYPE ProcessKind : ENUM {computing LABEL "computing (-c)"|"calcul (-c)", generate LABEL "generate (-g)"|"gnrateur (-g)", accessor LABEL "accessor (-a)"|"accesseur (-a)", test LABEL "test (-t)"|"test (-t)"};


OOASystemDiagram : SystemDiagram
{
} LABEL "OOA Subsystems Diagram"|"Diagramme des Sous-Systmes OOA";


OOA_OCM : InteractionDiagram
{
} LABEL "Object Communication Diagram"|"Diagramme de Communication des Objets";


OOAProjectDiagram : ProjectDiagram
{
} LABEL "OOA Domains Chart"|"Carte Domaines OOA";


OOAServersDiagram : ServersDiagram
{
} LABEL "OOA Context Diagram"|"Diagramme de Contexte OOA";


Class : TypingObject
{
	key_name: String LABEL "key name"|"cl";
	number: Integer LABEL "number"|"numro";
	update_number: Integer;
	is_assigner: Boolean;
	ref_attributes: ReferentialAttribute [0..*] INVERSE class -agg LABEL "referential attributes"|"attributs rfrentiels";
	implemented_use: Use [0..1] INVERSE implementing_class;
	assigner_for_association: Association [0..1] INVERSE assigner_class;
} LABEL "Class"|"Classe";


Service : TypedObject
{
	number: Integer LABEL ""|"numro";
	label: String LABEL ""|"libell";
};


/* AbstractAttribute : abstract class for class attributes (issued from an association or not) */

AbstractAttribute : Variable -abstract
{
	is_identifier_2: Boolean LABEL "secondary identifier"|"identifiant secondaire";
	is_identifier_3: Boolean LABEL "tertiary identifier"|"identifiant tertiaire";
	defined_ref_atts: ReferentialAttribute [0..*] INVERSE issued_from LABEL "defined referential attributes"|"attributs rfrentiels dfinis";
	blocks_accessors: Block [0..*] INVERSE accessed_attributes;
} LABEL "Abstract Attribute"|"Attribut Abstrait";


/* Acquaintance : attribute in a class coming from an association and describing the opposite role; it has a deduced type */

Acquaintance : AbstractAttribute -noimplicitidrule
{
	reference_kind: ReferenceKind LABEL "reference kind"|"caractrisation de la rfrence";
	verb: String LABEL "verb label"|"label verbal";
} LABEL ""|"Accointance";


Association : Relation
{
	reference_place: ReferencePlace LABEL "reference place"|"place de la rfrence";
	reference_kind: ReferenceKind;
	assigner_class: Class [0..1] INVERSE assigner_for_association;
};


Inheritance : Relation
{
	formalization: InheritanceFormalization LABEL ""|"formalisation";
} LABEL ""|"Hritage";


ReferentialAttribute : AbstractAttribute
{
	name: Identifier -id LABEL ""|"nom";
	class: Class INVERSE ref_attributes -id LABEL ""|"classe";
	relations: Relation [1..*] INVERSE ref_attributes -id;
	issued_from: AbstractAttribute INVERSE defined_ref_atts LABEL "issued from"|"provient de";
} LABEL "Referential Attribute"|"Attribut Rfrentiel";


/* System : abstract class for systems RootSystem and SubSystem */

System : NameSpace -abstract
{
	type: SystemKind LABEL "type"|"type";
	base_num: Integer LABEL "numbering basis"|"base de numrotation";
	range: Integer LABEL "numbering range"|"plage de numrotation";
	key_name: String LABEL "key name"|"cl";
} LABEL "Package"|"Paquetage";


Use : Entity
{
	implementing_class: Class [0..1] INVERSE implemented_use;
} LABEL ""|"Utilisation";


State : Entity
{
	number: Integer LABEL "number"|"numro";
} LABEL ""|"Etat";


Block
{
	number: Integer;
	process_kind: ProcessKind LABEL "process kind"|"type de processus";
	accessed_attributes: AbstractAttribute [0..*] INVERSE blocks_accessors LABEL "accessed attributes"|"attributs accds";
} LABEL ""|"Bloc";


OOAClassDiagram : ClassDiagram
{
	show_navigation: Boolean LABEL "show navigation role name"|"montrer le nom de navigation du rle";
} LABEL "OOA Class Diagram"|"Diagramme de Classe OOA";


OOAStateDiagram : StateDiagram
{
	hide_action_code: Boolean LABEL "hide action code"|"cacher le code de l'action";
} LABEL "OOA State Diagram"|"Diagramme d'Etat OOA";


Relation : InstanciableEntity -abstract
{
	number: Integer LABEL "number"|"numro";
	ref_attributes: ReferentialAttribute [0..*] INVERSE relations LABEL "referential attributes"|"attributs rfrentiels";
};