

TYPE Access : ENUM {read_write LABEL "read/write"|"lecture/criture", read_only LABEL "read only"|"lecture seule", write_only LABEL "write only"|"criture seule"} LABEL ""|"Accs";

TYPE Visibility : ENUM {public, protected LABEL ""|"protg", private LABEL ""|"priv"} LABEL ""|"Visibilit";

TYPE CollectionKind : ENUM {none LABEL ""|"nant", ordered LABEL ""|"ordonn", sorted LABEL ""|"tri", keyed LABEL ""|"par cl"} LABEL ""|"GenreCollection";

TYPE ServiceKind : ENUM {constructor LABEL ""|"constructeur", destructor LABEL ""|"destructeur"} LABEL ""|"GenreService";

TYPE InOut : ENUM {in, out, in_out};


/* Entity : superclass of any meta-model class */

Entity -abstract
{
} LABEL ""|"Entit";


Actor : Class
{
} LABEL ""|"Acteur";


Relation : InstanciableEntity -abstract
{
};


InstanciableEntity : Entity -abstract
{
};


/* TypingObject : abstract class for classes and atomic types */

TypingObject : InstanciableEntity -abstract
{
	name: Identifier -id LABEL "name"|"nom";
	typed_services: Service [0..*] INVERSE type LABEL "typed services"|"services typs";
		/* collection of services using the type instance */
	typed_parameters: Parameter [0..*] INVERSE type LABEL "typed parameters"|"paramtres typs";
		/* collection of parameters using the type instance */
	typed_attributes: Attribute [0..*] INVERSE type LABEL "typed attributes"|"attributs typs";
		/* collection of attributes using the type instance */
} LABEL "Typing Object"|"Objet Typant";


Class : TypingObject
{
	is_type: Boolean LABEL "is a type"|"est un type";
	abstract: Boolean LABEL "abstract"|"abstraite";
		/* if a class must not be instanciated, then this flag must be true */
	is_utility: Boolean LABEL "is utility"|"est utilitaire";
		/* must be true for a dummy class that encapsulates attributes and operations that are not part of a class, such as global variables and procedures */
	is_persistent: Boolean LABEL "persistent"|"persistante";
	inst_card_min: Integer LABEL "inst card min"|"nb min inst";
		/* min number of instances for the class */
	inst_card_max: Integer LABEL "inst card max"|"nb max inst";
		/* max number of instances for the class (* for infinity) */
	last_update: Integer LABEL "last update"|"dernire mise  jour";
	attributes: Attribute [0..*] INVERSE class -agg LABEL ""|"attributs";
		/* collection of attributes not coming from associations */
	services: Service [0..*] INVERSE class -agg;
		/* collection of methods in the class */
	specializations: Inheritance [0..*] INVERSE superclass -agg LABEL "subclasses inheritance links"|"liens d'hritage sous-classes";
		/* collection of inheritance objects leading to subclasses */
	generalizations: Inheritance [0..*] INVERSE subclass LABEL "superclass(es) inheritance link(s)"|"lien(s) d'hritage superclasse(s)";
		/* collection of inheritance objects leading to superclasses */
	acquaintances: Acquaintance [0..*] INVERSE class -agg LABEL ""|"accointances";
		/* collection of attributes issued from associations */
	associative_association: AssAssoc [0..1] INVERSE associative_class -agg LABEL "associative link"|"lien associatif";
	class_roles: Role [0..*] INVERSE role_class -agg LABEL "roles on class"|"rles sur la classe";
} LABEL "Class"|"Classe";


/* TypedObject : abstract class for typed object (variables, attributes, parameters, ...) */

TypedObject : InstanciableEntity -abstract
{
	visibility: Visibility LABEL "visibility"|"visibilit";
		/* public, private, or protected */
	card_min: Integer LABEL "min card"|"card min";
	card_max: Integer LABEL "max card"|"card max";
	collection_kind: CollectionKind LABEL "collection type"|"genre de collection";
} LABEL "Typed Object"|"Objet Typ";


Service : TypedObject
{
	meta: Boolean LABEL "class method"|"mthode de classe";
		/* true for class method; false for instance method */
	abstract: Boolean LABEL "abstract"|"abstrait";
	service_kind: ServiceKind [0..1] LABEL "service kind"|"genre de service";
	name: Identifier -id LABEL ""|"nom";
	type: TypingObject [0..1] INVERSE typed_services LABEL "returned type"|"type retour";
		/* service type (returned type) */
	class: Class INVERSE services -id LABEL "class"|"classe";
		/* class the method belongs to */
	parameters: Parameter [0..*] INVERSE service -id -agg LABEL ""|"paramtres";
};


/* Variable : abstract class for different kind of variables */

Variable : TypedObject -abstract
{
	access: Access LABEL "access"|"accs";
		/* readWrite, readOnly, writeOnly */
};


Parameter : Variable
{
	name: Identifier -id LABEL ""|"nom";
	direction: InOut;
	type: TypingObject INVERSE typed_parameters LABEL "type"|"type";
		/* parameter type */
	service: Service INVERSE parameters -id;
} LABEL ""|"Paramtre";


/* AbstractAttribute : abstract class for class attributes (issued from an association or not) */

AbstractAttribute : Variable -abstract
{
	is_identifier_1: Boolean LABEL "identifier"|"identifiant";
} LABEL "Abstract Attribute"|"Attribut Abstrait";


/* Attribute : class for basic attributes (not issued from an association) */

Attribute : AbstractAttribute
{
	meta: Boolean LABEL "class variable"|"variable de classe";
		/* true for class variable; false for instance variable */
	is_derived: Boolean LABEL "is derived"|"est driv";
	derivation_expression: Text LABEL "computing expression"|"expression de calcul";
	name: Identifier -id LABEL ""|"nom";
	class: Class INVERSE attributes -id LABEL "class"|"classe";
		/* class the attribute belongs to */
	type: TypingObject INVERSE typed_attributes LABEL "type"|"type";
		/* attribute type */
	block: Block [0..1] INVERSE coded_derived_attribute LABEL ""|"bloc";
} LABEL ""|"Attribut";


/* Acquaintance : attribute in a class coming from an association and describing the opposite role; it has a deduced type */

Acquaintance : AbstractAttribute -noimplicitidrule
{
	aggregation: Boolean LABEL "aggregation"|"agrgation";
		/* true for aggregation mapping; false for pointer mapping */
	mutable: Boolean LABEL "mutable"|"mutable";
		/* true if, once an association is created, the link can be reassigned; false otherwise */
	name: Identifier [0..1] -id LABEL ""|"nom";
	class: Class INVERSE acquaintances -id LABEL "class"|"classe";
		/* the class the acquaintance belongs to */
	association: Association INVERSE roles -agg;
		/* association the Acquaintance instance is linked to */
} LABEL ""|"Accointance";


Association : Relation
{
	label: String LABEL "label"|"label";
	is_derived: Boolean LABEL "is derived"|"est drive";
	roles: Acquaintance [2] INVERSE association -id LABEL "roles"|"rles";
		/* Acquaintance instances (roles) of the association */
	associative_association: AssAssoc [0..1] INVERSE described_association LABEL "associative link"|"lien associatif";
};


Inheritance : Relation
{
	label: String LABEL "label"|"label";
	superclass: Class INVERSE specializations -id LABEL "superclass"|"super-classe";
		/* an inheritance object has one superclass */
	subclass: Class INVERSE generalizations -id LABEL "subclass"|"sous-classe";
		/* an inheritance object has one subclass */
} LABEL ""|"Hritage";


Block : Entity
{
	coded_derived_attribute: Attribute [0..1] INVERSE block LABEL "coded derived attribute"|"attribut driv cod";
} LABEL ""|"Bloc";


AssAssoc : InstanciableEntity
{
	card: Integer LABEL "cardinality"|"cardinalit";
	described_association: Association [0..1] INVERSE associative_association -id LABEL "described association"|"association dcrite";
	associative_class: Class INVERSE associative_association -id LABEL "associative class"|"classe associative";
	described_asso_n: Asso_N [0..1] INVERSE associative_association -id LABEL "described association"|"association dcrite";
} LABEL "Associative Link"|"Lien Associatif";


Role : AbstractAttribute
{
	name: Identifier [0..1] LABEL ""|"nom";
	association: Asso_N INVERSE roles -agg;
	role_class: Class INVERSE class_roles LABEL "class"|"classe";
} LABEL ""|"Rle";


Asso_N : Relation
{
	label: String;
	roles: Role [3..*] INVERSE association LABEL ""|"rles";
	associative_association: AssAssoc [0..1] INVERSE described_asso_n LABEL "associative association"|"association associative";
} LABEL "N-ary Association"|"Association N-aire";