


Class : TypingObject
{
	interactions: Interaction [0..*] INVERSE interacting_classes;
	activations: Activation [0..*] INVERSE class;
	cp_firing: CommunicationPath [0..*] INVERSE source -agg LABEL "com path firing"|"com sortantes";
	cp_ending: CommunicationPath [0..*] INVERSE target LABEL "com path ending"|"com entrantes";
	interaction: Interaction [0..1] INVERSE class;
} LABEL "Class"|"Classe";


Service : TypedObject
{
	activations: Activation [0..*] INVERSE service;
	transactions: Transaction [0..*] INVERSE activated_service;
	transactions_using_condition: Transaction [0..*] INVERSE condition LABEL "transactions using condition"|"transactions utilisant la condition";
	interaction: Interaction [0..1] INVERSE service;
};


/* System : abstract class for systems RootSystem and SubSystem */

System : NameSpace -abstract
{
	interaction: Interaction [0..1] INVERSE system;
} LABEL "Package"|"Paquetage";


ClassInstance : Instance
{
	interactions: Interaction [0..*] INVERSE instances;
} LABEL "Class Instance"|"Instance de Classe";


CommunicationPath : Entity
{
	source: Class INVERSE cp_firing -id;
	target: Class INVERSE cp_ending -id LABEL ""|"cible";
} LABEL "Communication Path"|"Chemin De Communication";


UseCase : Entity
{
	interaction: Interaction [0..1] INVERSE use_case;
} LABEL "Use Case"|"Use Case";


Interaction : Entity
{
	name: String -id;
	service: Service [0..*] INVERSE interaction;
	use_case: UseCase [0..*] INVERSE interaction LABEL "use case"|"cas d'utilisation";
	interacting_classes: Class [0..*] INVERSE interactions LABEL "interacting classes"|"classes en interaction";
	system: System [0..1] INVERSE interaction;
	instances: ClassInstance [0..*] INVERSE interactions;
	class: Class [0..*] INVERSE interaction;
};


Activation : Entity
{
	service: Service [0..1] INVERSE activations;
	class: Class INVERSE activations LABEL ""|"classe";
	initiated_transactions: Transaction [0..*] INVERSE source_activation LABEL "initiated transactions"|"transactions inities";
	received_transactions: Transaction [0..*] INVERSE target_activation LABEL "received transactions"|"transactions reues";
};


Transaction : Entity
{
	source_activation: Activation INVERSE initiated_transactions LABEL "source activation"|"activation source";
	target_activation: Activation INVERSE received_transactions LABEL "target activation"|"activation cible";
	activated_service: Service [0..1] INVERSE transactions LABEL "send service"|"service envoy";
	condition: Service [0..1] INVERSE transactions_using_condition;
};