

TYPE DFDeventKind : ENUM {evt LABEL "any"|"quelconque", trigger LABEL ""|"dclencheur", enable LABEL ""|"autorisation", disable LABEL ""|"interdiction"};

TYPE DataAccessKind : ENUM {read, write};

TYPE DepKind : ENUM {static, dynamic};


HRAInteractionDiagram : InteractionDiagram
{
} LABEL "HOORA Interaction Diagram"|"Diagramme d'Interaction HOORA";


HRA_DFD : DataFlowDiagram
{
} LABEL "HOORA Data Flow Diagram"|"Diagramme  Flot de Donnes HOORA";


ClassStateModel
{
	control: ControlTransformation [0..*] INVERSE std;
};


RequirementObject -abstract
{
	transactions: HRATransaction [0..*] INVERSE req_objects;
} LABEL "Requirement Object"|"Objet de Besoin";


Class
{
	refined_by: SubSystem [0..1] INVERSE refines;
	initiated_transactions: HRATransaction [0..*] INVERSE initiating_class LABEL "initiated transactions"|"transactions sortantes";
	received_transactions: HRATransaction [0..*] INVERSE receiving_class LABEL "received transactions"|"transactions entrantes";
	dependencies: Dependency [0..*] INVERSE dep_classes;
} LABEL "Class"|"Classe";


Service
{
	critical_delay: String LABEL "critical delay"|"dlai critique";
	activating_transactions: HRATransaction [0..*] INVERSE activated_service;
	flows_out: DataFlow [0..*] INVERSE source LABEL "outgoing data flows"|"flots de donnes sortants";
	flows_in: DataFlow [0..*] INVERSE target LABEL "incoming data flows"|"flots de donnes entrants";
	data_access: DataAccess [0..*] INVERSE service_accessing_data;
	control_flow: ControlFlow [0..*] INVERSE service LABEL "control flows"|"flots de contrle";
	flows_carrying_trigger: ControlFlow [0..*] INVERSE trigger;
	called_transactions: HRATransaction [0..*] INVERSE calling_services;
};


Parameter
{
	volumetry: String LABEL ""|"volumtrie";
	flows_providing_data: DataFlow [0..*] INVERSE provided_data;
	issued_from: Parameter [0..1] INVERSE deduced_parameters LABEL "issued from"|"provient de";
	deduced_parameters: Parameter [0..*] INVERSE issued_from LABEL "deduced parameters"|"paramtres dduits";
};


/* AbstractAttribute : abstract class for class attributes (issued from an association or not) */

AbstractAttribute -abstract
{
	data_access: DataAccess [0..*] INVERSE data;
	dfd_model: DataFlowModel [0..*] INVERSE data_stores;
	flows_in: DataFlow [0..*] INVERSE data LABEL "incoming data flows"|"flots de donnes entrants";
};


/* RegionStateModel : class for basic attributes (not issued from an association) */

RegionStateModel
{
	control: ControlTransformation [0..*] INVERSE substd;
};


/* SubSystem : class to build systems trees */

SubSystem
{
	refines: Class INVERSE refined_by;
} LABEL "Package"|"Paquetage";


Relation -abstract
{
	dependencies: Dependency [0..*] INVERSE relations;
};


HRATransaction : Entity
{
	label: String;
	periodic: Boolean LABEL ""|"priodique";
	period: String LABEL ""|"priode";
	rate: String LABEL "average occurency rate"|"taux moyen d'occurence";
	delta_min: String LABEL "min delay between 2 occurrences"|"temps min entre 2 occurrences";
	initiating_class: Class INVERSE initiated_transactions LABEL "source class"|"classe source";
	receiving_class: Class INVERSE received_transactions LABEL "target class"|"classe cible";
	activated_service: Service [0..1] INVERSE activating_transactions LABEL "activated service"|"service activ";
	dependencies: Dependency [0..*] INVERSE transactions;
	req_objects: RequirementObject [0..*] INVERSE transactions;
	calling_services: Service [0..*] INVERSE called_transactions;
} LABEL "Transaction"|"Transaction";


ControlTransformation : Entity
{
	control_flow: ControlFlow [0..*] INVERSE control LABEL "control flows"|"flots de contrle";
	dfd_model: DataFlowModel INVERSE control;
	std: ClassStateModel INVERSE control LABEL "state model"|"modle d'tat";
	substd: RegionStateModel [0..1] INVERSE control LABEL "state submodel"|"sous-modle d'tat";
} LABEL "Control Transformation"|"Transformation de Contrle";


DataFlowModel : Entity
{
	control: ControlTransformation [0..*] INVERSE dfd_model LABEL "control transformation"|"transformation de contrle";
	data_stores: AbstractAttribute [0..*] INVERSE dfd_model;
};


DataFlow : Entity
{
	source: Service [0..1] INVERSE flows_out;
	target: Service [0..1] INVERSE flows_in LABEL ""|"cible";
	provided_data: Parameter [0..*] INVERSE flows_providing_data LABEL "data"|"donnes";
	data: AbstractAttribute [0..1] INVERSE flows_in LABEL ""|"donnes";
} LABEL "Data Flow"|"Flot de Donnes";


DataAccess : Entity
{
	access_kind: DataAccessKind;
	service_accessing_data: Service INVERSE data_access;
	data: AbstractAttribute INVERSE data_access LABEL ""|"donnes";
} LABEL "Data Access"|"Accs Donnes";


ControlFlow : Entity
{
	to_service: Boolean;
	event_kind: DFDeventKind LABEL "event kind"|"type d'vnement";
	service: Service [0..1] INVERSE control_flow;
	control: ControlTransformation [0..1] INVERSE control_flow LABEL ""|"contrle";
	trigger: Service [0..1] INVERSE flows_carrying_trigger;
} LABEL "Control Flow"|"Flot de Contrle";


Dependency : Entity
{
	dep_kind: DepKind;
	dep_classes: Class [2] INVERSE dependencies;
	relations: Relation [0..*] INVERSE dependencies;
	transactions: HRATransaction [0..*] INVERSE dependencies;
} LABEL ""|"Dpendance";