

TYPE GetReplace_GDMO : ENUM {get LABEL "GET"|"GET", replace LABEL "REPLACE"|"REPLACE", get_replace LABEL "GET-REPLACE"|"GET-REPLACE"} LABEL "GDMO Access"|"Accs GDMO";

TYPE AddRemove_GDMO : ENUM {access_none LABEL "none"|"nant", add LABEL "ADD"|"ADD", remove LABEL "REMOVE"|"REMOVE", add_remove LABEL "ADD-REMOVE"|"ADD-REMOVE"};

TYPE Context_GDMO : ENUM {action_info LABEL "ACTION-INFO"|"ACTION-INFO", action_reply LABEL "ACTION-REPLY"|"ACTION-REPLY", event_info LABEL "EVENT-INFO"|"EVENT-INFO", event_reply LABEL "EVENT-REPLY"|"EVENT-REPLY", specific_error LABEL "SPECIFIC-ERROR"|"SPECIFIC-ERROR"};


Entity_GDMO : InstanciableEntity
{
} LABEL "GDMO Entity"|"Entit GDMO";


Class
{
	registered_as: String -id2 LABEL "registered as"|"rpertori par";
	subordinations: NameBinding_GDMO [0..*] INVERSE superior;
	superiorizations: NameBinding_GDMO [0..*] INVERSE subordinate;
	pack_relations: ClassPackageRelation_GDMO [0..*] INVERSE class LABEL "package relations"|"relations paquetage";
};


Behaviour_GDMO : NamedEntity_GDMO
{
	entities_gdmo: RegisteredEntity_GDMO [0..*] INVERSE behaviours;
	iv_patts: Package_Attribute_GDMO [0..*] INVERSE ini_val_beh;
	dv_patts: Package_Attribute_GDMO [0..*] INVERSE def_val_beh;
} LABEL "GDMO Behaviour"|"Comportement GDMO";


Package_GDMO : RegisteredEntity_GDMO
{
	pack_attributes: Package_Attribute_GDMO [0..*] INVERSE package LABEL "package attributes"|"attributs du paquetage";
	gdmo_services: Service_GDMO [0..*] INVERSE packages;
	class_relations: ClassPackageRelation_GDMO [0..*] INVERSE package LABEL "class relations"|"relations classe";
	pack_params: Pack_Param_GDMO [0..*] INVERSE package;
} LABEL "GDMO Package"|"Paquetage GDMO";


NameBinding_GDMO : RegisteredEntity_GDMO
{
	create_with_automatic_instance_naming: Boolean LABEL "create with automatic instance naming"|"cration avec nommage automatique";
	create_with_reference_object: Boolean LABEL "create with reference object"|"cration avec objet rfrence";
	delete_only_if_no_contained_objects: Boolean LABEL "delete only if no contained objects"|"ne dtruire que si ne contient pas d'objet";
	delete_contained_objects: Boolean LABEL "delete contained objects"|"destruction des objets contenus";
	superior_and_subclasses: Boolean LABEL "propagate to superior subclasses"|"propager aux sous-classes du suprieur";
	subordinate_and_subclasses: Boolean LABEL "propagate to subordinate subclasses"|"propager aux sous-classes du subordonn";
	create: Boolean LABEL "CREATE"|"CREATE";
	delete: Boolean LABEL "DELETE"|"DELETE";
	superior: Class INVERSE subordinations LABEL ""|"suprieur";
	subordinate: Class INVERSE superiorizations LABEL ""|"subordonn";
	attribute: Attribute_GDMO INVERSE name_binding LABEL ""|"attribut";
	create_parameters: Parameter_GDMO [0..*] INVERSE name_bindings_for_create LABEL "CREATE parameters"|"paramtres CREATE";
	delete_parameters: Parameter_GDMO [0..*] INVERSE name_bindings_for_delete LABEL "DELETE parameters"|"paramtres DELETE";
} LABEL "GDMO Name Binding"|"Relation de Nommage GDMO";


RegisteredEntity_GDMO : NamedEntity_GDMO
{
	registered_as: String -id2 LABEL "registered as"|"rpertori par";
	behaviours: Behaviour_GDMO [0..*] INVERSE entities_gdmo LABEL ""|"comportements";
} LABEL "Named GDMO Entity"|"Entit GDMO Nomme";


Attribute_GDMO : RegisteredEntity_GDMO
{
	derived_from: String LABEL "derived from"|"driv de";
	with_attribute_syntax: String LABEL "with attribute syntax"|"with attribute syntax";
	is_derived: Boolean LABEL "is derived"|"est driv";
	name_binding: NameBinding_GDMO [0..*] INVERSE attribute LABEL "name binding"|"relation de nommage";
	pack_attributes: Package_Attribute_GDMO [0..*] INVERSE attribute LABEL "packages containing the attribute"|"paquetages intgrant l'attribut";
	parameters: Parameter_GDMO [0..*] INVERSE atts_using_param LABEL ""|"paramtres";
	roles: Acquaintance [0..*] INVERSE gdmo_attribute LABEL ""|"rles";
	filtering_capabilities: AttributeFilter_GDMO [0..*] INVERSE gdmo_attributes LABEL "filtering capabilities"|"capacits de filtrage";
	notif_atts: NotifAttID_GDMO [0..*] INVERSE attribute;
} LABEL "GDMO Attribute"|"Attribut GDMO";


Package_Attribute_GDMO : Entity_GDMO
{
	access: GetReplace_GDMO LABEL ""|"accs";
	default_value: String LABEL "default value"|"valeur par dfaut";
	initial_value: String LABEL "initial value"|"valeur initiale";
	permitted_values: String LABEL "permitted values"|"valeurs autorises";
	replace_with_default: Boolean LABEL "replace with default"|"remplacer avec dfaut";
	set_capability: AddRemove_GDMO LABEL "set capability"|"action sur ensemble";
	dv_derivation: Boolean LABEL "d.v. derivation"|"d.v. drivation";
	iv_derivation: Boolean LABEL "i.v. derivation"|"i.v. drivation";
	package: Package_GDMO INVERSE pack_attributes LABEL ""|"paquetage";
	attribute: Attribute_GDMO INVERSE pack_attributes LABEL ""|"attribut";
	parameters: Parameter_GDMO [0..*] INVERSE pack_atts LABEL ""|"paramtres";
	ini_val_beh: Behaviour_GDMO [0..1] INVERSE iv_patts LABEL "i.v. behaviour"|"i.v. comportement";
	def_val_beh: Behaviour_GDMO [0..1] INVERSE dv_patts LABEL "d.v. behaviour"|"d.v. comportement";
} LABEL "Package-Attribute GDMO"|"Attribut-Paquetage GDMO";


Service_GDMO : RegisteredEntity_GDMO
{
	information_syntax: String LABEL "information syntax"|"syntaxe d'information";
	reply_syntax: String LABEL "reply syntax"|"syntaxe de rponse";
	parameters: Parameter_GDMO [0..*] INVERSE servs_using_param LABEL ""|"paramtres";
	packages: Package_GDMO [0..*] INVERSE gdmo_services LABEL ""|"paquetages";
	pack_params: Pack_Param_GDMO [0..*] INVERSE gdmo_service;
} LABEL "GDMO Service"|"Service GDMO";


Action_GDMO : Service_GDMO
{
	confirmed: Boolean LABEL ""|"confirmation";
} LABEL "GDMO Action"|"Action GDMO";


Notification_GDMO : Service_GDMO
{
	attribute_ids: NotifAttID_GDMO [0..*] INVERSE notification LABEL "ATTRIBUTE IDS"|"ATTRIBUTE IDS";
} LABEL "GDMO Notification"|"Notification GDMO";


Pack_Param_GDMO : Entity_GDMO
{
	parameters: Parameter_GDMO [1..*] INVERSE pack_params;
	package: Package_GDMO INVERSE pack_params -id;
	gdmo_service: Service_GDMO INVERSE pack_params -id;
} LABEL "Package-Parameter GDMO"|"Paramtre-Paquetage GDMO";


NamedEntity_GDMO : Entity_GDMO
{
	name: Identifier -id;
	system: System INVERSE entities_gdmo LABEL ""|"systme";
};


Parameter_GDMO : RegisteredEntity_GDMO
{
	context: String LABEL ""|"contexte";
	syntax: String LABEL ""|"syntaxe";
	context_enum: Context_GDMO [0..1] LABEL "predefined context"|"contexte prdfini";
	atts_using_param: Attribute_GDMO [0..*] INVERSE parameters;
	servs_using_param: Service_GDMO [0..*] INVERSE parameters;
	pack_params: Pack_Param_GDMO [0..*] INVERSE parameters;
	name_bindings_for_create: NameBinding_GDMO [0..*] INVERSE create_parameters;
	name_bindings_for_delete: NameBinding_GDMO [0..*] INVERSE delete_parameters;
	pack_atts: Package_Attribute_GDMO [0..*] INVERSE parameters;
} LABEL "GDMO Parameter"|"Paramtre GDMO";


GDMOClassDiagram : ClassDiagram
{
	show_packages: Boolean LABEL "show packages"|"voir paquetages";
};


System
{
	entities_gdmo: NamedEntity_GDMO [0..*] INVERSE system LABEL "gdmo entities"|"entits gdmo";
};


Acquaintance
{
	gdmo_attribute: Attribute_GDMO [0..1] INVERSE roles LABEL "gdmo attribute"|"attribut gdmo";
};


AttributeFilter_GDMO : Entity_GDMO
{
	name: Identifier -id LABEL ""|"nom";
	gdmo_attributes: Attribute_GDMO [0..*] INVERSE filtering_capabilities LABEL "gdmo attributes"|"attributs gdmo";
	system: RootSystem INVERSE filtering_capabilities LABEL ""|"systme";
} LABEL "GDMO Attribute Filter"|"Filtre d'Attribut GDMO";


RootSystem
{
	filtering_capabilities: AttributeFilter_GDMO [0..*] INVERSE system LABEL "filtering capabilities"|"capacits de filtrage";
};


ClassPackageRelation_GDMO : Entity_GDMO
{
	is_conditional: Boolean LABEL "is conditional"|"est conditionnel";
	condition: Text [0..1];
	class: Class INVERSE pack_relations -id LABEL ""|"classe";
	package: Package_GDMO INVERSE class_relations -id LABEL ""|"paquetage";
};


NotifAttID_GDMO : Entity_GDMO
{
	field: Identifier LABEL "asn1 field"|"champ asn1";
	notification: Notification_GDMO INVERSE attribute_ids;
	attribute: Attribute_GDMO INVERSE notif_atts LABEL ""|"attribut";
} LABEL "Field-Attribute for GDMO Notification"|"Champ-Attribut pour Notification GDMO";