


StateModel : Entity -abstract
{
	state_diagram: StateDiagram [0..*] INVERSE state_model;
} LABEL "State Model"|"Modle d'Etat";


/* Project : a Project instance includes RootSystem instances */

Project : Entity -cluster
{
	project_diagram: ProjectDiagram [0..1] INVERSE project LABEL "project diagram"|"diagramme de projet";
} LABEL ""|"Projet";


/* System : abstract class for systems RootSystem and SubSystem */

System : NameSpace -abstract
{
	system_diagram: SystemDiagram [0..*] INVERSE system LABEL "system diagram"|"diagramme de systme";
	class_diagrams: ClassDiagram [0..*] INVERSE system LABEL "class diagrams"|"diagrammes de classe";
	interaction_diagrams: InteractionDiagram [0..*] INVERSE system LABEL "interaction diagrams"|"diagrammes d'interaction";
	servers_diagram: ServersDiagram [0..1] INVERSE system;
	use_case_diagram: UseCaseDiagram [0..*] INVERSE system;
} LABEL "Package"|"Paquetage";


Diagram : Entity -abstract
{
	name: Identifier -id LABEL "name"|"nom";
	scale: Integer LABEL "scale %"|"chelle %";
	landscape: Boolean LABEL ""|"paysage";
	hide_types: Boolean LABEL "hide types"|"cacher types";
	hide_visibility: Boolean LABEL "hide visibility"|"cacher visibilit";
	xPages: Integer := 1 LABEL "columns"|"colonnes";
	yPages: Integer := 1 LABEL "lines"|"lignes";
	diagram_title: Text [0..1] LABEL "title"|"titre";
	display_title: Boolean LABEL "display title"|"afficher titre";
	hide_stereo: Boolean LABEL "hide stereotype"|"cacher strotype";
	notes: Note [0..*] INVERSE diagram;
} LABEL ""|"Diagramme";


ClassDiagram : Diagram -abstract
{
	system: System INVERSE class_diagrams -id LABEL "system"|"systme";
} LABEL "Class Diagram"|"Diagramme De Classe";


SystemDiagram : Diagram -abstract
{
	system: System INVERSE system_diagram -id LABEL "system"|"systme";
} LABEL "System Diagram"|"Diagramme De Systme";


StateDiagram : Diagram -abstract
{
	state_model: StateModel INVERSE state_diagram -id;
} LABEL "State Diagram"|"Diagramme Etat";


InteractionDiagram : Diagram -abstract
{
	system: System INVERSE interaction_diagrams -id LABEL "system"|"systme";
} LABEL "Interaction Diagram"|"Diagramme Interaction";


Note : Entity
{
	bold: Boolean LABEL ""|"gras";
	no_frame: Boolean LABEL "no frame"|"sans cadre";
	bg_color: GColor := GColor#White LABEL "background color"|"couleur de fond";
	justify: GText LABEL ""|"justifier";
	diagram: Diagram INVERSE notes LABEL ""|"diagramme";
};


ProjectDiagram : Diagram -abstract
{
	project: Project INVERSE project_diagram -id LABEL ""|"projet";
} LABEL "Project Diagram"|"Diagramme De Projet";


DataFlowDiagram : Diagram -abstract
{
	data_flow_model: DataFlowModel INVERSE data_flow_diagram -id;
} LABEL "Data Flow Diagram"|"Diagramme  Flots de Donnes";


ServersDiagram : Diagram -abstract
{
	system: System INVERSE servers_diagram -id;
} LABEL "Servers Diagram"|"Diagramme Serveurs";


UseCaseDiagram : Diagram -abstract
{
	system: System INVERSE use_case_diagram -id LABEL ""|"systme";
} LABEL "Use Case Diagram"|"Diagramme de Cas d'Utilisation";


DataFlowModel : Entity
{
	data_flow_diagram: DataFlowDiagram [0..1] INVERSE data_flow_model;
} LABEL "Data Flow Model"|"Modle  Flot de Donnes";