### HTML ROUTINES FOR THE ULTIMATE BULLETIN BOARD ##
#
# Ultimate Bulletin Board is copyright Madrona Park, Inc., 1997, 1998.
#
#       ------------ ubb_htmlALT.pl -------------
#
#  This file contains all of the non control panel HTML
#  that is used throughout the BB.  Be very careful if you
#  modify this file,  since many variables are used which will
#  affect the display.  This file is only used by browsers not
#  supporting javascript (or that have javascript turned off).
#  The companion file (ubb_html.pl) is used for browsers that do
#  not support javascript.  You, as a BB administrator, do not have
#  to worry about the assignment of the appropriate HTML file...
#  the scripts handle that for you.  
#
#  Madrona park, Inc. offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.prime-web.com.com
#
###############################################################
sub FAQ {
print<<FAQHTML;
 <HTML>
 <BODY BGCOLOR="$BGColor" $PageBackground  text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<FONT SIZE="$TextSize" FACE="$FontFace">
<FONT SIZE="3" FACE="$FontFace" COLOR="#000080"><CENTER><B>
$BBName<BR>Frequently Asked Questions</B></FONT>
<p>
<FONT COLOR="#808000">[use your back button to return to previous page]</FONT>
</CENTER>
<p>
To review all Bulletin Board rules, <A HREF="$CGIURL/UltimateALT.cgi?action=rules">click here</A>.
<P>
<TABLE BORDER=2 BGCOLOR="$AltColumnColor1" width=240 align=left>
<TR>
<TD valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace">
<B><FONT SIZE="3" FACE="$FontFace" COLOR="$VisitedLinkColor"><CENTER>Definitions</CENTER></B></FONT><P>
<FONT COLOR="#800000"><B>Administrators</B></FONT><br>
Administrators have total control over every aspect of the bulletin board.  They are, in essence, the owners of the board.  
<p>
Administrators are able to set moderators for each forum, set permissions for any registered user, and edit/prune messages.
<P>
<FONT COLOR="#800000"><B>Moderators</B></FONT><BR>
Moderators are the ringleaders for each forum.  Each forum can have its own moderator, but one person may be a moderator in multiple forums.  An administrator may also be a moderator.
<p>
Moderators have the ability to edit/remove messages from their particular forum(s).  They cannot change permissions for a particular users, however.  Only administrators can change user permissions.
<P>
<FONT COLOR="#800000"><B>Members</B></FONT><BR>
Members are registered users of the bulletin board that have posted at least $MemberMinimum messages.  Members can edit their own profiles, but may not edit/remove messages, set user permissions, or assign moderators.
<P>
<FONT COLOR="#800000"><B>Junior Members</B></FONT><BR>
Junior Members are registered users who have posted fewer than $MemberMinimum messages.  Their privileges are identical to those of Members.

<P>
<FONT COLOR="#800000"><B>UBB Code</B></FONT><BR>
<A HREF="$NonCGIURL/ubbcode.html">UBB Code</A> is an HTML-like tag set that allows bulletin board writers to add additional functionality to their posts.  Current UBB Code functions include hyperlinking URLs and email addresses.
<P>
<FONT COLOR="#800000"><B>Forum</B></FONT><BR>
A Forum is a broad discussion area covering a particular interest.  Each forum may be controlled by a particular moderator assigned to lead discussion efforts and minimize abuse.
<P>
<FONT COLOR="#800000"><B>Topic</B></FONT><BR>
A Topic is a discussion point within a Forum. Any registered user can start a new Topic within a Forum.
<P>
<FONT COLOR="#800000"><B>Reply</B></FONT><BR>
A Reply is a post that is in response to an existing topic.  Any registered user can post a reply.
<P>
<FONT COLOR="#800000"><B>Thread</B></FONT><BR>
A Thread is a conversation within a forum that includes a topic (the post that started the conversation) and all replies to that topic.

</FONT>
</TD></TR></table>

<TABLE BORDER=0>
<TR><TD valign=top><FONT SIZE="1" FACE="$FontFace">
<B>
<FONT COLOR="#FF0000">Can I attach files to my Topic or Reply? </FONT>
<P>
No. You may cut and paste within the input box for your Topic or Reply, however.
<P>
<FONT COLOR="#FF0000">Why should I register?</FONT>
<P>
You may only post Topics and/or Replies if you are registered.  Registration is free.
<P>
<FONT COLOR="#FF0000">Can I customize the BB in any way?</FONT>
<P>
Yes.  All users, even unregistered users, can <A HREF="UltimateALT.cgi?action=setprefs">set preferences</A> that affect how the BB is displayed every time.  Currently, there are only 2 preferences.  The first allows Internet Explorer users to place all topic lists and threads within inline frames.  Note that not all browsers support inline frames.  We recommend the use of inline frames only for Windows users of Microsoft Internet Explorer 4.0 or higher.  Inline frames are not supported currently in any version of Netscape's browser.  WebTV and Macintosh users also should not set preferences to inline frames.
<P>
The second preference option concerns the viewing of topics.  The default configuration shows all topics that have been posted to within the last 20 days.  You can change this default.  

<P><FONT COLOR="#FF0000">
My Email address has changed since I first registered... how can I change my profile?

</FONT>
<P>
Throughout the site, you will find an "edit profile" link. Feel free to change any of your profile information (except your UserName) at any time.
<P>
<FONT COLOR="#FF0000">How do I become a moderator for a forum?</FONT>
<P>

Only the bulletin board administrator can control the assignment of moderators. Contact the BB administrator if you would like more
information.
<P>
<FONT COLOR="#FF0000">What can moderators do?</FONT>
<P>
Moderators can edit and delete messages in their particular forums. They cannot restrict member access to boards, though they can appeal to
the administrator to have a member's posting priviledge revoked.
<P>
<FONT COLOR="#FF0000">I've just seen a post that was very offensive. Is there anything I can do about it?</FONT>
<P>
You should contact the Forum Moderator and tell them which particular Topic or Topic Reply you found offensive. If necessary, they have the
ability to delete or edit a post.
<P>
<FONT COLOR="#FF0000">Can I incorporate HTML in my posts?</FONT>
<P>
Maybe.  Each forum can be independently configured to either allow HTML tags or not. (This is determined by the bulletin board administrators).  Whenever you post a new topic or reply in a forum, you will see a note near the top of the page saying that HTML is either enabled or not enabled.
<P>
Even if HTML is not enabled, you will still be able to perform certain HTML-like function, however, using <A HREF="$NonCGIURL/ubbcode.html">UBB Code</A>, an HTML-like tag set that allows for certain basic functions like hyperlinking URLS and email addresses.  
<P>
<FONT COLOR="#FF0000">Who is responsible for this Bulletin Board?</FONT>
<P>
The BB administrators have total control over the content of this bulletin board.  Although the code for this BB was created by <A HREF="mailto:ted\@prime-web.com">Ted O'Neill</A>, he is not responsible for the content contained in the BB nor any negative ramifications associated with the operation of the BB.    The BB administrators/owners assume liability for this BB, within the framework of their own guidelines and warranties (if any).</font></B></td></TR></table>
<p>
<CENTER><FONT COLOR="$LinkColor">[use your back button to return to previous page]</FONT></CENTER>
<p><CENTER>
<FONT COLOR="$CopyrightTextColor" size="1">
$YourCopyrightNotice
<P>
Powered by: Ultimate Bulletin Board, Version 4.5<BR>&copy; Madrona Park, Inc., 1997, 1998.
<br>
<br>
</CENTER>
</FONT>
</BODY></HTML>
FAQHTML
}

sub ForumsTopHTML {
print <<INTROHTML;
<HTML>
<HEAD><TITLE>$BBName - powered by the Ultimate Bulletin Board</title>
</head>
 <BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<center>
<FONT FACE="$FontFace" SIZE="$TextSize">
<table border=0 width=$TableWidth>
<tr>
<TD>
<CENTER>
<A HREF="UltimateALT.cgi"><IMG SRC="$NonCGIURL/$BBTitle"  BORDER=0></A>
</CENTER>
</td>
<td>
<CENTER>
<B><FONT SIZE="3" FACE="$FontFace" COLOR="#800000">$BBName</FONT></B>
<br><FONT SIZE="1" FACE="$FontFace">
<A HREF="$CGIURL/UltimateALT.cgi?action=editbio&Browser=$Browser&DaysPrune=$DaysPrune">edit profile</A> | <A HREF="$CGIURL/UltimateALT.cgi?action=agree">register</A> | <A HREF="$CGIURL/UltimateALT.cgi?action=faq">help/faq</A>
</FONT>
</CENTER>
</td></TR>
</table>

<table border=0 width=$TableWidth>
<tr bgcolor="$TableColorStrip">
<td valign=bottom>
<FONT SIZE="1" FACE="$FontFace" COLOR="$TableStripTextColor">Forum</FONT>
</td>
<td NOWRAP valign=bottom align=center>
<FONT SIZE="1" FACE="$FontFace" COLOR="$TableStripTextColor">Posts</FONT>
</td>
<td NOWRAP valign=bottom align=center>
<FONT SIZE="1" FACE="$FontFace" COLOR="$TableStripTextColor">Last Post</FONT>
</td>
<td valign=bottom>
<FONT SIZE="1" FACE="$FontFace" COLOR="$TableStripTextColor">Moderator</FONT>
</td></tr>
INTROHTML
}  ## END FORUMS TOP HTML

sub ForumsGutsHTML {
print <<ForumSummary;
<TR>
<TD BGCOLOR=$AltColumnColor1 valign=top><FONT SIZE="$TextSize" FACE="$FontFace"><B><A HREF="$CGIURL/UltimateALT.cgi?action=topics&forum=$ForumCoded&number=$x&DaysPrune=$DaysPruneDefault&Browser=other">$ForumName</A></B>
<BR>
$ForumDesc</FONT></td>
<td BGCOLOR=$AltColumnColor2 align=center valign=top NOWRAP>
<FONT SIZE="$TextSize" FACE="$FontFace">$numberOfPosts</FONT>
</td><td BGCOLOR=$AltColumnColor1 NOWRAP valign=top align=center>
<FONT SIZE=$TextSize" FACE="$FontFace">$TheDate <FONT COLOR="$LinkColor" SIZE="$TextSize" FACE="$FontFace">$LatestTime</FONT>
</td>
<td BGCOLOR=$AltColumnColor2 valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace">$Moderator</FONT></td></tr>
ForumSummary
}  ## END FORUMS GUTS HTML

sub ForumsBottomHTML {
print <<BOTTOMhtml;
</table>
</center>
<P>
<FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">All times are $TimeZone.  $DateWording</FONT>

<P><center>
<FONT COLOR="#800000"><A HREF="mailto:$BBEmail">Contact Us</A> | <A HREF="$HomePageURL">$MyHomePage</A></FONT>
<p>
<FONT COLOR="$CopyrightTextColor" size="1">$YourCopyrightNotice
<P>
Powered by: 
Ultimate Bulletin Board, Version 4.5<BR>&copy; Madrona Park, Inc., 1997, 1998.
<br>
<br>

</FONT>
</CENTER>
</FONT>
</body></html>
BOTTOMhtml
}  ## END Forums Bottom HTML subroutine



##################


sub TopicTopHTML {
print <<TOP;
<HTML>
<HEAD><TITLE>$BBName</title>
</head>
 <BODY BGCOLOR="$BGColor" $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor" topmargin=0>
<b><FONT SIZE="$TextSize" FACE="$FontFace">
TOP
}  ## END TOPIC TOP HTML sr

sub TopicMidNonIEhtml {
print <<OtherMiddle;
<table border=0 width=$TableWidth>
<tr>
<td align=left valign=top>
<A HREF="UltimateALT.cgi"><IMG SRC="$NonCGIURL/$BBTitle" BORDER=0></A>
<BR>
<FONT SIZE="$TextSize" FACE="$FontFace" color="$LinkColor"><B>$Forum</B>
<br><FONT size= "1" COLOR="$VisitedLinkColor">(moderated by <A HREF="mailto:$ModeratorEmail">$Moderator</A>)</FONT>
</FONT>
</td>
<td valign=top nowrap><FONT SIZE="1" FACE="$FontFace">

<IMG SRC="$NonCGIURL/open.gif" WIDTH=15 HEIGHT=11 BORDER=0>&nbsp;&nbsp;<A HREF="$CGIURL/UltimateALT.cgi">$BBName</A>
<br>
<IMG SRC="$NonCGIURL/tline.gif" WIDTH=12 HEIGHT=12 BORDER=0><IMG SRC="$NonCGIURL/open.gif" WIDTH=15 HEIGHT=11 BORDER=0>&nbsp;&nbsp;$Forum
<P>
<CENTER>
<FONT SIZE="$TextSize" FACE="$FontFace">
<A HREF="$CGIURL/UltimateALT.cgi?action=newtopic&number=$number&forum=$ForumCoded&Browser=$Browser&DaysPrune=$DaysPrune"><IMG SRC="$NonCGIURL/$BBTopic"  BORDER=0 ALT="Post New Topic"></A></FONT>
<BR>
<A HREF="$CGIURL/UltimateALT.cgi?action=editbio&Browser=$Browser&DaysPrune=$DaysPrune">edit profile</A> | <A HREF="$CGIURL/UltimateALT.cgi?action=agree">register</A> | <A HREF="$CGIURL/UltimateALT.cgi?action=faq">help/faq</A>
<p>
<FORM ACTION="UltimateALT.cgi" NAME="PruneForm" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="topics">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$Forum">
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$number">
<INPUT TYPE="HIDDEN" NAME="Browser" VALUE="$Browser">
<SELECT NAME="DaysPrune">
	<OPTION value="1" $Days1>Show topics from last day
	<OPTION value="2" $Days2>Show topics from last 2 days
	<OPTION value="5" $Days5>Show topics from last 5 days
	<OPTION value="10" $Days10>Show topics from last 10 days
	<OPTION value="20" $Days20>Show topics from last 20 days
	<OPTION value="30" $Days30>Show topics from last 30 days
	<OPTION value="45" $Days45>Show topics from last 45 days
	<OPTION value="60" $Days60>Show topics from last 60 days
	<OPTION value="75" $Days75>Show topics from last 75 days
	<OPTION value="100" $Days100>Show topics from last 100 days
	<OPTION value="365" $Days365>Show topics from the last year
</SELECT>
<INPUT TYPE="SUBMIT" NAME="SUBMIT" VALUE="Go">
</FORM>
</CENTER>
</FONT>
</td></tr></table>

<table border=0 width=$TableWidth>
<tr bgcolor="$TableColorStrip">
<td>
<FONT SIZE="1" FACE="$FontFace" color="$TableStripTextColor">Topic</FONT>
</td>
<td>
<FONT SIZE="1" FACE="$FontFace" color="$TableStripTextColor">Originator</FONT>
</td>
<td><FONT SIZE="1" FACE="$FontFace" color="$TableStripTextColor">Replies</FONT>
</td>
<td NOWRAP><FONT SIZE="1" FACE="$FontFace" color="$TableStripTextColor">Last Post</FONT>
</td></tr>
OtherMiddle
}  ## END Middle HTML for Topic Page 

sub TopicGutsNonIEhtml {
print <<GUTS;
<TR>
<TD BGCOLOR="$AltColumnColor1">
$FolderIcon<FONT SIZE="$TextSize" FACE="$FontFace">&nbsp;
<A HREF="$CGIURL/UltimateALT.cgi?action=threadlist&forum=$ForumCoded&number=$number&topic=$topic&Browser=$Browser&DaysPrune=$DaysPrune&LastLogin=$in{'LastLogin'}&NewThreadPosts=$NewThreadPosts">$subject</A>
</FONT>
</td>
<td BGCOLOR="$AltColumnColor2">
<FONT SIZE="$TextSize" FACE="$FontFace">$author</FONT>
</td>
<td align=center BGCOLOR="$AltColumnColor1">
<FONT SIZE="$TextSize" FACE="$FontFace">$RepliesFormat</FONT>
</td>
<td NOWRAP BGCOLOR="$AltColumnColor2">
<FONT SIZE="$TextSize" FACE="$FontFace">$TheDate <FONT SIZE="1" FACE="$FontFace" COLOR="$TableStripTextColor">$FormatTime</FONT></FONT>
</td></tr>
GUTS
}  ## END Guts HTML for Topic Page (Non IE version)


sub TopicBottomNonIEhtml {
print<<BOTTOM
</table>
<br>
<table border=0 width=$TableWidth>
<tr><td align=left valign=top>
<FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">All times are $TimeZone. $DateWording</FONT></td>
<td align=right NOWRAP>
<FONT SIZE="$TextSize" FACE="$FontFace">
<FORM ACTION="UltimateALT.cgi" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="topics">
<INPUT TYPE="HIDDEN" NAME="Browser" VALUE="$Browser">
<INPUT TYPE="HIDDEN" NAME="DaysPrune" VALUE="$DaysPrune">
<B>Hop to: </B><SELECT NAME="number">
BOTTOM
} ## End TopicBottomNonIEhtml

sub TopicBottom2NonIEhtml {
print<<TrueTopicBottom;
</SELECT><INPUT TYPE="SUBMIT" NAME="SUBMIT" VALUE="Go"></FORM></FONT></TD></tr></TABLE>
<P>
<IMG SRC="$NonCGIURL/lock.gif" WIDTH=9 HEIGHT=11 BORDER=0 ALT="Closed Thread">&nbsp;&nbsp;A Closed thread - no new replies accepted.
<P>
<CENTER><B><A HREF="$CGIURL/UltimateALT.cgi?action=newtopic&number=$number&forum=$ForumCoded&Browser=$Browser&DaysPrune=$DaysPrune&LastLogin=$in{'LastLogin'}">Post New Topic</A> | 
<A HREF="mailto:$BBEmail">Contact Us</A> | <A HREF="$HomePageURL">$MyHomePage</A>
</B>
</CENTER><P><BR>
<center><FONT SIZE="1" FACE="$FontFace" COLOR="$CopyrightTextColor">
$YourCopyrightNotice
<P>
Powered by: 
Ultimate Bulletin Board, Version 4.5<BR>&copy; Madrona Park, Inc., 1997, 1998.
<br>
<br>

</FONT>
</center>
</body></html>
TrueTopicBottom
}


###########


sub ThreadTopHTML {
print <<TOP;
<HTML>
<HEAD><TITLE>$BBName</title>
</head>
 <BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<b><FONT SIZE="$TextSize" FACE="$FontFace">

<table border=0 width=$TableWidth cellpadding=5><TR>
<td valign=top align=left>
<A HREF="UltimateALT.cgi"><IMG SRC="$NonCGIURL/$BBTitle"  BORDER=0></A>
<BR><center><FONT SIZE="1" FACE="$FontFace" COLOR="$LinkColor">$ThisThreadClosed</FONT></center>
</FONT>
</td>
<td NOWRAP valign=top>
<FONT SIZE="1" FACE="$FontFace">
<IMG SRC="$NonCGIURL/open.gif" WIDTH=15 HEIGHT=11 BORDER=0>&nbsp;&nbsp;<A HREF="$CGIURL/UltimateALT.cgi">$BBName</A>
<br>
<IMG SRC="$NonCGIURL/tline.gif" WIDTH=12 HEIGHT=12 BORDER=0><IMG SRC="$NonCGIURL/open.gif" WIDTH=15 HEIGHT=11 BORDER=0>&nbsp;&nbsp;<A HREF="$CGIURL/UltimateALT.cgi?action=topics&forum=$ForumCoded&number=$number&DaysPrune=$DaysPrune&Browser=$Browser&LastLogin=$in{'LastLogin'}">$Forum</A>
<br>
<IMG SRC="$NonCGIURL/tline3.gif" WIDTH=24 HEIGHT=12 BORDER=0><IMG SRC="$NonCGIURL/open.gif" WIDTH=15 HEIGHT=11 BORDER=0>&nbsp;&nbsp;$TopicSubject
<center>
<P>
<FONT SIZE="$TextSize" FACE="$FontFace">
<A HREF="$CGIURL/UltimateALT.cgi?action=newtopic&number=$number&forum=$ForumCoded&Browser=$Browser&DaysPrune=$DaysPrune"><IMG SRC="$NonCGIURL/$BBTopic"  BORDER=0 ALT="Post New Topic"></A>&nbsp;&nbsp;<A HREF="$CGIURL/UltimateALT.cgi?action=reply&forum=$ForumCoded&number=$number&topic=$topic&TopicSubject=$SubjectCoded&Browser=$Browser&DaysPrune=$DaysPrune">$ReplyButton</A></FONT>
<BR>
<A HREF="$CGIURL/UltimateALT.cgi?action=editbio&Browser=$Browser&DaysPrune=$DaysPrune">edit profile</A> | <A HREF="$CGIURL/UltimateALT.cgi?action=agree">register</A> | <A HREF="$CGIURL/UltimateALT.cgi?action=faq">help/faq</A>
</center>
</td></tr></table>
TOP
}  ## END Thread Top HTML sr

sub ThreadGutsNonIEhtml {
if ($EditOption eq "ON") {
$EditLink = "<A HREF=\"UltimateALT.cgi?action=editpost&forum=$ForumCoded&number=$number&topic=$topic&TopicSubject=$SubjectCoded&Browser=other&DaysPrune=$DaysPrune\"><IMG SRC=\"$NonCGIURL/edit.gif\" BORDER=0 ALT=\"Edit Message\"></A>";
}  else {
$EditLink = "";
}


print<<otherHTML;
<center>
<table width=$TableWidth border=0 cellpadding=5>
<TR bgcolor="$TableColorStrip">
<TD valign=top width=18%>
<FONT SIZE="1" face="$FontFace" color="$TableStripTextColor"><B>Name</B></FONT>
</TD>
<TD valign=top>
<FONT SIZE="1" face="$FontFace" color="$TableStripTextColor"><B>Post</B></FONT>
</TD>
</TR>
<tr bgcolor="$AltColumnColor1">
<td NOWRAP width=18% valign=top>
<FONT SIZE="$TextSize" face="$FontFace"><B>$topicguts[0]</B></FONT></td>
</TD>
<td valign=top>
<IMG SRC="$PostFolder" BORDER=0>
<FONT SIZE="$TextSize" FACE="$FontFace">
<FONT SIZE="1" color="$TableStripTextColor" face="$FontFace">posted $ThisDate $FormatTime $TimeZone&nbsp;&nbsp;&nbsp;<A HREF="$CGIURL/UltimateALT.cgi?action=getbio&UserName=$UNCoded" target=_new><IMG SRC="$NonCGIURL/$profilegif" BORDER=0 ALT="Profile for $topicguts[0]"></A>&nbsp;&nbsp;<A HREF="mailto:$topicguts[4]"><IMG SRC="$NonCGIURL/$mailgif" BORDER=0 ALT="Email for $topicguts[0]"></A> &nbsp;&nbsp;$EditLink</FONT><HR>$topicguts[5]</FONT>
</td></tr>
otherHTML
}  ## Guts HTML for Threads page (non Internet Explorer version)

sub ThreadRepliesNonIEhtml {
if ($EditOption eq "ON") {
$EditLink = "<A HREF=\"UltimateALT.cgi?action=editpost&forum=$ForumCoded&number=$number&topic=$matchreply&TopicSubject=$SubjectCoded&Browser=other&DaysPrune=$DaysPrune\"><IMG SRC=\"$NonCGIURL/edit.gif\"  BORDER=0 ALT=\"Edit Message\"></A>";
}  else {
$EditLink = "";
}

print <<REPLYhtml;
<tr bgcolor="$AlternateColor">
	<TD width=18% valign=top>
	<FONT SIZE="$TextSize" face="$FontFace"><B>$replyguts[0]</B>$NameFinish</FONT>
</td>
<TD>
<IMG SRC="$PostFolder" BORDER=0 ALT="">
<FONT SIZE="$TextSize" FACE="$FontFace">
<FONT SIZE="1" color="$TableStripTextColor" face="$FontFace">posted $ThisDate $FormatTime $TimeZone&nbsp;&nbsp;&nbsp;
<A HREF="$CGIURL/UltimateALT.cgi?action=getbio&UserName=$UserNameCoded" target=_new>
<IMG SRC="$NonCGIURL/$profilegif" BORDER=0 ALT="Profile for $replyguts[0]"></A>&nbsp;&nbsp;<A HREF="mailto:$replyguts[4]"><IMG SRC="$NonCGIURL/$mailgif" BORDER=0 ALT="Email $replyguts[0]"></A>&nbsp;&nbsp;$EditLink</FONT>
<HR>$replyguts[5]
</FONT>
</td></tr>
REPLYhtml
}  ## END Replies within Thread page (non IE version)

sub ThreadBottomNonIEhtml {
print<<BOTTOM;
</table></center>
<p>
$CloseOption
<table border=0 width=$TableWidth><tr><td><CENTER><A HREF="$CGIURL/UltimateALT.cgi?action=newtopic&number=$number&forum=$ForumCoded&Browser=$Browser&DaysPrune=$DaysPrune"><IMG SRC="$NonCGIURL/$BBTopic"  BORDER=0 ALT="Post New Topic"></A>&nbsp;&nbsp;<A HREF="$CGIURL/UltimateALT.cgi?action=reply&forum=$ForumCoded&number=$number&topic=$topic&TopicSubject=$SubjectCoded&Browser=other&DaysPrune=$DaysPrune">$replyButton</A></CENTER></TD>
<td align=right valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace">
<FORM ACTION="UltimateALT.cgi" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="topics">
<INPUT TYPE="HIDDEN" NAME="Browser" VALUE="$Browser">
<INPUT TYPE="HIDDEN" NAME="DaysPrune" VALUE="$DaysPrune">
<B>Hop to: </B><SELECT NAME="number">
BOTTOM
} #END ThreadBottomNonIEhtml sr

sub ThreadBottom2NonIEhtml {
print<<Bottom2;
</SELECT><INPUT TYPE="SUBMIT" NAME="SUBMIT" VALUE="Go"></FORM></font></TD></tr></TABLE>
<P>
<CENTER><B><FONT SIZE="$TextSize" FACE="$FontFace">
<A HREF="mailto:$BBEmail">Contact Us</A> | <A HREF="$HomePageURL">$MyHomePage</A>
</B></FONT>
<p><BR><FONT SIZE="1" FACE="$FontFace" COLOR="$CopyrightTextColor">
$YourCopyrightNotice
<P>
Powered by: 
Ultimate Bulletin Board, Version 4.5 <BR>&copy; Madrona Park, Inc., 1997, 1998.
<br>
<br>

</FONT>
</center>
</body></html>
Bottom2
}  ## END bottom of Threads page


sub ReplyFormLWAHTML {
print <<REPLYFORM;
<HTML><HEAD>
</HEAD>
 <BODY BGCOLOR="$BGColor" $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<table border=0>
<TR><TD>
<A HREF="UltimateALT.cgi"><IMG SRC="$NonCGIURL/$BBTitle"  BORDER=0></A></td>
<td valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace" color="$TextColor">
<B>
Forum: <FONT COLOR="$VisitedLinkColor">$Forum </FONT>
<BR>
Topic: <FONT COLOR="$VisitedLinkColor">$TopicSubject</FONT>
</B>
</FONT>
</td></tr></table>
<CENTER><table border=0 bgcolor="$AltColumnColor1" width=100%>
<TR><TD align=center><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor"><B>Only Administrators, Moderators, and users with the forum password may post notes in this particular forum</B></font></td></tr></table>
<p><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$VisitedLinkColor">
Note: You must be registered in order to post a topic or reply. <br>
To register, <A HREF="$CGIURL/UltimateALT.cgi?action=agree">click here</A>.  Registration is FREE!
</FONT>
</CENTER>
<ul>
<FORM ACTION="UltimateALT.cgi" NAME="REPLIER" METHOD="POST">
<table border=0>
<tr><td NOWRAP>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor"><B>Your UserName:</B></FONT></td>
<td>
<INPUT TYPE="TEXT" NAME="UserName" VALUE="" SIZE=25 MAXLENGTH=25>
</td>
</tr>
<tr>
<td NOWRAP>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor"><B>Your Password:</B></FONT></td>
<td><INPUT TYPE="PASSWORD" NAME="Password" VALUE="" SIZE=13 MAXLENGTH=13>&nbsp;&nbsp;<FONT SIZE="1" FACE="$FontFace"><A HREF="UltimateALT.cgi?action=lostpw">Forget your password?</A></FONT>
</td></tr>
<tr>
<td colspan=2>
<B><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">If you are an administrator or moderator, you do not need to type a forum password.  If you are not, you must supply the forum password in order to post a message in this forum.</FONT></B>
</td></tr>
<tr>
<td NOWRAP>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor"><B>Forum Password:</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="ForumPassword" VALUE="" SIZE=10 MAXLENGTH=25> 
</td></tr>
<TR><TD valign=top NOWRAP>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor"><B>Your Reply:</B></FONT>
<p><BR>
<FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">
$ISHTML<BR>
$ISUBB</p></font>
</td>
<td>
<TEXTAREA NAME="ReplyMessage" ROWS=10 COLS=45 WRAP="VIRTUAL"></TEXTAREA>
</td></tr>
</table>
<p>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="postreply">
<INPUT TYPE="HIDDEN" NAME="TopicSubject" VALUE="$TopicSubject">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$Forum">
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$number">
<INPUT TYPE="HIDDEN" NAME="topic" VALUE="$topic">
<INPUT TYPE="HIDDEN" NAME="Browser" VALUE="$Browser">
<INPUT TYPE="HIDDEN" NAME="DaysPrune" VALUE="$DaysPrune">
<INPUT TYPE="HIDDEN" NAME="HTMLAllowed" VALUE="$HTMLAllowed">
<INPUT TYPE="HIDDEN" NAME="UBBAllowed" VALUE="$UBBAllowed">
<INPUT TYPE="HIDDEN" NAME="LWAForum" VALUE="yes">
<CENTER>
 <FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">
<P>
If you have previously registered, but forgotten your password, <A HREF="UltimateALT.cgi?action=lostpw">click here</A>.
</font>
<p>
<INPUT TYPE="Submit" NAME="SUBMIT" VALUE="Submit Reply">
<INPUT TYPE="RESET" NAME="RESET" VALUE="Clear Fields">
</form>
<P>
<FONT SIZE="1" FACE="$FontFace" COLOR="#FF0000">*If HTML and/or <A HREF="$NonCGIURL/ubbcode.html" target=_new>UBB Code</A> are enabled, this means you can use use HTML and/or UBB Code in your message.</FONT>
</center>
<br></ul><center>
REPLYFORM
} # end ReplyFormLWAHTML


sub ReplyFormHTML {
print <<REPLYFORM;
<HTML><HEAD>
</HEAD>
 <BODY BGCOLOR="$BGColor" $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<table border=0>
<TR><TD>
<A HREF="UltimateALT.cgi"><IMG SRC="$NonCGIURL/$BBTitle"  BORDER=0></A></td>
<td valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace" color="$TextColor">
<B>
Forum: <FONT COLOR="$VisitedLinkColor">$Forum </FONT>
<BR>
Topic: <FONT COLOR="$VisitedLinkColor">$TopicSubject</FONT>
</B>
</FONT>

</td></tr></table>
<CENTER><FONT SIZE="$TextSize" FACE="$FontFace">Note: You must be registered in order to post a topic or reply. <br>
To register, <A HREF="$CGIURL/UltimateALT.cgi?action=agree">click here</A>.  Registration is FREE!
</FONT>
</CENTER>
<ul>
<FORM ACTION="UltimateALT.cgi" NAME="REPLIER" METHOD="POST">
<table border=0>
<tr><td>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor">Your UserName:</FONT></td>
<td>
<INPUT TYPE="TEXT" NAME="UserName" VALUE="" SIZE=25 MAXLENGTH=25>
</td>
</tr>
<tr>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor">Your Password:</FONT></td>
<td><INPUT TYPE="PASSWORD" NAME="Password" VALUE=""  SIZE=13 MAXLENGTH=13>&nbsp;&nbsp;<FONT SIZE="1" FACE="$FontFace"><A HREF="UltimateALT.cgi?action=lostpw">Forget your password?</A></FONT>
</td></tr>
<TR><TD valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor">Your Reply:</FONT><p>
<FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">
$ISHTML<BR>
$ISUBB</p></font>
</td>
<td>
<TEXTAREA NAME="ReplyMessage" ROWS=10 COLS=45 WRAP="VIRTUAL"></TEXTAREA>
</td></tr>
</table>
<p>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="postreply">
<INPUT TYPE="HIDDEN" NAME="TopicSubject" VALUE="$TopicSubject">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$Forum">
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$number">
<INPUT TYPE="HIDDEN" NAME="topic" VALUE="$topic">
<INPUT TYPE="HIDDEN" NAME="Browser" VALUE="$Browser">
<INPUT TYPE="HIDDEN" NAME="DaysPrune" VALUE="$DaysPrune">
<INPUT TYPE="HIDDEN" NAME="HTMLAllowed" VALUE="$HTMLAllowed">
<INPUT TYPE="HIDDEN" NAME="UBBAllowed" VALUE="$UBBAllowed">
<CENTER>
 <FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">
<P>
If you have previously registered, but forgotten your password, <A HREF="UltimateALT.cgi?action=lostpw">click here</A>.
</font>
<p>
<INPUT TYPE="Submit" NAME="SUBMIT" VALUE="Submit Reply">
<INPUT TYPE="RESET" NAME="RESET" VALUE="Clear Fields">
</form>
<P>
<FONT SIZE="1" FACE="$FontFace" COLOR="#FF0000">*If HTML and/or <A HREF="$NonCGIURL/ubbcode.html" target=_new>UBB Code</A> are enabled, this means you can use use HTML and/or UBB Code in your message.</FONT>
</center>
<br></ul><center>
REPLYFORM
} # end ReplyFormHTML

sub ReplyFormBottom {
print<<REPLYFORMBOTTOM
</table>
<P>
<FONT SIZE="$TextSize" FACE="$FontFace">
<CENTER><B>
<A HREF="mailto:$BBEmail">Contact Us</A> | <A HREF="$HomePageURL">$MyHomePage</A>
</B></FONT>
<FONT SIZE="1" FACE="$FontFace" COLOR="$CopyrightTextColor">
<br><br><br><B>
$YourCopyrightNotice
<P>
Powered by: Ultimate Bulletin Board, Version 4.5<br>&copy;Madrona Park, Inc., 1997, 1998.
</FONT></B></CENTER>
</BODY></HTML>
REPLYFORMBOTTOM
}  ## END Reply Form Bottom sr


sub ReplyConfirmHTML {
print <<CONFIRM;
<HTML><HEAD>
<meta http-equiv="Refresh" content="3; URL=UltimateALT.cgi?action=threadlist&forum=$ForumCoded&number=$number&Browser=$Browser&DaysPrune=$DaysPrune&topic=$newFileName">
</HEAD>
 <BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<br><br>
<ul><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">
<B>Thanks for posting your message, $UserName!  We are now sending you back automatically to the thread list for this topic.  Please wait three seconds.
</B><br><br>


</FONT>
</ul></body></html>
CONFIRM
}  ## END Reply Confirmation HTML


sub TopicFormHTML {
print <<FORM;
<HTML>
<HEAD>
</HEAD>
 <BODY BGCOLOR="$BGColor" $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<table border=0>
<TR><TD>
<A HREF="UltimateALT.cgi"><IMG SRC="$NonCGIURL/$BBTitle"  BORDER=0></A></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace">
<B>Post New Topic for Forum:<br>&nbsp;&nbsp;&nbsp;<FONT COLOR="$LinkColor">$Forum</FONT></FONT></B>
</td></tr></table>
<CENTER><FONT SIZE="$TextSize" FACE="$FontFace">Note: You must be registered in order to post a topic or reply. <br>
To register, <A HREF="$CGIURL/UltimateALT.cgi?action=agree">click here</A>.  Registration is FREE!<BR><br>
</CENTER>
</FONT>
<UL><FORM ACTION="UltimateALT.cgi" METHOD="POST" NAME="PostTopic">
<table border=0>
<tr>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Your UserName:</B></FONT></td><td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td></tr>
<tr>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Your Password:</B></FONT></td><td><INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>&nbsp;&nbsp;<FONT SIZE="1" FACE="$FontFace"><A HREF="UltimateALT.cgi?action=lostpw">Forget your password?</A></FONT></td></tr>
<TR>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Subject:</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="TopicSubject" VALUE="" SIZE=40 MAXLENGTH=120></td></tr>
<tr><td valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Message:</B></FONT><p>
<FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">
$ISHTML<BR>
$ISUBB</p>
</FONT></td>
<td>
<TEXTAREA NAME="Message" ROWS=6 COLS=45 WRAP="VIRTUAL">
</TEXTAREA></td></tr></table>
<BR><BR>
$EmailNotificationHTML

<P>
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$number">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$Forum">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="posttopic">
<INPUT TYPE="HIDDEN" NAME="Browser" VALUE="$Browser">
<INPUT TYPE="HIDDEN" NAME="DaysPrune" VALUE="$DaysPrune">
<INPUT TYPE="HIDDEN" NAME="HTMLAllowed" VALUE="$HTMLAllowed">
<INPUT TYPE="HIDDEN" NAME="UBBAllowed" VALUE="$UBBAllowed">
<CENTER>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit New Topic">
<INPUT TYPE="RESET" NAME="Reset" VALUE="Clear Fields">
</form></center>
<br></ul>
<FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">*If HTML and/or <A HREF="$NonCGIURL/ubbcode.html" target=_new>UBB Code</A> are enabled, this means you can use use HTML and/or UBB Code in your message.</FONT>
<P>
<center>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor">
If you have previously registered, but forgotten your password, <A HREF="UltimateALT.cgi?action=lostpw">click here</A>.
<P>
<B>
<A HREF="mailto:$BBEmail">Contact Us</A> | <A HREF="$HomePageURL">$MyHomePage</A>
</B>
</FONT>
<p>
<FONT SIZE="1" FACE="$FontFace" color="$CopyrightTextColor">
$YourCopyrightNotice
<P>
Powered by: Ultimate Bulletin Board, Version 4.5<br>UBB is &copy;Madrona Park, Inc., 1997, 1998</FONT>
</CENTER>
</ul>
</BODY></HTML>
FORM
}  ## END Topic Form HTML



sub TopicFormLWAHTML {
print <<FORM;
<HTML>
<HEAD>
</HEAD>
 <BODY BGCOLOR="$BGColor" $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<table border=0>
<TR><TD>
<A HREF="UltimateALT.cgi"><IMG SRC="$NonCGIURL/$BBTitle"  BORDER=0></A></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace">
<B>Post New Topic for Forum:<br>&nbsp;&nbsp;&nbsp;<FONT COLOR="$LinkColor">$Forum</FONT></FONT></B>
</td></tr></table>
<CENTER><table border=0 bgcolor="$AltColumnColor1" width=100%>
<TR><TD align=center><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor"><B>Only Administrators, Moderators, and users with the forum password may post notes in this particular forum</B></font></td></tr></table>
<p><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$VisitedLinkColor">
Note: You must be registered in order to post a topic or reply. <br>
To register, <A HREF="$CGIURL/UltimateALT.cgi?action=agree">click here</A>.  Registration is FREE!
</FONT>
</CENTER>
</FONT>
<UL><FORM ACTION="UltimateALT.cgi" METHOD="POST" NAME="PostTopic">
<table border=0>
<tr>
<td NOWRAP>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Your UserName:</B></FONT></td><td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td></tr>
<tr>
<td NOWRAP>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Your Password:</B></FONT></td><td><INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>&nbsp;&nbsp;<FONT SIZE="1" FACE="$FontFace"><A HREF="UltimateALT.cgi?action=lostpw">Forget your password?</A></FONT></td></tr>
<tr>
<td colspan=2>
<B><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">If you are an administrator or moderator, you do not need to type a forum password.  If you are not, you must supply the forum password in order to post a message in this forum.</FONT></B>
</td></tr>
<tr>
<td NOWRAP>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor"><B>Forum Password:</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="ForumPassword" VALUE="" SIZE=10 MAXLENGTH=25>
</td></tr>
<TR>
<td NOWRAP>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Subject:</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="TopicSubject" VALUE="" SIZE=40 MAXLENGTH=120></td></tr>
<tr><td valign=top NOWRAP>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Message:</B></FONT>
<p><BR>
<FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">
$ISHTML<BR>
$ISUBB</p></font>
</td>
<td>
<TEXTAREA NAME="Message" ROWS=6 COLS=45 WRAP="VIRTUAL">
</TEXTAREA></td></tr></table>
<BR><BR>
$EmailNotificationHTML

<P>
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$number">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$Forum">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="posttopic">
<INPUT TYPE="HIDDEN" NAME="Browser" VALUE="$Browser">
<INPUT TYPE="HIDDEN" NAME="DaysPrune" VALUE="$DaysPrune">
<INPUT TYPE="HIDDEN" NAME="HTMLAllowed" VALUE="$HTMLAllowed">
<INPUT TYPE="HIDDEN" NAME="UBBAllowed" VALUE="$UBBAllowed">
<INPUT TYPE="HIDDEN" NAME="LWAForum" VALUE="yes">
<CENTER>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit New Topic">
<INPUT TYPE="RESET" NAME="Reset" VALUE="Clear Fields">
</form></center>
<br></ul>
<FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">*If HTML and/or <A HREF="$NonCGIURL/ubbcode.html" target=_new>UBB Code</A> are enabled, this means you can use use HTML and/or UBB Code in your message.</FONT>
<P>
<center>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor">
If you have previously registered, but forgotten your password, <A HREF="UltimateALT.cgi?action=lostpw">click here</A>.
<P>
<B>
<A HREF="mailto:$BBEmail">Contact Us</A> | <A HREF="$HomePageURL">$MyHomePage</A>
</B>
</FONT>
<p>
<FONT SIZE="1" FACE="$FontFace" color="$CopyrightTextColor">
$YourCopyrightNotice
<P>
Powered by: Ultimate Bulletin Board, Version 4.5<br>UBB is &copy;Madrona Park, Inc., 1997, 1998</FONT>
</CENTER>
</ul>
</BODY></HTML>
FORM
}  ## END Topic Form LWA HTML

sub TopicConfirmHTML {
print <<Confirm;
<HTML>
<HEAD>
<meta http-equiv="Refresh" content="3; URL=UltimateALT.cgi?action=topics&forum=$ForumCoded&number=$number&DaysPrune=$DaysPrune&Browser=$Browser">
</HEAD>
 <BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<br><br>
<ul><FONT SIZE="$TextSize" FACE="$FontFace">
<B>Thanks for posting your message, $UserName!  We are now taking you back automatically to the topic list for $Forum.  Please wait two seconds.
</B><br><br>

</FONT>
</ul></body></html>
Confirm
}  ## END Topic Confirmatin HTML

########


sub ViewBioHTML {

print <<BioHTML;
<HTML>
 <BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Profile for $thisprofile[0]</B></FONT>
<HR>
<BLOCKQUOTE>
<table border=0>
<tr><td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Status:</B></FONT></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$thisprofile[8]</FONT>
</td></tr>
<tr><td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Total Posts:</B></FONT></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$thisprofile[7]</FONT>
</td></tr>
<tr><td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Current Email:</B></FONT></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor"><A HREF="mailto:$thisprofile[2]">$thisprofile[2]</A></FONT>
</td></tr>
<TR>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><B>Homepage:</B></font></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor"><A HREF="$thisprofile[3]" target=_top>$thisprofile[3]</A></font>
</td></tr>
<TR>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><B>Occupation:</B></font></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$thisprofile[5]</font>
</td></tr>
<TR>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><B>Location:</B></font></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$thisprofile[6]</font>
</td></tr>
<TR>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><B>Interests:</B></font></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$thisprofile[9]</font>
</td></tr>
</table>
</BLOCKQUOTE>
<HR>
</BODY></HTML>
BioHTML
}  ## END View BIO HTML sr


sub EditBio {
print<<EDITbioHTML;
<HTML>
<HEAD><TITLE>$BBName - Edit Profile</TITLE>
</HEAD>
 <BODY BGCOLOR="$BGColor" $PageBackground  text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<A HREF="UltimateALT.cgi"><IMG SRC="$NonCGIURL/$BBTitle" BORDER=0></A>
<FONT SIZE="3" FACE="$FontFace" COLOR="$LinkColor"><B>Modify Your Profile</B></FONT>
<p>
<FONT SIZE="$TextSize" FACE="$FontFace">
It is your responsibility to keep your profile information up-to-date.  Do not ask the administrator or moderators to do this for you.
<p>
To modify your current profile information, please identify yourself below.

<p>
<FORM ACTION="UltimateALT.cgi" METHOD="POST" NAME="EditProfile">
<table border=0>
<tr>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>UserName</B></FONT>
</td>
<td>
<INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td></tr>
<tr>
<td>
<B><FONT SIZE="$TextSize" FACE="$FontFace">Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>&nbsp;&nbsp;<FONT SIZE="1" FACE="$FontFace"><A HREF="UltimateALT.cgi?action=lostpw">Forget your password?</A></FONT>
</td></tr>
</table>
<center>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="checkbioid">
<INPUT TYPE="HIDDEN" NAME="Browser" VALUE="$Browser">
<INPUT TYPE="HIDDEN" NAME="DaysPrune" VALUE="$DaysPrune">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Identification">
<INPUT TYPE="RESET" NAME="Reset" VALUE="Clear Fields">
</center>

</form>

<P>
If you have previously registered, but forgotten your password, <A HREF="UltimateALT.cgi?action=lostpw">click here</A>.
<P>
</FONT>
</BODY></HTML>
EDITbioHTML

}  ##END EDIT BIO SR

sub BioModifyConfirmHTML {
print<<HTML;
<HTML>
<HEAD><TITLE>
Member Profile Modification Confirmation</title>
</head>
 <BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor"><BR><BR>
<p><FONT SIZE="$TextSize" FACE="$FontFace"><B>
Thank you, $UserName.  Your profile has been successfully updated.
<P>
$ModifyWarning
<P>
<table border=0>
<TR>
<TD valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Return to:</B></FONT></td>
<td valign=top>
<a href="UltimateALT.cgi?action=intro">Forums Summary Page</a> |
<a href="UltimateALT.cgi?action=editbio&Browser=$Browser&DaysPrune=$DaysPrune">Edit Your Profile</a>
</td></tr></table>
</B>
</FONT>
</body>
</html>
HTML
}  ## END Bio Modify Confirmation sr

sub ProcessEdit {

if (($UseEmail eq "ON") && ($EmailVerify eq "ON")) {
$WarningHTML = "Warning: Because we require email verification, if you change your email address, a new password will be created for you and emailed to the new email address you list.  Thus, do not change your email address unless you can retrieve email from it to get your new password.";
}  else {
$WarningHTML = "";
}



print<<EditHTML;
<HTML>
 <BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<A HREF="UltimateALT.cgi"><IMG SRC="$NonCGIURL/$BBTitle" BORDER=0></A>
<FONT SIZE="3" FACE="$FontFace" COLOR="$LinkColor"><B>Modify Your Profile</B></FONT>
<p><FONT SIZE="$TextSize" FACE="$FontFace">
Thank you! We have confirmed your identity, $UserName ($Status).
<p>
Feel free to modify any of the fields below.
<p><b>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$WarningHTML</FONT></b>
<P>
</FONT>
<FORM ACTION="UltimateALT.cgi" METHOD="POST">
<table border=0>
<tr>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Email Address</B></FONT>
</td>
<td>
<INPUT TYPE="TEXT" NAME="Email" VALUE="$Email" SIZE=30 MAXLENGTH=155>
</td></tr>
<tr>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Password</B></FONT>
</td>
<td>
<INPUT TYPE="TEXT" NAME="NewPassword" VALUE="$Password" SIZE=30 MAXLENGTH=155>
</td></tr>
<tr>
<td>
<B><FONT SIZE="$TextSize" FACE="$FontFace">Homepage</FONT></B>
</td>
<td>
<INPUT TYPE="TEXT" NAME="URL" VALUE="$URL" SIZE=30 MAXLENGTH=200>
</td></tr>
<tr>
<td>
<B><FONT SIZE="$TextSize" FACE="$FontFace">Occupation</FONT></B>
</td>
<td>
<INPUT TYPE="TEXT" NAME="Occupation" VALUE="$Occupation" SIZE=30 MAXLENGTH=100>
</td></tr>
<tr>
<td>
<B><FONT SIZE="$TextSize" FACE="$FontFace">City, State, Country</FONT></B>
</td>
<td>
<INPUT TYPE="TEXT" NAME="Location" VALUE="$Location" SIZE=30 MAXLENGTH=150>
</td></tr>
<tr>
<td>
<B><FONT SIZE="$TextSize" FACE="$FontFace">Interests</FONT></B>
</td>
<td>
<INPUT TYPE="TEXT" NAME="Interests" VALUE="$Interests" SIZE=50 MAXLENGTH=200>
</td></tr>
</table>
<center>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="modifybio">
<INPUT TYPE="HIDDEN" NAME="UserName" VALUE="$UserName">
<INPUT TYPE="HIDDEN" NAME="Password" VALUE="$in{'Password'}">
<INPUT TYPE="HIDDEN" NAME="Browser" VALUE="$Browser">
<INPUT TYPE="HIDDEN" NAME="DaysPrune" VALUE="$DaysPrune">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Modifications">
<INPUT TYPE="RESET" NAME="Reset" VALUE="Clear Fields">
</center>
</form>
</BODY></HTML>
EditHTML
}  ##END Process Edit SR

sub Register {
if (($UseEmail eq "ON") && ($EmailVerify eq "ON")) {
$EmailVerifyHTML = "<tr><TD bgcolor=\"$AltColumnColor2\" colspan=2><FONT SIZE=\"$TextSize\" FACE=\"$FontFace\" COLOR=\"$LinkColor\">IMPORTANT: We will email your registration password to the email address you provide.  Thus, failure to provide your actual email address will mean you can not post any messages or replies on this bulletin board.</FONT></td></tr>";

$PasswordWording1 = "UserNames can be up to 25 characters.  Please use only letters and numbers.";
$PasswordWording2 = "";

} else {

$EmailVerifyHTML = "<TR><TD bgcolor=\"$AltColumnColor2\"><FONT SIZE=\"$TextSize\" FACE=\"$FontFace\"><B>Password*</B></FONT></TD><TD><INPUT TYPE=\"PASSWORD\" NAME=\"Password\" VALUE=\"\" SIZE=13 MAXLENGTH=13> </TD></TR><TR><TD bgcolor=\"$AltColumnColor2\"><FONT SIZE=\"$TextSize\" FACE=\"$FontFace\"><B>Enter Password Again*</B></FONT></TD><TD><INPUT TYPE=\"PASSWORD\" NAME=\"PasswordConfirm\" VALUE=\"\" SIZE=13 MAXLENGTH=13></TD></tr>";

$PasswordWording1 = "UserNames can be up to 25 characters and passwords can be a maximum of 13 characters.  Please use only letters and numbers.  Passwords are case-sensitive.  This means that \"Howard\" is distinct from \"HOWARD.\"";

$PasswordWording2 = "In addition, your passwords are not encrypted and can be seen by the BB administrators.  Do not use a password that you would be afraid to reveal to anyone.";
}

print<<RegHTML;
<HTML>
<HEAD>
	<TITLE>$BBName Registration</TITLE>
</HEAD>
 <BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<A HREF="UltimateALT.cgi"><IMG SRC="$NonCGIURL/$BBTitle" BORDER=0></A>
<FONT SIZE="3" FACE="$FontFace" COLOR="$LinkColor"><B>
Bulletin Board Registration

</B></FONT>
<P>
<table border=0>
<tr>
<td colspan=2>
<FONT SIZE="$TextSize" FACE="$FontFace">
<B>In order to post messages on this Bulletin Board, you must first register.  
<BR><BR>
$PasswordWording1
 
<BR><BR>
Note: all of the information provided on this page (with the exception of your password) will be viewable by anyone visiting the bulletin board.  Thus, if you don't feel comfortable about completing certain fields, just leave them blank.  $PasswordWording2 Required fields are marked by an asterisk.
<br><br></B></FONT>

</td></tr>
<tr>
<FORM NAME="Register" METHOD=POST ACTION="UltimateALT.cgi">

<TD bgcolor="$AltColumnColor1"><FONT SIZE="$TextSize" FACE="$FontFace"><B>User Name*</B></FONT></TD>
<TD><INPUT TYPE="TEXT" NAME="UserName" VALUE="" SIZE=25 MAXLENGTH=25>
 </TD>
</TR>


$EmailVerifyHTML


<TR>
	<TD bgcolor="$AltColumnColor1"><FONT SIZE="$TextSize" FACE="$FontFace"><B>Email*</B></FONT></TD>
	<TD><INPUT TYPE="TEXT" NAME="Email" VALUE="" SIZE=30 MAXLENGTH=50>
 </TD>
</TR>
<TR>
	<TD bgcolor="$AltColumnColor2"><FONT SIZE="$TextSize" FACE="$FontFace"><B>City, State, Country</B></FONT></TD>
	<TD><INPUT TYPE="TEXT" NAME="Location" VALUE="" SIZE=30 MAXLENGTH=50>
 </TD></tr>

<TR>
	<TD bgcolor="$AltColumnColor1"><FONT SIZE="$TextSize" FACE="$FontFace"><B>Occupation</B></FONT></TD>
	<TD><INPUT TYPE="TEXT" NAME="Occupation" VALUE="" SIZE=30 MAXLENGTH=50>
 </TD>
</TR>

<TR>
	<TD bgcolor="$AltColumnColor2"><FONT SIZE="$TextSize" FACE="$FontFace"><B>Homepage</B></FONT></TD>
	<TD><INPUT TYPE="TEXT" NAME="URL" VALUE="http://" SIZE=30 MAXLENGTH=100>
 </TD></tr>
<TR>
	<TD bgcolor="$AltColumnColor1"><FONT SIZE="$TextSize" FACE="$FontFace"><B>Interests</B></FONT></TD>
	<TD><INPUT TYPE="TEXT" NAME="Interests" VALUE="" SIZE=30 MAXLENGTH=200>
 </TD></tr>
</TABLE>
<BR><BR>
<CENTER>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="RegSubmit">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit">
<INPUT TYPE="RESET" NAME="Reset" VALUE="Reset">

</CENTER></FORM>
<BR><BR><BR>.</BODY>
</HTML>
RegHTML


}  ## END Register SR ##

sub IllegalNameHTML {
print<<Illegal;
<HTML>
 <BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<BR><BR>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>The User Name you attempted to register is illegal for one of the following reasons:
<P><blockquote>
1.  You may have included an illegal character in your User Name.  You should only use letters, numbers, or spaces (apostrophes, for example, are not permitted). You may not begin a User Name with a space, either.<p>
2.  You may have attempted to use a name that doesn't include any letters or numbers.</B>
</blockquote>
<p><CENTER>
[Use your back button to try again]
</CENTER>
</FONT>
</BODY></HTML>
Illegal

}  ## END Illegal name sr

sub PrintRegistrationHTML {
print <<HTML;
<HTML>
<HEAD><TITLE>
User Registration Confirmation</title></head>
 <BODY BGCOLOR="$BGColor" $PageBackground  text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<table border=0>
<tr><td colspan=2>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Congratulations!
<P>
$RegWording1 Feel free to post messages on any of our forums.  Your registration information is listed below.</B></FONT>
</td></tr>
<tr>

<TD bgcolor="$AltColumnColor1"><FONT SIZE="$TextSize" FACE="$FontFace"><B>User Name</B></FONT></TD>
<TD bgcolor="$AltColumnColor2"><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$UserName</font>
 </TD>
</tr>

<TR>
	<TD bgcolor="$AltColumnColor1"><FONT SIZE="$TextSize" FACE="$FontFace"><B>Password</B></FONT></TD>
	<TD bgcolor="$AltColumnColor2"><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$RegWording2</font>
 </TD>
</tr>
<TR>
	<TD bgcolor="$AltColumnColor1"><FONT SIZE="$TextSize" FACE="$FontFace"><B>Email</B></FONT></TD>
	<TD bgcolor="$AltColumnColor2"><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$Email</font>
 </TD>
</TR>
<TR>
	<TD bgcolor="$AltColumnColor1"><FONT SIZE="$TextSize" FACE="$FontFace"><B>City, State, Country</B></FONT></TD>
	<TD bgcolor="$AltColumnColor2"><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$Location</font>
 </TD>
</TR>
<TR>
	<TD bgcolor="$AltColumnColor1"><FONT SIZE="$TextSize" FACE="$FontFace"><B>Occupation</B></FONT></TD>
	<TD bgcolor="$AltColumnColor2"><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$Occupation</font>
 </TD>
</tr>
<TR>
	<TD bgcolor="$AltColumnColor1"><FONT SIZE="$TextSize" FACE="$FontFace"><B>Interests</B></FONT></TD>
	<TD bgcolor="$AltColumnColor2"><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$Interests</font>
 </TD>
</tr>
<TR>
	<TD bgcolor="$AltColumnColor1"><FONT SIZE="$TextSize" FACE="$FontFace"><B>Homepage</B></FONT></TD>
	<TD bgcolor="$AltColumnColor2"><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$URL</font>
 </TD>
</tr>
</TABLE>
<p><FONT SIZE="$TextSize" FACE="$FontFace">
<A HREF="$CGIURL/UltimateALT.cgi?action=intro">Click here to enter the Bulletin Board now!</A><br><br>
</FONT>
<br><br><br><br>.</body>
</html>
HTML
} ## END Print Registration sr


sub GoBack {
print <<GoBackText;
<HTML>
<HEAD><TITLE>
User Registration Attempt Failed</title></head>
 <BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<ul>
<table border=0>
<tr>
<td bgcolor="$AltColumnColor1">
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor"><B>Registration Failed!</B></font> </td></tr>
<tr>
<td>
<font SIZE="$TextSize" face="$FontFace"><B>You failed to type the same password twice on the registration form.  Please go back and try again.
<br><br>
<A HREF="$CGIURL/UltimateALT.cgi?action=agree">Click here</A> to go back.
</B></font>
</td>
</tr>
</table>
<BR><BR><BR>.
</body></html>
GoBackText
} #end GoBack subroutine


sub Duplicate {
print <<Sorry_HTML;
<HTML>
<HEAD><TITLE>
User Registration Attempt Failed</title></head>
 <BODY BGCOLOR="$BGColor" $PageBackground  text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<ul>
<table border=0>
<tr><td>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor"><B>Registration Failed!</B></font> </td></tr>
<tr><td>
<font SIZE="$TextSize" face="$FontFace"><B>The User Name and/or the email address you listed have already been reserved by someone else.  Please choose another User Name and/or email address.
<br><br>
<A HREF="$CGIURL/UltimateALT.cgi?action=agree">Click here</A> to return to the Registration Screen.
</B></font>
</td></tr></table>
</ul>
<br><br>.
</body>
</html>

Sorry_HTML
}



sub Agree {
print <<Agreement;
<HTML>
 <BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<table border=0><TR><TD>
<A HREF="UltimateALT.cgi"><IMG SRC="$NonCGIURL/$BBTitle"  BORDER=0></A></TD><TD align=center><FONT SIZE="3" FACE="$FontFace" COLOR="$LinkColor"><B>$BBName Rules</B></FONT></td></tr></table> 
<br><BR>
<FONT SIZE="$TextSize" FACE="$FontFace">
Registration for this bulletin board is completely free!  If you agree to our rules below, you should press the "Agree" button, which will enable you to register.  If you do not agree, press the "Cancel" button.
<HR width=90%>
<CENTER><B><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$BBName Rules & Policies</B></CENTER>
<P>
<Blockquote>
$BBRules</FONT>
</blockquote>
<HR width=90%><CENTER>
<FORM ACTION="UltimateALT.cgi" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="register">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Agree">
</FORM>
<FORM ACTION="UltimateALT.cgi" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="intro">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Cancel">
</FORM>
</CENTER>
</FONT>
<p>
</BODY></HTML>
Agreement
}


sub NoMatch {
print <<NoMatchHTML;
<HTML>
 <BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<br><BR>
<FONT SIZE="$TextSize" FACE="$FontFace">
Sorry, you supplied a UserName that is not registered.  If you have never registered before, <A HREF="$CGIURL/UltimateALT.cgi?action=agree">please do so now</A>.  Registration is free.
</FONT>
<p>

</BODY></HTML>
NoMatchHTML
}

sub LostPW {
print <<LostPassword;
<HTML>
 <BODY BGCOLOR="$BGColor" $PageBackground  text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<A HREF="UltimateALT.cgi"><IMG SRC="$NonCGIURL/$BBTitle" BORDER=0></A>
<br><BR><B>
<FONT SIZE="$TextSize" FACE="$FontFace">
You can have your username and password emailed to you by providing your email address.  We will then email the username and password info we have associated with the email address you provide.  This information will be sent to the email address you type below.
<P>
<center>
<FORM ACTION="UltimateALT.cgi" METHOD="POST">Your Email Address: &nbsp;&nbsp;&nbsp;
<INPUT TYPE="TEXT" NAME="sendto" SIZE=35 MAXLENGTH=90>
<P>
<input type="Hidden" name="action" value="pwrequest">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Request UserName/Password Now">

</FORM>
</center>
</B>
</FONT>
<p>
</BODY></HTML>
LostPassword
}

sub WrongPassword {
print <<WrongHTML;
<HTML>
 <BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<br><BR>
<FONT SIZE="$TextSize" FACE="$FontFace">Sorry, the password you supplied is incorrect.  Please use your back button to try again!</FONT>
<p>
</BODY></HTML>
WrongHTML
}
sub Rules {
		
print<<RULES;
<HTML><HEAD><TITLE>$BBName - Rules</TITLE></HEAD>
<BODY $PageBackground BGCOLOR="$BGColor" Text="$TextColor" LINK="$LinkColor" VLINK="$VisitedLinkColor">
<CENTER>
<A HREF="UltimateALT.cgi"><IMG SRC="$NonCGIURL/$BBTitle" BORDER=0></A><BR><B><FONT FACE="$FontFace" SIZE="$TextSize" COLOR="$VisitedLinkColor">$BBName Rules</FONT></B>
<p>
<table width=80% border=0>
<TR><TD><B><FONT FACE="$FontFace" SIZE="$TextSize">
$BBRules</FONT>
</B>
</TD></tr>
</TABLE></CENTER>
<p><FONT FACE="$FontFace" SIZE="$TextSize">
<BLOCKQUOTE>If you understand these rules, <A HREF="$CGIURL/UltimateALT.cgi">please enter the bulletin board now</A>.</BLOCKQUOTE>
</FONT>
<BR><BR><BR>.
</BODY></HTML>
RULES
}  # end Rules sr




#######


sub PermissionDeniedHTML {
print<<NoPermission;
<HTML>
 <BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<FONT SIZE="$TextSize" FACE="$FontFace">
<BR><BR><B><ul>
Sorry, but you no longer have permission to post a note on the bulletin board.  Either the administrator of the BB or one of the moderators has removed your posting priviledges.
</B></UL></FONT>
</body></HTML>
NoPermission
}  ## END Permission Denied HTML sr







sub MissingFields {
print<<MISSING;
<HTML><HEAD><TITLE>$BBName - Missing Form Field(s)</TITLE></HEAD>
<BODY $PageBackground BGCOLOR="$BGColor" Text="$TextColor" LINK="$LinkColor" VLINK="$VisitedLinkColor">
<CENTER>
<BR><BR>
<p><FONT FACE="$FontFace" SIZE="$TextSize">
<BLOCKQUOTE>You did not complete all required form fields!  Please re-enter.</BLOCKQUOTE>
</FONT>
<BR><BR><BR>.
</BODY></HTML>
MISSING
}  # end Missing Fields sr

sub CloseThread {	
print<<CLOSE;
<HTML><HEAD><TITLE>$BBName - Request Closing of Thread</TITLE>
</HEAD>
<BODY $PageBackground BGCOLOR="$BGColor" Text="$TextColor" LINK="$LinkColor" VLINK="$VisitedLinkColor">
<CENTER>
<A HREF="UltimateALT.cgi"><IMG SRC="$NonCGIURL/$BBTitle" BORDER=0></A><BR><B><FONT FACE="$FontFace" SIZE="$TextSize" COLOR="$LinkColor">Request to Close Thread: $TopicSubject</FONT></B>
<p><FONT FACE="$FontFace" SIZE="$TextSize">
<CENTER>Only administrators and the moderator for this forum may close a thread.<BR>Please verify your identity below.</CENTER></font>
<FORM ACTION="UltimateALT.cgi" NAME="CloseThread" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="processclose">
<INPUT TYPE="HIDDEN" NAME="topic" VALUE="$topic">
<INPUT TYPE="HIDDEN" NAME="TopicSubject" VALUE="$TopicSubject">
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$number">
<INPUT TYPE="HIDDEN" NAME="LastLogin" VALUE="$in{'LastLogin'}">
<INPUT TYPE="HIDDEN" NAME="DaysPrune" VALUE="$DaysPrune">
<INPUT TYPE="HIDDEN" NAME="Browser" VALUE="$Browser">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$Forum">
<table width=80% border=0>
<TR><TD><B><FONT FACE="$FontFace" SIZE="$TextSize">
Your User Name</FONT>
</B>
</TD>
<TD>
<INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
</tr>
<TR><TD><B><FONT FACE="$FontFace" SIZE="$TextSize">
Your Password</FONT>
</B>
</TD>
<TD>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</tr>
</TABLE>
<P>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Identification">
</form>
</CENTER>
<p><BR><BR>.
</BODY></HTML>
CLOSE
}


sub EditPost {
## check UBB and HTML status for this forum
@thisforum = &GetForumRecord($number);
  
if ($thisforum[4] eq "is") {
	$ISHTML = "*HTML is ON";
	$HTMLAllowed = "yes";
}  else {
	$ISHTML = "*HTML is OFF";
	$HTMLAllowed = "no";
}
 
if ($thisforum[5] eq "is") {
	$ISUBB = "*UBB Code is ON";
	$UBBAllowed = "yes";
}  else {
	$ISUBB = "*UBB Code is OFF";
	$UBBAllowed = "no";
}

## Get current message from file
open (POST, "$ForumsPath/Forum$number/$topic");
@thispost = <POST>;
close (POST);

$message = $thispost[5];
chomp($message);
$author = $thispost[0];
chomp($author);
$postdate = $thispost[1];
chomp($postdate);
$posttime = $thispost[2];
chomp($posttime);

&UNHTMLIFY($message);

	$message =~ s/<p>/\n\r\n/ig;
	$message =~ s/<br>/\n/ig;

print <<EditFORM;
<HTML><HEAD>
</HEAD>
 <BODY BGCOLOR="$BGColor" $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<table border=0>
<TR><TD>
<A HREF="UltimateALT.cgi?action=intro"><IMG SRC="$NonCGIURL/$BBTitle"  BORDER=0></A></td>
<td valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace" color="$TextColor">
<B>
Forum: <FONT COLOR="$VisitedLinkColor">$Forum </FONT>
<BR>
Topic: <FONT COLOR="$VisitedLinkColor">$TopicSubject</FONT>
</B>
</FONT>

</td></tr></table>
<CENTER><FONT SIZE="$TextSize" FACE="$FontFace">Note: Only the person that posted this message, the forum's moderator, or an administrator, may edit this message.<br>
</FONT>
</CENTER>
<ul>
<FORM ACTION="UltimateALT.cgi" NAME="REPLIER" METHOD="POST">
<table border=0>
<tr><td>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor">Your UserName:</FONT></td>
<td>
<INPUT TYPE="TEXT" NAME="UserName" VALUE="" SIZE=25 MAXLENGTH=25>
</td>
</tr>
<tr>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor">Your Password:</FONT></td>
<td><INPUT TYPE="PASSWORD" NAME="Password" VALUE=""  SIZE=13 MAXLENGTH=13>&nbsp;&nbsp;<FONT SIZE="1" FACE="$FontFace"><A HREF="UltimateALT.cgi?action=lostpw&LastLogin=$in{'LastLogin'}">Forget your password?</A></font>
</td></tr>
<TR><TD valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor">Message to Edit:</FONT><p>
<FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">
$ISHTML<BR>
$ISUBB</p></font></td>
<td><FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">Originally posted by $author on $postdate $posttime<BR></FONT>
<TEXTAREA NAME="EditedMessage" ROWS=10 COLS=45 WRAP="VIRTUAL">$message</TEXTAREA>
</td></tr>
</table>
<p>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="submitedit">
<INPUT TYPE="HIDDEN" NAME="TopicSubject" VALUE="$TopicSubject">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$Forum">
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$number">
<INPUT TYPE="HIDDEN" NAME="topic" VALUE="$topic">
<INPUT TYPE="HIDDEN" NAME="Browser" VALUE="$Browser">
<INPUT TYPE="HIDDEN" NAME="DaysPrune" VALUE="$DaysPrune">
<CENTER>
 <FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">

</font>
<p>
<INPUT TYPE="Submit" NAME="SUBMIT" VALUE="Submit Edited Post">
<INPUT TYPE="RESET" NAME="RESET" VALUE="Clear Fields">
</form>
<P>
<FONT SIZE="1" FACE="$FontFace" COLOR="#FF0000">*If HTML and/or <A HREF="$NonCGIURL/ubbcode.html" target=_new>UBB Code</A> are enabled, this means you can use use HTML and/or UBB Code in your message.</FONT>
</center>
<br></ul><center>
<P>
<FONT SIZE="$TextSize" FACE="$FontFace">
<CENTER><B>
<A HREF="mailto:$BBEmail">Contact Us</A> | <A HREF="$HomePageURL">$MyHomePage</A>
</B></FONT>
<FONT SIZE="1" FACE="$FontFace" COLOR="$CopyrightTextColor">
<br><br><br><B>
$YourCopyrightNotice
<P>
Powered by: Ultimate Bulletin Board, Version 4.5
<br>&copy;Madrona Park, Inc., 1997, 1998.
</FONT></B></CENTER>
</BODY></HTML>
EditFORM
}
1; #return true 
