#!/usr/bin/perl

#
### CONTROL PANEL UBB SCRIPT - EDIT/PRUNE FUNCTIONS ##
#
# Ultimate Bulletin Board is copyright Prime-Web, 1997, 1998.
#
#       ------------ edit.cgi -------------
#
#  This file contains most of the edit/prune functionality for the
#  UBB... used in the control panel.
#
# Prime Web offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.prime-web.com
#
###############################################################
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";

print ("Content-type: text/html\n\n");

require "cgi-lib.pl";
require "UltBB.setup";
require "Date.pl";
require "ubb_html.pl";
require "Styles.file";
require "mods.file";
require "ubb_library.pl";

&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
	if ($Name eq "UserName") {
			$UserName = $Value;
			$UserNameFile = $UserName;
			$UserNameFile =~ s/ /_/g; #remove spaces
			}
	
	if ($Name eq "Password") {
			$Password = $Value;
			}
}  ## END FOREACH $row


if ($in{'EditFunction'} eq "Prune") {
	&DoPrune;
}

if ($in{'EditFunction'} eq "Delete") {
	&DoDelete;
}

if ($in{'EditFunction'} eq "Edit") {
	&DoEdit;
}

if ($in{'EditFunction'} eq "AdminEditThisForum") {
	&AdminEditForum;
}
if ($in{'EditFunction'} eq "GetEditThreads") {
	&GetEditThreads;
}
if ($in{'EditFunction'} eq "GetExactEditMessage") {
	&GetExactEditMessage;
}
if ($in{'EditFunction'} eq "DoMessageEdit") {
	&DoMessageEdit;
}
if ($in{'EditFunction'} eq "PruneThisForum") {
	&PruneThisForum;
	}
if ($in{'EditFunction'} eq "SubmitPrune") {
	&SubmitPrune;
	}
if ($in{'EditFunction'} eq "DoSubjectEdit") {
	&DoSubjectEdit;
	}
if ($in{'EditFunction'} eq "DoDeleteThread") {
	&DoDeleteThread;
	}

sub SubmitPrune {
$UNCheck = ("$in{'UserNameCheck'}" . ".cgi");
@checkauthority = &OpenProfile($UNCheck);

if ($in{'PasswordCheck'} eq "$checkauthority[1]") {
$Status = "$checkauthority[8]";
	&CheckStatus;
	$ModMatch = &CheckModStatus($in{'ForumNumber'}, $in{'UserNameCheck'});
	   if (($AdminStatus eq "true") || ($ModMatch eq "yes")) {
			&DoThePrune;
		}  else {
			&NotAllowed;
		}
		
	} else {

		&WrongPassword;
	}
}  ## End SubmitPrune sr

	
sub DoPrune {

## identify user-- moderator/administrator/neither
&GetMemberListArray;  #returns @members

$NameFound = "no";

foreach $check(@members) {
  if ($check eq "$UserNameFile.cgi") {
      $NameFound = "yes";
    } 
}  # END FOREACH CHECK


if ($NameFound eq "yes") {
@profilestats = &OpenProfile("$UserName.cgi");
	
	if ($Password eq "$profilestats[1]") {
	$Status = "$profilestats[8]";
	&CheckStatus;
	   if ($AdminStatus eq "true") {
	   &PruneAsAdmin;
	   } 
	    elsif ($ModStatus eq "true") {
	   &PruneAsMod;
	   }
	   else  {
	   &NotAllowed;
	   }
	} else {
	&WrongPassword;
	}
}  else {
&NameNotFoundHTML;


}  ##END IF/ELSE NAME CHECK BLOCK

}  ## END DoPrune

sub DoMessageEdit {
## confirm that user is authorized
$UNCheck = ("$in{'UserNameCheck'}" . ".cgi");
@profilestats = &OpenProfile("$UNCheck");

if ($in{'PasswordCheck'} eq "$profilestats[1]") {
$Status = "$profilestats[8]";
	&CheckStatus;
	$ModMatch = &CheckModStatus($in{'forum'}, $in{'UserNameCheck'});
	
	   if (($AdminStatus eq "true") || ($ModMatch eq "yes")){
			&PerformTheEdit;
		}  else {
			&NotAllowed;
		}

}  else {
&WrongHTML;
} # END IF/ELSE
}  ## End DoMessageEdit sr


sub GetExactEditMessage {

if (($in{'DeleteThread'} eq "yes") && ($in{'EditSubject'} eq "yes")) {
	&CantDoBoth;
}
elsif ($in{'DeleteThread'} eq "yes") {

$TopicNumber = substr($in{'topic'}, 0, 13);
&GrabTopic;

open (GETMESSAGE, "$ForumsPath/$in{'forum'}/$in{'topic'}");
	@message = <GETMESSAGE>;
close (GETMESSAGE);

	$ThreadSubject = $message[3];
	chomp ($ThreadSubject);

&JSEditMessageTopHTML;
			
print<<otherHTML;
<p><B>
<FONT COLOR="#008080">Thread Subject: $ThreadSubject</FONT>
<P>
<center>
<FORM ACTION="edit.cgi" METHOD="POST" NAME="Edit">
<FONT SIZE="$TextSize" FACE="$FontFace">Clicking the button below will permanently delete this entire thread.<br>
</FONT>
<P>
<table border=0>
<TR><TD>
<FONT Size="$TextSize" FACE="$FontFace" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT>
<P>
<INPUT TYPE="HIDDEN" NAME="TopicNumber" VALUE="$TopicNumber">
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="DoDeleteThread">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$in{'forum'}">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Delete Entire Thread Now">
</form>
</CENTER>
<TD>
otherHTML
	}
	elsif ($in{'EditSubject'} eq "yes") {
	
$TopicNumber = substr($in{'topic'}, 0, 13);
&GrabTopic;

open (GETMESSAGE, "$ForumsPath/$in{'forum'}/$in{'topic'}");
	@message = <GETMESSAGE>;
close (GETMESSAGE);

	$EditSubject = $message[3];
	chomp ($EditSubject);

&JSEditMessageTopHTML;
			
print<<otherHTML;
<p><center>
<FORM ACTION="edit.cgi" METHOD="POST" NAME="Edit">
<B><FONT SIZE="$TextSize" FACE="$FontFace">Edit the subject, re-enter your UserName & Password, and then click Submit button.<br>
</FONT></B><BR>
<table width=600 border=0>
<TR>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="#800000"><B>Thread Subject:</B></FONT>
</td>
<td>
<INPUT TYPE="TEXT" NAME="NewSubject" VALUE="$EditSubject" SIZE=40 MAXLENGTH=120>
</td>
<tr>
<td colspan=2><CENTER><B>
<FONT Size="$TextSize" FACE="$FontFace" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT>
<P>
<INPUT TYPE="HIDDEN" NAME="TopicNumber" VALUE="$TopicNumber">
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="DoSubjectEdit">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$in{'forum'}">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Edited Thread Subject">
</form>
</CENTER>
</td>
otherHTML
	} else {
	
open (GETMESSAGE, "$ForumsPath/$in{'forum'}/$in{'EditMessageNumber'}");
	@message = <GETMESSAGE>;
close (GETMESSAGE);

&JSEditMessageTopHTML;

chomp ($message[0]);
chomp ($message[1]);
chomp ($message[2]);
chomp ($message[5]);
	$message[5] =~ s/<p>/\n\n/g;
	$message[5] =~ s/<P>/\n\n/g;
	$message[5] =~ s/<BR>/\n/g;
	$message[5] =~ s/<br>/\n/g;
			
print<<otherHTML;
<p><center>
<FORM ACTION="edit.cgi" METHOD="POST" NAME="Edit">
<B><FONT SIZE="$TextSize" FACE="$FontFace">Edit the message, re-enter your UserName and Password, and then click Submit button.<br>
To delete the message, check this box. <FONT FACE="$FontFace" COLOR="#FF0000">--></FONT> <INPUT TYPE="CHECKBOX" NAME="DeleteMessage" VALUE="yes">
otherHTML

## if this is a topic, then warn that all replies will also be deleted
$ReplyField = substr($in{'EditMessageNumber'}, 7, 6);
if ($ReplyField eq "000000") {
print ("<BR><font face=\"$FontFace\" SIZE=\"2\" COLOR=\"\#800000\">Warning: This message is the topic.  If you delete this, all the replies to it will also be deleted!!</font>");
}
print<<MidHTML;
</FONT></B><BR>
<table width=600 border=0>
<TR bgcolor="#FFFCEC">
<td>
<FONT SIZE="1" FACE="$FontFace" COLOR="#000000"><B>Author</B></FONT>
</td>
<td>
<FONT SIZE="1" FACE="$FontFace" COLOR="#000000"><B>Message</B></font>
</td>
<tr bgcolor="#FBEEFF">
<td width=150 valign=top>
<FONT SIZE="$TextSize" face="$FontFace" COLOR="#000000"><B>$message[0]</B></FONT>
</td>
<td width=450 valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace">
<FONT SIZE="1" color="#008080" face="$FontFace">posted $message[1] $message[2] $TimeZone</FONT>
<br>
<TEXTAREA NAME="MessageText" ROWS=10 COLS=45 WRAP="VIRTUAL">$message[5]
</TEXTAREA>
</FONT>
</td>
MidHTML

print<<FormBottom;
<tr>
<td colspan=3><CENTER><BR>
<FONT Size="$TextSize" FACE="$FontFace" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT>
<P>
<INPUT TYPE="HIDDEN" NAME="MessageNumber" VALUE="$in{'EditMessageNumber'}">
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="DoMessageEdit">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$in{'forum'}">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Edited Message">
</form>
</CENTER>
</td>
FormBottom
}
&BOTTOMHTML;

}  ## End GetExactEdit Message

sub GetEditThreads {

open (GETTOPIC, "$ForumsPath/$in{'forum'}/$in{'topic'}");
	@topicguts = <GETTOPIC>;
close (GETTOPIC);

$UNCoded = $topicguts[0];
$UNCoded =~ tr/ /+/;
$TopicSubject = $topicguts[3];
	$SubjectCoded = &HTMLIFY($TopicSubject);
			$SubjectCoded =~ tr/ /+/;

&EditMessageTopHTML;
		
chop ($topicguts[1]);
chop ($topicguts[2]);
chop ($topicguts[5]);
#format date
if ($DateFormat eq "Euro") {
@datearray = split(/-/, $topicguts[1]);
chomp($datearray[2]);
$ThisDate = "$datearray[1]-$datearray[0]-$datearray[2]";
}  else {
$ThisDate = "$topicguts[1]";
}
#format time option 1
	if ($TimeFormat eq "24HR")  {
		@timearray = split(/ /, $topicguts[2]);
		chomp($timearray[1]);
		($gethour, $getmin) = split(/:/, $timearray[0]);
		
		if ($timearray[1] eq "PM") {		
		if ($gethour < 12) {
			$gethour = ($gethour  + 12);
		}
	}
	if ($AMpm eq "AM") {		
		if ($gethour == 12) {
			$gethour = "0";
		}
	}
	$gethour = sprintf ("%2d", $gethour);
	$gethour =~tr/ /0/;
	$getmin = sprintf ("%2d", $getmin);
	$getmin =~tr/ /0/;
	
		$FormatTime = "$gethour:$getmin";
	} else {
		$FormatTime = "$topicguts[2]";
	}

print<<otherHTML;
<p><center>
<FORM ACTION="edit.cgi" METHOD="POST">
<B><FONT SIZE="$TextSize" FACE="$FontFace">Select the message to be edited/deleted.<br>
To delete the entire thread, check this box<FONT SIZE="$TextSize" COLOR="#FF0000">--></FONT><INPUT TYPE="CHECKBOX" NAME="DeleteThread" VALUE="yes">
<br>
To edit the thread subject, check this box<FONT SIZE="$TextSize" COLOR="#FF0000">--></FONT><INPUT TYPE="CHECKBOX" NAME="EditSubject" VALUE="yes">
</FONT></B><BR>
<table width=600 border=0>
<TR bgcolor="#FFFCEC">
<td>&nbsp;
</td>
<td>
<FONT SIZE="1" FACE="$FontFace" COLOR="#000000"><B>Author</B></FONT>
</td>
<td>
<FONT SIZE="1" FACE="$FontFace" COLOR="#000000"><B>Message</B></font>
</td>
<tr bgcolor="#FBEEFF">
<td valign=top>
<INPUT TYPE="RADIO" NAME="EditMessageNumber" VALUE="$in{'topic'}" SELECTED>
</td>
<td width=150 valign=top>
<FONT SIZE="$TextSize" face="$FontFace" COLOR="#000000"><B>$topicguts[0]</B></FONT>
</td>
<td width=450 valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace">
<FONT SIZE="1" color="#008080" face="$FontFace">posted $ThisDate $FormatTime $TimeZone</FONT>
<br><B>$topicguts[5]</B>
</FONT>
</td>
otherHTML

#get Replies to this topic
opendir (FORUMDIR, "$ForumsPath/$in{'forum'}"); 
    @forummsgs = readdir(FORUMDIR);
closedir (FORUMDIR);

$ThisTopicNumber = substr($in{'topic'}, 0,6);

#sort to find all replies to this topic

foreach $msg(@forummsgs) {
	$TopicNumber = substr($msg, 0, 6);
	if ($TopicNumber eq "$ThisTopicNumber") {
		$ReplyNumber = substr($msg, 7, 6);
		if ($ReplyNumber > 0) {
			push  (@replyarray, $msg);
		}
	}
}
@replyarray = sort(@replyarray);

#### @replyarray holds all replies to the topic in question

foreach $matchreply(@replyarray) {
	open (REPLY, "$ForumsPath/$in{'forum'}/$matchreply");
		@replyguts = <REPLY>;
	close (REPLY);
	
chomp ($replyguts[0]);		
chomp ($replyguts[1]);
chomp ($replyguts[2]);
chomp ($replyguts[5]);

#format date
if ($DateFormat eq "Euro") {
@datearray = split(/-/, $replyguts[1]);
chomp($datearray[2]);
$ThisDate = "$datearray[1]-$datearray[0]-$datearray[2]";
}  else {
$ThisDate = "$replyguts[1]";
}

#format time option 1
	if ($TimeFormat eq "24HR")  {
		@timearray = split(/ /, $replyguts[2]);
		chomp($timearray[1]);
		($gethour, $getmin) = split(/:/, $timearray[0]);
		
		if ($timearray[1] eq "PM") {		
		if ($gethour < 12) {
			$gethour = ($gethour  + 12);
		}
	}
	if ($AMpm eq "AM") {		
		if ($gethour == 12) {
			$gethour = "0";
		}
	}
	$gethour = sprintf ("%2d", $gethour);
	$gethour =~tr/ /0/;
	$getmin = sprintf ("%2d", $getmin);
	$getmin =~tr/ /0/;
	
		$FormatTime = "$gethour:$getmin";
	} else {
		$FormatTime = "$replyguts[2]";
	}
print<<REPLYhtml;
<tr bgcolor="#FBEEFF">
<td valign=top>
<INPUT TYPE="RADIO" NAME="EditMessageNumber" VALUE="$matchreply">
</td>
<td width=150 valign=top>
<FONT SIZE="$TextSize" face="$FontFace" COLOR="#000000"><B>$replyguts[0]</B></FONT>
</td>
<td width=450 valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace">
<FONT SIZE="1" color="#008080" face="$FontFace">posted $ThisDate $FormatTime $TimeZone</FONT>
<br><B>$replyguts[5]</B>
</FONT>
</td>
REPLYhtml
}
print<<FormBottom;
<tr>
<td colspan=3><CENTER><BR>

<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="GetExactEditMessage">
<INPUT TYPE="HIDDEN" NAME="topic" VALUE="$in{'topic'}">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$in{'forum'}">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Retrieve Message to be Edited">
</form>
</CENTER>
</td>
FormBottom

&BOTTOMHTML;
} ## END GetEditThreads sr


sub AdminEditForum {

&EditMessageTopHTML;

print<<MoreHTML;
<p><center>
<B><FONT SIZE="$TextSize" FACE="$FontFace">Select the topic in which the post is located.</FONT></B>
<table border=0>
<tr bgcolor="#FFFCEC">
<td width=300>
<FONT SIZE="1" FACE="$FontFace" color="#808080">Topic</FONT>
</td>
<td>
<FONT SIZE="1" FACE="$FontFace" color="#808080">Originator</FONT>
</td>
<td><FONT SIZE="1" FACE="$FontFace" color="#808080">
Replies
</FONT>
</td>
<td><FONT SIZE="1" FACE="$FontFace" color="#808080">
Last Post
</FONT>
</td>
MoreHTML

&DoPruneGathering;
		
foreach $item(@topicarray) {
	
$MonthOfMessage = substr($item, 14, 2);
$DayOfMessage = substr($item, 16, 2);
$YearOfMessage = substr($item, 18, 2);

	$CheckJulian = &jday($MonthOfMessage, $DayOfMessage, $YearOfMessage);
	if ($CheckJulian >= $CloseJulian) {
		push (@finalarray, $item);
	}  
} #end FOREACH $item


#sort topics by date, then alphabetic by title
foreach $one(@finalarray) {
($trash4, $trash5, $sortkey, $trash6) = split("-", $one);

## sortkey is the date...
## but we need to move year up front for ordering purposes

$sortyear = substr($sortkey, 4, 2);
$sortrest = substr($sortkey, 0, 4);
$sortkey = ("$sortyear" . "$sortrest");


open (THETOPIC, "$ForumsPath/$in{'ForumNumber'}/$one");
	@stuff = <THETOPIC>;
close (THETOPIC);

$sortline = ("$sortkey" . "$stuff[3]" . "|$one");
push(@sortthis, $sortline);
}

@sortedthat = sort(@sortthis);
@sortedthat = reverse(@sortedthat);

# now we have the array of topics in the forum
# next... deconstruct each topic to show last post, original author, #topic subject

foreach $topic2(@sortedthat) {

($trash, $topic) = split(/\|/, $topic2);
$MessageNumber = substr($topic, 0, 6);
$MessageReply = substr($topic, 7, 6);
$DateOfMessage = substr($topic, 14, 6);
$Replies = substr($topic, 21, 6);

$RepliesFormat = $Replies + 0;

open (TOPIC, "$ForumsPath/$in{'ForumNumber'}/$topic");
	@insides = <TOPIC>;
close (TOPIC);

$author = "$insides[0]";
$subject = "$insides[3]";
chop($subject);
$Month = substr($DateOfMessage, 0, 2);
$Day = substr($DateOfMessage, 2, 2);
$Year = substr($DateOfMessage, 4, 2);
if ($DateFormat eq "Euro") {
$TheDate = "$Day-$Month-$Year";
}  else {
$TheDate = "$Month-$Day-$Year";
}
print <<GUTS;
<TR>
<TD width=300><IMG SRC="$NonCGIURL/closed.gif" WIDTH=14 HEIGHT=11 BORDER=0>
<FONT SIZE="$TextSize" FACE="$FontFace">
<A HREF="edit.cgi?EditFunction=GetEditThreads&forum=$in{'ForumNumber'}&topic=$topic">$subject</A>
</FONT>
</td>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace">$author</FONT>
</td>
<td align=center>
<FONT SIZE="$TextSize" FACE="$FontFace">$RepliesFormat</FONT>
</td>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace">$TheDate</FONT>
</td>
GUTS
}  ## END FOREACH

&BOTTOMHTML;
}  ## END AdminEditForum sr


sub PruneThisForum {

&JSPruneMessageTopHTML;

print<<MoreHTML;
<p><center>
<FORM ACTION="edit.cgi" METHOD="POST" NAME="Edit">
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="SubmitPrune">
<INPUT TYPE="HIDDEN" NAME="ForumNumber" VALUE="$in{'ForumNumber'}">
<INPUT TYPE="HIDDEN" NAME="DaysPrune" VALUE="$in{'DaysPrune'}">
<B>
<P>
To exclude a thread from being pruned, uncheck the box next to the thread on the left and then click the "Prune Me" button on the bottom.</FONT></B>
<table border=0>
<tr bgcolor="#FFFCEC">
<td width=300 valign=bottom>
<FONT SIZE="1" FACE="$FontFace" color="#808080">Topic</FONT>
</td>
<td valign=bottom>
<FONT SIZE="1" FACE="$FontFace" color="#808080">Originator</FONT>
</td>
<td valign=bottom><FONT SIZE="1" FACE="$FontFace" color="#808080">
Replies
</FONT>
</td>
<td valign=bottom><FONT SIZE="1" FACE="$FontFace" color="#808080">
Last Post
</FONT>
</td>
MoreHTML

&DoPruneGathering;

foreach $item(@topicarray) {
	
$MonthOfMessage = substr($item, 14, 2);
$DayOfMessage = substr($item, 16, 2);
$YearOfMessage = substr($item, 18, 2);


	$CheckJulian = &jday($MonthOfMessage, $DayOfMessage, $YearOfMessage);
		
	if ($CheckJulian < $CloseJulian) {
		push (@finalarray, $item);
	}  
	
} #end FOREACH $item


#sort topics by date, then alphabetic by title
foreach $one(@finalarray) {
($trash4, $trash5, $sortkey, $trash6) = split("-", $one);

## sortkey is the date...
## but we need to move year up front for ordering purposes

$sortyear = substr($sortkey, 4, 2);
$sortrest = substr($sortkey, 0, 4);
$sortkey = ("$sortyear" . "$sortrest");


open (THETOPIC, "$ForumsPath/$in{'ForumNumber'}/$one");
	@stuff = <THETOPIC>;
close (THETOPIC);

$sortline = ("$sortkey" . "$stuff[3]" . "|$one");
push(@sortthis, $sortline);
}

@sortedthat = sort(@sortthis);
@sortedthat = reverse(@sortedthat);

# now we have the array of topics in the forum
# next... deconstruct each topic to show last post, original author, #topic subject

foreach $topic2(@sortedthat) {

($trash, $topic) = split(/\|/, $topic2);
$MessageNumber = substr($topic, 0, 6);
$MessageReply = substr($topic, 7, 6);
$DateOfMessage = substr($topic, 14, 6);
$Replies = substr($topic, 21, 6);

$RepliesFormat = $Replies + 0;

open (TOPIC, "$ForumsPath/$in{'ForumNumber'}/$topic");
	@insides = <TOPIC>;
close (TOPIC);

$author = "$insides[0]";
$subject = "$insides[3]";
chomp($subject);
$Month = substr($DateOfMessage, 0, 2);
$Day = substr($DateOfMessage, 2, 2);
$Year = substr($DateOfMessage, 4, 2);
if ($DateFormat eq "Euro") {
$TheDate = "$Day-$Month-$Year";
}  else {
$TheDate = "$Month-$Day-$Year";
}
print <<GUTS;
<TR>
<TD width=300>
<INPUT TYPE="CHECKBOX" NAME="PruneThis:::$MessageNumber" VALUE="yes" CHECKED>
<IMG SRC="$NonCGIURL/closed.gif" WIDTH=14 HEIGHT=11 BORDER=0>
<FONT SIZE="$TextSize" FACE="$FontFace">
$subject
</FONT>
</td>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace">$author</FONT>
</td>
<td align=center>
<FONT SIZE="$TextSize" FACE="$FontFace">$RepliesFormat</FONT>
</td>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace">$TheDate</FONT>
</td>
GUTS
}  ## END FOREACH

print<<FORMbottom;
<tr>
<td colspan=4><CENTER>
<FONT Size="$TextSize" FACE="$FontFace" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT><p>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Prune Me!"></CENTER>
</form>
</td>
FORMbottom

&BOTTOMHTML;


}  ## END PruneThisForm sr

sub DoEdit {
## identify user-- moderator/administrator/neither

&GetMemberListArray;  #Returns @members array

$NameFound = "no";

foreach $check(@members) {
  if ($check eq "$UserNameFile.cgi") {
      $NameFound = "yes";
    } 
}  # END FOREACH CHECK


if ($NameFound eq "yes") {
@profilestats = &OpenProfile("$UserName.cgi");
	
	if ($Password eq "$profilestats[1]") {
	$Status = "$profilestats[8]";
	&CheckStatus;
	   if ($AdminStatus eq "true") {
	   &EditAsAdmin;
	   } 
	    elsif ($ModStatus eq "true") {
	   &EditAsMod;
	   }
	   else  {
	   &NotAllowed;
	   }
	} else {
	&WrongPassword;
	}
}  else {
&NameNotFoundHTML;

}  ##END IF/ELSE NAME CHECK BLOCK

}  ## END Do EDIT subroutine

sub EditAsAdmin {

print<<EditHTML;
<HTML>
<HEAD>
	<TITLE>Ultimate Bulletin Board - $BBName</TITLE>
	<script language="JavaScript"> 
<!-- HIDE
var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}


function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}
//-->
</script>
	
</HEAD>

<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000">
<table border=0 width=600>
<TR><TD>
<IMG SRC="$NonCGIURL/$BBTitle" BORDER=0>
</TD><td align=center>
<FONT SIZE="3" FACE="$FontFace" COLOR="#000080"><B>Edit BB Post</B></FONT>
</td></table>
<FONT SIZE="$TextSize" FACE="$FontFace">
<CENTER><B><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A>  |  <A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A> | <A HREF="$CGIURL/cpanel.cgi?action=variables">Set Variables</A></B></CENTER>
<p><B>
As an administrator, you can edit any post in any forum.  Please select a forum below.
</B>
<P>
<FORM ACTION="edit.cgi" METHOD="POST">
<center>
<table border=0>
<TR>
<TD valign=top><FONT SIZE="$TextSize" FACE="$FontFace"><B>
EditHTML

#Get List of All Forums
$ForumTotal = &GetTotalForums;
for ($x = 1; $x <= $ForumTotal; $x++) {
@thisforum = &GetForumRecord($x);

	if ($thisforum[3] eq "On") {
print<<Forum1HTML;
<INPUT TYPE="RADIO" NAME="ForumNumber" VALUE="Forum$x">
$thisforum[1]<br>
Forum1HTML
	}
} #End for $x--

print<<EDITbottomHTML;
</FONT></B>
</td>
<tr>
<td><FONT SIZE="$TextSize" FACE="$FontFace" color="#800000"><B>Search posts going back <INPUT TYPE="TEXT" NAME="DaysPrune" VALUE="20" SIZE=3 MAXLENGTH=3> days.</B></FONT>
</td>
</table>
<P><BR>
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="AdminEditThisForum">
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Forum Choice Now">

</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="$FontFace" COLOR="#C0C0C0">&copy; Prime-Web, 1998.
</FONT>
</CENTER>
</BODY>
</HTML>
EDITbottomHTML
}  ## END EditAsAdmin sr



sub PruneAsMod {

print<<PruneHTML;
<HTML>
<HEAD>
	<TITLE>Ultimate Bulletin Board - $BBName</TITLE>
	<script language="JavaScript"> 
<!-- HIDE
var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}


function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}
//-->
</script>
	
</HEAD>

<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000">
<table border=0 width=600>
<TR><TD>
<IMG SRC="$NonCGIURL/$BBTitle" BORDER=0>
</TD><td align=center>
<FONT SIZE="3" FACE="$FontFace" COLOR="#000080"><B>Prune BB Posts</B></FONT>
</td></table>
<FONT SIZE="$TextSize" FACE="$FontFace">
<CENTER><B><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A>  |  <A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A> | <A HREF="$CGIURL/cpanel.cgi?action=variables">Set Variables</A></B></CENTER>
<p><B>
As a moderator, you can prune posts by date in any forum for which you are a moderator.  Please select a forum below.
</B>
<P>
<FORM ACTION="edit.cgi" METHOD="POST">
<center>
<table border=0>
<TR>
<TD valign=top><FONT SIZE="$TextSize" FACE="$FontFace"><B>
PruneHTML


#Get List of All Forums
$ForumTotal = &GetTotalForums;
for ($x = 1; $x <= $ForumTotal; $x++) {
@thisforum = &GetForumRecord($x);
$ForumModerator = ("Forum" . "$x" . "Moderator");
$ForumModerator = $$ForumModerator;

	if (($thisforum[3] eq "On") && ($ForumModerator eq "$UserName")){
print<<Forum1HTML;
<INPUT TYPE="RADIO" NAME="ForumNumber" VALUE="Forum$x">
$thisforum[1]<br>
Forum1HTML
	}
} #End for $x--

print<<EDITbottomHTML;
</FONT></B>
</td>
<tr>
<td><FONT SIZE="$TextSize" FACE="$FontFace" color="#800000"><B>Prune threads with last post older than <INPUT TYPE="TEXT" NAME="DaysPrune" VALUE="60" SIZE=3 MAXLENGTH=3> days.</B></FONT>
</td>
</table>
<P><BR>
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="PruneThisForum">
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Forum Choice Now">

</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="$FontFace" COLOR="#C0C0C0">&copy; Prime-Web, 1998.
</FONT>
</CENTER>
</BODY>
</HTML>
EDITbottomHTML
}  ## END PruneAsMod sr


sub PruneAsAdmin {

print<<PruneHTML;
<HTML>
<HEAD>
	<TITLE>Ultimate Bulletin Board - $BBName</TITLE>
	<script language="JavaScript"> 
<!-- HIDE
var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}


function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}
//-->
</script>
</HEAD>

<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000">
<table border=0 width=600>
<TR><TD>
<IMG SRC="$NonCGIURL/$BBTitle">
</TD><td align=center>
<FONT SIZE="3" FACE="$FontFace" COLOR="#000080"><B>Prune BB Posts</B></FONT>
</td></table>
<FONT SIZE="$TextSize" FACE="$FontFace">
<CENTER><B><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A>  |  <A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A> | <A HREF="$CGIURL/cpanel.cgi?action=variables">Set Variables</A></B></CENTER>
<p><B>
As an administrator, you can prune posts by date in any forum.  Please select a forum below.
</B>
<P>
<FORM ACTION="edit.cgi" METHOD="POST">
<center>
<table border=0>
<TR>
<TD valign=top><FONT SIZE="$TextSize" FACE="$FontFace"><B>
PruneHTML

$ForumTotal = &GetTotalForums;
for ($x = 1; $x <= $ForumTotal; $x++) {
@thisforum = &GetForumRecord($x);

if ($thisforum[3] eq "On") {
print<<ForumHTML;
<INPUT TYPE="RADIO" NAME="ForumNumber" VALUE="Forum$x">
$thisforum[1]<br>
ForumHTML
}
} #END for $x -------

print<<EDITbottomHTML;
</FONT></B>
</td>
<tr>
<td><FONT SIZE="$TextSize" FACE="$FontFace" color="#800000"><B>Prune threads with last post older than <INPUT TYPE="TEXT" NAME="DaysPrune" VALUE="60" SIZE=3 MAXLENGTH=3> days.</B></FONT>
</td>
</table>
<P><BR>
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="PruneThisForum">
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Forum Choice Now">

</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="$FontFace" COLOR="#C0C0C0">&copy; Prime-Web, 1998.
</FONT>
</CENTER>
</BODY>
</HTML>
EDITbottomHTML
}  ## END PruneAsAdmin sr

sub EditAsMod {
print<<EditHTML;
<HTML>
<HEAD>
	<TITLE>Ultimate Bulletin Board - $BBName</TITLE>
	
	<script language="JavaScript"> 
<!-- HIDE
var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}


function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}
//-->
</script>
</HEAD>

<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000">
<table border=0 width=600>
<TR><TD>
<IMG SRC="$NonCGIURL/$BBTitle" BORDER=0>
</TD><td align=center>
<FONT SIZE="3" FACE="$FontFace" COLOR="#000080"><B>Edit BB Post</B></FONT>
</td></table>
<FONT SIZE="$TextSize" FACE="$FontFace">
<CENTER><B><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A>  |  <A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A> | <A HREF="$CGIURL/cpanel.cgi?action=variables">Set Variables</A></B></CENTER>
<p><B>
As a moderator, you can edit or delete any post in any of the forums below.  Please select a forum.
</B>
<P>
<FORM ACTION="edit.cgi" METHOD="POST">
<center>
<table border=0>
<TR>
<TD valign=top><FONT SIZE="$TextSize" FACE="$FontFace"><B>
EditHTML

$ForumTotal = &GetTotalForums;
for ($x = 1; $x <= $ForumTotal; $x++) {
@thisforum = &GetForumRecord($x);
$ForumModerator = ("Forum" . "$x" . "Moderator");
$ForumModerator = $$ForumModerator;

if (($thisforum[3] eq "On") && ($ForumModerator eq "$UserName")) {
print<<Forum1HTML;
<INPUT TYPE="RADIO" NAME="ForumNumber" VALUE="Forum$x">
$thisforum[1]<br>
Forum1HTML
}
} #end for $x ----

print<<EDITbottomHTML2;
</FONT></B>
</td>
<tr>
<td><FONT SIZE="$TextSize" FACE="$FontFace" color="#800000">
<B>Search posts going back <INPUT TYPE="TEXT" NAME="DaysPrune" VALUE="20" SIZE=3 MAXLENGTH=3> days.</B></FONT>
</td>
</table>
<P><BR>
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="AdminEditThisForum">
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Forum Choice Now">

</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="$FontFace" COLOR="#C0C0C0">&copy; Prime-Web, 1998.</FONT>
</CENTER>
</BODY>
</HTML>
EDITbottomHTML2
}  ## END EditAsMod sr

sub DoDeleteThread {
## confirm UN/password
$UNCheck = ("$in{'UserNameCheck'}" . ".cgi");
@checkprofile = &OpenProfile($UNCheck);
if ($in{'PasswordCheck'} eq "$checkprofile[1]") {
$Status = "$checkprofile[8]";
	&CheckStatus;
		$ModMatch = &CheckModStatus($in{'forum'}, $in{'UserNameCheck'});
	   if (($AdminStatus eq "true") || ($ModMatch eq "yes")) {
			&PerformTheDelete;
		}  else {
			&NotAllowed;
		}

}  else {
&WrongHTML;

} # END IF/ELSE
}


sub CheckStatus {

		if ($Status =~ m/Administrator/)  {
			$AdminStatus = "true";
		} else {
			$AdminStatus = "false";
		}
		
		if ($Status =~ m/Moderator/)  {
			$ModStatus = "true";
		} else {
			$ModStatus = "false";
		}
	

} #end CheckStatus


sub WrongPassword {
print<<WrongPass;
<HTML><BODY BGCOLOR="#FFFFFF">
<br><br>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="#808000">Sorry, but the password you entered was not correct.  Please try again.  (Use your Back button.)</FONT>
</BODY></HTML>
WrongPass

}  ## END WRONG PASSWORD

sub JSEditMessageTopHTML {
print<<TOP;
<HTML>
<HEAD><TITLE>Ultimate Bulletin Board - $BBName</title>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.Edit.UserNameCheck.value = getCookie("UserNameCP");
document.Edit.PasswordCheck.value = getCookie("PasswordCP");
	}  else {
	document.Edit.UserNameCheck.focus();
}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>

</head>
 <BODY BGCOLOR="#FFFFFF" link="#000080" vlink="#808000" topmargin=0 onLoad="SetCursor()">
<b><FONT SIZE="$TextSize" FACE="$FontFace">
<table border=0 width=600>
<tr>
<td width=300 align=left valign=top>
<IMG SRC="$NonCGIURL/$BBTitle" BORDER=0></td>
<td align=center>
<FONT SIZE="3" FACE="$FontFace" color="#000080"><B>Edit Message</B>
</FONT>
</td>
</table>
TOP
}  ## END JSEditMessageTopHTML


sub EditMessageTopHTML {
print<<TOP;
<HTML>
<HEAD><TITLE>Ultimate Bulletin Board - $BBName</title>
</head>
 <BODY BGCOLOR="#FFFFFF" link="#000080" vlink="#808000" topmargin=0>
<b><FONT SIZE="$TextSize" FACE="$FontFace">
<table border=0 width=600>
<tr>
<td width=300 align=left valign=top>
<IMG SRC="$NonCGIURL/$BBTitle" BORDER=0></td>
<td align=center>
<FONT SIZE="3" FACE="$FontFace" color="#000080"><B>Edit Message</B>
</FONT>
</td>
</table>
TOP
}  ## END EditMessageTopHTML

sub PruneMessageTopHTML {
print<<TOP;
<HTML>
<HEAD><TITLE>Ultimate Bulletin Board - $BBName</title>
</head>
 <BODY BGCOLOR="#FFFFFF" link="#000080" vlink="#808000" topmargin=0>
<b><FONT SIZE="$TextSize" FACE="$FontFace">
<table border=0 width=600>
<tr>
<td width=300 align=left valign=top>
<IMG SRC="$NonCGIURL/$BBTitle" BORDER=0></td>
<td align=center>
<FONT SIZE="3" FACE="$FontFace" color="#000080"><B>Prune Messages</B>
</FONT>
</td>
</table>
TOP
}  ## END PruneMessageTopHTML


sub JSPruneMessageTopHTML {
print<<TOP;
<HTML>
<HEAD><TITLE>Ultimate Bulletin Board - $BBName</title>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.Edit.UserNameCheck.value = getCookie("UserNameCP");
document.Edit.PasswordCheck.value = getCookie("PasswordCP");
	}  else {
	document.Edit.UserNameCheck.focus();
}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</head>
 <BODY BGCOLOR="#FFFFFF" link="#000080" vlink="#808000" topmargin=0 onLoad="SetCursor()">
<b><FONT SIZE="$TextSize" FACE="$FontFace">
<table border=0 width=600>
<tr>
<td width=300 align=left valign=top>
<IMG SRC="$NonCGIURL/$BBTitle" BORDER=0></td>
<td align=center>
<FONT SIZE="3" FACE="$FontFace" color="#000080"><B>Prune Messages</B>
</FONT>
</td>
</table>
TOP
}  ## END JSPruneMessageTopHTML

sub BOTTOMHTML {
print<<BOTTOM;
</table>
<center><FONT SIZE="1" FACE="$FontFace" COLOR="#C0C0C0">Powered by: Ultimate Bulletin Board<br>
&copy; Prime-Web, 1998.
</FONT>
</center>
</body></html>
BOTTOM
} ## END BottomHTML sr

sub NameNotFoundHTML {
print<<NAMENOTFOUND;
<HTML><BODY BGCOLOR="#FFFFFF">
<br><br>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="#808000">Sorry, but no one is registered with the User Name you listed.  Please try again.  (Use your Back button.)
<P>
</FONT>
</BODY></HTML>
NAMENOTFOUND


}  ## End NameNotFOundHTML

sub DoPruneGathering {

#get Forum Messages
opendir (FORUMDIR, "$ForumsPath/$in{'ForumNumber'}"); 
    @forummsgs = readdir(FORUMDIR);
closedir (FORUMDIR);

foreach $message(@forummsgs) {
$MessageNumber = substr($message, 0, 6);
$MessageReply = substr($message, 7, 6);
$DateOfMessage = substr($message, 14, 6);
	if ($MessageReply eq "000000") {
				push (@topicarray, $message);
	}
}

## do date pruning 

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime (time);

$mon++;

#convert Closing and Current Dates to Julian Dates
$CurrentJulian = &jday($mon, $mday, $year);
$CloseJulian = $CurrentJulian - $in{'DaysPrune'};

#configure memo date to Julian
}  ## End DoPruneGathering


sub DoSubjectEdit {
## confirm UN/password
$UNCheck = ("$in{'UserNameCheck'}" . ".cgi");
@checkprofile = &OpenProfile($UNCheck);
if ($in{'PasswordCheck'} eq "$checkprofile[1]") {
$Status = "$checkprofile[8]";
	&CheckStatus;
	$ModMatch = &CheckModStatus($in{'forum'}, $in{'UserNameCheck'});
	   if (($AdminStatus eq "true") || ($ModMatch eq "yes")) {
			&UpdateTheSubject;
		}  else {
			&NotAllowed;
		}

}  else {
&WrongHTML;

} # END IF/ELSE
}  ## End DoSubjectEdit sr

sub WrongHTML {
print <<WrongHTML;
<HTML>
 <BODY BGCOLOR="$BGColor"  text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<br><BR>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="#808000">Sorry, the password you supplied is incorrect.  Please use your back button to try again!</FONT>
<p>
</BODY></HTML>
WrongHTML
} # end WrongHTML sr


sub CantDoBoth {
print <<NoMatchHTML;
<HTML>
 <BODY BGCOLOR="$BGColor"  text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<br><BR>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="#808000">
You accidentally checked "delete entire thread" and "edit subject"... You can't do both.  Go back and try again.
</FONT>
<p>
</BODY></HTML>
NoMatchHTML
}

sub PerformTheEdit {
if ($in{'DeleteMessage'} eq "yes") {
&EditMessageTopHTML;

($junk, $Extension) = split(/\./, $in{'MessageNumber'});

$TopicNumber = substr($in{'MessageNumber'}, 0, 6);
$TestReply = substr($in{'MessageNumber'}, 7, 6);
if ($TestReply ne "000000") {

unlink ("$ForumsPath/$in{'forum'}/$in{'MessageNumber'}");
## change topic number to reflect one fewer reply
	opendir (TOPICGRAB, "$ForumsPath/$in{'forum'}");
	@topiclist = readdir(TOPICGRAB);
	closedir (TOPICGRAB);
foreach $checktopic(@topiclist) {
	if ($checktopic =~ m/^$TopicNumber-000000/) {
		$TopicMatched = "$checktopic"; 
	}
}
$TopicFront = substr($TopicMatched, 0, 20);
$TopicOldReplies = substr($TopicMatched, 21, 6);
$TopicOR = $TopicOldReplies;
$TopicNewReplies = ($TopicOR - 1);
$TopicNewReplies = sprintf("%6d", $TopicNewReplies);
$TopicNewReplies =~tr/ /0/;
if ($TopicMatched =~ /X/) {
$NewTopicName = ("$TopicFront" . "-$TopicNewReplies" . "X" . ".$Extension");
}  else {
$NewTopicName = ("$TopicFront" . "-$TopicNewReplies" . ".$Extension");
}

### can't use rename for certain NT systems; thus, here's the fix:
open (THISFILE, "$ForumsPath/$in{'forum'}/$TopicMatched");
@topicfile = <THISFILE>;
close(THISFILE);

open (RENAME, ">$ForumsPath/$in{'forum'}/$NewTopicName");
print RENAME "@topicfile";
close(RENAME);

unlink ("$ForumsPath/$in{'forum'}/$TopicMatched");
### END NEW RENAME ALTERNATIVE SECTION
#OLD RENAME PROCESS (Much easier, but NT doesn't fully support...)
#rename ("$ForumsPath/$in{'forum'}/$TopicMatched", "$ForumsPath/$in{'forum'}/$NewTopicName");

print<<otherHTML;
<p><center>
<B><FONT SIZE="$TextSize" FACE="$FontFace">The message has been successfully deleted!</FONT></B><BR><p>
<table border=0 cellpadding=20>
<tr>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A></FONT></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A></FONT></td>
otherHTML


} else {
	opendir (TOPICGRAB, "$ForumsPath/$in{'forum'}");
		@topiclist = readdir(TOPICGRAB);
	closedir (TOPICGRAB);
foreach $checktopic(@topiclist) {
	if ($checktopic =~ m/^$TopicNumber/) {
		unlink "$ForumsPath/$in{'forum'}/$checktopic"; 
	}
}

print<<otherHTML;
<p><center>
<B><FONT SIZE="$TextSize" FACE="$FontFace">The topic and all of its replies have been successfully deleted!</FONT></B><BR><p>
<table border=0 cellpadding=20>
<tr>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A></FONT></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A></FONT></td>
otherHTML
}
&BOTTOMHTML;
}  else  {
open (GETMESSAGE, "$ForumsPath/$in{'forum'}/$in{'MessageNumber'}");
	@oldmessage = <GETMESSAGE>;
close (GETMESSAGE);

&EditMessageTopHTML;

chomp ($oldmessage[0]);
chomp ($oldmessage[1]);
chomp ($oldmessage[2]);
chomp ($oldmessage[3]);
chomp ($oldmessage[4]);

$MessageText = &decodeURL($in{'MessageText'});

	$MessageText =~ s/\n\r\n/<p>/g;
			$MessageText =~ s/\n/<BR>/g;
			$MessageText = ("$MessageText" . " <BR> <font color=\#800000 size=1 face=\"$FontFace\">[Note: This message was edited by an administrator or moderator.]</font>");
open (FORUM, ">$ForumsPath/$in{'forum'}/$in{'MessageNumber'}"); 
print FORUM ("$oldmessage[0]\n");
print FORUM ("$oldmessage[1]\n");
print FORUM ("$oldmessage[2]\n");
print FORUM ("$oldmessage[3]\n");
print FORUM ("$oldmessage[4]\n");
print FORUM ("$MessageText\n");
close (FORUM);
			
print<<otherHTML;
<p><center>
<B><FONT SIZE="$TextSize" FACE="$FontFace">The message has been successfully edited!</FONT></B><BR><p>
<table border=0 cellpadding=20>
<tr>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A></FONT></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A></FONT></td>
otherHTML

&BOTTOMHTML;
}

} #End PerformTheEdit sr

sub DoThePrune {
foreach $row(@in) {
		($Name2, $Value2) = split ("=", $row);
			$Name2 = &decodeURL($Name2);
			$Value2 = &decodeURL($Value2);
			
			$_ = "$Name2";
			if (/PruneThis/) {
				($Trash, $DeleteThread) = split(/:::/, $Name2);
 				push(@DeleteList, $DeleteThread);
			}
		}
		
			opendir (GETFILES, "$ForumsPath/$in{'ForumNumber'}");
					@allmsgs = readdir(GETFILES);
				closedir (GETFILES);
				
				foreach $prunenum(@DeleteList) {
					foreach $matchtop(@allmsgs) {
						$TopicNum2 = substr($matchtop, 0, 6);
						if ($prunenum eq "$TopicNum2") {
							unlink "$ForumsPath/$in{'ForumNumber'}/$matchtop";
						}
					}
				}
						
			&PruneMessageTopHTML;
				
print<<PruneAllHTML;
<center>	<FONT SIZE="$TextSize" FACE="$FontFace"><B>	All requested threads have been deleted!</B></FONT>
<table border=0 cellpadding=20>
<tr>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A></FONT></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A></FONT></td>
PruneAllHTML
		
			&BOTTOMHTML;


} #end DoThePrune sr

sub UpdateTheSubject {

$TopicNumber = "$in{'TopicNumber'}";
	&GrabTopic;
			
open (GETMESSAGE, "$ForumsPath/$in{'forum'}/$TopicFile");
	@oldmessage = <GETMESSAGE>;
close (GETMESSAGE);

&EditMessageTopHTML;

chomp ($oldmessage[0]);
chomp ($oldmessage[1]);
chomp ($oldmessage[2]);
chomp ($oldmessage[4]);
chomp ($oldmessage[5]);

	$in{'NewSubject'} =~ s/<.+?>//g;
	$in{'NewSubject'} =~ s/"/&quot;/g;
	
open (FORUM, ">$ForumsPath/$in{'forum'}/$TopicFile"); 
print FORUM ("$oldmessage[0]\n");
print FORUM ("$oldmessage[1]\n");
print FORUM ("$oldmessage[2]\n");
print FORUM ("$in{'NewSubject'}\n");
print FORUM ("$oldmessage[4]\n");
print FORUM ("$oldmessage[5]\n");
close (FORUM);
			
print<<otherHTML;
<p><center>
<B><FONT SIZE="$TextSize" FACE="$FontFace">The thread subject has been successfully edited!</FONT></B><BR><p>
<table border=0 cellpadding=20>
<tr>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A></FONT></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A></FONT></td>
otherHTML

&BOTTOMHTML;


} #end UpdateTheSubject sr


sub PerformTheDelete {
$TopicNumber = substr($in{'TopicNumber'}, 0, 6);

	opendir (TOPICGRAB, "$ForumsPath/$in{'forum'}");
		@topiclist2 = readdir(TOPICGRAB);
	closedir (TOPICGRAB);
	
foreach $checktopic2(@topiclist2) {
	if ($checktopic2 =~ m/^$TopicNumber/) {
		unlink "$ForumsPath/$in{'forum'}/$checktopic2"; 
	}
}
&EditMessageTopHTML;

print<<otherHTML;
<p><center>
<B><FONT SIZE="$TextSize" FACE="$FontFace">The topic and all of its replies have been successfully deleted!</FONT></B><BR><p>
<table border=0 cellpadding=20>
<tr>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A></FONT></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A></FONT></td>
otherHTML

&BOTTOMHTML

} #end perform the delete sr
