#!/usr/bin/perl

#
### CONTROL PANEL SCRIPT FOR ULTIMATE BULLETIN BOARD ##
#
# Ultimate Bulletin Board is copyright Prime Web, 1997, 1998.
#
#       ------------ cpanel2.cgi -------------
#
#  This file contains some of the control panel functionality for
#  the UBB.  It is called from the controlpanel pages (cp.html).
#
#  NOTE: you MAY NOT redistribute this script under any
#  circumstance.  This means that you may not sell, trade, or in
#  any other way give this script to another user who is not
#  licensed to use it.  Prime Web offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.prime-web.com
#
###############################################################
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";

print ("Content-type: text/html\n\n");

require "cgi-lib.pl";
require "mods.file";
require "UltBB.setup";
require "Styles.file";
require "ubb_library.pl";

&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);

	if ($Name eq "ViewEntire") {
			$ViewEntire = $Value;
		}
	if ($Name eq "NN") {
			$SearchName = $Value;
			$SearchName =~tr/A-Z/a-z/; 
			}
	if ($Name eq "BBEmail") {
			$BBEmail = $Value;
			$BBEmail =~ s/@/\\@/;
			}
			
	if ($Name eq "Forum1") {
			$Forum1 = $Value;
			$Forum1 =~ s/"/&quot;/g;
		}
	
	if ($Name eq "BBRules") {
			$BBRules = $Value;
			$BBRules =~ s/"/&quot;/g;
			$BBRules =~ s/\n\r\n/<P>/g;
			$BBRules =~ s/\n/<BR>/g;
			$BBRules =~ s/\r//g;
			$BBRules =~ s/\@/\\@/g;
			}
		if ($Name eq "censorwords") {
			$censorwords = $Value;
			$censorwords =~ s/\n//g;
			$censorwords =~ s/\r//g;
			$censorwords =~ s/<BR>//g;
			$censorwords =~ s/<P>//g;
			$censorwords =~ s/"/&quot;/g;
			$censorwords =~ s/\@/\\@/g;
			}
		if ($Name eq "YourCopyrightNotice") {
			$YourCopyrightNotice = $Value;
			$YourCopyrightNotice =~ s/"/&quot;/g;
			$YourCopyrightNotice =~ s/\n\r\n//g;
			$YourCopyrightNotice =~ s/<BR>//g;
			$YourCopyrightNotice =~ s/<P>//g;
			$YourCopyrightNotice =~ s/\n//g;
			$YourCopyrightNotice =~ s/\r//g;
			$YourCopyrightNotice =~ s/\@/\\@/g;
			}
	if ($Name eq "ForumStatus1") {
			$ForumStatus1 = $Value;
			}
	
	
	if ($Name eq "MyHomePage") {
			$MyHomePage = $Value;
			}
	
	if ($Name eq "HomePageURL") {
			$HomePageURL = $Value;
			}
	
	if ($Name eq "BBName") {
			$BBName = $Value;
			}
	if ($Name eq "ForumsPath") {
			$ForumsPath = $Value;
			}
			if ($Name eq "MembersPath") {
			$MembersPath = $Value;
			}
			if ($Name eq "CGIPath") {
			$CGIPath = $Value;
			}
			if ($Name eq "NonCGIPath") {
			$NonCGIPath = $Value;
			}
			if ($Name eq "CGIURL") {
			$CGIURL = $Value;
			}
			if ($Name eq "NonCGIURL") {
			$NonCGIURL = $Value;
			}
		
		if ($Name eq "UserNameCheck") {
			$UserNameCheck = $Value;
			$UserNameCheckFile = $UserNameCheck;
			$UserNameCheckFile =~ s/ /_/g; #remove spaces
			}

		if ($Name eq "UserName") {
			$UserName = $Value;
			$UserNameFile = $UserName;
			$UserNameFile =~ s/ /_/g; #remove spaces
			}
			if ($Name eq "Password") {
			$Password = $Value;
			}
			if ($Name eq "PasswordCheck") {
			$PasswordCheck = $Value;
			}
				if ($Name eq "action") {
			$action = $Value;
			}
			
} #end foreach loop

if ($action eq "mods") {
&Mods;
}

if ($action eq "setgenvars") {
&SetGenVars;
}


if ($action eq "sendstyle") {
&SendStyle;
}
if ($action eq "getmatches") {
&GetMatches;
}

if ($action eq "updatepermiss") {
&UpdatePermiss;
}

if ($action eq "sendvarID") {
&SendVarID;
}

if ($action eq "sendforums") {
&SendForums;
}
if ($action eq "DoGenVars") {
&DoGenVars;
}
if ($action eq "addnewforum") {
&AddNewForum;
}
if ($action eq "forums") {
&Forums;
}

sub Forums {
# Verify that user is ADMIN first!
&GetMemberListArray;   #returns @members array
$NameFound = "no";
foreach $check(@members) {
   if ($check eq "$UserNameFile.cgi") {
      $NameFound = "yes";
    } 
}  # END FOREACH CHECK
if ($NameFound eq "yes") {
	@theprofile = &OpenProfile("$UserName.cgi");
	if ($Password eq "$theprofile[1]") {
	$Permission = "$theprofile[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoForums;
	   }  else {
	   &DontProcess;
	   }
	} else {
	&WrongPassword;
	}
}  else {
&WrongUserName;
}  ##END IF/ELSE NAME CHECK BLOCK
} #end Forums sr

sub DoForums {
# check to see how many forums are currently listed
	open (FORUMFILE, "$CGIPath/forums.cgi");
			@forums = <FORUMFILE>;
	close (FORUMFILE);
		
		$ForumTotal = @forums;
	$StartPoint = $in{'StartPoint'};
	$EndPoint = $StartPoint + 10;		
	$RecordStart = $StartPoint + 1;
	
if ($EndPoint >= $ForumTotal) {
	$NoMore = "true";
	$EndPoint = $ForumTotal;
}
if (($NoMore eq "true") && ($StartPoint eq "0")) {
	$PrefixWord = "";
	$NextPoint = "";
	}
elsif ($ForumTotal >= ($EndPoint + 10)) {
	$NextTotal = "10";
	$PrefixWord = "Next";
	$NextPoint = $EndPoint;
}
elsif ($ForumTotal <= $EndPoint) {
	$PrefixWord = "Previous";
	$NextTotal = "10";
	$NextPoint = $StartPoint - 10;
}  else {
	$PrefixWord = "Next";
	$NextTotal = $ForumTotal - $EndPoint;
	$NextPoint = $EndPoint;
}

$PageTitle = "Set Forum Variables";
&HEADER2HTML;

if ($UserNameCheck ne "") {
$UserNameFill = "$UserNameCheck";
}  else {
$UserNameFill = "$UserName";
}
$UserNameFill =~ tr/ /+/;

if ($PasswordCheck ne "") {
$PasswordFill = "$PasswordCheck";
}  else {
$PasswordFill = "$Password";
}
$PasswordFill =~ tr/ /+/;

print<<ForumHTML;
<B>
You can easily assign/change forum names, descriptions, and properties through this control panel.  The UBB now supports unlimited forums, as well, so there is nothing to hold you back!
<P>
</B>
<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<table border=0 width=95%><TR><TD>
<B><FONT SIZE="3" FACE="Verdana, Arial" COLOR="#800000">Set Forum Variables Below</FONT></B></td><TD align=center><FONT SIZE="2" FACE="Verdana, Arial">[<A HREF="$NonCGIURL/forumterms.html" target=_new>forum variable terms</A>]</FONT></td></TR></table>
<P>
You currently have $ForumTotal total forums (either active or inactive).  Forums are listed in blocks of 10 per page.  If you need to add new forums, <A HREF="cpanel.cgi?action=addforums">click here</A>.
<P>
<center>
<table border=0 bgcolor="#dedfdf" width=95%>
<TR><TD>
<B><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#800000">Forums $RecordStart to $EndPoint (of $ForumTotal Total)</FONT></B></td>
<td align=center><FONT SIZE="2" FACE="Verdana, Arial">[ <A HREF="cpanel2.cgi?action=forums&UserName=$UserNameFill&Password=$PasswordFill&StartPoint=$NextPoint">$PrefixWord $NextTotal</A> ]</FONT></td></tr></table>
</center>
<blockquote>
<table border=0>
ForumHTML

	$ForumCounter = 0;
	for $forumline(@forums) {
		$ForumCounter++;
		if (($StartPoint < $ForumCounter) && ($ForumCounter <= $EndPoint)) {
	$ForumActive = "";
	$ForumInactive = "";
	$HTMLOn = "";
	$HTMLOff = "";
	$UBBOn = "";
	$UBBOff = "";
	$RWOn = "";
	$RWOff = "";
	

		@thisforum = split(/\|/, $forumline);
		
		if ($thisforum[3] eq "On") {
			$ForumActive = "CHECKED";
		}  else {
			$ForumInactive = "CHECKED";
		}
		if ($thisforum[4] eq "is") {
			$HTMLOn = "CHECKED";
		}  else {
			$HTMLOff = "CHECKED";
		}
		if ($thisforum[5] eq "is") {
			$UBBOn = "CHECKED";
		}  else {
			$UBBOff = "CHECKED";
		}
			if ($thisforum[6] eq "yes") {
			$RWOn = "CHECKED";
		}  else {
			$RWOff = "CHECKED";
		}
print<<ForumGuts;
<tr>
<td valign=top>
<FONT SIZE="2" FACE="Verdana, Arial">
<B>Forum $ForumCounter</B>
<BLOCKQUOTE>
<table border=0 bgcolor="$AltColumnColor1">
<TR>
<TD>
<FONT SIZE="1" FACE="Verdana, Arial"><B>Name:</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="Name||$ForumCounter" VALUE="$thisforum[1]" SIZE=30 MAXLENGTH=100></td></tr>
<tr><td><FONT SIZE="1" FACE="Verdana, Arial"><B>
Category:</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="Category||$ForumCounter" VALUE="$thisforum[0]" SIZE=30 MAXLENGTH=100></td></tr>
<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Status:</B></FONT></td>
<td><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="Status||$ForumCounter" VALUE="On" $ForumActive> On &nbsp;&nbsp;&nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="Status||$ForumCounter" VALUE="Off" $ForumInactive> Off</B></FONT></td></tr>
<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>HTML Allowed?</B></FONT></td><TD><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="HTML||$ForumCounter" VALUE="is" $HTMLOn> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="HTML||$ForumCounter" VALUE="is not" $HTMLOff> No</B></FONT></td></tr>
<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>UBB Code Allowed?</B></FONT></td><TD><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="UBB||$ForumCounter" VALUE="is" $UBBOn> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="UBB||$ForumCounter" VALUE="is not" $UBBOff> No</B></FONT></td></tr>
<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Limited Write Access? <FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000">If yes, you will restrict ability to write to this forum to admins, moderators, and anyone with the password you select below.</FONT></B></FONT></td><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="RestrictWrite||$ForumCounter" VALUE="yes" $RWOn> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="RestrictWrite||$ForumCounter" VALUE="no" $RWOff> No</B></FONT></td></tr>
<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Limited Write Access Password.  (Only necessary if Limited Write Access is chosen for this forum.</B></FONT></td><TD><INPUT TYPE="TEXT" NAME="ForumPW||$ForumCounter" VALUE="$thisforum[7]" SIZE=10 MAXLENGTH=25></td></tr>
<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Description:</B></FONT></td><td><TEXTAREA NAME="Description||$ForumCounter" ROWS=3 COLS=30 wrap="VIRTUAL">$thisforum[2]</TEXTAREA></td></tr>
</table>
</BLOCKQUOTE></FONT>
<br>
</B></FONT>
</td>
</tr>
ForumGuts
} # if greater than start point, less than end point
} #for forumline

print<<BottomForumHTML;
</table>
<P><BR>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="sendforums">
<INPUT TYPE="HIDDEN" NAME="StartPoint" VALUE="$EndPoint">
<INPUT TYPE="HIDDEN" NAME="ForumTotal" VALUE="$ForumTotal">
<INPUT TYPE="HIDDEN" NAME="PrefixWord" VALUE="$PrefixWord">
<INPUT TYPE="HIDDEN" NAME="NextTotal" VALUE="$NextTotal">
<INPUT TYPE="HIDDEN" NAME="NextPoint" VALUE="$NextPoint">
<CENTER>
<P>
<HR>
<CENTER><FONT Size="$TextSize" FACE="$FontFace" COLOR="$LinkColor"><B>Enter Your UserName & Password:</font>
<P>
<FONT Size="1" FACE="$FontFace" COLOR="$VisitedLinkColor">(NOTE: if you are configuring your BB for the first time, type your default UserName and Password here)</font>
<p>
<FONT Size="$TextSize" FACE="$FontFace" COLOR="$LinkColor">
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B>
<p><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Forum Variables Now"></form>
<P>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#C0C0C0">Ultimate Bulletin Board, &copy; Prime-Web, 1998.</FONT>
</CENTER></font>
</BODY>
</HTML>
BottomForumHTML
}  ## END DoForums

sub SendVarID {
### CHECK USERNAME - must be an admin
##verify that this user is an administrator

&GetMemberListArray;   #returns @members array
$NameFound = "no";
foreach $check(@members) {
   if ($check eq "$UserNameFile.cgi") {
      $NameFound = "yes";
    } 
}  # END FOREACH CHECK
if ($NameFound eq "yes") {
	@theprofile = &OpenProfile("$UserName.cgi");
	if ($Password eq "$theprofile[1]") {
	$Permission = "$theprofile[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoGenVars;
	   }  else {
	   &DontProcess;
	   }
	} else {
	&WrongPassword;
	}
}  else {
&WrongUserName;
}  ##END IF/ELSE NAME CHECK BLOCK

} # end SendVarsID sr

sub DoGenVars {

			$BBRules =~ s/&quot;/"/ig;
			$BBRules =~ s/<BR>/\n/ig;
			$BBRules =~ s/<p>/\n\n/ig;
			
if ($CategoryView eq "yes") {
	$CategoryViewOn = "CHECKED";
}  else {
	$CategoryViewOff = "CHECKED";
}

if ($EmailVerify eq "ON") {
	$EmailVerifyOn = "CHECKED";
}  else {
	$EmailVerifyOff = "CHECKED";
}

if ($EditOption eq "ON") {
	$EditOptionOn = "CHECKED";
}  else {
	$EditOptionOff = "CHECKED";
}						
if ($ForumDescriptions eq "yes") {
	$ForumDescriptionsOn = "CHECKED";
}  else {
	$ForumDescriptionsOff = "CHECKED";
}
		
if ($Censor eq "ON") {
	$CensorOn = "CHECKED";
}  else {
	$CensorOff = "CHECKED";
}
		
if ($UseEmail eq "ON") {
	$EmailOn = "CHECKED";
}  else {
	$EmailOff = "CHECKED";
}		
if ($TimeFormat eq "24HR") {
	$Time24HR = "CHECKED";
}  else {
	$TimeAMPM = "CHECKED";
}		
if ($DateFormat eq "Euro") {
	$DateEuro = "CHECKED";
}  else {
	$DateUS = "CHECKED";
}
if ($EmailCheck eq "true") {
	$EmailTrue = "CHECKED";
}  else {
	$EmailFalse = "CHECKED";
}
if ($MemberMinimum eq "") {
	$MemberMinimum = "31";
}
if ($DaysPruneDefault eq "") {
	$DaysPruneDefault = "20";
}
if ($TimeZoneOffset eq "") {
	$TimeZoneOffset = "0";
}

$PageTitle = "Set General Variables";
&HEADERHTML;

print<<THIS;
To check your environmental variables, <A HREF="cpanel.cgi?action=env">click here</A>.<P>
<b>Note: if you are configuring your system for the first time, you MUST start with the General Variables below!</B>
<P>
Other Variable Settings: 
<ul>
<LI><A HREF="cpanel.cgi?action=style">Styles (fonts, colors, graphics, tables, etc.)</A>
<LI><A HREF="cpanel.cgi?action=logintoforums">Forums (names, descriptions, on/off status, HTML on/off, etc.)</a></ul>
<P>
<U><B><FONT SIZE="3" FACE="Times New Roman" COLOR="#800000">General Variables</FONT></B></U>
<P>
<FORM ACTION="cpanel2.cgi" NAME="THEFORM" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="setgenvars">
<table border=0>
<tr bgcolor="$AltColumnColor1">
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Absolute Path to Members Directory</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor"><B>Important!</B> If possible, this directory should be kept BELOW your www domain directory so that it cannot be accessed through a browser (eg, if your www root is at "/home/www/", you could go with "/home/Members")</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="MembersPath" VALUE="$MembersPath" SIZE=40 MAXLENGTH=250>
</td></tr>

<tr bgcolor="$AltColumnColor2" >
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Absolute Path to Directory Where Forum Directories Reside</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor"><B>Important!</B> This is your server path (check your server!) for the location of your Forum directories (Forum1, Forum2, etc.)</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="ForumsPath" VALUE="$ForumsPath" SIZE=40 MAXLENGTH=250>
</td></tr>

<tr bgcolor="$AltColumnColor1">
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Absolute Path for CGI/PL/SETUP/FILE Scripts</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor"> This is your server path (check your server!) for the location of all of your .cgi and .pl scripts (for example, /home/www/cgi-bin).  Be sure to put your files ending in .file and .setup in this directory.</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="CGIPath" VALUE="$CGIPath" SIZE=40 MAXLENGTH=250>
</td></tr>

<tr bgcolor="$AltColumnColor2">
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Absolute Path of your HTML and Image Files</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor"> This is your server path (check your server!) for the location of all your HTML and image (.gif, .jpg) files (put them all in the same directory) (for example, /home/www/UltimateBB, as opposed to the URL.)</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="NonCGIPath" VALUE="$NonCGIPath" SIZE=40 MAXLENGTH=250>
</td></tr>

<tr bgcolor="$AltColumnColor1">
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial"><B>URL for your CGI Directory</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor"> For instance, if your CGI files are in a directory called cgi-bin, and your domain name is whatever.com, you would write, "http://www.whatever.com/cgi-bin"</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="CGIURL" VALUE="$CGIURL" SIZE=40 MAXLENGTH=250>
</td></tr>

<tr bgcolor="$AltColumnColor2">
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial"><B>URL for your Non-CGI Directory</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">For instance, if your HTML, .gif, and .jpg files are in a directory called UltimateBB, and your domain name is whatever.com, you would write, "http://www.whatever.com/UltimateBB"</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="NonCGIURL" VALUE="$NonCGIURL" SIZE=40 MAXLENGTH=250>
</td></tr>

<TR bgcolor="$AltColumnColor1">
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your Email Address</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">this is email address that will be shown so that users can contact you</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="BBEmail" VALUE="$BBEmail" SIZE=30 MAXLENGTH=250>
</td></tr>

<TR bgcolor="$AltColumnColor2">
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Name of Your Bulletin Board</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">whatever you want to call your bulletin board</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="BBName" VALUE="$BBName" SIZE=30 MAXLENGTH=250>
</td></tr>

<TR bgcolor="$AltColumnColor1" >
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your Home Page URL</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">the complete URL (format- http://www.homepage.com) for your home page (not the bulletin board).  This will be used for links back to your homepage.</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="HomePageURL" VALUE="$HomePageURL" SIZE=40 MAXLENGTH=250>
</td></tr>

<TR bgcolor="$AltColumnColor2">
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Name of Your Home Page</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">this is the name of your home page that will listed for links back to your homepage.</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="MyHomePage" VALUE="$MyHomePage" SIZE=30 MAXLENGTH=250>
</td></tr>

<TR bgcolor="$AltColumnColor1">
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Registration Option</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">The default option is to require unique email addressed for each registered user.  You can disable this requirement by checking the "Unique Email Not Required" box.</FONT>
</td>
<td valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><INPUT TYPE="RADIO" NAME="EmailCheck" VALUE="true" $EmailTrue> Unique Email Required<br>
<INPUT TYPE="RADIO" NAME="EmailCheck" VALUE="false" $EmailFalse> Unique Email Not Required
</FONT>
</td></tr>

<TR bgcolor="$AltColumnColor2">
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Time Zone</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">The time of each posting is based on the time zone where your server is located.  If you want your users to know the time zone, provide it here (e.g., ET, CT, PT, etc.).  You may also leave this blank if you would prefer not to show a time zone.  You may type a different time zone than your server uses, but if you do so be sure to provide a time zone offset in the next field.</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="TimeZone" VALUE="$TimeZone" SIZE=20 MAXLENGTH=35>
</td></tr>


<TR bgcolor="$AltColumnColor2">
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Server Time Zone Offset</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">You can offset the time drawn from your web server.  For instance, if your server time is EST (US), but you want all time to reflect Pacific Time (US), you would have to offset your server time by placing the time zone difference in this field (for this example, that would be -3.  You would place -3 in this field).  The default is for there to be no server time zone offset (0).</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="TimeZoneOffset" VALUE="$TimeZoneOffset" SIZE=3 MAXLENGTH=4>
</td></tr>

<TR bgcolor="$AltColumnColor1" >
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Default Topic View (Days)</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">The default number of days for the "Show Topics Going Back X Days" option.  Users are able to customize this through preferences, but this is the default that will be given, otherwise.  Recommended: 20.</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="DaysPruneDefault" VALUE="$DaysPruneDefault" SIZE=3 MAXLENGTH=3>
</td></tr>

<TR bgcolor="$AltColumnColor2">
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Minimum Number of Messages For Full Member Status</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">Registered users are initially called Junior Members.  After a certain number of postings, the member will be automatically upgraded to full Member.  The default is 31 messages, but you can reset this value here.</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="MemberMinimum" VALUE="$MemberMinimum" SIZE=5 MAXLENGTH=5>
</td></tr>

<TR bgcolor="$AltColumnColor1">
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Category View Option</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">If you have numerous forums, or merely an ecletic collection of forums, you may want to assign categories to each forum.  You assign the category names when you Set Forums.  In order to have your forums displayed in Catgory format, you must click on the yes button to the right.</FONT></td>
<td>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="$LinkColor">
<INPUT TYPE="RADIO" NAME="CategoryView" VALUE="yes" $CategoryViewOn> yes 
<INPUT TYPE="RADIO" NAME="CategoryView" VALUE="no" $CategoryViewOff> no
</FONT></CENTER>
</td></tr>

<TR bgcolor="$AltColumnColor2">
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Display Forum Descriptions?</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">If you have many forums, you may not want to display your forum descriptions.  If not, check no.</FONT></td>
<td>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="$LinkColor"><INPUT TYPE="RADIO" NAME="ForumDescriptions" VALUE="yes" $ForumDescriptionsOn> yes
<INPUT TYPE="RADIO" NAME="ForumDescriptions" VALUE="no" $ForumDescriptionsOff> no
</FONT></CENTER>
</td></tr>

<TR bgcolor="$AltColumnColor1">
<td width=320 valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Censor Option</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">You may have certain words censored on your BB.  Words you choose to censor will be replaced by asterisks.  All subjects and messages will be affected. To activate the censor function, check the "yes" button below.  To deactivate, press the "no" button.  List all censored words in the field to the right.</FONT>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="$LinkColor"><INPUT TYPE="RADIO" NAME="Censor" VALUE="ON" $CensorOn> yes
<INPUT TYPE="RADIO" NAME="Censor" VALUE="OFF" $CensorOff> no
</FONT></CENTER>
</td>
<td valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Censor Words</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">Type all words you want censored in the field below.  Do not use commas to separate words, just use spaces.  For example, type "dog cat boy", rather than "dog, cat, boy."  If you type "dog", all words containing the string "dog" would be censored (dogma, for instance, would appear as "***ma").  To censor more accurately, you can require that censors occur only for exact words.  You can do this by placing a censor word in curly braces, as in {dog}.  Signifying "dog" in the curly braces would mean that dogma would appear as dogma, but dog would appear as "***".  Thus your censor list may appear as cat "{dog} {barn} barn."
</FONT><BR>
<TEXTAREA NAME="censorwords" ROWS=3 COLS=30 WRAP="VIRTUAL">$censorwords
</TEXTAREA>
</td></tr>

<TR bgcolor="$AltColumnColor2">
<td valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Bulletin Board Rules</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">You can customize the exact wording for your bulletin board's rules.  Just edit the wording in the box to the right.</FONT>
</td>
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial"><B>$BBName Rule Wording:</B><br></FONT>
<TEXTAREA NAME="BBRules" ROWS=8 COLS=35 wrap="virtual">$BBRules
</TEXTAREA>
</td></tr>

<TR bgcolor="$AltColumnColor2">
<td valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Date Format</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">European Format is DD-MM-YR, while US format is MM-DD-YR.</FONT>
</td>
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="DateFormat" VALUE="US" $DateUS> US Format (Month-Day-Year)<BR>
<INPUT TYPE="RADIO" NAME="DateFormat" VALUE="Euro" $DateEuro> European Format (Day-Month-Year)
</font>
</td></tr>


<TR bgcolor="$AltColumnColor1">
<td valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Time Format</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">You can have time displayed in AM/PM format, or in 24-hour format.</FONT>
</td>
<td width=320>
<FONT SIZE="2" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="TimeFormat" VALUE="AMPM" $TimeAMPM> Use AM/PM Time Format<BR>
<INPUT TYPE="RADIO" NAME="TimeFormat" VALUE="24HR" $Time24HR> User 24-Hour Format Time (eg, 23:15)
</font>
</td></tr>

<TR bgcolor="$AltColumnColor2">
<td valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your Copyright Wording</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">This wording will appear in smaller print directly above the copyright wording concerning the UBB script itself. You can leave this blank or provide any wording you like.</FONT>
</td>
<td width=320>
<TEXTAREA NAME="YourCopyrightNotice" ROWS=3 COLS=30 WRAP="VIRTUAL">$YourCopyrightNotice
</TEXTAREA>
</td></tr>

<TR bgcolor="$AltColumnColor1">
<td width=320 valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Email Options</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">To enable all functions that send email to users, set this field to on.  If for some reason email features don't seem to be working for your system, you may simply turn them off.</FONT>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="$LinkColor"><INPUT TYPE="RADIO" NAME="UseEmail" VALUE="ON" $EmailOn> yes
<INPUT TYPE="RADIO" NAME="UseEmail" VALUE="OFF" $EmailOff> no</FONT></CENTER>
</td>
<td valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Email Server Name</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">This is the SMTP email server that will be used to send email from the UBB.  Use whatever you use for your email account (check your email settings under "SMTP server").
</FONT><BR>
<INPUT TYPE="TEXT" NAME="EmailServer" VALUE="$EmailServer" SIZE=25 MAXLENGTH=50>
</td></tr>

<TR bgcolor="$AltColumnColor2">
<td valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Verify User Email Address During Registration?</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">For tighter security, you may want to require that your registered users have valid email addresses.  This is accomplished by mailing their password to them at the email address they register.  To enable email verification during registration, click yes in the field to the right.</FONT>
</td><td width=320>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="$LinkColor"><INPUT TYPE="RADIO" NAME="EmailVerify" VALUE="ON" $EmailVerifyOn> yes
<INPUT TYPE="RADIO" NAME="EmailVerify" VALUE="OFF" $EmailVerifyOff> no</FONT></CENTER>
</td></tr>

<TR bgcolor="$AltColumnColor1">
<td valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Allow User Editing of Messages?</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">Adminsitrators and moderators can always edit and delete messages.  You may want to allow every user to edit messages.  To do so, select "yes" to the right.</FONT>
</td><td width=320>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="$LinkColor"><INPUT TYPE="RADIO" NAME="EditOption" VALUE="ON" $EditOptionOn> yes
<INPUT TYPE="RADIO" NAME="EditOption" VALUE="OFF" $EditOptionOff> no</FONT></CENTER>
</td></tr>

</table>
<P>
<br>
<CENTER><FONT Size="$TextSize" FACE="$FontFace" COLOR="$LinkColor"><B>Enter your UserName & Password:</font>
<P>
<FONT Size="1" FACE="$FontFace" COLOR="$VisitedLinkColor">(NOTE: if you are configuring your BB for the first time, type your default UserName and Password here)</font>
<p>
<FONT Size="$TextSize" FACE="$FontFace" COLOR="$LinkColor">
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B></CENTER>
<p><center>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit General Variables"></center>
</form>
</BODY></HTML>
THIS
}


sub SendStyle {
### CHECK USERNAME - must be an admin
##verify that this user is an administrator
&GetMemberListArray;

$NameFound = "no";

foreach $check(@members) {
   if ($check eq "$UserNameFile.cgi") {
      $NameFound = "yes";
    }
   
}  # END FOREACH CHECK


if ($NameFound eq "yes") {

	@theprofile = &OpenProfile("$UserName.cgi");
	
	if ($Password eq "$theprofile[1]") {
	$Permission = "$theprofile[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoProcessStyle;
	   }  else {
	   &DontProcess;
	   }
	} else {
	&WrongPassword;
	}
}  else {
&WrongUserName;
}  ##END IF/ELSE NAME CHECK BLOCK



################
sub DoProcessStyle {

$variable0=('$BGColor = ' . '"' . $in{'BGColor'} . '";');
$variable1=('$FontFace = ' . '"' . $in{'FontFace'} . '";');
$variable2=('$TextColor = ' . '"' . $in{'TextColor'} . '";');
$variable3=('$LinkColor = ' . '"' . $in{'LinkColor'} . '";');
$variable4=('$VisitedLinkColor = ' . '"' . $in{'VisitedLinkColor'} . '";');
$variable5=('$TableColorStrip = ' . '"' . $in{'TableColorStrip'} . '";');
$variable6=('$TableStripTextColor = ' . '"' . $in{'TableStripTextColor'} . '";');
$variable7=('$ThreadsTableBGColor = ' . '"' . $in{'ThreadsTableBGColor'} . '";');
$variable8=('$AltColumnColor1 = ' . '"' . $in{'AltColumnColor1'} . '";');
$variable9=('$AltColumnColor2 = ' . '"' . $in{'AltColumnColor2'} . '";');
$variable10=('$TextSize = ' . '"' . $in{'TextSize'} . '";');
$variable11=('$BBTitle = ' . '"' . $in{'BBTitle'} . '";');
$variable12=('$BBTopic = ' . '"' . $in{'BBTopic'} . '";');
$variable13=('$BBReply = ' . '"' . $in{'BBReply'} . '";');
$variable14=('$TableWidth = ' . '"' . $in{'TableWidth'} . '";');
$variable15=('$CategoryStripColor = ' . '"' . $in{'CategoryStripColor'} . '";');
if ($in{'PageBackground'} ne "") {
$variable16=('$PageBackground = ' . '"' . 'background=$NonCGIURL/' . $in{'PageBackground'} . '";');
}  else {
$variable16=('$PageBackground = ' . '"' . '";');
}
$variable17=('$ThreadClosed = ' . '"' . $in{'ThreadClosed'} . '";');
$variable18=('$mailgif = ' . '"' . $in{'mailgif'} . '";');
$variable19=('$profilegif = ' . '"' . $in{'profilegif'} . '";');
$variable20=('$CopyrightTextColor = ' . '"' . $in{'CopyrightTextColor'} . '";');

open (FILE, ">$CGIPath/Styles.file") or die("Unable to open setup file for writing.");

	print FILE ("$variable0\n");
	print FILE ("$variable1\n");
	print FILE ("$variable2\n");
	print FILE ("$variable3\n");
	print FILE ("$variable4\n");
	print FILE ("$variable5\n");
	print FILE ("$variable6\n");
	print FILE ("$variable7\n");
	print FILE ("$variable8\n");
	print FILE ("$variable9\n");
	print FILE ("$variable10\n");
	print FILE ("$variable11\n");
	print FILE ("$variable12\n");
	print FILE ("$variable13\n");
	print FILE ("$variable14\n");
	print FILE ("$variable15\n");
	print FILE ("$variable16\n");
	print FILE ("$variable17\n");
	print FILE ("$variable18\n");
	print FILE ("$variable19\n");
	print FILE ("$variable20\n");
	print FILE ("1;\n");
close (FILE);

$ConfirmLine = "The Style Variables for your bulletin board have been updated.";
&ConfirmHTML2;

} ## END DO PROCESS VARS


}  ## END SendStyle subroutine

sub UpdatePermiss {
$CheckUN = ("$in{'UserNameCheck'}" . ".cgi");
@theprofile = &OpenProfile($CheckUN);

if ($in{'PasswordCheck'} eq "$theprofile[1]") {
	$Status = "$theprofile[8]";
	&CheckStatus;
	   if ($AdminStatus eq "true") {
			&UpdateThePermissions;
		}  else {
			&NotAllowed;
		} #end if adminstatus is true 
}  else {
&WrongPassword;
}
}  ## END UPdatePermiss SR ###


sub GetMatches {

##verify that this user is an administrator
&GetMemberListArray; #returns @members array

$NameFound = "no";

foreach $check(@members) {
   if ($check eq "$UserNameFile.cgi") {
      $NameFound = "yes";
    }
   
}  # END FOREACH CHECK


if ($NameFound eq "yes") {
	@theprofile = &OpenProfile("$UserName.cgi");
			
	if ($Password eq "$theprofile[1]") {
	$Permission = "$theprofile[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   	   
if ($ViewEntire eq "Yes") {
	&GetAll;
	} else {
	&DoSearch;
	}
	   }  else {
	   &DontProcess;
	   }
	} else {
	&WrongPassword;
	}
	
	
}  else {
&WrongUserName;
}  ##END IF/ELSE NAME CHECK BLOCK


## if admin priviledges, conduct search


sub GetAll {
&GetMemberListArray; #returns @members array

	@members = sort(@members);
	$TotalProfiles = @members;
	
if ($TotalProfiles > 0) {	

print <<HTML_TOP;
<HTML>
<HEAD><TITLE>
Ultimate Bulletin Board - Set Permissions - All Members</title>


<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE

var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}

function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.PERMISS.UserNameCheck.value = getCookie("UserNameCP");
document.PERMISS.PasswordCheck.value = getCookie("PasswordCP");
	}  else {
	document.PERMISS.UserNameCheck.focus();
}
}

function Check(form)  {
if ((form.PasswordCheck.value == "") || (form.UserNameCheck.value == ""))  {
	alert ("You forgot to complete one or more of the form fields.");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</head>
<body bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<FONT Size="$TextSize" FACE="$FontFace">
<table border=0 width=600>
<tr>
<TD>
<CENTER><b>
<IMG SRC="$NonCGIURL/$BBTitle" WIDTH=299 HEIGHT=75 BORDER=0 ALT="Ultimate Bulletin Board - graphic by Karen Vail">
</CENTER>
</td>
<td>
<B><FONT SIZE="3" FACE="$FontFace" COLOR="#000080">Ultimate Bulletin Board<br>Set Permissions </FONT></B>
</td>
</table>
<p>
There are currently $TotalProfiles registered bulletin board members.
Make any changes necessary and then click on "Submit" to modify any/all user records.  Check the delete box on the left for all registrations you want deleted.<br><br>

<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="PERMISS" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="updatepermiss">

<center>
<table border=2 bgcolor="#FFF8EA" width=550>
<tr>
<td valign=bottom>
<FONT SIZE="1" FACE="$FontFace">
<B>Delete?</B></font>
</td>
<td valign=bottom><FONT SIZE="1" FACE="$FontFace"><B>User Name</B></FONT></td>
<td valign=bottom ><FONT SIZE="1" FACE="$FontFace" COLOR="#FF0000"><B>Able to post notes?</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="$FontFace" COLOR="#FF0000"><B>Authorized Administrator?</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="$FontFace"><B>Status</B></FONT></td>
</tr>
HTML_TOP

for $line(@members) {

@searchrow = &OpenProfile($line);

$Permission = $searchrow[4];
&CheckPermissions;
$WriteYes = "";
$WriteNo = "";
$AdminYes="";
$AdminNo="";

if ($AdminWrite eq "true") {
   $WriteYes = "CHECKED";
}  else {
   $WriteNo = "CHECKED";
}
if ($AdminPermission eq "true") {
   $AdminYes = "CHECKED";
}  else {
   $AdminNo = "CHECKED";
}
####


print <<GUTS;
<tr>
<td align=center>
<INPUT TYPE="CHECKBOX" NAME="Delete::$searchrow[0]" VALUE="yes">
</td>
<td><FONT SIZE="1" FACE="$FontFace">$searchrow[0]</font></td>
<td><FONT SIZE="1" FACE="$FontFace">
<INPUT TYPE="RADIO" NAME="AdminWrite::$searchrow[0]" VALUE="true" $WriteYes>Yes &nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="AdminWrite::$searchrow[0]" VALUE="false" $WriteNo>No
</FONT>
</td>
<td><FONT SIZE="1" FACE="$FontFace">
<INPUT TYPE="RADIO" NAME="AdminPermission::$searchrow[0]" VALUE="true" $AdminYes>Yes &nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="AdminPermission::$searchrow[0]" VALUE="false" $AdminNo>No
</FONT>
</td>
<td><FONT SIZE="1" FACE="$FontFace">$searchrow[8]</FONT></td></tr>
GUTS

####
} #end FOREACH

print <<ENDHTML;
</table>
</center>
<br>
<CENTER><FONT Size="$TextSize" FACE="$FontFace" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B></CENTER>
<p>
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Permission Changes Now">
</form><FONT COLOR="#C0C0C0">
<BR><BR>Powered by: Ultimate Bulletin Board, Version 4.0<br>
&copy; Prime Web Corporation, 1997.<BR><BR>.</CENTER>
</FONT>
</FONT>
</body>
</html>
ENDHTML
}  else {

print <<SORRY;
<HTML><BODY bgcolor="#FFFFFF"><FONT Size="$TextSize" FACE="$FontFace"><BR><BR><BR>
Sorry, but we couldn't find any users that matched your search criteria.  Please go back and try again!
<P>
</FONT>
<br><br>
</body>
</html>
SORRY
}

}  ## END GET ALL SR ##

sub DoSearch {
&GetMemberListArray;  #returns @members array

$Search = 0;
foreach $member(@members) {
@searchfile = &OpenProfile("$member");
	
$bad = "0";

#start UserName check block

	if ($SearchName ne "") {
		$Caser = $searchfile[0];
		$Caser =~tr/A-Z/a-z/;   #convert temporarily to lower case to compare
#		$Caser =~ s/ //g; 	 #spaces are removed
		$Caser = &decodeURL($Caser);
		if ($Caser =~ m/$SearchName/) {
					$valid = "1";	
						}  else {
					$bad = "1";
					}
	} 

$CheckEmail = "$in{'Email'}";

	if ($CheckEmail ne "") {
		$CheckEmail =~tr/A-Z/a-z/;
		$Caser = $searchfile[2];
		$Caser =~tr/A-Z/a-z/;   #convert to lower case to compare
		$Caser =~ s/ //g; 	 #spaces are removed
		$Caser = &decodeURL($Caser);
		if ($Caser =~ m/$CheckEmail/) {
				$valid = "1";	
			}   else {
				$bad = "1";
			}
	} 

#start validation block

if ($valid eq "1" && $bad eq "0")  {
$Search++;
$line = ("$searchfile[0]" .  "|" .  "$searchfile[2]" .  "|"  . "$searchfile[4]" . "|" . "$searchfile[8]");
push (@final, $line);
}  

#close validation block

}  #end FOREACH $member


if ($Search > 0) {	

@final = sort(@final);

print <<HTML_TOP;
<HTML>
<HEAD>

<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE

var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}

function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.PERMISS.UserNameCheck.value = getCookie("UserNameCP");
document.PERMISS.PasswordCheck.value = getCookie("PasswordCP");
	}  else {
	document.PERMISS.UserNameCheck.focus();
}
}

function Check(form)  {
if ((form.PasswordCheck.value == "") || (form.UserNameCheck.value == ""))  {
	alert ("You forgot to complete one or more of the form fields.");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
<TITLE>
Ultimate Bulletin Board - Set Permissions - All Members</title></head>
<body bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<FONT Size="$TextSize" FACE="$FontFace">
<table border=0 width=600>
<tr>
<TD>
<CENTER><b>
<IMG SRC="$NonCGIURL/$BBTitle" WIDTH=299 HEIGHT=75 BORDER=0 ALT="Ultimate Bulletin Board - graphic by Karen Vail">
</CENTER>
</td>
<td>
<B><FONT SIZE="3" FACE="$FontFace" COLOR="#000080">Ultimate Bulletin Board<br>Set Permissions </FONT></B>
</td>
</table>
<p>
Make any changes necessary and then click on "Submit" to modify any/all user records.  Check the delete box on the left for all registrations you want deleted.<br><br>

<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="PERMISS"  onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="updatepermiss">
<center>
<table border=2 bgcolor="#FFF8EA" width=550>
<tr>
<td valign=bottom>
<FONT SIZE="1" FACE="$FontFace">
<B>Delete?</B></font>
</td>
<td valign=bottom><FONT SIZE="1" FACE="$FontFace"><B>User Name</B></FONT></td>
<td valign=bottom ><FONT SIZE="1" FACE="$FontFace" COLOR="#FF0000"><B>Able to post notes?</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="$FontFace" COLOR="#FF0000"><B>Authorized Administrator?</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="$FontFace"><B>Status</B></FONT></td>
</tr>
HTML_TOP

foreach $line2(@final) {
		
	@searchrow = split (/\|/, $line2);
	
$Permission = $searchrow[2];
&CheckPermissions;
$WriteYes = "";
$WriteNo = "";
$AdminYes="";
$AdminNo="";

if ($AdminWrite eq "true") {
   $WriteYes = "CHECKED";
}  else {
   $WriteNo = "CHECKED";
}
if ($AdminPermission eq "true") {
   $AdminYes = "CHECKED";
}  else {
   $AdminNo = "CHECKED";
}
print <<GUTS;
<tr>
<td align=center>
<INPUT TYPE="CHECKBOX" NAME="Delete::$searchrow[0]" VALUE="yes">
</td>
<td><FONT SIZE="1" FACE="$FontFace">$searchrow[0]</font></td>
<td><FONT SIZE="1" FACE="$FontFace">
<INPUT TYPE="RADIO" NAME="AdminWrite::$searchrow[0]" VALUE="true" $WriteYes>Yes &nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="AdminWrite::$searchrow[0]" VALUE="false" $WriteNo>No
</FONT>
</td>
<td><FONT SIZE="1" FACE="$FontFace">
<INPUT TYPE="RADIO" NAME="AdminPermission::$searchrow[0]" VALUE="true" $AdminYes>Yes &nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="AdminPermission::$searchrow[0]" VALUE="false" $AdminNo>No
</FONT>
</td>
<td><FONT SIZE="1" FACE="$FontFace">$searchrow[3]</FONT></td>
GUTS

} #end FOREACH

print <<ENDHTML;
</table>
<br>
<FONT Size="$TextSize" FACE="$FontFace" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B></CENTER><P>
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Permission Changes Now">
</form><FONT COLOR="#C0C0C0">
<BR><BR>Powered by: Ultimate Bulletin Board<BR>
&copy; Prime-Web, 1998.<BR><BR>.</CENTER>
</FONT>
</FONT>
</body>
</html>
ENDHTML
}  else {

print <<SORRY;
<HTML><BODY bgcolor="#FFFFFF"><FONT Size="$TextSize" FACE="$FontFace"><BR><BR><BR>
Sorry, but we couldn't find any users that matched your search criteria.  Please go back and try again!</FONT>
<br><br>
</body>
</html>
SORRY
}
}  ##END DOSEARCH SR ###
}  #end GetMatches SR ###


sub SetGenVars {
### CHECK USERNAME - must be an admin
##verify that this user is an administrator

&GetMemberListArray;  #returns @members array

$NameFound = "no";

foreach $check(@members) {
   if ($check eq "$UserNameCheckFile.cgi") {
      $NameFound = "yes";
    }
   
}  # END FOREACH CHECK


if ($NameFound eq "yes") {
	@profilestats = &OpenProfile("$UserNameCheck.cgi");
			
	if ($in{'PasswordCheck'} eq "$profilestats[1]") {
	$Permission = "$profilestats[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoProcessGenVars;
	   }  else {
	   &DontProcess;
	   }
	} else {
	&WrongPassword;
	}
}  else {
&WrongUserName;
}  ##END IF/ELSE NAME CHECK BLOCK
}  ##END Set Gen Vars

sub DoProcessGenVars {

$variable1=('$BBEmail = ' . '"' . $BBEmail . '";');
$variable2=('$MembersPath = ' . '"' . $in{'MembersPath'} . '";');
$variable3=('$MyHomePage = ' . '"' . $MyHomePage . '";');
$variable4=('$HomePageURL = ' . '"' . $HomePageURL . '";');
$variable5=('$BBName = ' . '"' . $BBName . '";');
$variable6=('$ForumsPath = ' . '"' . $in{'ForumsPath'} . '";');
$variable7=('$CGIPath = ' . '"' . $in{'CGIPath'} . '";');
$variable8=('$NonCGIPath = ' . '"' . $in{'NonCGIPath'} . '";');
$variable9=('$CGIURL = ' . '"' . $in{'CGIURL'} . '";');
$variable10=('$NonCGIURL = ' . '"' . $in{'NonCGIURL'} . '";');
$variable12=('$EmailCheck = ' . '"' . $in{'EmailCheck'} . '";');
$variable13=('$TimeZone = ' . '"' . &decodeURL($in{'TimeZone'}) . '";');
$variable14=('$Censor = ' . '"' . $in{'Censor'} . '";');
$variable15=('$censorwords = ' . '"' . $censorwords . '";');
$variable16=('$MemberMinimum = ' . '"' . $in{'MemberMinimum'} . '";');
$variable17=('$BBRules = ' . '"' . $BBRules . '";');
$variable18=('$DaysPruneDefault = ' . '"' . $in{'DaysPruneDefault'} . '";');
$variable19=('$CategoryView = ' . '"' . $in{'CategoryView'} . '";');
$variable20=('$ForumDescriptions = ' . '"' . $in{'ForumDescriptions'} . '";');
$variable21=('$DateFormat = ' . '"' . $in{'DateFormat'} . '";');
$variable22=('$TimeZoneOffset = ' . '"' . $in{'TimeZoneOffset'} . '";');
$variable23=('$TimeFormat = ' . '"' . $in{'TimeFormat'} . '";');
$variable24=('$YourCopyrightNotice = ' . '"' . $YourCopyrightNotice . '";');
$variable25=('$UseEmail = ' . '"' . $in{'UseEmail'} . '";');
$variable26=('$EmailServer = ' . '"' . $in{'EmailServer'} . '";');
$variable27=('$EmailVerify = ' . '"' . $in{'EmailVerify'} . '";');
$variable28=('$EditOption = ' . '"' . $in{'EditOption'} . '";');

open (FILE, ">$CGIPath/UltBB.setup") or die("Unable to open setup file for writing.");

	print FILE ("$variable0\n");
	print FILE ("$variable1\n");
	print FILE ("$variable2\n");
	print FILE ("$variable3\n");
	print FILE ("$variable4\n");
	print FILE ("$variable5\n");
	print FILE ("$variable6\n");
	print FILE ("$variable7\n");
	print FILE ("$variable8\n");
	print FILE ("$variable9\n");
	print FILE ("$variable10\n");
	print FILE ("$variable12\n");
	print FILE ("$variable13\n");
	print FILE ("$variable14\n");
	print FILE ("$variable15\n");
	print FILE ("$variable16\n");
	print FILE ("$variable17\n");
	print FILE ("$variable18\n");
	print FILE ("$variable19\n");
	print FILE ("$variable20\n");
	print FILE ("$variable21\n");
	print FILE ("$variable22\n");
	print FILE ("$variable23\n");
	print FILE ("$variable24\n");
	print FILE ("$variable25\n");
	print FILE ("$variable26\n");
	print FILE ("$variable27\n");
	print FILE ("$variable28\n");
	
	print FILE ("1;\n");
close (FILE);

$UserNameCoded = "$UserNameCheck";
$UserNameCoded =~ tr/ /+/;
$PasswordCoded = "$PasswordCheck";
$PasswordCoded =~ tr/ /+/;

$ConfirmLine = "The Ultimate Bulletin Board general variables have been updated.<P>If you are configuring your bulletin board for the first time (or if you are upgrading to Version 4.0), you should set your Forum variables now.  <P>
** <a href=\"cpanel2.cgi?action=forums&UserName=$UserNameCoded&Password=$PasswordCoded&StartPoint=0\">Click here to set your forum variables.</a> **";
&ConfirmHTML;
} ## END DO PROCESS GENERAL VARS SR


sub SendForums {
### CHECK USERNAME - must be an admin
##verify that this user is an administrator
&GetMemberListArray;  #returns @members array
$NameFound = "no";
foreach $check(@members) {
   if ($check eq "$UserNameCheckFile.cgi") {
      $NameFound = "yes";
    } 
}  # END FOREACH CHECK

if ($NameFound eq "yes") {
	@profilestats = &OpenProfile("$UserNameCheck.cgi");
			
	if ($PasswordCheck eq "$profilestats[1]") {
	$Permission = "$profilestats[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoProcessForums;
	   }  else {
	   &DontProcess;
	   }
	} else {
	&WrongPassword;
	}
}  else {
&WrongUserName;
}  ##END IF/ELSE NAME CHECK BLOCK

}  ##END SendForums sr


sub AddNewForum {
### CHECK USERNAME - must be an admin
##verify that this user is an administrator

&GetMemberListArray;  #returns @members array

$NameFound = "no";

foreach $check(@members) {
   if ($check eq "$UserNameFile.cgi") {
      $NameFound = "yes";
    }
   
}  # END FOREACH CHECK


if ($NameFound eq "yes") {
	@profilestats = &OpenProfile("$UserName.cgi");
			
	if ($Password eq "$profilestats[1]") {
	$Permission = "$profilestats[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoAddNewForum;
	   }  else {
	   &DontProcess;
	   }
	} else {
	&WrongPassword;
	}
}  else {
&WrongUserName;
}  ##END IF/ELSE NAME CHECK BLOCK

}  ##END AddNewForum sr

sub DoProcessForums {
### write forum info to forums.cgi
foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	if ($Name =~ m/Category/) {
	($Trash, $ForumNumber) = split(/\|\|/, $Name);
	push (@AdjustForums, $ForumNumber);
	}
} # end foreach $row

# now we have list of forum numbers to adjust (e.g., 1 - 9)

#read current forum data
open (FORUMFILE, "$CGIPath/forums.cgi");
	@forums = <FORUMFILE>;
close (FORUMFILE);

#assemble new line for each revised forum
for $num(@AdjustForums) {
	
foreach $row2(@in) {
	($Name, $Value) = split ("=", $row2);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	if ($Name eq "Name||$num") {
		$ThisName = $Value;
		$ThisName =~ s/"/&quot;/g;
	}
	if ($Name eq "Category||$num") {
		$ThisCategory = $Value;
	}
	if ($Name eq "Status||$num") {
		$ThisStatus = $Value;
	}
	if ($Name eq "HTML||$num") {
		$ThisHTML = $Value;
	}
	if ($Name eq "UBB||$num") {
		$ThisUBB = $Value;
	}
	if ($Name eq "RestrictWrite||$num") {
		$ThisRestrictWrite = $Value;
	}
	if ($Name eq "ForumPW||$num") {
		$ThisForumPW = $Value;
	}
	if ($Name eq "Description||$num") {
		$ThisDescription = $Value;
		$ThisDescription =~ s/"/&quot;/g;
		$ThisDescription =~ s/\n\r\n//g;
		$ThisDescription =~ s/\n//g;
		$ThisDescription =~ s/\r//g;
		$ThisDescription =~ s/  / /g;
	}
} # end foreach $row2

$arrayrow = ($num - 1);

$forums[$arrayrow] = ("$ThisCategory|$ThisName|$ThisDescription|$ThisStatus|$ThisHTML|$ThisUBB|$ThisRestrictWrite|$ThisForumPW|$num\n");

}  #end for each @AdjustForum

#write to forums file

open (FORUMS, ">$CGIPath/forums.cgi"); 
print FORUMS (@forums);
close (FORUMS);

$UserNameCoded = "$UserNameCheck";
$UserNameCoded =~ tr/ /+/;
$PasswordCoded = "$PasswordCheck";
$PasswordCoded =~ tr/ /+/;

$ConfirmLine = "The Ultimate Bulletin Board forums have been updated.<P>
Additional Forums to Edit: [ <A HREF=\"cpanel2.cgi?action=forums&UserName=$UserNameCoded&Password=$PasswordCoded&StartPoint=$in{'NextPoint'}\">$in{'PrefixWord'} $in{'NextTotal'}</A> ]";
&ConfirmHTML;
} ## END DO PROCESS FORUMS SR


sub DoAddNewForum {
$ForumTotal = &GetTotalForums;
$ForumTotal++;
### write forum info to forums.cgi
	$Description = &decodeURL($in{'Description'});
		$Description =~ s/"/&quot;/g;
		$Description =~ s/\n\r\n//g;
		$Description =~ s/\n//g;
		$Description =~ s/\r//g;
		$Description =~ s/  / /g;
		
	$Name = &decodeURL($in{'Name'});
	$Name =~ s/"/&quot;/g;
	$Category = &decodeURL($in{'Category'});
	
$newforumline = ("$Category|$Name|$Description|$in{'Status'}|$in{'HTML'}|$in{'UBB'}|$in{'RestrictWrite'}|$in{'ForumPW'}|$ForumTotal");

#write to forums file

open (NEWFORUM, ">>$CGIPath/forums.cgi"); 
print NEWFORUM ("$newforumline\n");
close (NEWFORUM);

#create new Forum Directory with permissions for UNIX servers
mkdir("$ForumsPath/Forum$in{'Number'}", 0777);
chmod (0777, "$ForumsPath/Forum$in{'Number'}");

$ConfirmLine = "New forum successfully added!<P>";
&ConfirmHTML;
} ## END DO ADD NEW FORUM SR


sub Mods {
##verify that this user is an administrator
&GetMemberListArray;  #returns @members array

$NameFound = "no";

foreach $check(@members) {
   if ($check eq "$UserNameFile.cgi") {
      $NameFound = "yes";
    }
   
}  # END FOREACH CHECK


if ($NameFound eq "yes") {
	@profilestats = &OpenProfile("$UserName.cgi");
			
	if ($Password eq "$profilestats[1]") {
	$Permission = "$profilestats[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoProcess;
	   }  else {
	   &DontProcess;
	   }
	} else {
	&WrongPassword;
	}
	
	
}  else {
&WrongUserName;
}  ##END IF/ELSE NAME CHECK BLOCK

sub DoProcess {

&GetMemberListArray;  #returns @members array

## now we have our current Member list (in filename format)

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	if ($Name =~ m/NewMod/) {
	($Trash, $Number) = split(/Mod/, $Name);
	$Combine = ("$Number" . "::" . "$Value");
	push (@GoodMods, $Combine);
	}
} # end foreach $row

#	for (@GoodMods2) {
#		($Trash, $ModSplit) = split(/::/, $_);
#		push (@GoodMods, $ModSplit);
#	}

#now Moderator names are in order

for (@GoodMods) {
	$modmatch = "false";
	($ForumNumber, $ModName) = split(/::/, $_);
	if (($ModName ne "none") && ($ModName ne "")) {
		$ModCoded = "$ModName";
		$ModCoded =~ s/ /_/g; #convert spaces
			for $matcher(@members) {
				if ($matcher eq "$ModCoded.cgi") {
					$modmatch = "true";
$modline = ('$Forum' . "$ForumNumber" . 'Moderator = "' . "$ModName" . '"' . ";\n");
		push(@modarray, $modline);
				} #end if modcoded
			} #end for $matcher

	if ($modmatch ne "true") {
		$error = "true";
		$errorline = ("$errorline" .  "The moderator name \"$_\" is not a valid UserName.<br>");
	} # end if $modmatch
} # if not "none"
} # end for

if ($error ne "true") {
	open (MODS, ">$CGIPath/mods.file") || die("Unable to open Mods file.");
		print MODS (@modarray);
		print MODS ("1;\n");
	close (MODS);

## UPDATE MEMBER PROFILES FOR ALL MODERATORS

for (@GoodMods) {
	($ForumNumber, $ModName) = split(/::/, $_);
	if (($ModName ne "none") && ($ModName ne "")) {
	$ModCoded = "$ModName";
	$ModCoded =~ s/ /_/g; #convert spaces
		@modprof = &OpenProfile("$ModName.cgi");
		$Status = $modprof[8];
			&CheckStatus;
			if ($AdminStatus ne "true") {
						
				open (UPDATE, ">$MembersPath/$ModCoded.cgi");
				print UPDATE ("$modprof[0]|");
					print UPDATE ("$modprof[1]|");
					print UPDATE ("$modprof[2]|");
					print UPDATE ("$modprof[3]|");
					print UPDATE ("$modprof[4]|");
					print UPDATE ("$modprof[5]|");
					print UPDATE ("$modprof[6]|");
					print UPDATE ("$modprof[7]|");
					print UPDATE ("Moderator|");
					print UPDATE ("$modprof[9]\n");
			close (UPDATE);
			}  ## END IF madprof
	}  # END if not "none"
} # end for


## Delete Moderator status from users who are no longer Moderators

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	if ($Name =~ m/OldMod/) {
	push (@OldMods, $Value);
	}
} # end foreach $row

for $oldie(@OldMods) {
	$SaveOldie = "no";
	for $checkthis(@GoodMods) {
		($ForumNum, $TheGoodModName) = split(/::/, $checkthis);
		if ($oldie eq "$TheGoodModName") {
		$SaveOldie = "yes";
		}
	}
	if (($SaveOldie ne "yes") && ($oldie ne "none") && ($oldie ne "")) {
		$OldieFile = "$oldie";
		$OldieFile =~ s/ /_/g; #remove spaces
		@oldmod = &OpenProfile("$oldie.cgi");  #only change
			$Status = $oldmod[8];
			$TotalPosts = $oldmod[7];
			&CheckStatus;
			
			if ($AdminStatus ne "true") {
				if ($TotalPosts < $MemberMinimum) {
					$Status = "Junior Member";
				}  else {
					$Status = "Member";
				}
				###
				
				open (UPDATE, ">$MembersPath/$OldieFile.cgi");
					print UPDATE ("$oldmod[0]|");
					print UPDATE ("$oldmod[1]|");
					print UPDATE ("$oldmod[2]|");
					print UPDATE ("$oldmod[3]|");
					print UPDATE ("$oldmod[4]|");
					print UPDATE ("$oldmod[5]|");
					print UPDATE ("$oldmod[6]|");
					print UPDATE ("$oldmod[7]|");
					print UPDATE ("$Status|");
					print UPDATE ("$oldmod[9]\n");
			close (UPDATE);
		}  ## END IF ADMIN status ne true
	}

} 


$ConfirmLine = "The forum moderators have been successfully updated.";
&ConfirmHTML2;

} else {

print<<Error;
<HTML><BODY BGCOLOR="#FFFFFF" link="#000080" vlink="#808000">
<br><br><FONT Size="$TextSize" FACE="$FontFace"><B>
Sorry, we could not process the Moderator updates, due to the following error(s).
<P>
<FONT COLOR="#FF0000">$errorline</FONT>
<p>
Use your back button to go back to the Moderator page, or use the links below.
<p>
Return to: <br>
<ul>
<A HREF="$NonCGIURL/controlpanel.html">Control Panel</A><br>
<A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A>
</ul>
</B></FONT>
</BODY></HTML>
Error

}#end if/else error ne true
}  ## END DO PROCESS SR

}  # END MODS SR

sub CheckStatus {

		if ($Status =~ m/Administrator/) {
			$AdminStatus = "true";
			} else {
			$AdminStatus = "false";
		}
		

		if ($Status =~ m/Moderator/) {
			$ModStatus = "true";
		} else {
			$ModStatus = "false";
		}
		if ($Permission =~ m/Write/) {
			$AdminWrite = "true";
		} else {
			$AdminWrite = "false";
		}

} #end CheckStatus


sub ConfirmHTML2 {

$UserNameCoded = "$UserName";
$UserNameCoded =~ tr/ /+/;
$PasswordCoded = "$Password";
$PasswordCoded =~ tr/ /+/;

print<<Confirm2;
<HTML>
<HEAD>
<script language="JavaScript"> 
<!-- HIDE
var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}


function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}
//-->
</script>
</HEAD>
<BODY BGCOLOR="#FFFFFF" link="#000080" vlink="#808000">
<br><br><FONT Size="$TextSize" FACE="$FontFace"><B>
Thank you.  $ConfirmLine
<P>
Return to: <br>
<ul>
<A HREF="$NonCGIURL/controlpanel.html">Control Panel</A><br>
<ul>
<LI><A HREF="cpanel2.cgi?action=DoGenVars">Set General Variables</A>
<LI><A HREF="cpanel2.cgi?action=forums&UserName=$UserNameCoded&Password=$PasswordCoded&StartPoint=0">Set Forum Variables</a>
<LI><A HREF="cpanel.cgi?action=style">Set Style Variables</a>
<LI><A HREF="cpanel.cgi?action=setmods">Set Moderators</a>
<LI><A HREF="cpanel.cgi?action=permissions">Set User Permissions</a>
<LI><A HREF="cpanel.cgi?action=prune">Edit/Delete/Prune Messages</A>
</ul>
<A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A>
</ul>
</B></FONT>
</BODY></HTML>
Confirm2
}

sub ConfirmHTML {

$UserNameCoded = "$UserNameCheck";
$UserNameCoded =~ tr/ /+/;
$PasswordCoded = "$PasswordCheck";
$PasswordCoded =~ tr/ /+/;

print<<Confirm;
<HTML>
<HEAD>
<script language="JavaScript"> 
<!-- HIDE
var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}


function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}
//-->
</script>
</HEAD>
<BODY BGCOLOR="#FFFFFF" link="#000080" vlink="#808000">
<br><br><FONT Size="$TextSize" FACE="$FontFace"><B>
Thank you.  $ConfirmLine
<P>
Return to: <br>
<ul>
<A HREF="$NonCGIURL/controlpanel.html">Control Panel</A><br>
<ul>
<LI><A HREF="cpanel2.cgi?action=DoGenVars">Set General Variables</A>
<LI><A HREF="cpanel2.cgi?action=forums&UserName=$UserNameCoded&Password=$PasswordCoded&StartPoint=0">Set Forum Variables</a>
<LI><A HREF="cpanel.cgi?action=style">Set Style Variables</a>
<LI><A HREF="cpanel.cgi?action=setmods">Set Moderators</a>
<LI><A HREF="cpanel.cgi?action=permissions">Set User Permissions</a>
<LI><A HREF="cpanel.cgi?action=prune">Edit/Delete/Prune Messages</A>
</ul>
<A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A>
</ul>
</B></FONT>
</BODY></HTML>
Confirm
}


sub HEADERHTML {
print<<HEADER;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE

var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}

function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.THEFORM.UserNameCheck.value = getCookie("UserNameCP");
document.THEFORM.PasswordCheck.value = getCookie("PasswordCP");
	}  
}

function Check(form)  {
if ((form.Password.value == "") || (form.UserName.value == ""))  {
	alert ("You forgot to fill in the Username and/or Password fields.  These are required entries!");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<table border=0 width=95%>
<TR><TD>
<IMG SRC="$NonCGIURL/$BBTitle" BORDER=0>
</TD><td align=center>
<FONT SIZE="3" FACE="Verdana, Arial" COLOR="#000080"><B>$PageTitle</B></FONT>
</td></table>
<FONT SIZE="2" FACE="Verdana, Arial">
<CENTER><B>
<A HREF="$NonCGIURL/controlpanel.html">Control Panel</A>  |  <A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A></B>
</CENTER>
<p>
HEADER
} #end HEADERHTML sr

sub HEADER2HTML {
print<<HEADER2HTML;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE

var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}

function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.THEFORM.UserNameCheck.value = getCookie("UserNameCP");
document.THEFORM.PasswordCheck.value = getCookie("PasswordCP");
	}  
}

function Check(form)  {
if ((form.PasswordCheck.value == "") || (form.UserNameCheck.value == ""))  {
	alert ("You forgot to fill in the Username and/or Password fields.  These are required entries!");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<table border=0 width=95%>
<TR><TD>
<IMG SRC="$NonCGIURL/$BBTitle" BORDER=0>
</TD><td align=center>
<FONT SIZE="3" FACE="Verdana, Arial" COLOR="#000080"><B>$PageTitle</B></FONT>
</td></table>
<FONT SIZE="2" FACE="Verdana, Arial">
<CENTER><B>
<A HREF="$NonCGIURL/controlpanel.html">Control Panel</A>  |  <A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A></B>
</CENTER>
<p>
HEADER2HTML
} #end HEADERHTML2 sr

sub UpdateThePermissions {
foreach $row2(@in) {
	($Name, $Value) = split ("=", $row2);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
		$matchAW = $row2 =~ m/AdminWrite/;
		if ($matchAW eq "1")  {
		    ($type, $UserName) = split(/::/, $Name);
			if ($Value eq "true") {
			       $Value = "Write";
				   }  else {
				      $Value = "";
			}
			
			$changeline = ("$UserName|$Value");
			$skippush = "no";
			
			if ($arraylength > 0) {
			$arrayline = 0;
			   foreach $checker(@changes) {
			       ($this, $that) = split(/\|/, $checker);
				   
				   if ($this eq "$UserName") {
				       $skippush = "yes";
				       $changes[$arrayline] = ("$UserName|$that$Value");
					} 
					$arrayline++;
			}  # foreach checker
		} ## if array length greater than 0
		
	if ($skippush eq "no") {
		    push(@changes, $changeline);
			}
          		   
			$arraylength = @changes;
			
}  ## IF match = 1

		$matchAP = $row2 =~ m/AdminPermission/;
		if ($matchAP eq "1")  {
		    ($type, $UserName) = split(/::/, $Name);
			if ($Value eq "true") {
			       $Value = "Admin";
				   }  else {
				      $Value = "";
			}
			
			$changeline = ("$UserName|$Value");
			$skippush = "no";
			
			if ($arraylength > 0) {
			$arrayline = 0;
			   foreach $checker(@changes) {
			       ($this, $that) = split(/\|/, $checker);
				   
				   if ($this eq "$UserName") {
				       $skippush = "yes";
				       $changes[$arrayline] = ("$UserName|$that$Value");
					} 
					$arrayline++;
			}  # foreach checker
		} ## if array length greater than 0
		
	if ($skippush eq "no") {
		    push(@changes, $changeline);
			}
          		   
			$arraylength = @changes;
			
}  ## IF match = 1

	$matchDelete = $row2 =~ m/Delete/;
		if ($matchDelete eq "1")  {
		    ($type, $UserName) = split(/::/, $Name);
			if ($Value eq "yes") {
			       $Value = "Delete";
				   }  else {
				      $Value = "";
			}
			
			$changeline = ("$UserName|$Value");
			$skippush = "no";
			
			if ($arraylength > 0) {
			$arrayline = 0;
			   foreach $checker(@changes) {
			       ($this, $that) = split(/\|/, $checker);
				   
				   if ($this eq "$UserName") {
				       $skippush = "yes";
				       $changes[$arrayline] = ("$UserName|$that$Value");
					} 
					$arrayline++;
			}  # foreach checker
		} ## if array length greater than 0
		
	if ($skippush eq "no") {
		    push(@changes, $changeline);
			}
          		   
			$arraylength = @changes;
			
}  ## IF match = 1
	}  # end foreach row2

##have array of changes now
##open each profile to make changes

foreach $updatename(@changes) {
($thisname, $Permission) = split(/\|/, $updatename);
$thisNameCoded = $thisname;
$thisNameCoded =~ s/ /_/g; #remove spaces

	if ($Permission =~ m/Delete/) {
			unlink("$MembersPath/$thisNameCoded.cgi");
		}  else {
		
		@theprofile = &OpenProfile("$thisname.cgi");    
	
	$Status = "$theprofile[8]";
	
		if ($Permission =~ m/Admin/) {
			$Status = "Administrator";
		} else { 
			open (MODS, "$CGIPath/mods.file");
				@modslist = <MODS>;
			close (MODS);

			$ModsTotal = @modslist;

			for ($x = 1; $x <= $ModsTotal; $x++) {
				$GetModerator = ("Forum" . "$x" . "Moderator");
				$Moderator = $$GetModerator;
				push(@modsarray, $Moderator);
			}

			CHECKMODS: foreach (@modsarray) {
				if ($_ eq "$thisname") {
					$Status = "Moderator";
					$Modfound = "yes";
					last CHECKMODS;
				}
			}
		if ($Modfound ne "yes") {
			if ($theprofile[7] < $MemberMinimum) {
				$Status = "Junior Member";
				}  else {
					$Status = "Member";
				}
		}
	} # end if/else admin

	open (MEMBERSHIP, ">$MembersPath/$thisNameCoded.cgi") or die("Unable to open Members directory.");

	print MEMBERSHIP ("$thisname|");
	print MEMBERSHIP ("$theprofile[1]|");
	print MEMBERSHIP ("$theprofile[2]|");
	print MEMBERSHIP ("$theprofile[3]|");
	print MEMBERSHIP ("$Permission|");
	print MEMBERSHIP ("$theprofile[5]|");
	print MEMBERSHIP ("$theprofile[6]|");
	print MEMBERSHIP ("$theprofile[7]|");
	print MEMBERSHIP ("$Status|");
	print MEMBERSHIP ("$theprofile[9]\n");
close (MEMBERSHIP);
}  # END IF match del
}  ## FOREACH

$ConfirmLine = "We have made the changes you requested.";
&ConfirmHTML;

} # End UpdateThePermissions sr
