#!/usr/bin/perl

#
### PRIMARY UBB SCRIPT - FOR JAVASCRIPT-CAPABLE BROWSERS ##
#
# Ultimate Bulletin Board is copyright Prime-Web, 1997, 1998.
#
#       ------------ UltimateALT.cgi -------------
#
#  This file contains most of the functionality for the UBB... used
#  strictly by javascript-capable browsers.
#
#  Prime Web offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.prime-web.com
#
###############################################################
#
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";
use Socket;

print ("Content-type: text/html\n\n");

require "cgi-lib.pl";
require "UltBB.setup";
require "Date.pl";
require "mods.file";
require "ubb_htmlALT.pl";
require "Styles.file";
require "cookie-lib.pl";
require "ubb_library.pl";

&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
		$Name = &decodeURL($Name);
		$Value = &decodeURL($Value);
		
		if ($Name eq "forum") {
			$Forum = $Value;
			$ForumCoded = &HTMLIFY($Forum);
			$ForumCoded =~ tr/ /+/;
			$Forum = &UNHTMLIFY($Forum);
	}
		if ($Name eq "TopicSubject") {
			$TopicSubject = $Value;
			$TopicSubject =~ s/<.+?>//g;
				$TopicSubject = &UNHTMLIFY($TopicSubject);
	}
		if ($Name eq "UserName") {
			$UserName = $Value;
			$UserNameFile = $UserName;
			$UserNameFile =~ s/ /_/g; #remove spaces
	}

		if ($Name eq "PasswordConfirm") {
			$PasswordConfirm = $Value;
		}

		if ($Name eq "number") {
			$number = $Value;
	}
		if ($Name eq "DaysPrune") {
			$DaysPrune = $Value;
	}
	if ($Name eq "topic") {
			$topic = $Value;
	}
	if ($Name eq "Browser") {
			$Browser = $Value;
	}
	if ($Name eq "Email") {
			$Email = $Value;
			$Email =~tr/A-Z/a-z/; 
	}
	if ($Name eq "URL") {
			$URL = $Value;
	}
	if ($Name eq "Permissions") {
			$Permissions = $Value;
	}
	if ($Name eq "Occupation") {
			$Occupation = $Value;
	}
	if ($Name eq "Location") {
			$Location = $Value;
	}
	if ($Name eq "TotalPosts") {
			$TotalPosts = $Value;
	}
	if ($Name eq "Status") {
			$Status = $Value;
	}
	if ($Name eq "Interests") {
			$Interests = $Value;
	}
	if ($Name eq "sendto") {
			$sendto = $Value;
	}
}  # end FOREACH $row


$ReplyMessage = $in{'ReplyMessage'};
$Message = $in{'Message'};

@censored = split(/ /, $censorwords);

if ($Censor eq "ON") {
	for (@censored) {
		if (m/({)(.*)(})/) {
			$_ = ("$2 ");
			$wordlength = length($_);
			$wordlength = $wordlength - 1;
			$replaceword = "*" x $wordlength;
			$replaceword = "$replaceword ";
		}  else {
		$wordlength = length($_);
		$replaceword = "*" x $wordlength;
		}
		$TopicSubject =~ s/$_/$replaceword/isg;
	}
}
		$SubjectCoded = &HTMLIFY($TopicSubject);
		$SubjectCoded =~ tr/ /+/;
		

if (@in == 0) {
&Intro;
}
 
if ($in{'action'} eq "intro") {
 &Intro;
 }  

if ($in{'action'} eq "topics") {
 &Topics;
 }  

if ($in{'action'} eq "agree") {
 &Agree;
 } 
if ($in{'action'} eq "threadlist") {
 &Threadlist;
 }  
 
if ($in{'action'} eq "closethread") {
 &CloseThread;
 }  

if ($in{'action'} eq "processclose") {
 &ProcessClose;
 }  
if ($in{'action'} eq "reply") {
 &Reply;
 }  

if ($in{'action'} eq "postreply") {
 &PostReply;
 }  
 
if ($in{'action'} eq "newtopic") {
 &NewTopic;
 }  
 
if ($in{'action'} eq "posttopic") {
 &PostTopic;
 }  
 
if ($in{'action'} eq "getbio") {
 &GetBio;
 } 
 
if ($in{'action'} eq "editbio") {
 &EditBio;
 } 

if ($in{'action'} eq "checkbioid") {
&CheckBioID;
 } 
 
if ($in{'action'} eq "modifybio") {
   &ModifyBio;
 }  
 
if ($in{'action'} eq "register") {
   &Register;
 }  
 if ($in{'action'} eq "RegSubmit") {
 &RegSubmit;
 }
 if ($in{'action'} eq "faq") {
 &FAQ;
 }
 
if ($in{'action'} eq "rules") {
 &Rules;
 }  
 
if ($in{'action'} eq "lostpw") {
	if ($UseEmail eq "ON") {
 &LostPW;
 }  else {
 &EmailDisabled;
 }
 }  
 
if ($in{'action'} eq "pwrequest") {
 &PWRequest;
 } 
  
if ($in{'action'} eq "editpost") {
 &EditPost;
 } 
 
if ($in{'action'} eq "submitedit") {
 &SubmitEdit;
 } 

sub Intro {

&ForumsTopHTML;

open (FORUMFILE, "$CGIPath/forums.cgi");
	@forums = <FORUMFILE>;
close (FORUMFILE);
if ($CategoryView eq "yes") {
@sortforums = sort(@forums); #sorts forums by category
}  else  {
@sortforums = @forums;
}
$forumcategory = "";

for (@sortforums) {
@thisforuminfo = split(/\|/, $_);
chomp($thisforuminfo[8]);
$x = "$thisforuminfo[8]";

if ($CategoryView eq "yes") {
$thisforumcategory = &decodeURL($thisforuminfo[0]);
if ($thisforumcategory ne "$forumcategory") {
print<<CategoryHeader;
<TR bgcolor="$CategoryStripColor"><TD colspan=4>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor"><B> $thisforumcategory</B></FONT>
</td></tr>
CategoryHeader
}
$forumcategory = "$thisforumcategory";
} # end if categoryview eq yes


opendir (FORUMDIR, "$ForumsPath/Forum$x"); 
    @files = readdir(FORUMDIR);
closedir (FORUMDIR);

 @datesummary = "";
 @GetLastTime = "";
 @Times = "";
 
@sortedfiles = sort(@files);
@sortedfiles = grep(/msg/, @sortedfiles);
$numberOfPosts = grep(/msg/, @sortedfiles);
if ($numberOfPosts eq "") {
	$numberOfPosts = "0";
	}

if ($numberOfPosts > 0) {

foreach $checkdate(@sortedfiles) {
($postStuff, $Trash) = split (/\./, $checkdate);
($Trash2, $Trash3, $LastDate, $Trash4) = split ("-", $postStuff);

## we need to move year up front for ordering purposes

$LastYear = substr($LastDate, 4, 2);

#resolve year 2000 problem
if ($LastYear > 96) {
	$LastYear = ("19". "$LastYear");
	}  else {
	$LastYear = ("20" . "$LastYear");
	}

$LastRest = substr($LastDate, 0, 4);
$LastDate = ("$LastYear" . "$LastRest");
push (@datesummary, $LastDate);
}

@sortdates = sort(@datesummary);
@sortdates = reverse(@sortdates);
$LatestDate = $sortdates[0];
$MoDate = substr($LatestDate, 4, 4);
$ChopYear = substr($$LatestDate, 2, 2);
$ChopDate = ("$MoDate" . "$ChopYear");

#find latest time (from amongst messages posted on latest date)
for (@sortedfiles) {
	if ($_ =~ m/000000-$ChopDate/) {
		push (@GetLastTime, $_);
	}
}

for (@GetLastTime) {
&PullTimes;
		push (@Times, $MilitaryTime);
}
	@Times = sort(@Times);
	@Times = reverse(@Times);
	$LatestMilTime = $Times[0];
	($milhour, $milmin) = split(/:/, $LatestMilTime);
	$hour = "$milhour";
	$min = "$milmin";
$hour = sprintf ("%2d", $hour);
$hour =~tr/ /0/;
$min = sprintf ("%2d", $min);
$min =~tr/ /0/;

if ($TimeFormat eq "24HR") {
	$LatestTime = "$hour:$min";
} 
	&NormalTime;
	if ($TimeFormat eq "AMPM") {
		$LatestTime = ("$hour" . ":" . "$min" . " $AMPM");
	}
	


$Year = substr($LatestDate, 2, 2);
$Month = substr($LatestDate, 4, 2);
$Day = substr($LatestDate, 6, 2);
if ($DateFormat eq "Euro") {
$TheDate = "$Day-$Month-$Year";
$DateWording = "All dates are in Day-Month-Year format.";
}  else {
$TheDate = "$Month-$Day-$Year";
$DateWording = "All dates are in Month-Day-Year format.";
}
}  else {
$Month = "";
$Day = "";
$Year = "";
$LatestTime = "";
$TheDate = "";
}

@thisforum = &GetForumRecord($x);

$ForumName = $thisforum[1];
$Moderator = ("Forum" . "$x" . "Moderator");
$Moderator = $$Moderator;
$ForumDesc = $thisforum[2];
$OnOff = $thisforum[3];
chomp($OnOff);

$ForumCoded = &HTMLIFY($ForumName);
$ForumCoded =~ tr/ /+/;
$ForumDesc =~ s/&quot;/"/g;

if ($ForumDescriptions eq "no") {
	$ForumDesc = "";
}


if ($OnOff eq "On") {
&ForumsGutsHTML;
} ## End IF ONOFF Conditional
}

&ForumsBottomHTML;
}  #END INTRO SR ###



sub Topics {
if ($number ne "NONE") {

if ($DaysPrune == 1) {
	$Days1 = "SELECTED";
}

if ($DaysPrune == 2) {
	$Days2 = "SELECTED";
}

if ($DaysPrune == 5) {
	$Days5 = "SELECTED";
}

if ($DaysPrune == 10) {
	$Days10 = "SELECTED";
}

if ($DaysPrune == 20) {
	$Days20 = "SELECTED";
}

if ($DaysPrune == 30) {
	$Days30 = "SELECTED";
}

if ($DaysPrune == 45) {
	$Days45 = "SELECTED";
}

if ($DaysPrune == 60) {
	$Days60 = "SELECTED";
}

if ($DaysPrune == 75) {
	$Days75 = "SELECTED";
}

if ($DaysPrune == 100) {
	$Days100 = "SELECTED";
}

if ($DaysPrune == 365) {
	$Days365 = "SELECTED";
}

@thisforum = &GetForumRecord($number);


$Moderator = ("Forum" . "$number" . "Moderator");
$Moderator = $$Moderator;
$Forum = $thisforum[1];

$ForumCoded = &HTMLIFY($Forum);
$ForumCoded =~ tr/ /+/;

@theprofile = &OpenProfile("$Moderator.cgi");
	
$ModeratorEmail = "$theprofile[2]";

&TopicTopHTML;

&TopicMidNonIEhtml;

#get Forum Messages
opendir (FORUMDIR, "$ForumsPath/Forum$number"); 
    @forummsgs = readdir(FORUMDIR);
closedir (FORUMDIR);


foreach $message(@forummsgs) {
$MessageNumber = substr($message, 0, 6);
$MessageReply = substr($message, 7, 6);
$DateOfMessage = substr($message, 14, 6);
	if ($MessageReply eq "000000") {
				push (@topicarray, $message);
	}
}

## do date pruning 

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime (time);


if ($year > 96)  {
	$year = ("19" . "$year");
	} else  {
		$year = ("20" . "$year");
	}

#convert Closing and Current Dates to Julian Dates
$CurrentJulian = &jday($mon, $mday, $year);
$CloseJulian = $CurrentJulian - $DaysPrune;

#configure memo date to Julian
foreach $item(@topicarray) {
	
$MonthOfMessage = substr($item, 14, 2);
$DayOfMessage = substr($item, 16, 2);
$YearOfMessage = substr($item, 18, 2);

if ($YearOfMessage > 96)  {
	$YearOfMessage = ("19" . "$YearOfMessage");
	} else  {
		$YearOfMessage = ("20" . "$YearOfMessage");
	}
	$MonthOfMessage = $MonthOfMessage - 1;
	$CheckJulian = &jday($MonthOfMessage, $DayOfMessage, $YearOfMessage);
		
	if ($CheckJulian >= $CloseJulian) {
		push (@finalarray, $item);
	}  
} #end FOREACH $item
############################################

$x = $number;

for (@finalarray) {
&PullTimes;
$TheYear = substr($DaterMatch, 4, 2);
$TheRest = substr($DaterMatch, 0, 4);

if ($TheYear > 96)  {
	$TheYear = ("19" . "$TheYear");
	} else  {
		$TheYear = ("20" . "$TheYear");
	}
$FullDTSort = ("$TheYear" . "$TheRest" . "$hour" . "$min");
$SortString = ("$FullDTSort" . "|" . "$_");
		
		push (@sortedthat, $SortString);
}
	@sortedthis = sort(@sortedthat);
	@sortedthis = reverse(@sortedthis);
	
	for (@sortedthis) {
	($TimeInfo, $topic) = split(/\|/, $_);
	$JYear = substr($TimeInfo, 0, 4);
	$Year = substr($TimeInfo, 2, 2);
	$Month = substr($TimeInfo, 4, 2);
	$Day = substr($TimeInfo, 6, 2);
	$hour = substr($TimeInfo, 8, 2);
	$min = substr($TimeInfo, 10, 2);
	$Replies = substr($topic, 21, 6);
	$RepliesFormat = $Replies + 0;
	
	
	$JMonth = ($Month - 1);
	
	
	#format date
	if ($DateFormat eq "Euro") {
	$TheDate = "$Day-$Month-$Year";
	$DateWording = "All dates are in Day-Month-Year format.";
	}  else {
	$TheDate = "$Month-$Day-$Year";
	$DateWording = "All dates are in Month-Day-Year format.";
	}
open (THETOPIC, "$ForumsPath/Forum$number/$topic");
	@stuff = <THETOPIC>;
close (THETOPIC);

$author = "$stuff[0]";
$subject = "$stuff[3]";
chomp($author);
chomp($subject);

#$TopicJulian = &jday($JMonth, $Day, $JYear);
#$JTime = ("$hour" . "$min");
#$TopicJulian = ($TopicJulian + ($JTime * 0.0001));

#format time option 1
	if ($TimeFormat eq "24HR")  {
		$FormatTime = "$hour:$min";
	}
	&NormalTime;

#format time option 2
	if ($TimeFormat eq "AMPM")  {
		$FormatTime = "$hour:$min $AMPM";
	}

	if ($topic =~ /X/) {
		$FolderIcon = "<IMG SRC=\"$NonCGIURL/yellockfolder.gif\" WIDTH=14 HEIGHT=15 BORDER=0>";
	}  else {
	$FolderIcon = "<IMG SRC=\"$NonCGIURL/closed.gif\" WIDTH=14 HEIGHT=11 BORDER=0>";
	$NewThreadPosts = "no";
	}


################################################
&TopicGutsNonIEhtml;

}

&TopicBottomNonIEhtml;
&GetForumSelectList;
&TopicBottom2NonIEhtml;


} else {
print <<Confirm;
<HTML>
<HEAD>
<meta http-equiv="Refresh" content="3; URL=UltimateALT.cgi">
</HEAD>
 <BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<br><br>
<ul><FONT SIZE="$TextSize" FACE="$FontFace">
<B>You failed to select a valid forum.  You may have selected a forum category, rather than a specific forum.  We are thus taking you back automatically to the overall forum list.  Please wait two seconds.
</B><br><br>

</FONT>
</ul></body></html>
Confirm

} #end if/else number eq NONE
}  ## END TOPICS SR ####



sub Threadlist {

$TopicNumber = substr($topic, 0, 13);
&GrabTopic;

open (GETTOPIC, "$ForumsPath/Forum$number/$TopicFile");
	@topicguts = <GETTOPIC>;
close (GETTOPIC);

$UNCoded = $topicguts[0];
$UNCoded =~ tr/ /+/;
$TopicSubject = $topicguts[3];
	$SubjectCoded = &HTMLIFY($TopicSubject);
			$SubjectCoded =~ tr/ /+/;
			
# Check to see if this thread has been closed...
	if ($TopicFile =~ m/X/) {
	$ThisThreadClosed = "<IMG SRC=\"$NonCGIURL/lock.gif\" WIDTH=9 HEIGHT=11 BORDER=0 ALT=\"Thread Closed\">&nbsp;&nbsp;Thread Closed";
		$CloseOption = "";
		$ReplyButton = "<IMG SRC=\"$NonCGIURL/$ThreadClosed\" BORDER=0>";
	}  else {
		$ThisThreadClosed = "";
		$CloseOption = "<CENTER><FONT SIZE=\"1\" FACE=\"$FontFace\"><IMG SRC=\"$NonCGIURL/lock.gif\" WIDTH=9 HEIGHT=11 BORDER=0 ALT=\"Thread Closed\"> To close this thread, <A HREF=\"UltimateALT.cgi?action=closethread&topic=$topic&TopicSubject=$SubjectCoded&number=$number&Browser=other&DaysPrune=$DaysPrune&forum=$ForumCoded\">click here</A> (moderator or admin only).<br></FONT></CENTER><BR>";
$ReplyButton = "<IMG SRC=\"$NonCGIURL/$BBReply\" BORDER=0 ALT=\"Post A Reply\">";
	}

&ThreadTopHTML;
	
chomp ($topicguts[1]);
chomp ($topicguts[2]);
chomp ($topicguts[5]);

## determine JulianTime for post,
## first post that is older than LastLoginJulian
## receives A NAME tag

$NameTag = "";
$NameFinish = "";

$theDate = "$topicguts[1]";
#format date
if ($DateFormat eq "Euro") {
@datearray = split(/-/, $topicguts[1]);
chomp($datearray[2]);
$ThisDate = "$datearray[1]-$datearray[0]-$datearray[2]";
}  else {
$ThisDate = "$topicguts[1]";
}
$theTime = "$topicguts[2]";
#format time option 1
	if ($TimeFormat eq "24HR")  {
		@timearray = split(/ /, $topicguts[2]);
		chomp($timearray[1]);
		($gethour, $getmin) = split(/:/, $timearray[0]);
		
		if ($timearray[1] eq "PM") {		
		if ($gethour < 12) {
			$gethour = ($gethour  + 12);
		}
	}
	if ($AMpm eq "AM") {		
		if ($gethour == 12) {
			$gethour = "0";
		}
	}
	$gethour = sprintf ("%2d", $gethour);
	$gethour =~tr/ /0/;
	$getmin = sprintf ("%2d", $getmin);
	$getmin =~tr/ /0/;
	
		$FormatTime = "$gethour:$getmin";
	} else {
		$FormatTime = "$topicguts[2]";
	}




	$PostFolder = "$NonCGIURL/closed.gif";


&ThreadGutsNonIEhtml;

#get Replies to this topic
opendir (FORUMDIR, "$ForumsPath/Forum$number"); 
    @forummsgs = readdir(FORUMDIR);
closedir (FORUMDIR);

$ThisTopicNumber = substr($topic, 0,6);

#sort to find all replies to this topic

foreach $msg(@forummsgs) {
	$TopicNumber = substr($msg, 0, 6);
	if ($TopicNumber eq "$ThisTopicNumber") {
		$ReplyNumber = substr($msg, 7, 6);
		if ($ReplyNumber > 0) {
			push  (@replyarray, $msg);
		}
	}
}
@replyarray = sort(@replyarray);

#### @replyarray holds all replies to the topic in question

$AlternateColor = "$AltColumnColor2";

foreach $matchreply(@replyarray) {
	open (REPLY, "$ForumsPath/Forum$number/$matchreply");
		@replyguts = <REPLY>;
	close (REPLY);
	
$UserNameCoded = $replyguts[0];
$UserNameCoded =~ tr/ /+/;
			
chomp ($replyguts[1]);
chomp ($replyguts[2]);
chomp ($replyguts[5]);

## determine JulianTime for post,
## first post that is older than LastLoginJulian

$NameTag = "";
$NameFinish = "";

$theDate = "$replyguts[1]";

#format date
if ($DateFormat eq "Euro") {
@datearray = split(/-/, $replyguts[1]);
chomp($datearray[2]);
$ThisDate = "$datearray[1]-$datearray[0]-$datearray[2]";
}  else {
$ThisDate = "$replyguts[1]";
}
#format time option 1
	if ($TimeFormat eq "24HR")  {
		@timearray = split(/ /, $replyguts[2]);
		chomp($timearray[1]);
		($gethour, $getmin) = split(/:/, $timearray[0]);
		
		if ($timearray[1] eq "PM") {		
		if ($gethour < 12) {
			$gethour = ($gethour  + 12);
		}
	}
	if ($AMpm eq "AM") {		
		if ($gethour == 12) {
			$gethour = "0";
		}
	}
	$gethour = sprintf ("%2d", $gethour);
	$gethour =~tr/ /0/;
	$getmin = sprintf ("%2d", $getmin);
	$getmin =~tr/ /0/;
	
		$FormatTime = "$gethour:$getmin";
	} else {
		$FormatTime = "$replyguts[2]";
	}
$theTime = "$replyguts[2]";
$JulianPost = &ConvertToJulian;
$PostFolder = "$NonCGIURL/closed.gif";

&ThreadRepliesNonIEhtml;

#rotate thru alt colors
if ($AlternateColor eq "$AltColumnColor1") {
	$AlternateColor = "$AltColumnColor2";
	}  else {
	$AlternateColor = "$AltColumnColor1";
	}
}

&ThreadBottomNonIEhtml;
&GetForumSelectList;
&ThreadBottom2NonIEhtml;


} #END THREADLIST SR ####


sub Reply {
#verify that topic number exists
opendir (FORUMFILE, "$ForumsPath/Forum$number");
	@forums = readdir(FORUMFILE);
close (FORUMFILE);
	@forums = grep(/msg/, @forums);
$Found = "no";
$ThreadStart = substr($topic, 0, 13);
	foreach (@forums) {
		if ($_ =~ /$ThreadStart/) {
			$Found = "yes";
			$TopicFile = "$_";
		}
	}


if ($Found eq "yes") {
	

# if thread is closed, say so
if ($TopicFile =~ /X/) {
&ThreadClosedHTML;
}  else {

@thisforum = &GetForumRecord($number);
  
if ($thisforum[4] eq "is") {
	$ISHTML = "*HTML is ON";
	$HTMLAllowed = "yes";
}  else {
	$ISHTML = "*HTML is OFF";
	$HTMLAllowed = "no";
}
 
if ($thisforum[5] eq "is") {
	$ISUBB = "*UBB Code is ON";
	$UBBAllowed = "yes";
}  else {
	$ISUBB = "*UBB Code is OFF";
	$UBBAllowed = "no";
}
#check to see if this forum is Limited Write Access-----
if ($thisforum[6] eq "yes") {
	&ReplyFormLWAHTML;
	} else {
		&ReplyFormHTML;
}

&GenerateThread;
&ReplyFormBottom;
} #end if/else thread closed
}  else {
	&FaultyTopicNumber;
} #end if/else topic number verification
}  ## END Reply SR #####


sub PostReply {
## Verify form input
if (($in{'UserName'} eq "") || ($in{'Password'} eq "") || ($in{'ReplyMessage'} eq "")) {
	&MissingFields;
	}  else {
	
## See if this is an LWA Forum
if ($in{'LWAForum'} eq "yes") {
@thisforum = &GetForumRecord($number);
$ValidPassword = &decodeURL($thisforum[7]);
chomp($ValidPassword);
&GetMemberListArray;
$NameFound = "no";
foreach $check(@members) {
   if ($check eq "$UserNameFile.cgi") {
      $NameFound = "yes";
    } 
}  # END FOREACH CHECK
if ($NameFound eq "yes") {
	@theprofile = &OpenProfile("$UserName.cgi");
	if ($in{'Password'} eq "$theprofile[1]") {
		$Permission = "$theprofile[4]";
		$Status = $theprofile[8];
		$ForumPassword = &decodeURL($in{'ForumPassword'});
		&CheckTheStatus;
		&CheckPermissions;
	   	if (($AdminPermission eq "true") || ($ModStatus eq "true")) {
	   &DoPostTheReply;
	   }
	   elsif ($ForumPassword eq "$ValidPassword") {
	   &DoPostTheReply;
	   }  else {
	   &DontProcessLWA;
	   }
	} else {
	&WrongPassword;
	}
}  else {
&WrongUserName;
}  ##END IF/ELSE NAME CHECK BLOCK
} else {
	   &DoPostTheReply;
}#end if/else LWA = yes
} # end if/else missing fields
}  ## END Post Reply SR



sub DoPostTheReply {
##get current date/time
&GetDateTime;
##verify user name/password
$match = "no";
$verified = "false";

opendir (MEMBERDIR, "$MembersPath"); 
    @members = readdir(MEMBERDIR);
closedir (MEMBERDIR);

$UserNameFile = $UserName;
$UserNameFile =~ s/ /_/g; #remove spaces

CHECKPROFILES: foreach $member(@members) {
	if ($member eq "$UserNameFile.cgi") {
		$match = "yes";
		
		open (CHECKPROFILE, "$MembersPath/$UserNameFile.cgi");
			@profile = <CHECKPROFILE>;
		close (CHECKPROFILE);
		
	@profilestats = split (/\|/, $profile[0]);
	
		if ($profilestats[1] eq "$in{'Password'}") {
				$verified = "true";
				$Email = "$profilestats[2]";
				$UserName = "$profilestats[0]";
				$TotalPosts = "$profilestats[7]";
				$Permission = "$profilestats[4]";
				$Password = "$profilestats[1]";
				$URL = "$profilestats[3]"; 
				$Occupation = "$profilestats[5]";
				$Location = "$profilestats[6]";
				$Status = "$profilestats[8]";
				$Interests = "$profilestats[9]";
			last CHECKPROFILES;
		}  #END IF profilestats
	
	} #END IF $MEMBER
		
}  #end FOREACH $member

&CheckPermissions;

if ($match eq "no") {
&NoMatch
}

if ($match eq "yes" && $verified eq "false") {
&WrongPassword;
}

if ($match eq "yes" && $verified eq "true") {
   if ($PermissionToWrite eq "true") {

##create filenumber for reply based on father message

## recheck topic number, in case someone
## posted reply while user was typing
$TopicNumber = substr($topic, 0, 13);
&GrabTopic;
####

($father, $replynum, $dater, $replytotal) = split(/\-/, $TopicFile);

($junk, $Extension) = split(/\./, $replytotal);
chomp($Extension);

$replytotal = substr($replytotal, 0, 6);
$oldreplytotal = $replytotal;
$oldreplytotal++;
$newreplynum = sprintf("%6d", $oldreplytotal);
$newreplynum =~tr/ /0/;
$father = sprintf("%6d", $father);
$father =~tr/ /0/;
$ReplyFile = ("$father" . "-" . "$newreplynum" . "-" . "$RunonDate" . "-" . "000000.msg");

#now we have to add the message to the forum directory

## IF HTML is not allowed, render HTML useless
if ($in{'HTMLAllowed'} eq "no") {
		$ReplyMessage =~ s/</&lt;/g;
		$ReplyMessage =~ s/>/&gt;/g;
 }
 
if ($Censor eq "ON") {
	for (@censored) {
		if (m/({)(.*)(})/) {
			$_ = ("$2 ");
			$wordlength = length($_);
			$wordlength = $wordlength - 1;
			$replaceword = "*" x $wordlength;
			$replaceword = "$replaceword ";
		}  else {
		$wordlength = length($_);
		$replaceword = "*" x $wordlength;
		}
		$ReplyMessage =~ s/$_/$replaceword/isg;
	}
}

#convert newlines/carriage returns to HTML
$ReplyMessage =~ s/\n\r\n/<p>/g;
$ReplyMessage =~ s/\n/<br>/g;

#UBB Code-ify (if allowed)
if ($in{'UBBAllowed'} eq "yes") {
$ReplyMessage =~ s/(\[URL\])(http:\/\/\S+)(\[\/URL\])/ <A HREF="$2" TARGET=_blank>$2<\/A> /isg;

$ReplyMessage =~ s/(\[URL\])(\S+)(\[\/URL\])/ <A HREF="http:\/\/$2" TARGET=_blank>$2<\/A> /isg;

$ReplyMessage =~ s/(\[EMAIL\])(\S+\@\S+)(\[\/EMAIL\])/ <A HREF="mailto:$2">$2<\/A> /isg;

$ReplyMessage =~ s/(\[IMG\])(\S+)(\[\/IMG\])/ <IMG SRC="$2"> /isg;

$ReplyMessage =~ s/(\[QUOTE\])(.+?)(\[\/QUOTE\])/ <BLOCKQUOTE><font size="1" face="$FontFace">quote:<\/font><HR>$2<HR><\/BLOCKQUOTE>/isg;
} #END UBB CODE 

&Lock ("lock.file");
open (THISFILE, ">$ForumsPath/Forum$number/$ReplyFile");
print THISFILE ("$UserName\n");
print THISFILE ("$HyphenDate\n");
print THISFILE ("$Time\n");
print THISFILE ("$TopicSubject\n");
print THISFILE ("$Email\n");
print THISFILE ("$ReplyMessage\n");
close (THISFILE);

## Amend father message to reflect new reply
$newFileName = "$father-000000-$RunonDate-$newreplynum.$Extension";

### can't use rename for certain NT systems, thus, here's the fix:
open (THISFILE, "$ForumsPath/Forum$number/$TopicFile");
@topicstuff = <THISFILE>;
close(THISFILE);


open (RENAME, ">$ForumsPath/Forum$number/$newFileName");
for $line(@topicstuff) {
chomp($line);
print RENAME "$line\n";
}
close(RENAME);


unlink ("$ForumsPath/Forum$number/$TopicFile");
### END NEW RENAME ALTERNATIVE SECTION
#OLD RENAME PROCESS (Much easier, but NT doesn't fully support...)
#rename ("$ForumsPath/Forum$number/$TopicFile", #"$ForumsPath/Forum$number/$newFileName");


$UserInfo = ("$UserName" . "|$in{'Password'}");

##Add reply to user's profile (total posts)
$TotalPosts++;
#Bump user up to Member if Total Posts reaches $MemberMinimum
if (($TotalPosts == $MemberMinimum)  && ($Status eq "Junior Member")) {
$Status = "Member";
}
open (MEMBERSHIP, ">$MembersPath/$UserNameFile.cgi") or die("Unable to open Members directory.");

	print MEMBERSHIP ("$UserName|");
	print MEMBERSHIP ("$Password|");
	print MEMBERSHIP ("$Email|");
	print MEMBERSHIP ("$URL|");
	print MEMBERSHIP ("$Permission|");
	print MEMBERSHIP ("$Occupation|");
	print MEMBERSHIP ("$Location|");
	print MEMBERSHIP ("$TotalPosts|");
	print MEMBERSHIP ("$Status|");
	print MEMBERSHIP ("$Interests\n");
close (MEMBERSHIP);

## IF TOPIC SET TO NOTIFY, THEN WE NEED TO GENERATE AN
## EMAIL MESSAGE TO SEND TO THE AUTHOR OF THE TOPIC

if ($Extension eq "nmsg") {

$sendto = $topicstuff[4];
chomp($sendto);
$subject = "Notification: Reply to Your BB Topic";
$message = "Hello, \n\r\n $UserName has just replied to your topic entitled '$TopicSubject' in the $Forum forum of $BBName. \n\r\n This BB is located at $CGIURL/Ultimate.cgi";

&SendEmail;
}  # end if extension = nmsg


&ReplyConfirmHTML;

} else {

&PermissionDeniedHTML;

} #END Check Permission block
}  ## END match yes and verified true block
} # end Do Post The Reply


sub NewTopic {
@thisforum = &GetForumRecord($number);
  
if ($thisforum[4] eq "is") {
	$ISHTML = "*HTML is ON";
	$HTMLAllowed = "yes";
}  else {
	$ISHTML = "*HTML is OFF";
	$HTMLAllowed = "no";
}
 
if ($thisforum[5] eq "is") {
	$ISUBB = "*UBB Code is ON";
	$UBBAllowed = "yes";
}  else {
	$ISUBB = "*UBB Code is OFF";
	$UBBAllowed = "no";
}

## if email is enabled, show notification wording

	if ($UseEmail eq "ON") {
	$EmailNotificationHTML = "<CENTER><FONT FACE=\"$FontFace\" SIZE=\"$TextSize\" COLOR=\"$LinkColor\"><INPUT TYPE=\"CHECKBOX\" NAME=\"EmailNotification\" VALUE=\"yes\">Check here to be notified by email whenever someone replies to your topic.</FONT></CENTER>";
	}  else {
	$EmailNotificationHTML = "";
	}


#check to see if this forum is Limited Write Access-----
if ($thisforum[6] eq "yes") {
	&TopicFormLWAHTML;
	} else {
		&TopicFormHTML;
}
}  ## END NEWTOPIC SR ##

sub PostTopic {
## Verify form input
if (($in{'UserName'} eq "") || ($in{'Password'} eq "") || ($in{'TopicSubject'} eq "") || ($in{'Message'} eq "")) {
	&MissingFields;
	}  else {
	
## See if this is an LWA Forum
if ($in{'LWAForum'} eq "yes") {
@thisforum = &GetForumRecord($number);
$ValidPassword = &decodeURL($thisforum[7]);
chomp($ValidPassword);
&GetMemberListArray;
$NameFound = "no";
foreach $check(@members) {
   if ($check eq "$UserNameFile.cgi") {
      $NameFound = "yes";
    } 
}  # END FOREACH CHECK
if ($NameFound eq "yes") {
	@theprofile = &OpenProfile("$UserName.cgi");
	if ($in{'Password'} eq "$theprofile[1]") {
		$Permission = "$theprofile[4]";
		$Status = $theprofile[8];
		$ForumPassword = &decodeURL($in{'ForumPassword'});
		&CheckTheStatus;
		&CheckPermissions;
	   	if (($AdminPermission eq "true") || ($ModStatus eq "true")) {
	   &DoPostTheTopic;
	   }
	   elsif ($ForumPassword eq "$ValidPassword") {
	   &DoPostTheTopic;
	   }  else {
	   &DontProcessLWA;
	   }
	} else {
	&WrongPassword;
	}
}  else {
&WrongUserName;
}  ##END IF/ELSE NAME CHECK BLOCK
} else {
	   &DoPostTheTopic;
}#end if/else LWA = yes
} #end if/else field check
}  ## END POST TOPIC SR ###

sub DoPostTheTopic {

##get current date/time

&GetDateTime;

##verify user name/password
$match = "no";
$verified = "false";

&GetMemberListArray; #returns @members

$UserNameFile = $UserName;
$UserNameFile =~ s/ /_/g; #remove spaces

GETUSER: foreach $member2(@members) {
	if ($member2 eq "$UserNameFile.cgi") {
		$match = "yes";
		
		open (CHECKPROFILE2, "$MembersPath/$UserNameFile.cgi");
			@profile2 = <CHECKPROFILE2>;
		close (CHECKPROFILE2);
		
	@profilestats2 = split (/\|/, $profile2[0]);
	
		if ($profilestats2[1] eq "$in{'Password'}") {
				$verified = "true";
				$Location = "$profilestats2[6]";
				$Occupation = "$profilestats2[5]";
				$Email = "$profilestats2[2]";
				$Status = "$profilestats2[8]";
				$TotalPosts = "$profilestats2[7]";
				$Interests = "$profilestats2[9]";
				$URL = "$profilestats2[3]";
				$Permission = "$profilestats2[4]";
			last GETUSER;
		}  #END IF profilestats
	
	} #END IF $MEMBER
		
}  #end FOREACH $member


&CheckPermissions;

if ($match eq "no") {
&NoMatch
}

if ($match eq "yes" && $verified eq "false") {
&WrongPassword;
}

if ($match eq "yes" && $verified eq "true") {

if ($PermissionToWrite eq "true") {
##determine last topic number and increment by 1

opendir (FORUMCOUNT, "$ForumsPath/Forum$number"); 
    @forumcounter = readdir(FORUMCOUNT);
closedir (FORUMCOUNT);

#make sure we are only sorting  msg files
@forumcounter = grep(/msg/, @forumcounter);
$count = @forumcounter;

if ($in{'EmailNotification'} eq "yes") {
	$Extension = "nmsg";
}  else {
	$Extension = "msg";
}

if ($count > 0) {
@sortedforum = sort(@forumcounter);
@sortedforum = reverse(@sortedforum);
$lasttopic = $sortedforum[0];
($lastnumber, $trash, $trash2, $trash3) = split("-", $lasttopic);
$lasttopic++;
$newtopic = sprintf("%6d", $lasttopic);
$newtopic =~tr/ /0/;

##create filenumber for new topic
$newtopicfile = ("$newtopic-000000-$RunonDate-000000.$Extension");
}  else {
$newtopicfile = ("000000-000000-$RunonDate-000000.$Extension");
}
#now we have to add the message to the forum directory

## IF HTML is not allowed, render HTML useless
if ($in{'HTMLAllowed'} eq "no") {
		$Message =~ s/</&lt;/g;
		$Message =~ s/>/&gt;/g;
    }
	

if ($Censor eq "ON") {
	for (@censored) {
		if (m/({)(.*)(})/) {
			$_ = ("$2 ");
			$wordlength = length($_);
			$wordlength = $wordlength - 1;
			$replaceword = "*" x $wordlength;
			$replaceword = "$replaceword ";
		}  else {
		$wordlength = length($_);
		$replaceword = "*" x $wordlength;
		}
		$Message =~ s/$_/$replaceword/isg;
	}
}
#convert newlines/carriage returns to <br> and <p> html tags
	$Message =~ s/\n\r\n/<p>/g;
	$Message =~ s/\n/<br>/g;
	
#UBB Code-ify (if allowed)
if ($in{'UBBAllowed'} eq "yes") {
$Message =~ s/(\[URL\])(http:\/\/\S+)(\[\/URL\])/ <A HREF="$2" TARGET=_blank>$2<\/A> /isg;

$Message =~ s/(\[URL\])(\S+)(\[\/URL\])/ <A HREF="http:\/\/$2" TARGET=_blank>$2<\/A> /isg;

$Message =~ s/(\[EMAIL\])(\S+\@\S+)(\[\/EMAIL\])/ <A HREF="mailto:$2">$2<\/A> /isg;

$Message =~ s/(\[IMG\])(\S+)(\[\/IMG\])/ <IMG SRC="$2"> /isg;
$Message =~ s/(\[QUOTE\])(.+?)(\[\/QUOTE\])/ <BLOCKQUOTE><font size="1" face="$FontFace">quote:<\/font><HR>$2<HR><\/BLOCKQUOTE>/isg;
} #end if UBB Code allowed


&Lock ("lock.file");
open (FORUM, ">$ForumsPath/Forum$number/$newtopicfile"); 
print FORUM ("$UserName\n");
print FORUM ("$HyphenDate\n");
print FORUM ("$Time\n");
print FORUM ("$TopicSubject\n");
print FORUM ("$Email\n");
print FORUM ("$Message\n");
close (FORUM);
&Unlock ("lock.file");

&TopicConfirmHTML;


##Add reply to user's profile (total posts)
$TotalPosts++;
#Bump user up to Member if Total Posts reaches $MemberMinimum
if (($TotalPosts == $MemberMinimum)  && ($Status eq "Junior Member")) {
$Status = "Member";
}

open (MEMBERS, ">$MembersPath/$UserNameFile.cgi") or die("Unable to open Members directory.");
	print MEMBERS ("$UserName|");
	print MEMBERS ("$in{'Password'}|");
	print MEMBERS ("$Email|");
	print MEMBERS ("$URL|");
	print MEMBERS ("$Permission|");
	print MEMBERS ("$Occupation|");
	print MEMBERS ("$Location|");
	print MEMBERS ("$TotalPosts|");
	print MEMBERS ("$Status|");
	print MEMBERS ("$Interests\n");
close (MEMBERS);


} else {

&PermissionDeniedHTML;

} #END Check Permission block
}  # END IF block

} #end do post the topic sr
 
########


sub GetBio {

$UserNameFile = $UserName;
$UserNameFile =~ s/ /_/g; #remove spaces

open (GETPROFILE, "$MembersPath/$UserNameFile.cgi");
	@thatprofile = <GETPROFILE>;
close (GETPROFILE);

@thisprofile = split(/\|/, $thatprofile[0]);

&ViewBioHTML;

}  ## END GET BIO sr


sub CheckBioID {
if (($in{'UserName'} eq "") || ($in{'Password'} eq "")) {
	&MissingFields;

} else {

opendir (MEMS, "$MembersPath");
@memberlist = readdir(MEMS);
closedir (MEMS);

$UserNameFile = $UserName;
$UserNameFile =~ s/ /_/g; #remove spaces

GETBIO: foreach $member(@memberlist) {
	if ($member eq "$UserNameFile.cgi") {
		$found = "yes";
		#Check Password Now
		
open (MEM, "$MembersPath/$member") or die("Unable to open Members directory.");
@checkpw = <MEM>;
close (MEM);

	@thisprofile = split (/\|/, $checkpw[0]);
	
         if ($in{'Password'} eq "$thisprofile[1]") {
		     $pwmatch = "true";
			 $Password = $thisprofile[1];
			 $Email = $thisprofile[2];
			 $URL = $thisprofile[3];
			 $Occupation = $thisprofile[5];
			 $Location = $thisprofile[6];
			 $Interests = $thisprofile[9];
			 $Status = $thisprofile[8];
			 $TotalPosts = $thisprofile[7];
			 $Permissions = $thisprofile[4];
            &ProcessEdit;
			last GETBIO;
         }
    } ## END IF MEMBER = Username.cgi condition

}  ## END FOREACH MEMBER loop

if ($found ne "yes") {
   &NoMatch;
}
if (($found eq "yes") && ($pwmatch ne "true")) {
   &WrongPassword;
}
} # end check for missing fields
}  ## END CheckBioID SR ###

sub ModifyBio {
if (($Email eq "") || ($in{'NewPassword'} eq "") || ($Email !~ /\@/)) {
&MissingFields;
 }  else {

$UserNameFile = $UserName;
$UserNameFile =~ s/ /_/g; #remove spaces

&OpenProfile("$UserName.cgi");  #returns @profileinfo

$CurrentEmail = "$profileinfo[2]";
$Permissions = "$profileinfo[4]";
$TotalPosts = "$profileinfo[7]";
$Status = "$profileinfo[8]";

if ($profileinfo[1] eq "$in{'Password'}") {

## check for duplicate email addresses, if applicable

if ($EmailCheck eq "true") {

opendir (MEMBERDIR, "$MembersPath"); 
    @members = readdir(MEMBERDIR);
closedir (MEMBERDIR);

@members = grep(/cgi/, @members);

$duplicate = "";

for $checkemails(@members) {

open (MEM, "$MembersPath/$checkemails") or die("Unable to open Members directory.");
@checkemail = <MEM>;
close (MEM);

	@profileEM = split (/\|/, $checkemail[0]);
	
if (($Email eq "$profileEM[2]") && ($UserName ne "$profileEM[0]")) {
$duplicate = "yes";
}
} # end for $checkemails

}  #END if Email check eq TRUE

if ($duplicate eq "yes") { 
	&Duplicate;
} else {

# if email verify is on, then we can't let users change
# email address without sending a new password generated
# by system to them
$Password = "$in{'NewPassword'}";
$ModifyWarning = "";

if (($CurrentEmail ne "$Email") && ($UseEmail eq "ON") && ($EmailVerify eq "ON")){
#generate new password
$NewPassword = &GeneratePassword;
$sendto = "$Email";
$from = "$BBEmail";
$subject = "$BBName Registration - Your New Password";
$message = "Hello!\n\r\nBecause you just modified your email address, we have sent you a new password to use for your registration on $BBName.  Your registration information is provided below, including your new password.  You will need this information in order to post any messages in our forums.\n\r\nYour UserName: $UserName\nYourPassword: $NewPassword\nYour Email Address of record is now: $Email";
$Password = "$NewPassword";
$ModifyWarning = "Note: Because you changed your email address, and because we require email verification, a new password has been issued to you.  This new password has been sent to: $Email.  You may change your password, but you may not change your password and email address at the same time.  Thank you!"; 
&SendEmail;
}  



##print profile fields to file
open (MEMBERSHIP, ">$MembersPath/$UserNameFile.cgi") || die("Unable to open Members directory.");

	print MEMBERSHIP ("$UserName|");
	print MEMBERSHIP ("$Password|");
	print MEMBERSHIP ("$Email|");
	print MEMBERSHIP ("$URL|");
	print MEMBERSHIP ("$Permissions|");
	print MEMBERSHIP ("$Occupation|");
	print MEMBERSHIP ("$Location|");
	print MEMBERSHIP ("$TotalPosts|");
	print MEMBERSHIP ("$Status|");
	print MEMBERSHIP ("$Interests\n");
close (MEMBERSHIP);

#confirm processing to user, provide links to other places

&BioModifyConfirmHTML;
}

}  else  {
&UnauthorizedAccess;
}
}
}  ## END Modify Bio SR




sub RegSubmit {

if ( ($in{'UserName'} eq "") || (($UseEmail ne "ON") && ($EmailVerify ne "ON") && ($in{'Password'} eq "")) ) {
	&MissingFields;

} else {

if ($in{'Password'} eq "$PasswordConfirm")  {
	&GoAhead;
	}  
else {
		&GoBack;
	}
} #end if missing fields check
}  ## END RegSubmit SR ##

sub GoAhead  {	

#check for illegal (non alphanumeric characters)
$_ = "$UserNameFile";
if ((m/\W+/) || (m/\b[_]/)) {
&IllegalNameHTML;
}  else {
#check to make sure Username is unique
opendir (MEMBERDIR, "$MembersPath"); 
    @members = readdir(MEMBERDIR);
closedir (MEMBERDIR);

@members = grep(/cgi/, @members);

$LCUNFile = "$UserNameFile"; #Get ready to lower case it
	$LCUNFile =~ tr/A-Z/a-z/; #convert to lc for check
	
$duplicate = "no";

CHECKDUPES: for $checkthis(@members) {
	$checkthisLC = "$checkthis";
	$checkthisLC =~ tr/A-Z/a-z/; #convert to lc for check
	if ($checkthisLC =~ m/$LCUNFile/) {
		$duplicate = "yes";
		&Duplicate;
		last CHECKDUPES;
	}
#CHECK to make sure email isn't a duplicate too

if (($duplicate ne "yes") && ($EmailCheck eq "true")) {

open (MEM, "$MembersPath/$checkthis") or die("Unable to open Members directory.");
@checkemail = <MEM>;
close (MEM);

	@profile = split (/\|/, $checkemail[0]);
	
if ($Email eq "$profile[2]") {
$duplicate = "yes";
&Duplicate;
}
}  #END if duplicate ne yes

}

if ($duplicate ne "yes") {
if (($UseEmail eq "ON") && ($EmailVerify eq "ON")) {
$Password = &GeneratePassword;  

}  else {
$Password = "$in{'Password'}";
}


open (MEMBERSHIP, ">$MembersPath/$UserNameFile.cgi") or die("Unable to open Members directory.");

	print MEMBERSHIP ("$UserName|");
	print MEMBERSHIP ("$Password|");
	print MEMBERSHIP ("$Email|");
	print MEMBERSHIP ("$URL|");
	print MEMBERSHIP ("Write|");
	print MEMBERSHIP ("$Occupation|");
	print MEMBERSHIP ("$Location|");
	print MEMBERSHIP ("0|");
	print MEMBERSHIP ("Junior Member|");
	print MEMBERSHIP ("$Interests\n");
close (MEMBERSHIP);


if (($UseEmail eq "ON") && ($EmailVerify eq "ON")) {
$sendto = "$Email";
$from = "$BBEmail";
$subject = "$BBName Registration - Your Password";
$message = "Hello!\n\r\nThank you for registering on $BBName.  Your registration is provided below, including your new password.  You will need this information in order to post any messages in our forums.\n\r\nYour UserName: $UserName\nYourPassword: $Password\nYour Email Address of record is: $Email\n\r\nAgain, thank you for registering.";

&SendEmail;

$RegWording1 = "You have successfully registered your User Name for $BBName. ";
$RegWording2 = "Your password has been emailed to you at $Email";
&PrintRegistrationHTML;
}  else {
$RegWording1 = "You have successfully registered your User Name and Password for $BBName. ";
$RegWording2 = "$in{'Password'}";
&PrintRegistrationHTML;
	} # end use email/verify on check
} ### end if dupe ne yes

} # end if/else /m
}  # end GoAhead subroutine

################################



sub ProcessClose {
# verify admin or mod status
&GetMemberListArray;  #returns @members

$NameFound = "no";

foreach $check(@members) {
  if ($check eq "$UserNameFile.cgi") {
      $NameFound = "yes";
    } 
}  # END FOREACH CHECK

if ($NameFound eq "yes") {
@profilestats = &OpenProfile("$UserName.cgi");
	
	if ($in{'Password'} eq "$profilestats[1]") {
	$Status = "$profilestats[8]";
	&CheckTheStatus;
	
	#get moderator for this forum
	$Moderator = ("Forum" . "$number" . "Moderator");
	$Moderator = $$Moderator;

	   if (($AdminStatus eq "true") || ($Moderator eq "$UserName")) {
			## get most current topic file name (in case someone posted new reply)
$TopicNumber = substr($topic, 0, 13);
&GrabTopic; #returns $TopicFile

### can't use rename for certain NT systems, thus, here's the fix:
open (THISFILE, "$ForumsPath/Forum$number/$TopicFile");
@topicfile = <THISFILE>;
close(THISFILE);

($Part1, $Part2, $Part3, $Part4) = split("-", $TopicFile);
($Footer, $Trash) = split(/\./, $Part4);
$NewFileName = ("$Part1" . "-$Part2" . "-$Part3" . "-$Footer" . "X" . ".msg");

# added an X to denote that topic is closed
open (RENAME, ">$ForumsPath/Forum$number/$NewFileName");
for (@topicfile) {
chomp($_);
print RENAME "$_\n";
}
close(RENAME);

unlink ("$ForumsPath/Forum$number/$TopicFile");

# Send confirmation screen
print <<CONFIRMHTML;
<HTML><HEAD>
<meta http-equiv="Refresh" content="3; URL=UltimateALT.cgi?action=topics&Browser=$Browser&DaysPrune=$DaysPrune&number=$number&forum=$ForumCoded&LastLogin=$in{'LastLogin'}">
</HEAD>
<BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<br><br>
<ul><FONT SIZE="$TextSize" FACE="$FontFace">
<B>The following thread has been closed:<P>
$TopicSubject
<P>
You are being automatically transported to the $Forum forum.  Please wait three seconds.
<P>
</B><br><br>
</FONT>
</ul></body></html>
CONFIRMHTML


	   }  else  {
	   &NotAllowed;
	   }
	   
	} else {
	&WrongPassword;
	}
	
}  else {
&WrongUserName;

}  ##END IF/ELSE NAME CHECK BLOCK

} # end process close sr



sub GetDateTime  {


if ($TimeZoneOffset) {
if (($TimeZoneOffset ne "") || ($TimeZoneOffset ne "0")) {
$adjustTime = time() + ($TimeZoneOffset * 3600);
}  else {
$adjustTime = time();
}
($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime ($adjustTime);

} else {

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime (time);

}

$mon++;


$JSMonth = ($mon - 1);

if ($year > 96)  {
	$JSYear = ("19" . "$year");
	} else  {
		$JSYear = ("20" . "$year");
	}


$LastLoginJulian = &jday($JSMonth, $mday, $JSYear);
$JSTime = ("$hour" . "$min");
$LastLoginJulian = ($LastLoginJulian + ($JSTime * 0.0001));

&NormalTime;

$min = sprintf ("%2d", $min);
$min =~tr/ /0/;
$mon = sprintf ("%2d", $mon);
$mon =~tr/ /0/;
$mday = sprintf ("%2d", $mday);
$mday =~tr/ /0/;
$HyphenDate = ("$mon" . "-" . "$mday" . "-" . "$year");
$RunonDate = ("$mon$mday$year");
$Time = ("$hour" . ":" . "$min" . " " . "$AMPM");

$LastLoginDT = ("$HyphenDate $Time");

}  #end GetDateTime sr

		
sub NormalTime {		
if ($hour < 12) {
$AMPM = "AM";
}

if ($hour > 12) {
	$hour = $hour - 12;
	$AMPM = "PM";
	}  	
if ($hour == 12) {
	$AMPM = "PM";
	}  	
	
if ($hour == 0) {
	$hour = "12";
	}
$hour = sprintf ("%2d", $hour);
$hour =~tr/ /0/;
}

		
sub MilitaryTime {
	if ($AMpm eq "PM") {		
		if ($hour < 12) {
			$hour = ($hour  + 12);
		}
	}
	if ($AMpm eq "AM") {		
		if ($hour == 12) {
			$hour = "0";
		}
	}
	$hour = sprintf ("%2d", $hour);
	$hour =~tr/ /0/;
	$min = sprintf ("%2d", $min);
	$min =~tr/ /0/;
}
sub PullTimes {
($ThreadNum, $ReplyNum, $DaterMatch, $Replies) = split(/-/, $_);
		($RepliesString, $Trash) = split(/\./, $Replies);
$Replies = substr($RepliesString, 0, 6);
	if ($Replies eq "000000") {
		$OpenThis = "$_";
		}  else {
		$OpenThis = ("$ThreadNum-$Replies-$DaterMatch-000000.msg");
		}
	open (TIMEX, "$ForumsPath/Forum$x/$OpenThis");
		@messageopen = <TIMEX>;
	close (TIMEX);

		chomp($messageopen[2]);
		($TheTime, $AMpm) = split(/ /, $messageopen[2]);
		($hour, $min) = split(/:/, $TheTime);
		&MilitaryTime; #converts hours to military format
		$MilitaryTime = ("$hour" . ":" . "$min");

}  # end Pull Times sr


sub ConvertToJulian {
	($TheMonth, $TheDay, $TheYear) = split(/-/, $theDate);		($TheTime, $AMpm) = split(/ /, $theTime);
		($hour, $min) = split(/:/, $TheTime);
		&MilitaryTime; #converts hours to military format
		

$TheMonth = ($TheMonth - 1);

if ($TheYear > 96)  {
	$TheYear = ("19" . "$TheYear");
	} else  {
		$TheYear = ("20" . "$TheYear");
	}
$ThisPostJulian = &jday($TheMonth, $TheDay, $TheYear);
$CJTime = ("$hour" . "$min");
$ThisPostJulian = ($ThisPostJulian + ($CJTime * 0.0001));
return ($ThisPostJulian);
}



sub PWRequest {
# Find the right registration
&GetMemberListArray;  # returns @members array
$Found = "";
CHECKPROFILES: foreach $eachmember(@members) {
				open (PROFILES, "$MembersPath/$eachmember");
					@theprofile = <PROFILES>;
				close (PROFILES);
				
			@thisprofile = split(/\|/, $theprofile[0]);
			
				if ($thisprofile[2] eq "$sendto") {
					$YourName = "$thisprofile[0]";
					$YourPassword = "$thisprofile[1]";
					$Found = "yes";
					last CHECKPROFILES;
				}
}

if ($Found eq "yes") {

#Send the Email

$from = "$BBEmail";
$subject = "Your UserName and Password - $BBName";
$message = ("Here is the registration information you requested for $BBName. \n\n Your UserName is: $YourName\n Your Password is: $YourPassword \n\n This bulletin board is located at $CGIURL/Ultimate.cgi \n\nThank you!");

&SendEmail;

#Notify user that email has been sent

print<<DUMMY;
<HTML><head>
<meta http-equiv="Refresh" content="5; URL=UltimateALT.cgi?action=intro"></head>
<BODY BGCOLOR="$BGColor"  text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<IMG SRC="$NonCGIURL/$BBTitle" BORDER=0>
<P><BR><blockquote>
<B><FONT FACE="$FontFace" size="2">Your username and password for this bulletin board have just been emailed to you!
<P>
You are now being automatically returned to the main forums page.</FONT></B></blockquote>
</BODY></HTML>
DUMMY
}  else {
print<<DUMMY;
<HTML><head>
</head>
<BODY BGCOLOR="$BGColor"  text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<IMG SRC="$NonCGIURL/$BBTitle" BORDER=0>
<P><BR><blockquote>
<B><FONT FACE="$FontFace" size=2>We have no one registered with the email address you listed.  Use your back button to try again.
</FONT></B></blockquote>
</BODY></HTML>
DUMMY
}

} #end PWRequest sr



sub SubmitEdit {
## check UBB and HTML status for this forum
@thisforum = &GetForumRecord($number);
  
if ($thisforum[4] eq "is") {
	$HTMLAllowed = "yes";
}  else {
	$HTMLAllowed = "no";
}
 
if ($thisforum[5] eq "is") {
	$UBBAllowed = "yes";
}  else {
	$UBBAllowed = "no";
}

$Moderator = ("Forum" . "$number" . "Moderator");
$Moderator = $$Moderator;

## Get current message from file
open (POST, "$ForumsPath/Forum$number/$topic");
@thispost = <POST>;
close (POST);

$postdate = $thispost[1];
chomp($postdate);
$posttime = $thispost[2];
chomp($posttime);
$postemail = $thispost[4];
chomp($postemail);
$author = $thispost[0];
chomp($author);

$Password = &decodeURL($in{'Password'});

&OpenProfile("$UserNameFile.cgi");    #returns @profileinfo

if ($UserName eq "") {
	&NotAllowed;
}  else {

if (($author eq "$UserName")  || ($Moderator eq "$UserName") || ($profileinfo[4] =~ m/Admin/)) {
#check password
	if ($profileinfo[1] eq "$Password") {
		&DoTheEdit;
	}  else {
	&WrongPassword;
	}

}  else {
&NotAllowed;
}
}
}  #end SubmitEdit sr


sub DoTheEdit {

## format the edited message
$EditedMessage = $in{'EditedMessage'};

## IF HTML is not allowed, render HTML useless
if ($HTMLAllowed eq "no") {
		$EditedMessage =~ s/</&lt;/g;
		$EditedMessage =~ s/>/&gt;/g;
 }
 
if ($Censor eq "ON") {
	for (@censored) {
		if (m/({)(.*)(})/) {
			$_ = ("$2 ");
			$wordlength = length($_);
			$wordlength = $wordlength - 1;
			$replaceword = "*" x $wordlength;
			$replaceword = "$replaceword ";
		}  else {
		$wordlength = length($_);
		$replaceword = "*" x $wordlength;
		}
		$EditedMessage =~ s/$_/$replaceword/isg;
	}
}

#convert newlines/carriage returns to HTML
$EditedMessage =~ s/\n\r\n/<p>/g;
$EditedMessage =~ s/\n/<br>/g;

#UBB Code-ify (if allowed)
if ($UBBAllowed eq "yes") {
$EditedMessage =~ s/(\[URL\])(http:\/\/\S+)(\[\/URL\])/ <A HREF="$2" TARGET=_blank>$2<\/A> /isg;

$EditedMessage =~ s/(\[URL\])(\S+)(\[\/URL\])/ <A HREF="http:\/\/$2" TARGET=_blank>$2<\/A> /isg;

$EditedMessage =~ s/(\[EMAIL\])(\S+\@\S+)(\[\/EMAIL\])/ <A HREF="mailto:$2">$2<\/A> /isg;

$EditedMessage =~ s/(\[IMG\])(\S+)(\[\/IMG\])/ <IMG SRC="$2"> /isg;

$EditedMessage =~ s/(\[QUOTE\])(.+?)(\[\/QUOTE\])/ <BLOCKQUOTE><font size="1" face="$FontFace">quote:<\/font><HR>$2<HR><\/BLOCKQUOTE>/isg;
} #END UBB CODE 

# append edit note to the message
$EditedMessage .= "<P><center>[This message has been edited.]</center>";

#open post for writing

open (POST, ">$ForumsPath/Forum$number/$topic");
print POST ("$UserName\n");
print POST ("$postdate\n");
print POST ("$posttime\n");
print POST ("$TopicSubject\n");
print POST ("$postemail\n");
print POST ("$EditedMessage\n");
close (POST);

#grab topic (father)
$TopicNumber = substr($topic, 0, 6);
$TopicNumber = ("$TopicNumber" . "-000000");
&GrabTopic;  #returns $TopicFile

# send onscreen confirmation to user

print <<CONFIRM;
<HTML><HEAD>
<meta http-equiv="Refresh" content="3; URL=UltimateALT.cgi?action=threadlist&forum=$ForumCoded&number=$number&Browser=$Browser&DaysPrune=$DaysPrune&topic=$TopicFile">
</HEAD>
 <BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<br><br>
<ul><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">
<B>Thanks for editing the message, $UserName!  We are now sending you back automatically to the thread list for this topic.  Please wait three seconds.
</B><br><br>
</FONT>
</ul></body></html>
CONFIRM
}  # end DoTheEdit sr


