/*------------------------------------------------------/
/														/
/	Copyright 1997, Srgio Durte <smd@di.fct.unl.pt>	/
/														/
/------------------------------------------------------*/

#include <glide.h>

#include "defines.h"
#include "mat.h"
#include "rgb.h"


static RGBA pal[4] ;


void rgb_InitPalette()
{
	int i ;
	for( i = 0 ; i < 256 ; i++ ) pal[i].a = 255.f ;

	pal[BLACK].r = 0.0   ; pal[BLACK].g	= 0.0 ;	pal[BLACK].b = 0.0 ;
	pal[WHITE].r = 255.0 ; pal[WHITE].g	= 255.0 ; pal[WHITE].b = 255.0 ;

}


void rgb_SetVertexColor( int i, GrVertex *v )
{
	v->r = pal[i].r ;
	v->g = pal[i].g ;
	v->b = pal[i].b ;
	v->a = pal[i].a ;
}

void rgb_SetRGBColor( int i, RGB *p )
{
	p->r = pal[i].r ;
	p->g = pal[i].g ;
	p->b = pal[i].b ;
}

void rgb_random_color( RGBA *c )
{
	Float m ;

	c->r = rnd() * 255.0 ;
	c->g = rnd() * 255.0 ;
	c->b = rnd() * 255.0 ;
	
	m = 255.0 / max(c->r, max( c->g, c->b ) ) ;
	c->r *= m ;
	c->g *= m ;
	c->b *= m ;
	c->a = 255.0 ;
}
