#ifndef _MAT_H
#define _MAT_H

#define mat_MAXDIMS	12

typedef	Float Vector[ mat_MAXDIMS ] ;

typedef Float Matrix[4][4] ;
typedef struct { Float x, y, z ; } XYZ ;
typedef struct { Float x, y, z, w ; } XYZW ;
typedef struct { Float x, y, z, w, r, g, b ; } XYZWRGB ;
typedef struct { Float x, y, z, w, r, g, b, s, t, oow, sow, tow ; } XYZWRGBST ;
typedef struct { Float x, y, z, w, r, g, b, a, s, t, oow, sow, tow ; } XYZWRGBAST ;

extern XYZ		xyz_Zero ;
extern XYZW		xyzw_Zero ;

#define			mat_direction mat_normalize             

extern int		mat_ipow( int b, int e ) ;
extern Float	mat_dotp( XYZ *, XYZ * ) ;                                     
extern void		mat_crossp( XYZ *, XYZ *, XYZ * ) ;                  
extern Float	mat_length( XYZ * ) ;
                                  
extern Float	mat_normalize( XYZ * ) ;                                               
extern void		mat_scalev( Float, XYZ *,  XYZ * ) ;   
extern void		mat_addv( XYZ *, XYZ *, XYZ *) ;      
extern void		mat_subv( XYZ *, XYZ *, XYZ * ) ;       
extern void		mat_combv( Float, XYZ *, XYZ *,  XYZ * ) ; 
extern void		mat_rotv( XYZ *, XYZ *, XYZ *) ;
extern void		mat_printv( XYZ * ) ;      
extern void		mat_printXYZW( XYZW *) ;

extern void		mat_randomDir( XYZ * ) ;

extern void		mat_multvm( XYZ *, Matrix, XYZ * ) ;
extern void		mat_multvtm( XYZ *,Matrix, XYZ * ) ;

extern void		mat_multpm( XYZ *, Matrix, XYZW *) ;
extern void		mat_multpim( XYZ *, Matrix, XYZ * ) ; 

extern void		mat_mult_m_XYZp( XYZ *v, Matrix a, XYZ *out ) ;

extern void		mat_mult_m_XYZv( XYZ *v, Matrix a, XYZ *out ) ;

extern void		mat_mult_m_XYZWp( XYZ *v, Matrix a, XYZW *out ) ;

extern void		mat_mult_tm_XYZv(XYZ *v, Matrix a, XYZ *out ) ;

extern void		mat_mult_tm_XYZp(XYZ *v, Matrix a, XYZ *out ) ;

extern void		mat_summ( Matrix, Matrix, Matrix ) ; 
extern void		mat_subm( Matrix, Matrix, Matrix ) ;   
extern void		mat_multm( Matrix, Matrix, Matrix) ; 
extern void		mat_invm( Matrix, Matrix ) ;
extern Bool		mat_ainvm( Matrix, Matrix ) ;


extern void		mat_idm( Matrix ) ;

extern void		mat_transpose( Matrix, Matrix ) ;
extern void		mat_transl( XYZ *, Matrix ) ;
extern void		mat_scale( XYZ *, Matrix ) ;

extern void		mat_rotx( Float, Matrix ) ; 
extern void		mat_roty( Float, Matrix ) ;
extern void		mat_rotz( Float, Matrix ) ;

extern void		mat_shearx( Float, Float, Matrix ) ;
extern void		mat_sheary( Float, Float, Matrix ) ;
extern void		mat_shearz( Float, Float, Matrix ) ;


extern void		mat_printm(char *, Matrix ) ; 


#endif /* _MAT_H */
