/*------------------------------------------------------/
/														/
/	Copyright 1997, Srgio Durte <smd@di.fct.unl.pt>	/
/														/
/------------------------------------------------------*/


#include <conio.h>
#include <stdlib.h>
#include <stdio.h>
#include <windows.h>
#include <math.h>
#include <string.h>
#include <glide.h>

#include "defines.h"
#include "hw.h"
#include "mat.h"
#include "rgb.h"

int hw_ResX = 800, hw_ResY = 600;
int hw_ResXo2, hw_ResYo2 ;

static GrHwConfiguration hwconfig;

Bool hw_ShutdownHardware( void )
{
	grSstControl( GR_CONTROL_DEACTIVATE ) ;
	grSstWinClose() ;
	grGlideShutdown() ;
	return True ;
}

Bool hw_VoodooChipset( void )
{
	return hwconfig.SSTs[0].type == GR_SSTTYPE_VOODOO ;
}


Bool hw_InitHardware( void )
{
	static GrHwConfiguration hwconfig;
	
	grGlideInit();

	if ( !grSstQueryHardware( & hwconfig ) ) return False ;
	
	grSstSelect( 0 );
	

	if ( !grSstWinOpen( (FxU32)GetActiveWindow(), GR_RESOLUTION_800x600,
                     GR_REFRESH_75Hz,
                     GR_COLORFORMAT_ABGR,
                     GR_ORIGIN_LOWER_LEFT,
                     2,
                     0 ) ) return False ; 

	hw_ResX = 800 ;
	hw_ResXo2 = hw_ResX / 2 ;

	hw_ResY = 600 ;
	hw_ResYo2 = hw_ResY / 2 ;

	grDepthBufferMode( GR_DEPTHBUFFER_DISABLE );

	grRenderBuffer( GR_BUFFER_BACKBUFFER ) ; 
	grCullMode( GR_CULL_DISABLE ) ;
	
	grHints( GR_HINT_ALLOW_MIPMAP_DITHER, 0 ) ;

	return True ;
}