#ifndef _DEFINES_H_
#define _DEFINES_H_
#include <stdlib.h>
#include <string.h>
/*
   * pseudo-tipos:
*/

#define Byte    unsigned char
#define Word    unsigned short int 
#define Long	unsigned int 
#define	Bool    int	
#define Float   float

/*
   * pseudo-constantes:
*/

#define True	 	1
#define False    	0
#define EPSILON  	1e-8 
#define ZERO  	 	EPSILON 
#define M_1_MAXINT 	4.65661287524579692410E-10 /*1/(2^31-1) 1/meu maxint 32bits*/
#define M_1_255		(1.0 / 255.0) 
#define M_1_65535   (1.0 / 65535.0) 
#define M_1_65500   (1.0 / 65500.0) 

#define SNAP_BIAS	(Float)(1<<19)

#define PI 3.14159265358979323846

#ifndef NULL
#define NULL     0
#endif

#define sqr( X )  ( (X) * (X) )	                   /* quadrado de X */
#define RAD(X)    (3.14159265358979323846*(X)/180.0) /* graus -> radianos */
#define rnd()		((Float)rand()*(1.0f /(Float)RAND_MAX))

#undef fabs
#define fabs(a)     ( (a) > 0 ? (a) : -(a) )

#define sgn(a)      ((a)<0?-1:((a)?1:0))


#define Swap( TYPE, a, b )	{ TYPE tmp ; tmp = a ; a = b ; b = tmp ; } 

#define New( TYPE, N )	      ( TYPE *)malloc( (N) * sizeof( TYPE ) )
#define Delete( N )		free( (char *)N )

#define random	rand


#ifndef max
#define max( a, b )   ((a) > (b) ? (a) : (b))
#endif

#ifndef min
#define min( a, b )   ((a) < (b) ? (a) : (b))
#endif

#ifndef bcopy
#define bcopy(src, dst, n )	memcpy( dst, src, n ) 
#endif 
#endif /* _DEFINES_H_ */
