/*------------------------------------------------------/
/														/
/	Copyright 1997, Srgio Durte <smd@di.fct.unl.pt>	/
/														/
/------------------------------------------------------*/


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <glide.h>

#include "defines.h"
#include "mat.h"
#include "rgb.h"
#include "cell.h"
#include "cell_util.h"
#include "cell_tp1.h"
#include "cell_tp2.h"
#include "cell_tp3.h"
#include "cell_tp4.h"

static Float Gravity = 1000.0 ;


void cutl_random_pos( Float radius, Cell * c )
{
	c->pos.x = radius * ( 1.0 - 2.0 * rnd()) ;
	c->pos.y = radius * ( 1.0 - 2.0 * rnd()) ;
	c->pos.z = radius * ( 1.0 - 2.0 * rnd()) ;	
}

void cutl_snap_pos_to_dad( Cell *c )
{
	Cell *dad = c->dad ;

	if( dad ) {
		XYZ s ;
		Float l ;
		mat_subv( & c->pos, & dad->pos, & s ) ;
		l = mat_direction( & s ) ;
		if( l < ZERO ) mat_randomDir( & s ) ;
		mat_combv( 0.5 * c->age, & s, & dad->pos, & c->pos ) ;
  }
}

void cutl_group_interaction(Cell *c, Cell **group, int n, Float scale, Float factor)
{
  int i ;
  for( i = 0 ; i < n ; i++ ) {
    Float a ;
    XYZ s ;
    Cell *q = group[i] ;
    
    if( q == c ) continue ;
    
    mat_subv( & q->pos, & c->pos, & s ) ;
    a = mat_direction( & s ) ;
	a = scale / (1.0 + pow( a, factor )) ;
    if( fabs(a) > ZERO ) mat_combv( a, & s, & c->acc, & c->acc ) ;
  }
}
void cutl_fgroup_interaction(Cell *c, Cell **group, int n, Float scale)
{
  int i ;
  for( i = 0 ; i < n ; i++ ) {
    Float l ;
    XYZ s ;
    Cell *q = group[i] ;
    
    if( q == c ) continue ;
    
    mat_subv( & q->pos, & c->pos, & s ) ;
    l = mat_direction( & s ) ;
    if( l > ZERO ) mat_combv( scale * l, & s, & c->acc, & c->acc ) ;
  }
}

void cutl_closest_interaction(Cell *c, Cell **group, int n, Float scale, Float factor)
{
  int i ;
  Float mL = -1e8 ;
  XYZ   mS ;

  for( i = 0 ; i < n ; i++ ) {
    Float l ;
    XYZ s ;
    Cell *q = group[i] ;
    
    if( q == c ) continue ;
    
    mat_subv( & q->pos, & c->pos, & s ) ;
    l = mat_direction( & s ) ;
    l = 1.0 / ( 1 + pow( l, factor )) ;
    if( l > mL ) {
      mL = l ;
      mS = s ;
    }

  }
  if( mL > ZERO ) mat_combv( scale * mL, & mS, & c->acc, & c->acc ) ;
}

void cutl_indiv_interaction( Cell *c, Cell *q, Float factor) 
{
    Float l ;
    XYZ s ;
    mat_subv( & q->pos, & c->pos, & s ) ;
    l = mat_direction( & s ) ;
    if( l > ZERO ) mat_combv( factor * l, & s, & c->acc, & c->acc ) ;
}

void cutl_stretch_to_age( Cell *c, Float scale )
{
  Float l ;
  XYZ s ;
  
  return ;
  if( c->dad ) {
    mat_subv( & c->pos, & c->dad->pos, & s ) ;
    l = mat_direction( & s ) ;
    if( l < ZERO ) mat_randomDir( & s ) ;
    
    mat_combv( scale  * (c->age - l), & s, & c->acc, & c->acc ) ;
  }
}

void cutl_stretch_to_distance( Cell *c, Float distance, Float scale )
{
  Float l ;
  XYZ s ;
 
  if( c->dad ) {
    mat_subv( & c->pos, & c->dad->pos, & s ) ;
    l = mat_direction( & s ) ;
    if( l < ZERO ) mat_randomDir( & s ) ; 
    mat_combv( scale  * (distance - l), & s, & c->acc, & c->acc ) ;
  }
}

void cutl_limit_bent( Cell *c, Float scale )
{
  Float l ;
  XYZ s ;
  Cell *dad, *gran ;

  dad = c->dad ;
  if( ! dad ) return ;

  gran = dad->dad ;
  if( ! gran ) return ;

  mat_subv( & c->pos, & gran->pos, & s ) ;  
  l = mat_direction( & s ) ;
  if( l < ZERO ) mat_randomDir( & s ) ; 
  l = (Float)(1.0 / ( 1 + l )) ;
  mat_combv( scale * l, & s, & c->acc, & c->acc ) ;
}


void cutl_limit_speed( Cell *c, Float maxV )
{
  Float v = mat_length( & c->vel ) ;
  if( v > maxV ) mat_scalev( maxV / v, & c->vel, & c->vel ) ;

}
