/*------------------------------------------------------/
/														/
/	Copyright 1997, Srgio Durte <smd@di.fct.unl.pt>	/
/														/
/------------------------------------------------------*/


#include <stdlib.h>
#include <math.h>
#include <glide.h>

#include "defines.h"
#include "mat.h"
#include "rgb.h"
#include "clip.h"
#include "tex.h"
#include "cam.h"
#include "cell.h"
#include "cell_util.h"
#include "cell_tp9.h"

static Bool first_init = True ;
static GrMipMapId_t tp9_texture_src ;

static void tp9_acc_cell(Cell *c) 
{
}

static void tp9_age_cell( Cell *c )
{
	c->age += dt ;
	if( c->age > c->adulthood ) c->status = DYING ;
	c->color.g *= 0.85 ;
	if( c->color.g < 1 ) c->color.r *= 0.90 ;
}

void tp9_set_glide_state( void )
{
	if( first_init ) {
		first_init = False ;
		tp9_texture_src = tex_InitTexture("flare1.3df") ;
	}
	
	tex_SetTexSource( tp9_texture_src ) ;
	guColorCombineFunction( GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB ) ;
	guAlphaSource( GR_ALPHASOURCE_ITERATED_ALPHA );	
	grAlphaBlendFunction( GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ZERO );

}

extern Float Time ;

Cell *ctp9_Constructor( Cell *dad )
{

  Cell *c = cell_Constructor( CellType9 ) ;

  c->max_speed = 65.0 ;

  c->dad = dad ;

  c->max_chld = 1 ;
  c->p_chld = 0.0 ;

  c->adulthood = 1.5 ;
  c->size = 4.0 ;

  
  c->color.r = 200.0 ;
  c->color.g = 120.0 ;
  c->color.b = 0.0 ;
  c->color.a = 1.0 ;

  c->sparkle = 1.0 ;
  c->sparkle_range = 0.3 ;
  c->sparkle_min = 0.5 ;

  c->acc_cell = tp9_acc_cell ; 
  c->age_cell = tp9_age_cell ; 
 
  return c ;
}  
    







    

