/*------------------------------------------------------/
/														/
/	Copyright 1997, Srgio Durte <smd@di.fct.unl.pt>	/
/														/
/------------------------------------------------------*/

#include <stdlib.h>
#include <math.h>
#include <glide.h>

#include "defines.h"
#include "mat.h"
#include "rgb.h"
#include "tex.h"
#include "cam.h"
#include "cell.h"
#include "cell_util.h"
#include "cell_tp2.h"
#include "cell_tp8.h"
#include "cell_tp9.h"

static Bool first_init = True ;
static GrMipMapId_t tp8_texture_src ;
 

static void tp8_acc_cell(Cell *c) 
{
	XYZ	d ;
	Cell **p ;
	int n ;

	mat_scalev( -0.2, & c->pos, & c->acc ) ;

	p = cell_get_cells_by_type( CellType2, & n ) ;
	cutl_closest_interaction( c, p, n, 4000.0, 1.0 ) ;

	p = cell_get_cells_by_type( CellType8, & n ) ;
	cutl_closest_interaction( c, p, n, -14000.0, 2.0 ) ;
}

static void tp8_reproduce_cell( Cell *c) 
{
	int i ;

	for( i = 0 ; i < 2 ; i++ ) {
		Cell *son = ctp9_Constructor( NULL ) ;
		Float a, b, r ;
		XYZ d ;

		a = rnd() * 2 * PI ;
		b = rnd() * PI ;

		r = 1.0 * cos( b ) ;
		son->pos.x = c->pos.x + r * cos( a ) ;
		son->pos.y = c->pos.y + r * sin( a ) ;
		son->pos.z = c->pos.z + 1.0 * sin( b ) ;
		mat_scalev( 0.95, & c->vel, & son->vel ) ;
		mat_subv( & son->pos, & c->pos, & d ) ;
		mat_combv( 18.0, & d, & son->vel, & son->vel ) ;
	}
}

void tp8_set_glide_state( void )
{
	if( first_init ) {
		first_init = False ;
		tp8_texture_src = tex_InitTexture("flare1.3df") ;
	}	

	tex_SetTexSource( tp8_texture_src ) ;
	grTexCombineFunction(GR_TMU0, GR_TEXTURECOMBINE_DECAL ) ;
	guColorCombineFunction( GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB ) ;
	guAlphaSource( GR_ALPHASOURCE_ITERATED_ALPHA );	
	grAlphaBlendFunction( GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ZERO );
}

Cell *ctp8_Constructor( Cell *dad )
{

  Cell *c = cell_Constructor( CellType8 ) ;

  c->max_speed = 60.0 ;

  c->age = 10.0 ;
  c->dad = dad ;

  c->max_chld = 1 ;
  c->p_chld = 0.05 * rnd() + 0.05 ;

  c->adulthood = 20.0 ;

  cutl_random_pos( 950.0, c ) ;

  c->size = 8.0 ;

  c->color.r = 255.0 ;
  c->color.g = 220.0 ;
  c->color.b = 255.0 ;
  c->color.a = 1.0 ;

  c->sparkle = 1.0 ;

  c->acc_cell = tp8_acc_cell ;
  c->reproduce_cell = tp8_reproduce_cell ;
  return c ;
}  
    







    

