#include <stdlib.h>
#include <glide.h>

#include "defines.h"
#include "mat.h"
#include "rgb.h"
#include "tex.h"
#include "cam.h"
#include "cell.h"
#include "cell_util.h"
#include "cell_tp5.h"
#include "cell_tp7.h"

static Bool first_init = True ;
static GrMipMapId_t tp7_texture_src ;


static void tp7_move_cell( Cell *c )
{
	mat_combv( dt, & c->vel, & c->pos, & c->pos ) ;
	mat_combv( dt, & c->acc, & c->vel, & c->vel ) ;
	cutl_limit_speed( c, c->max_speed ) ;
	cutl_snap_pos_to_dad( c ) ;
}
 
static void tp7_acc_cell(Cell *c) 
{

	c->acc = xyz_Zero ;

	if(c->n_chld ) {
	
		Cell *son = c->children[0] ;
		XYZ d ;
		mat_subv( & son->pos, & c->pos, & d ) ;
		mat_scalev( 0.2, & d, & c->acc ) ;
	}
}


static void tp7_reproduce_cell( Cell *c) 
{
	if( c->generation < 15 ) c->children[ c->n_chld++ ] = ctp7_Constructor( c ) ;	
	c->reproduce_cell = cell_menopause ; // no h mais reproduo
}

static void tp7_display_cell( Cell *c )
{
	Cell *dad = c->dad ;
	XYZW pos, dpos ;
	GrVertex vtx0, vtx1 ;

	if( ! dad ) return ;

	cam_W2P_XYZ( & c->pos, & pos ) ; 
	cam_W2P_XYZ( & dad->pos, & dpos ) ; 

	if( clp_PointVisible( & pos ) && clp_PointVisible( & dpos )) {

		cam_XYZW2Vertex( & pos, & vtx0 ) ;
		cam_XYZW2Vertex( & dpos, & vtx1 ) ;
	
		vtx0.r = c->color.r ;
		vtx0.g = c->color.g ;
		vtx0.b = c->color.b ;
		vtx0.a = c->color.a ;

		vtx1.r = c->color.r ;
		vtx1.g = c->color.g ;
		vtx1.b = c->color.b ;
		vtx1.a = c->color.a ;
		vtx1.tmuvtx[0].sow = 128.0 * vtx1.oow ; 
		vtx1.tmuvtx[0].tow = 128.0 * vtx1.oow ;

		grAADrawLine( & vtx0, &vtx1 ) ;	
	} 
}



void tp7_set_glide_state( void )
{
	if( first_init ) {
		first_init = False ;
		tp7_texture_src = tex_InitTexture("glow.3df") ;
	}	
	tex_SetTexSource( tp7_texture_src ) ;
	grTexCombineFunction(GR_TMU0, GR_TEXTURECOMBINE_DECAL );
	guColorCombineFunction( GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB ) ;
	guAlphaSource( GR_ALPHASOURCE_ITERATED_ALPHA );	
	grAlphaBlendFunction( GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ZERO );
}

Cell *ctp7_Constructor( Cell *dad )
{

  Cell *c = cell_Constructor( CellType7 ) ;

  c->max_speed = dad->max_speed ;
  c->dad = dad ;

  c->adulthood = 10.0 ;
  c->size = 3.0 ;

  c->pos.x = dad->pos.x + 0.1 * ( 1 - 2 * rnd()) ;
  c->pos.y = dad->pos.y + 0.1 * ( 1 - 2 * rnd()) ;
  c->pos.z = dad->pos.z + 0.1 * ( 1 - 2 * rnd()) ;

  c->generation = dad->generation + 1 ;
  
  c->color.r = 10.0 ;
  c->color.g = 100.0 ;
  c->color.b = 255.0 ;
  c->color.a = 255.0 ;

 
  c->sparkle = 1.0 ;

   
  c->move_cell = tp7_move_cell ;
  c->acc_cell = tp7_acc_cell ;
  c->reproduce_cell = tp7_reproduce_cell ;
  c->display_cell = tp7_display_cell ;
  return c ;
}  
    







    

