/*------------------------------------------------------/
/														/
/	Copyright 1997, Srgio Durte <smd@di.fct.unl.pt>	/
/														/
/------------------------------------------------------*/


#include <stdlib.h>
#include <glide.h>
#include <math.h>
#include "defines.h"
#include "mat.h"
#include "rgb.h"
#include "tex.h"
#include "cam.h"
#include "cell.h"
#include "cell_util.h"
#include "cell_tp6.h"

extern Float Time ;

static void tp6_acc_cell(Cell *c) 
{
	Float r = 5000.0 ;
	c->acc.x = r * sin( Time * 0.41233 ) ;
	c->acc.y = r * cos( -Time * 0.29432 ) ;
	c->acc.z = -8000.0 ;
}

static void tp6_display_cell( Cell *c )
{
	XYZW pos ;
	GrVertex vtx0, vtx1 ;

	cam_W2P_XYZ( & c->pos, & pos ) ; 

	if( clp_PointVisible( & pos ) ) {

		if( ! clp_PointVisible( & c->lpos ) ) {
			win_printf("caca da glossa") ;
		}
		cam_XYZW2Vertex( & pos, & vtx0 ) ;
		cam_XYZW2Vertex( & c->lpos, & vtx1 ) ;
	
		vtx0.r = c->color.r ;
		vtx0.g = c->color.g ;
		vtx0.b = c->color.b ;
		vtx0.a = c->color.a ;

		vtx1.r = 0.5 * c->color.r ;
		vtx1.g = 0.5 * c->color.g ;
		vtx1.b = 0.5 * c->color.b ;
		vtx1.a = c->color.a ;

		grAADrawLine( & vtx0, &vtx1 ) ;	

		c->lpos = pos ;
	} else {
		cutl_random_pos( 180.0, c ) ;
		cam_W2P_XYZ( & c->pos, & c->lpos ) ; 
	}
}

void tp6_set_glide_state( void )
{
	guColorCombineFunction( GR_COLORCOMBINE_ITRGB ) ;
	grAlphaCombine( GR_COMBINE_FUNCTION_SCALE_OTHER, GR_COMBINE_FACTOR_ONE, GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_ITERATED, FXFALSE );
	grAlphaBlendFunction( GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA, GR_BLEND_ZERO, GR_BLEND_ZERO ) ;
}

Cell *ctp6_Constructor( Cell *dad )
{

  Cell *c = cell_Constructor( CellType6 ) ;
 
  c->max_speed = 20.0 ; 


  c->dad = dad ;

  cutl_random_pos( 400.0, c ) ;
  cam_W2P_XYZ( & c->pos, & c->lpos ) ; 

  c->max_chld = 0 ;
  c->p_chld = 0.0 ;
  c->adulthood = 1.0 ;
  c->size = 2.0 ;

  c->color.r = 200.0 ;
  c->color.g = 200.0 ;
  c->color.b = 200.0 ;
  c->color.a = 255.0 ;

  c->display_cell = tp6_display_cell ;
  c->acc_cell = tp6_acc_cell ;

  return c ;
}  
    







    

