/*------------------------------------------------------/
/														/
/	Copyright 1997, Srgio Durte <smd@di.fct.unl.pt>	/
/														/
/------------------------------------------------------*/


#include <stdlib.h>
#include <glide.h>

#include "defines.h"
#include "mat.h"
#include "rgb.h"
#include "clip.h"
#include "tex.h"
#include "cam.h"
#include "cell.h"
#include "cell_util.h"
#include "cell_tp1.h"
#include "cell_tp2.h"
#include "cell_tp3.h"
#include "cell_tp4.h"

static Bool first_init = True ;
static GrMipMapId_t tp4_texture_src ;

static void tp4_acc_cell(Cell *c) 
{
  int n ;
  Cell **p ;
  
  mat_scalev( 0.95, & c->vel, & c->vel ) ;

}

static void tp4_age_cell( Cell *c )
{
	c->age += dt ;
	if( c->age > c->adulthood ) c->status = DYING ;

	c->color.r *= 0.965 ;
	c->color.g *= 0.965 ;	
	c->color.b *= 0.965 ;
}

void tp4_set_glide_state( void )
{
	if( first_init ) {
		first_init = False ;
		tp4_texture_src = tex_InitTexture("flare1.3df") ;
	}
	
	tex_SetTexSource( tp4_texture_src ) ;
	guColorCombineFunction( GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB ) ;
	guAlphaSource( GR_ALPHASOURCE_ITERATED_ALPHA );	
	grAlphaBlendFunction( GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ZERO );

}

Cell *ctp4_Constructor( Cell *dad )
{

  Cell *c = cell_Constructor( CellType4 ) ;

  c->max_speed = 65.0 ;

  c->dad = dad ;

  c->max_chld = 1 ;
  c->p_chld = 0.0 ;

  c->adulthood = 4.0 ;
  c->size = 6.0 ;

  c->sparkle = 1.0 ;
  c->sparkle_min = 0.5 ;
  c->sparkle_range = 0.2 ;

  if( dad ) {
	c->pos = dad->pos ;
	c->vel = dad->vel ;
  }
  rgb_random_color( & c->color ) ;


  c->acc_cell = tp4_acc_cell ; 
  c->age_cell = tp4_age_cell ; 

  return c ;
}  
    







    

