/*------------------------------------------------------/
/														/
/	Copyright 1997, Srgio Durte <smd@di.fct.unl.pt>	/
/														/
/------------------------------------------------------*/


#include <math.h>
#include <stdlib.h>
#include <glide.h>

#include "defines.h"
#include "mat.h"
#include "rgb.h"
#include "tex.h"
#include "cam.h"
#include "cell.h"

#include "cell.h"
#include "cell_util.h"
#include "cell_tp1.h"
#include "cell_tp2.h"
#include "cell_tp3.h"
#include "cell_tp4.h"

static Bool first_init = True ;
static GrMipMapId_t tp2_texture_src ;

static void tp2_acc_cell(Cell *c) 
{
  int n ;
  Cell **p ;
 
  c->acc = xyz_Zero ;
 
  p = cell_get_cells_by_type( CellType1, & n ) ;
  cutl_closest_interaction( c, p, n, 6000.0, 1.0 ) ;

  p = cell_get_cells_by_type( CellType2, & n ) ;
  cutl_closest_interaction( c, p, n, -80000.0, 3.0 ) ;

}
    
static void tp2_reproduce_cell( Cell *c) 
{
	c->children[ c->n_chld++ ] = ctp3_Constructor( c ) ;
	c->reproduce_cell = cell_menopause ;				// no h mais reproduo
}

void tp2_set_glide_state( void )
{
	if( first_init ) {
		first_init = False ;
		tp2_texture_src = tex_InitTexture("flare1.3df") ;
	}	
	guColorCombineFunction( GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB ) ;
	guAlphaSource( GR_ALPHASOURCE_ITERATED_ALPHA );	
	grAlphaBlendFunction( GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ZERO );
	tex_SetTexSource( tp2_texture_src ) ;
}

Cell *ctp2_Constructor( Cell *dad )
{

  Cell *c = cell_Constructor( CellType2 ) ;
 
  c->max_speed = 80.00 ;

  c->dad = dad ;

  c->max_chld = 1 ;
  c->p_chld = 1.0 ;
  c->adulthood = 16.0 ;
  c->size = 48.0 ;
  if( dad ) {

    c->pos.x = dad->pos.x + 1 * ( 1 - 2 * rnd()) ;
    c->pos.y = dad->pos.y + 1 * ( 1 - 2 * rnd()) ;
    c->pos.z = dad->pos.z + 1 * ( 1 - 2 * rnd()) ;
  
	c->generation = dad->generation + 1 ;
	c->adulthood = dad->adulthood ;
  }	cutl_random_pos( 500.0, c ) ;

  c->color.r = 255.0 ;
  c->color.g = 250.0 ;
  c->color.b = 252.0 ;
  c->color.a = 255.0 ;
 
  c->acc_cell = tp2_acc_cell ;
  c->reproduce_cell = tp2_reproduce_cell ;

  return c ;
} 






    

