/*------------------------------------------------------/
/														/
/	Copyright 1997, Srgio Durte <smd@di.fct.unl.pt>	/
/														/
/------------------------------------------------------*/


#include <stdlib.h>
#include <math.h>
#include <glide.h>

#include "defines.h"
#include "mat.h"
#include "rgb.h"
#include "clip.h"
#include "tex.h"
#include "cam.h"
#include "cell.h"
#include "cell_util.h"
#include "cell_tp10.h"

static Bool first_init = True ;
static GrMipMapId_t tp10_texture_src ;

static void tp10_move_cell( Cell *c )
{
	mat_combv( dt, & c->vel, & c->pos, & c->pos ) ;
	mat_combv( dt, & c->acc, & c->vel, & c->vel ) ;
	mat_scalev( 0.95, & c->vel, & c->vel ) ;
}
static void tp10_acc_cell(Cell *c) 
{
	c->acc = xyz_Zero ;
	if( c->age < 0.3 * c->adulthood && c->pos.z > 10.0 ) c->acc.z = -75.0 ;
}

static void tp10_age_cell( Cell *c )
{
	Float f = 1.0 ;

	c->age += dt ;

	if( c->age < 0.3 * c->adulthood ) f = 1.06 ;
	else if( c->age > 0.7 * c->adulthood ) f = 0.95 ;
	
	c->color.r = max( 0.0, min( 255.0, c->color.r * f )) ;
	c->color.g = max( 0.0, min( 255.0, c->color.g * f )) ;
	c->color.b = max( 0.0, min( 255.0, c->color.b * f )) ;

	if( c->age > c->adulthood ) c->status = DYING ;
}

void tp10_set_glide_state( void )
{
	if( first_init ) {
		first_init = False ;
		tp10_texture_src = tex_InitTexture("title.3df") ;
	}
	
	tex_SetTexSource( tp10_texture_src ) ;
	guColorCombineFunction( GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB ) ;
	guAlphaSource( GR_ALPHASOURCE_ITERATED_ALPHA );	
	grAlphaBlendFunction( GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ZERO );

}

extern Float Time ;

Cell *ctp10_Constructor( Cell *dad )
{

  Cell *c = cell_Constructor( CellType10 ) ;


  c->pos.x = 0.0 ;
  c->pos.y = 0.0 ;
  c->pos.z = 200.0 ;

  c->max_speed = 65.0 ;

  c->dad = dad ;

  c->max_chld = 1 ;
  c->p_chld = 0.0 ;

  c->adulthood = 15.0 ;
  c->age = 0.0 ;

  c->size = 60.0 ;

  c->sparkle = 1.0 ;
  c->sparkle_range = 0.0 ;
  c->sparkle_min = 1.0 ;

  c->color.r = 10.0 ;
  c->color.g = 10.0 ;
  c->color.b = 10.0 ;
  c->color.a = 255.0 ;

  c->move_cell = tp10_move_cell ;
  c->acc_cell = tp10_acc_cell ; 
  c->age_cell = tp10_age_cell ; 
  return c ;
}  
    







    

