/*------------------------------------------------------/
/														/
/	Copyright 1997, Srgio Durte <smd@di.fct.unl.pt>	/
/														/
/------------------------------------------------------*/


#include <stdlib.h>
#include <glide.h>

#include "defines.h"
#include "mat.h"
#include "rgb.h"
#include "cell.h"
#include "cell_util.h"
#include "cell_tp1.h"
#include "cell_tp2.h"
#include "cell_tp4.h"

static Bool first_init = True ;
static GrMipMapId_t tp1_texture_src ;

void tp1_set_glide_state( void )
{
	if( first_init ) {
		first_init = False ;
		tp1_texture_src = tex_InitTexture("flare2.3df") ;
	}	
	tex_SetTexSource( tp1_texture_src ) ;
	grTexCombineFunction(GR_TMU0, GR_TEXTURECOMBINE_DECAL );
	guColorCombineFunction( GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB ) ;
	guAlphaSource( GR_ALPHASOURCE_ITERATED_ALPHA );	
	grAlphaBlendFunction( GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ZERO );
}

static void tp1_acc_cell(Cell *c) 
{
  int n ;
  Cell **p ;
  
  mat_scalev( -1.0, & c->pos, & c->acc ) ;

  p = cell_get_cells_by_type( CellType1, & n ) ;
  cutl_closest_interaction( c, p, n, -10000.0, 1.0 ) ;

  p = cell_get_cells_by_type( CellType2, & n ) ;
  cutl_closest_interaction( c, p, n, -35000.0, 2.0 ) ;
}

static void tp1_reproduce_cell( Cell *c )
{
	if( rnd() <  c->p_chld ) ctp4_Constructor( c ) ;
}

Cell *ctp1_Constructor( Cell *dad )
{

  Cell *c = cell_Constructor( CellType1 ) ;
 
  c->max_speed = 100.0 ;

  c->dad = dad ;

  c->max_chld = 1 ;
  c->p_chld = 0.8 ;
  c->adulthood = 450.0 ;
  c->size = 15.0 ;
  c->size = 20.0 ;

  cutl_random_pos( 400.0, c ) ;

  c->sparkle = 0.9 ;
  c->sparkle_range = 0.2 ;
  c->sparkle_min = 0.6 ;

  c->color.r = 255.0 ;
  c->color.g = 255.0 ;
  c->color.b = 135.0 ;
  c->color.a = 255.0 ;

  c->acc_cell = tp1_acc_cell ;
  c->reproduce_cell = tp1_reproduce_cell ;

  return c ;
}  
    







    

