/*------------------------------------------------------/
/														/
/	Copyright 1997, Srgio Durte <smd@di.fct.unl.pt>	/
/														/
/------------------------------------------------------*/

#include <stdio.h>
#include <glide.h>

#include "defines.h"
#include "mat.h"
#include "rgb.h"
#include "tex.h"
#include "cam.h"
#include "cell.h"
#include "cell_util.h"
#include "cell_tp1.h"
#include "cell_tp2.h"
#include "cell_tp3.h"
#include "cell_tp4.h"
#include "cell_tp5.h"
#include "cell_tp6.h"
#include "cell_tp7.h"
#include "cell_tp8.h"
#include "cell_tp9.h"
#include "cell_tp10.h"

#define MaxCellTypes	12
#define MaxCells		2048

static	int tot_Cells = 0 ;

static	Cell cells[ MaxCells ] ;
 
struct {
	int n ;
	Cell *list[ MaxCells ] ;
	void (*set_glide_state)( void ) ;
} cells_by_type[ MaxCellTypes ] ;


Cell **cell_get_cells_by_type( int type, int *n)
{
	*n = cells_by_type[ type ].n ;
	return cells_by_type[ type ].list ;
}

static Cell *cell_new_cell( int type )
{
	int i ;
	Cell *c ;
	
	for( i = 0 ; i < MaxCells ; i++ )
		if( cells[i].status == DEAD ) {
			c = & cells[i] ;
			break ;
		}
	cells_by_type[ type ].list[ cells_by_type[type].n++ ] = c ;

	return c ;
}

// Isto  feio mas por agora fica assim
static void cell_compute_cells_by_type( void )
{
	int i ;

	for( i = 0 ; i < MaxCellTypes ; i++ ) cells_by_type[i].n = 0 ;

	for( i = 0 ; i < MaxCells ; i++ ) {
		Cell *c = & cells[i] ;
		if( c->status == ALIVE ) 
			cells_by_type[ c->type ].list[ cells_by_type[ c->type ].n++ ] = c ;		
	}
}

void cell_InitModule( void )
{
	int i ;
	
	for( i = 0 ; i < MaxCells ; i++ ) cells[i].status = DEAD ;
	for( i = 0 ; i < MaxCellTypes ; i++ ) cells_by_type[i].n = 0 ;

	cells_by_type[ CellType1 ].set_glide_state = tp1_set_glide_state ;
	cells_by_type[ CellType2 ].set_glide_state = tp2_set_glide_state ;
	cells_by_type[ CellType3 ].set_glide_state = tp3_set_glide_state ;
	cells_by_type[ CellType4 ].set_glide_state = tp4_set_glide_state ;
	cells_by_type[ CellType5 ].set_glide_state = tp5_set_glide_state ;
	cells_by_type[ CellType6 ].set_glide_state = tp6_set_glide_state ;
	cells_by_type[ CellType7 ].set_glide_state = tp7_set_glide_state ;
	cells_by_type[ CellType8 ].set_glide_state = tp8_set_glide_state ;
	cells_by_type[ CellType9 ].set_glide_state = tp9_set_glide_state ;
	cells_by_type[ CellType10 ].set_glide_state  = tp10_set_glide_state ;

	tot_Cells = 0 ;

	for( i = 0 ; i < 7 ; i++ ) ctp1_Constructor( NULL ) ;	
	for( i = 0 ; i < 100 ; i++ ) ctp6_Constructor( NULL ) ;	

	for( i = 0 ; i < 3 ; i++ ) ctp2_Constructor( NULL ) ;	
  
	for( i = 0 ; i < 2 ; i++ ) ctp5_Constructor( NULL ) ;	

	for( i = 0 ; i < 2 ; i++ ) ctp8_Constructor( NULL ) ;	
	
	ctp10_Constructor( NULL ) ;	// ttulo.

}


void cell_MainLoop( void )
{
	int j ;


	for( j = 1 ; j <= CellType10 ; j++ ) {
		int i ;
		cells_by_type[ j ].set_glide_state() ;

		for( i = 0 ; i < cells_by_type[ j ].n ; i++ ) {
				Cell *c = cells_by_type[ j ].list[i] ;
				c->display_cell( c ) ;
		}
	}

	// tratar dos vrios aspectos da vida das clulas
	for(j = MaxCells ; j >= 0 ; j-- ) 
		if( cells[j].status == ALIVE ) {
			cells[j].move_cell( cells + j ) ;
			cells[j].acc_cell( cells + j ) ;
			cells[j].reproduce_cell( cells + j ) ;
			cells[j].age_cell( cells + j ) ;
		
		}
	// apagar as clulas que morreram no passo anterior
	for( j = 0 ; j < MaxCells ; j++ )
		if( cells[j].status == DYING ) cells[j].status = DEAD ;

	cell_compute_cells_by_type() ;

}

void cell_menopause( Cell *c )
{
}

static void cell_move_cell( Cell *c )
{
	mat_combv( dt, & c->vel, & c->pos, & c->pos ) ;
	mat_combv( dt, & c->acc, & c->vel, & c->vel ) ;
	cutl_limit_speed( c, c->max_speed ) ;
}

static void cell_acc_cell(Cell *c) 
{  
	c->acc = xyz_Zero ;   
}

static void cell_age_cell(Cell *c)
{
  if( c->age < c->adulthood ) c->age += dt ;
}

static void cell_reproduce_cell( Cell *c) 
{
}

static void cell_display_cell( Cell *c )
{
	int n ;
	XYZ pos, p ;
	XYZWRGBAST p0, p1, p2, p3 ;
	RGBA color ;
	Vector *v[10] ;

	cam_W2C_XYZ( & c->pos, & pos ) ; 
	
	p.x = pos.x - c->size ;
	p.y = pos.y + c->size ;
	p.z = pos.z ;

	cam_C2P_XYZ( & p, (XYZW *)& p0 ) ;
	p.y = pos.y - c->size ;	
	cam_C2P_XYZ( & p, (XYZW *)& p1 ) ;
	p.x = pos.x + c->size ;
	cam_C2P_XYZ( & p, (XYZW *)& p2 ) ;
	p.y = pos.y + c->size ;	
	cam_C2P_XYZ( & p, (XYZW *)& p3 ) ;

	p0.s = 0.0 ; p0.t = 0.0 ;
	p1.s = 0.0 ; p1.t = 255.0 ;
	p2.s = 255.0 ; p2.t = 255.0 ;
	p3.s = 255.0 ; p3.t = 0.0 ;

	color = c->color ;
	c->sparkle += c->sparkle_range * (1.0 - 2.0 * rnd()) ;
	c->sparkle = max( c->sparkle_min, min( 1.0, c->sparkle ) ) ;

	color.r = c->color.r * c->sparkle ;
	color.g = c->color.g * c->sparkle ;
	color.b = c->color.b * c->sparkle ;
	color.a = c->color.a ;

	bcopy( & color, (RGBA *) & p0.r, sizeof( RGBA ) ) ;
	bcopy( & color, (RGBA *) & p1.r, sizeof( RGBA ) ) ;
	bcopy( & color, (RGBA *) & p2.r, sizeof( RGBA ) ) ;
	bcopy( & color, (RGBA *) & p3.r, sizeof( RGBA ) ) ;

	v[0] = (Vector *) & p0 ;
	v[1] = (Vector *) & p1 ;
	v[2] = (Vector *) & p2 ;
	v[3] = (Vector *) & p3 ;
	
	clp_ClipPolygonRef( 10, 4, v, & n, v ) ;

}

Cell *cell_Constructor( int type )
{
	
	Cell *c = cell_new_cell( type ) ;
	c->type = type ;

	c->status = ALIVE ;
	c->age = 1.0 ;
	c->acc = xyz_Zero ;
	c->vel = xyz_Zero ;
	c->max_speed = 1e8 ;
	c->n_chld = 0 ;
	c->generation = 1 ;
	c->sparkle = 1.0 ;
	c->sparkle_range = 0.2 ;
	c->sparkle_min = 0.6 ;

	c->move_cell = cell_move_cell ;
	c->acc_cell = cell_acc_cell ;
	c->age_cell = cell_age_cell ;
	c->reproduce_cell = cell_reproduce_cell ;
	c->display_cell = cell_display_cell ;

	return c ;
}

void cell_Destructor( Cell *c )
{
	c->status = DEAD ; // ainda  preciso ver se deve ser DYING...
}
 