/*------------------------------------------------------/
/														/
/	Copyright 1997, Srgio Durte <smd@di.fct.unl.pt>	/
/														/
/------------------------------------------------------*/

#include <stdlib.h>
#include <stdio.h>
#include <glide.h>
#include <math.h>

#include <windows.h>

#include "defines.h"
#include "mat.h"
#include "hw.h"
#include "cam.h"
#include "rgb.h"

#define Border 1

#define xAspect 0.75

XYZ from, at, up ;
static Float BackPlane = 1.0f , FrontPlane = 100.0f ;
static Float focus ;

static Matrix Tw2c, R, Tcam, M, TMSper ;

static Bool newCamera = False ;

static void cam_M( Matrix M )
{
	Float zmin ;

	zmin = -( focus + FrontPlane )/( focus + BackPlane ) ;

	mat_idm( M ) ;

	M[2][2] = 1.0f / ( 1.0f + zmin ) ;
	M[2][3] = -zmin / (1.0f + zmin ) ;
	M[3][2] = -1.0f ;
	M[3][3] =  0.0f ;
}

void cam_WEyeDirection( XYZ *p, XYZ *eye )
{
	eye->x = p->x - from.x ;
	eye->y = p->y - from.y ;
	eye->z = p->z - from.z ;
}

Bool cam_NewCamera( void )
{
	return newCamera ;
}


void cam_SetCamParameters( XYZ *f, XYZ *a, XYZ *u, Float df, Float front, Float back )
{
	from = *f ;
	at = *a ;
	up = *u ;

	mat_normalize( & up ) ;
	
	focus = df ;
	BackPlane = back ;
	FrontPlane = front ;

	newCamera = True ;
}
void cam_SetCamPosition( XYZ *f, XYZ *a, XYZ *u )
{
	from = *f ;
	at = *a ;
	up = *u ;

	mat_normalize( & up ) ;

	newCamera = True ;
}

void cam_GetCamParameters( XYZ *f, XYZ *a, XYZ *u )
{
	*f = from ;
	*a = at ;
	*u = up ;
}

static void cam_Rotation( Matrix R )
{
	XYZ rx, ry, rz ;
	
	mat_subv( & at, & from, & rz ) ;
	mat_normalize( & rz ) ;

	mat_crossp( & up, & rz, & rx ) ; /* assuming up normalized */
	
	mat_crossp( &  rz, & rx, & ry ) ;

	R[0][0] = rx.x ; R[0][1] = rx.y ; R[0][2] = rx.z ; R[0][3] = 0.0f ;
	R[1][0] = ry.x ; R[1][1] = ry.y ; R[1][2] = ry.z ; R[1][3] = 0.0f ;
	R[2][0] = rz.x ; R[2][1] = rz.y ; R[2][2] = rz.z ; R[2][3] = 0.0f ;
	R[3][0] = 0.0f ; R[3][1] = 0.0f ; R[3][2] = 0.0f ; R[3][3] = 1.0f ;
} 



static void cam_scaleW( Matrix W )
{
	Float maxW = 1000.0f ;
	
	mat_idm( W ) ;
	
	W[0][0] = 1.0f ;
	W[1][1] = 1.0f ;
	W[2][2] = 1.0f ;
	W[3][3] = maxW ;
} 

void cam_BuildCameraTransform()
{
	Matrix Tfrom, Tprp, Sper, T1 ;
	Matrix S, Twin ;

	XYZ p ;

	newCamera = False ;

	p.x = -from.x ;	p.y = -from.y ;	p.z = -from.z ;
	mat_transl( & p, Tfrom ) ;


	cam_Rotation( R ) ;

	mat_multm( R, Tfrom, T1 ) ;

	p.x = 0.0f ; p.y = 0.0f ; p.z = focus ;
	mat_transl( & p, Tprp ) ;


	mat_multm( Tprp, T1, Tcam ) ; 
	
	p.x = xAspect * focus / (focus + BackPlane ) ;
	p.y = focus / (focus + BackPlane ) ;
	p.z = -1.0f / (focus + BackPlane ) ;
	mat_scale( & p, Sper ) ;

	cam_M ( M ) ;

	mat_multm( M, Sper, TMSper ) ;

	mat_multm( TMSper,  Tcam, Tw2c) ;
}

void cam_W2P_XYZ( XYZ *p, XYZW *q )
{
  q->x = p->x * Tw2c[0][0] + p->y * Tw2c[0][1] + p->z * Tw2c[0][2] + Tw2c[0][3] ;
  q->y = p->x * Tw2c[1][0] + p->y * Tw2c[1][1] + p->z * Tw2c[1][2] + Tw2c[1][3] ;
  q->z = p->x * Tw2c[2][0] + p->y * Tw2c[2][1] + p->z * Tw2c[2][2] + Tw2c[2][3] ;
  q->w = p->x * Tw2c[3][0] + p->y * Tw2c[3][1] + p->z * Tw2c[3][2] + Tw2c[3][3] ;
}
 
void cam_W2C_XYZ( XYZ *p, XYZ *q )
{
  q->x = p->x * Tcam[0][0] + p->y * Tcam[0][1] + p->z * Tcam[0][2] + Tcam[0][3] ;
  q->y = p->x * Tcam[1][0] + p->y * Tcam[1][1] + p->z * Tcam[1][2] + Tcam[1][3] ;
  q->z = p->x * Tcam[2][0] + p->y * Tcam[2][1] + p->z * Tcam[2][2] + Tcam[2][3] ;
} 

void cam_C2P_XYZ( XYZ *p, XYZW *q )
{
  q->x = p->x * TMSper[0][0] + p->y * TMSper[0][1] + p->z * TMSper[0][2] + TMSper[0][3] ;
  q->y = p->x * TMSper[1][0] + p->y * TMSper[1][1] + p->z * TMSper[1][2] + TMSper[1][3] ;
  q->z = p->x * TMSper[2][0] + p->y * TMSper[2][1] + p->z * TMSper[2][2] + TMSper[2][3] ;
  q->w = p->x * TMSper[3][0] + p->y * TMSper[3][1] + p->z * TMSper[3][2] + TMSper[3][3] ;
} 


void cam_XYZW2Vertex( XYZW *Q, GrVertex *v )
{
	Float oow = 1.0 / Q->w ;

	v->x = SNAP_BIAS + Q->x * oow * (Float)(hw_ResXo2 - Border) + (Float)hw_ResXo2 ;

	v->y = SNAP_BIAS + Q->y * oow * (Float)(hw_ResYo2 - Border) + (Float)hw_ResYo2 ;

	v->oow = oow * M_1_65500 ;
}

void cam_XYZWRGB2Vertex( XYZWRGB *Q, GrVertex *v )
{
	Float oow = 1.0 / Q->w ;

	v->x = SNAP_BIAS + Q->x * oow * (Float)(hw_ResXo2 - Border) + (Float)hw_ResXo2 ;

	v->y = SNAP_BIAS + Q->y * oow * (Float)(hw_ResYo2 - Border) + (Float)hw_ResYo2 ;

	v->oow = oow * M_1_65500 ;

	v->r = Q->r ; v->g = Q->g ; v->b = Q->b ;
}

void cam_XYZWRGBST2Vertex( XYZWRGBST *Q, GrVertex *v )
{
	Float oow = 1.0 / Q->w ;

	v->x = SNAP_BIAS + Q->x * oow * (Float)(hw_ResXo2 - Border) + (Float)hw_ResXo2 ;

	v->y = SNAP_BIAS + Q->y * oow * (Float)(hw_ResYo2 - Border) + (Float)hw_ResYo2 ;

	v->oow = oow * M_1_65500 ;

	v->tmuvtx[0].sow = Q->s * v->oow ; 
	v->tmuvtx[0].tow = Q->t * v->oow ;

	v->r = Q->r ; v->g = Q->g ; v->b = Q->b ;	
}

void cam_XYZWRGBAST2Vertex( XYZWRGBAST *Q, GrVertex *v )
{
	Float oow = 1.0 / Q->w ;

	v->x = SNAP_BIAS + Q->x * oow * (Float)(hw_ResXo2 - Border) + (Float)hw_ResXo2 ;

	v->y = SNAP_BIAS + Q->y * oow * (Float)(hw_ResYo2 - Border) + (Float)hw_ResYo2 ;

	v->oow = oow * M_1_65500 ;

	v->tmuvtx[0].sow = Q->s * v->oow ; 
	v->tmuvtx[0].tow = Q->t * v->oow ;

	v->r = Q->r ; v->g = Q->g ; v->b = Q->b ; v->a = Q->a ;
}

