IPMAP(1)                 P32 Programmer's Manual              IPMAP(1)

NAME
        ipmap - specify an IP address mapping

SYNOPSIS
        ipmap [src_ipaddr [ifn]]
        ipmap off
        ipmapa [ifn]
        ipmapb ifn
                
DESCRIPTION
        Ipmap specifies the private IP address to be mapped to the IP 
        address of a specified P32 network interface. The interfaces
        are numbered as follows:
        
                            0   localhost
                            1   PPP
                            2   ETH1
                            3   ETH2
                            4   ETH3
                            5   ETH4
            
        If argument ifn is omitted, the Primary Interface address is used.
        If both arguments are omitted, the current mapping is printed.
        
        Ipmapa maps the OTHER IP address of the specified adapter to the
        IP address of the Primary Interface and enables port mapping. The 
        OTHER address is the IP address of the host's native TCP/IP stack.
        If the ifn argument is omitted, ETH1 (ifn 2) is assumed.
  
        Ipmapb maps ALL incoming unmapped UDP port numbers to the same port 
        number at the subnet broadcast address for the specified interface.
        P32 uses Ethernet broadcasting to propagate such packets.
               
        IP mapping is used to map a private IP address to a single 
        registered IP address. It is decribed in RFC 1631.
        
NOTES   
        The Primary Interface is the interface which is used for DNS
        resolution. It must have a registered IP address. That address
        is used as the target address of all mappings.
         
        The PPP interface automatically becomes the Primary Interface
        when a client connection is established. If the PPP interface is 
        not used, a Primary Interface can be specified during network
        configuration.

SEE ALSO
        netcfg(1), ns(1), pmap(1)
