CRON(1)                   P32 Programmer's Manual                 CRON(1)

NAME
        cron - start or stop the CRON daemon

SYNOPSIS
        cron on|off
        
DESCRIPTION
        Cron starts or stops the CRON daemon. At one-minute intervals, CRON 
        opens the file crontab in the current directory and loads it into 
        memory. File crontab contains entries specifying the time and date 
        for execution of a specified command. If the current time matches a 
        specification, the associated command is submitted to the shell in 
        the P32 Console for execution. 
        
        The format of crontab entries is as follows:
            
            time_spec command
            
        The format of time_spec is as follows:
        
            minute hour day-of-month month day-of-week command
        
        The fields are defined as:
        
            minute:         0-59
            hour:           0-23
            day-of-month:   0-31
            month:          0-12 or Jan Feb Mar etc.
            day-of-week:    0-7  or Sun Mon Tue etc.
        
        A field may be an asterisk (*) to denote ANY.
        
        Ranges are allowed: e.g. 8-11 denotes 8, 9, 10 and 11.
        Lists are allowed: e.g. 1,2,5,9 or 0-4,8-12
        Steps are allowed: e.g. 0-23/2 denotes 0 2 4 8 etc.
        
        The remained of the line specifies the command to be run.

        A time_spec can also have the following format:
        
                        @reboot
                        @yearly
                        @monthly
                        @weekly
                        @daily
                        @hourly

        Crontab entries starting with # are comments.
        
EXAMPLES
        # run at 09:00 every day
        0 9 * * * echo cron job
        # run at 17:00 weekdays
        0 17 * * 1-5 echo cron job
        # run at reboot
        @reboot echo cron reboot job
                 
SEE ALSO
