//
// Copyright (C) 1994 - 1996 Octopus Technologies, Inc.
// All rights reserved.
//
//
/****************************************************************************
*    octctrnm.h
*    PURPOSE: Offset definition file for exensible counter objects and counters
*
****************************************************************************/

/*
* $Log: octctrnm.h,v $
* Revision 2.1.1.1  1997/10/01 20:07:22  bobk
* Octopus v3 Source
*
* Revision 1.1  1997/06/20 23:52:21  ken
* renamed octoctrnm.h to octctrnm.h
*
* Revision 1.3  1997/06/19 01:26:15  bobk
* added aggregate and receive counters
*
* Revision 1.2  1997/06/12 15:55:37  bobk
* first official release
*
* Revision 1.1  1997/06/11 04:30:56  bobk
* Initial Version
*
*
*
*/

//  These "relative" offsets must start at 0 and be multiples of 2 (i.e.
//  even numbers). In the Open Procedure, they will be added to the 
//  "First Counter" and "First Help" values fo the device they belong to, 
//  in order to determine the  absolute location of the counter and 
//  object names and corresponding help text in the registry.
//
//  this file is used by the extensible counter DLL code as well as the 
//  counter name and help text definition file (.INI) file that is used
//  by LODCTR to load the names into the registry.

#define OCTOPUSOBJ 0
#define CTR_OP_LOG_SIZE 2
#define CTR_OP_NUM_OPEN_FILES 4
	// kernel "counters" (time averaged)
#define CTR_OP_NUM_LOG_WRITES 6
#define CTR_OP_NUM_LOG_BYTES 8
#define CTR_OP_NUM_LOG_HDR_BYTES 10
#define CTR_OP_NUM_LOG_DATA_BYTES 12
	// kernel command counts
#define CTR_OP_OCT__WRITE 14
#define CTR_OP_OCT__TRUNCATE 16
#define CTR_OP_OCT__ROLLLOG 18
#define CTR_OP_OCT__DELETE 20
#define CTR_OP_OCT__RENAME 22
#define CTR_OP_OCT__CONFIG 24
#define CTR_OP_OCT__SYNC_ID 26
#define CTR_OP_OCT__FILE_EXIST 28
#define CTR_OP_OCT__COPY 30
#define CTR_OP_OCT__ADD_SHARE 32
#define CTR_OP_OCT__DELETE_SHARE 34
#define CTR_OP_OCT__COPY_DONE 36
#define CTR_OP_OCT__CLOSE_APP_FILES 38
#define CTR_OP_OCT__CLOSE 40
#define CTR_OP_OCT__ATTRIBUTES 42
#define CTR_OP_OCT__ACLS 44
#define CTR_OP_OCT__ACLS_DATA 46
#define CTR_OP_OCT__BACKUPWRITE 48
#define CTR_OP_OCT__BACKUPEND 50
#define CTR_OP_OCT__CREATE 52
#define CTR_OP_OCT__ACLS_TEXT 54
#define CTR_OP_OCT__SYNC_COPY 56
#define CTR_OP_OCT__SET_COMPRESSION 58
#define CTR_OP_OCT__FILE_HEADER 60
#define CTR_OP_OCT__SYNC_COPY_DONE 62
#define CTR_OP_OCT__DFS_CMD 64
	// kernel command data counts
#define CTR_OP_OCT__WRITE_BYTES 66
#define CTR_OP_OCT__TRUNCATE_BYTES 68
#define CTR_OP_OCT__ROLLLOG_BYTES 70
#define CTR_OP_OCT__DELETE_BYTES 72
#define CTR_OP_OCT__RENAME_BYTES 74
#define CTR_OP_OCT__CONFIG_BYTES 76
#define CTR_OP_OCT__SYNC_ID_BYTES 78
#define CTR_OP_OCT__FILE_EXIST_BYTES 80
#define CTR_OP_OCT__COPY_BYTES 82
#define CTR_OP_OCT__ADD_SHARE_BYTES 84
#define CTR_OP_OCT__DELETE_SHARE_BYTES 86
#define CTR_OP_OCT__COPY_DONE_BYTES 88
#define CTR_OP_OCT__CLOSE_APP_FILES_BYTES 90
#define CTR_OP_OCT__CLOSE_BYTES 92
#define CTR_OP_OCT__ATTRIBUTES_BYTES 94
#define CTR_OP_OCT__ACLS_BYTES 96
#define CTR_OP_OCT__ACLS_DATA_BYTES 98
#define CTR_OP_OCT__BACKUPWRITE_BYTES 100
#define CTR_OP_OCT__BACKUPEND_BYTES 102
#define CTR_OP_OCT__CREATE_BYTES 104
#define CTR_OP_OCT__ACLS_TEXT_BYTES 106
#define CTR_OP_OCT__SYNC_COPY_BYTES 108
#define CTR_OP_OCT__SET_COMPRESSION_BYTES 110
#define CTR_OP_OCT__FILE_HEADER_BYTES 112
#define CTR_OP_OCT__SYNC_COPY_DONE_BYTES 114
#define CTR_OP_OCT__DFS_CMD_BYTES 116
// server counters
#define CTR_OP_SENT_TO_TARGET 118
#define CTR_OP_RECEIVED 120
#define CTR_BYTES_SENT_TO_TARGET 122
#define CTR_BYTES_RECEIVED 124

#define OCTOPUSSPEC 126
#define OCTOPUSSITE 128
