program kweights;
{
PURPOSE:        Collect weights for NASA-TLX.
                Presents 15 pairs of scale titles.
                Keyboard is used to collect subject choices.
INPUT FILE:     DEFAULT (infofile) contains:  subject, filename,
                condition, replication.   Last line must
                not be changed.
OUTPUT FILE:    Datafile (filename given by user, program
                adds .WGT extension) contains weights (numbers
                from 0 to 1) for each scale, identified by
                subject, condition, replication.
ENVIRONMENT:    IBM-PC compatible microcomputer;
                Turbo Pascal 3.0
HISTORY:        v. 1.0  Sept. 1986.  Author:  Walter Johnson
}
type
  namearray = array[1..19] of char;
  names = array[1..7] of namearray;
  line = string[80];
  ordertype = array[1..36] of integer;

const
  scalename : names = ('  mental demands   ','  physical demands ',
                       '  temporal demands ','       effort      ',
                       '    performance    ','    frustration    ',
                       '  overall workload ');
  blanks : line =
  '                                                                          ';
var
 pair : array[1..36,1..2] of integer;
 total : array[1..6] of integer;
 items,size : integer;
 orderfile : ordertype;
 weight : array[1..6] of real;
 Overall_Scale : char;
 infofile,datafile : text;
 filename : string[14];
 Condition,Replication,Subject : string[3];

Procedure Get_file;
var
 Filename, Nfilename : string[80];
 Nsubject,NReplication,Ncondition : string[80];
 old,Done : Boolean;
 icond : string[3];
 dum : char;
 ireplication,isubject,krep,ksub,i,j,
 IResult,Areplication,Asubject,Result : Integer;

Begin
 old := false;
 repeat
  ClrScr;
  if old=true then begin
   writeln('This file already contains weights for this condition and ');
   writeln(' replication for this subject.  Please reenter ');
  end;
  old := false;
  Assign(infofile,'default');
  Reset(infofile);
  for j := 1 to 5 do readln(infofile);  { read past header }
  Readln(infofile,Subject);
  Readln(infofile,Filename);
  Readln(infofile,Condition);
  Readln(infofile,Replication);
  Readln(infofile,Overall_Scale);


  Writeln('If Filename ',Filename,' is not OK enter new filename ');
  Write('( up to 10 characters, no extension): ');
  repeat
   Readln(con,Nfilename);
   Nfilename := Concat(Nfilename,'.wgt');
   If Length(Nfilename) > 14 then writeln('Filename too long, please re-enter') else
   If Length(Nfilename) > 4 then Filename := Nfilename else
   Filename := Concat(Filename,'.wgt');
   If Length(Nfilename) < 14 then begin
    Assign(datafile,filename);
    {$I-} Reset(datafile) {$I+};
    IResult := IOResult;
    If IResult > 1 then writeln('Unusable filename, please use another');
   end;
  until (Length(Nfilename) < 14) and (IResult < 2);


  Write('If Subject ',Subject,' is not OK, enter new subject number (1 or 2 digits): ');
  Done := false;
  repeat
   Readln(con,Nsubject);
   If Length(Nsubject) > 0 then begin
    Val(Nsubject,Asubject,Result);
    If Result <> 0 then
    writeln('Subject number not an integer, please re-enter') else
    If Asubject > 99 then writeln('Subject # too big, please re-enter') else
    begin Subject := Nsubject; Done := true; end;
   end else Done := true;
  until Done;

  Write('If Condition: ',Condition,' not ok then enter new three character code ');
  repeat
   Readln(con,Ncondition);
   If (Length(Ncondition) <> 3) and (Length(Ncondition) <> 0) then
    writeln('Condition Code not 3 characters, please re-enter') else
   If Length(Ncondition) > 0 then begin
    Condition := '   ';
    Condition := Ncondition;
   end;
  until (Length(Ncondition)=0) or (Length(Ncondition)=3);




  Write('If Replication ',Replication,' is not OK, enter new replication number (1 or 2 digits): ');
  Done := false;
  repeat
   Readln(con,Nreplication);
   If Length(Nreplication) > 0 then begin
    Val(Nreplication,Areplication,Result);
    If Result <> 0 then
     writeln('Replication number not an integer, please re-enter') else
     If Areplication > 99 then writeln('Replication # too big, please re-enter') else
     begin Replication := Nreplication; Done := true; end;
   end else Done := true;
  until Done;


  if IRESULT = 1 then
  begin
   writeln('New weighting file');
   rewrite(datafile);
   Delay(1000);
  end else
  begin
   Val(subject,ksub,result);
   Val(replication,krep,result);
   repeat
    readln(datafile,isubject,dum,icond,ireplication);
    if ((isubject=ksub) and (icond=condition) and (ireplication=krep))
    then Old := true;
   until eof(datafile);
   if old = false then Append(datafile) else Close(datafile);
  end;


  Rewrite(infofile);
  writeln(infofile,'DEFAULT.  NASA-TLX default values for subject,');
  writeln(infofile,' output filename, condition, replication.  Last');
  writeln(infofile,' line is 0 if 6 rating scales are used, 1 if');
  writeln(infofile,' overall workload is also used.');
  writeln(infofile,'DO NOT ADD OR REMOVE LINES OR ADD COMMENTS!');
  writeln(infofile,subject);
  writeln(infofile,Copy(Filename,1,Length(Filename)-4));
  writeln(infofile,Condition);
  writeln(infofile,replication);
  writeln(infofile,Overall_Scale);
  Close(infofile);
 until old=false;
end;




Procedure Randomize(Var ordering : ordertype; size : integer);
Var
 i,k,num : integer;

Begin
 num := 1;
 for i := 1 to size do ordering[i] := 0;
 repeat
  repeat k := Random(size) until ordering[k+1] = 0;
  ordering[k+1] := num;
  num := succ(num);
 until num > size;
End;






Procedure Get_Order;
var
 i,j,index : integer;

Begin
 items := 6;
 size := round(items*(items-1)/2.0);
 Randomize(orderfile,size);
 index := 0;
 for i := 1 to items do begin
  for j := i+1 to items do begin
   index := succ(index);
   if random < 0.5 then begin
    pair[orderfile[index],1] := i;
    pair[orderfile[index],2] := j;
   end else begin
    pair[orderfile[index],1] := j;
    pair[orderfile[index],2] := i;
   end;
  end;
 end;
End;


Procedure Get_Tallies;
var
 a,b,result,i,select : integer;
 chselect : char;

Begin
 for i := 1 to 6 do total[i] := 0;
 ClrScr;
 writeln('Which scale (1 or 2) was a more important contributor to workload for you');
 for i := 1 to size do begin
  GotoXY(24,8); writeln('1      ',scalename[pair[i,1]]);
  GotoXY(24,15); writeln('2      ',scalename[pair[i,2]]);
  GotoXY(1,2);
  writeln(blanks);
  GotoXY(1,2);
  readln(con,chselect);
  if not(chselect in ['1','2'] )then begin
   repeat
    GotoXY(1,1);
    writeln(blanks);
    GotoXY(1,1);
    writeln('You did not select 1 or 2, try again ');
    GotoXY(38,1);
    readln(con,chselect);
   until chselect in ['1','2'];
   GotoXY(1,1);
   writeln('Which (1 or 2) is the more important workload dimension for you ');
  end;
  Val(chselect,select,result);
  total[pair[i,select]] := total[pair[i,select]] + 1;
 end;
 val(subject,a,result);
 val(replication,b,result);
 write(datafile,a:4,' ',condition,b:4);
 for i := 1 to 6 do begin
  weight[i] := round(total[i])/round(size);
  write(datafile,'  ',weight[i]:5:3);
 end;
 writeln(datafile);
 Close(datafile);
End;


Begin
 Get_File;
 writeln('after get_file');
 Get_Order;
 Get_Tallies;
 ClrScr;
End.
