program kratings;
{
PURPOSE:     Collect ratings for NASA-TLX.
             Presents 6 scales, uses keyboard to get subject's
             rating on each scale.
INPUT FILE:  DEFAULT (infofile) contains:  subject, filename,
             condition, replication, and 0 (which sets up
             default condition in which overall workload
             is not collected; 1 would cause overall
             workload to be collected, in addition).
OUTPUT FILE: Datafile (filename given by user,
             extension .RAT given by program) contains ratings
             for each scale--numbers from 0-100--
             identified by subject, condition, replication.
ENVIRONMENT: IBM-PC compatible microcomputer;
             Turbo Pascal v. 3.0;
             IBM-PC color graphics card or compatible
HISTORY:     v. 1.0 Sept. 1986; Author:  Walter Johnson
}
{$I graph.p}
type
  names = array[1..7] of string[19];
  line = string[80];

const
  scalename : names = ('     mental demands','   physical demands',
                       '   temporal demands','             effort',
                       '        performance','        frustration',
                       '   overall workload');
  on =  1;
  off = 0;
  blanks : line =
  '                                                                          ';
  left = 250;
  right = 550;

var
  scale_value : array[1..7] of integer;
  infofile,
  datafile : text;
  Condition,Replication,Subject : string[3];
  Filename : string[10];
  Overall_Scale : integer;



Procedure GetFile;
var
 Filename, Nfilename : string[80];
 Nsubject,NReplication,Ncondition : string[80];
 old,Done : Boolean;
 icond : string[3];
 dum : char;
 ireplication,isubject,krep,ksub,
 j,i,Areplication,Asubject,IResult,Result : Integer;

Begin
 old := false;
 repeat
  ClrScr;
  if old=true then begin
   writeln('A rating for this condition/replication combination');
   writeln('exists in this file, please choose another combination');
  end;
  old := false;
  Assign(infofile,'default');
  Reset(infofile);
  for j := 1 to 5 do readln (infofile); { read past header }
  Readln(infofile,Subject);
  Readln(infofile,Filename);
  Readln(infofile,Condition);
  Readln(infofile,Replication);
  Readln(infofile,Overall_Scale);
  Close(infofile);


  Writeln('If filename ',Filename,' is not OK enter new filename ');
  Write(' (up to 10 characters, no extension): ');
  repeat
    Readln(con,Nfilename);
    Nfilename := Concat(Nfilename,'.rat');
    If Length(Nfilename) > 14 then
    writeln('Filename too long, please re-enter') else
    If Length(Nfilename) > 4 then Filename := Nfilename
    else Filename := Concat(Filename,'.rat');
    If Length(Nfilename) < 14 then begin
     Assign(datafile,filename);
     {$I-} Reset(datafile) {$I+};
     IResult := IOResult;
     If IResult > 1 then Close(datafile);
    end;
  until (Length(Nfilename) < 14) and (IResult < 2);



  Write('If Subject ',Subject,' is not OK, enter new subject number (1 or 2 digits): ');
  Done := false;
  repeat
   Readln(con,Nsubject);
   If Length(Nsubject) > 0 then begin
    Val(Nsubject,Asubject,Result);
    If Result <> 0 then
    writeln('Subject number not an integer, please re-enter') else
    If Asubject > 99 then writeln('Subject # too big, please re-enter') else
    begin Subject := Nsubject; Done := true; end;
   end else Done := true;
  until Done;

  Write('If Condition ',Condition,' is not OK, enter new three character code: ');
  repeat
   Readln(con,Ncondition);
   If (Length(Ncondition) <> 3) and (Length(Ncondition) <> 0) then
    writeln('Condition Code not 3 characters, please re-enter') else
   If Length(Ncondition) > 0 then begin
    Condition := '   ';
    Condition := Ncondition;
   end;
  until (Length(Ncondition)=0) or (Length(Ncondition)=3);




  Write('If Replication ',Replication,' is not OK, enter new replication number (1 or 2 digits): ');
  Done := false;
  repeat
   Readln(con,Nreplication);
   If Length(Nreplication) > 0 then begin
    Val(Nreplication,Areplication,Result);
    If Result <> 0 then
     writeln('Replication number not an integer, please re-enter') else
     If Areplication > 99 then writeln('Replication # too big, please re-enter') else
     begin Replication := Nreplication; Done := true; end;
   end else Done := true;
  until Done;


  Rewrite(infofile);
  writeln(infofile,'DEFAULT.  NASA-TLX default values for subject,');
  writeln(infofile,' output filename, condition, replication.  Last');
  writeln(infofile,' line is 0 if 6 rating scales used, 1 if');
  writeln(infofile,' overall workload also used.');
  writeln(infofile,'DO NOT ADD OR REMOVE LINES OR ADD COMMENTS!');
  writeln(infofile,subject);
  writeln(infofile,Copy(Filename,1,Length(Filename)-4));
  writeln(infofile,Condition);
  writeln(infofile,replication);
  writeln(infofile,Overall_Scale:1);
  Close(infofile);

  If IResult = 0 then begin
   Val(subject,ksub,result);
   Val(replication,krep,result);
   for i := 1 to 3 do readln(datafile);
   repeat
    readln(datafile,isubject,dum,icond,ireplication);
    if ((isubject=ksub) and (icond=condition) and (ireplication=krep))
    then Old := true;
   until eof(datafile);
   if old = false then Append(datafile)
  end else begin
   old := false;
   Rewrite(datafile);
   Writeln(datafile,' FILENAME: ',filename);
   Write(datafile,' SUB CON REP  MD  PD  TD  EF  OP  FR');
   If Overall_Scale=1 then writeln('  OW') else writeln;
   Writeln(datafile);
  end;
  if old then Close(datafile);
  until old=false;
End;




Procedure BlankScale(y : integer);

Begin
 GraphWindow(left-2,y-7,right+2,y+7);
 FillScreen(Off);
 GraphWindow(0,0,639,199);
End;



Procedure BlankHeader;
var
 i : integer;

Begin
 GotoXY(1,2);
 for i := 1 to 4 do writeln(blanks);
 GotoXY(1,2);
End;

procedure drawline(y : integer);
var
  i,x  :  integer;

Begin
 Draw(left,y,right,y,on);
 for i := 0 to 20 do begin
  x := left + i*15;
  Draw(x,y-2,x,y+2,on);
 end;
End;



Procedure Drawit(i : integer);
var
 y : integer;

Begin
 y := round(i*16.450) + 43;
 BlankScale(y);
 Drawline(y);
End;

Procedure InitGraphics;

Begin
 HiRes;
 HiResColor(15);
 Palette(3);
End;


procedure draw_scales;
var
 i,y : integer;

Begin
 for i := 1 to 6+Overall_Scale do Drawit(i);
 Window(1,1,80,23);
 for i := 1 to 6+Overall_Scale do begin
  y := 6 + i*2;
  GotoXY(1,y);
  if i <> 5 then begin
   write(trm,scalename[i],'      Low');
   GotoXY(70,y);write(trm,'    High');
  end else begin
   write(trm,scalename[i],'     Good');
   GotoXY(70,y);write(trm,'    Poor');
  end;
 end;
End;


Procedure InitTurtle(y : integer; Var direction : char);

Begin
 PenUp;
 SetPosition(72,y);
 SetHeading(90);
 direction := 'q';
End;



Procedure GetRating(scale : integer; direction : char);
var
 a,b,i : integer;
 moved : Boolean;

Begin
 moved := false;
 repeat
  if keypressed then read(kbd,direction);
  Delay(15);
  if (ord(direction) = 75) and (xcor >= -77) then begin
   back(1); moved := true;
  end;
  if (ord(direction) = 77) and (xcor <= 223) then begin
   forwd(1); moved := true;
  end;
 until (ord(direction) = 80) and moved;

 Scale_value[scale] := Trunc(((xcor + 70.0)/3.0 + 2.0)/5.0) * 5 + 5;
 If Scale_value[scale] > 100 then Scale_value[scale] := 100;
 a := xcor + 327; b := 100 - ycor;
 for i := -1 to 1 do Draw(a-i,b-5,a-i,b+5,On);
End;



Procedure get_difficulty(scale : integer);
var
 direction : char;
 y : integer;

Begin
 BlankHeader;
 y := 100 - (round(scale*16.450) + 43);
 Writeln('Select the level of ',scalename[scale]);
 Writeln(' " left arrow " to move marker left, "right arrow" to move it right');
 Writeln(' "up arrow" to stop marker, "down arrow" to enter present marker value');
 InitTurtle(y,direction);
 ShowTurtle;
 GetRating(scale,direction);
 HideTurtle;
end;




Procedure Present_Scales;
var
 i,areplication,asubject,acode : integer;
 answer : char;

begin
 for i := 1 to 6 + Overall_Scale do begin
  get_difficulty(i);
 end;
 BlankHeader;
 val(subject,asubject,acode);
 val(replication,areplication,acode);
 writeln(datafile);
 write(datafile,asubject:4,' ',condition);
 write(datafile,areplication:4);
 for i := 1 to 6 + Overall_Scale do write(datafile,scale_value[i]:4);
 Close(datafile);
end;




begin {Main Procedure}
 ClrScr;
 GetFile;
 InitGraphics;
 draw_scales;
 present_scales;
 TextMode;
end.