
#include <time.h>
#include <sys/stat.h>

/* Change this path if your FTP implementation is different */

#define	_PATH_FTPUSERS		"/etc/ftpusers"

#ifndef	USHORT
#define	USHORT	unsigned short 
#endif
#ifndef	ULONG
#define	ULONG	unsigned int 
#endif

/* Function prototypes */

int ConnectToWindows ();
void ProcessMessages ();
void fsConfigure ();
void fsOpenFile ();
void fsCloseFile ();
void fsReadFile ();
void fsWriteFile ();
void fsFileSeek ();
void fsFindFirstFile ();
void fsFindNextFile ();
void fsFindClose ();
void fsFileAttributes ();
void fsFilePermissions ();
void fsDir ();
void fsDeleteFile ();
void fsRenameFile ();
void fsGetDiskInfo ();

void fsWriteMoveEOF ();
void ProcessDir ();
int MakeNativePath ();
int readn ();
int writen ();
int MetaMatch ();
int MatchStarsAndQMs ();
int FindSubPattern ();
int CheckForExtension ();
int CaseMatchDirectory ();
char *zstrupr ();
char *StripFileFromPath ();
int FindSubPattern ();
void NukeDotStar ();
USHORT MapWindowsError ();
int SetFilePosition ();

int NewMemoryHandle ();
void* GetMemoryByHandle ();
void DeleteMemoryHandle ();

int CompareAgainstMangled ();
int is_mangled ();
void mangle_name_83 ();
void InitDosCharMap ();

int IsTextFile ();
int TranslateTextFile ();

void ShutDown ();
void SigHandler ();

int MultiUserMode ();
int GetLoginString ();
int checkuser();
void AuthenticateUser ();
int DaemonMode ();
int DetachProcess ();
void Usage ();
void SigReadTimeout ();

int FillFileStatus ();
int ReadDirEntry ();
int UnChain ();


/* ZanNet defines */

#ifndef S_IRWXU
#define S_IRWXU 0x01C0
#endif
#ifndef	S_IRUSR
#define	S_IRUSR	0x0100
#endif
#ifndef	S_IWUSR
#define	S_IWUSR	0x0080
#endif
#ifndef	S_IXUSR
#define	S_IXUSR	0x0040
#endif

#ifndef S_IRWXG
#define S_IRWXG 0x0038
#endif
#ifndef	S_IRGRP
#define	S_IRGRP	0x0020
#endif
#ifndef	S_IWGRP
#define	S_IWGRP	0x0010
#endif
#ifndef	S_IXGRP
#define	S_IXGRP	0x0008
#endif

#ifndef S_IRWXO
#define S_IRWXO 0x0007
#endif
#ifndef	S_IROTH
#define	S_IROTH	0x0004
#endif
#ifndef	S_IWOTH
#define	S_IWOTH	0x0002
#endif
#ifndef	S_IXOTH
#define	S_IXOTH	0x0001
#endif

#ifndef LOG_FTP
#define LOG_FTP LOG_DAEMON
#endif

#ifndef AYT
#define AYT			246
#endif
#ifndef IAC
#define IAC		 	255
#endif

#define ZANNET_VERSION_MAJOR	1
#define ZANNET_VERSION_MINOR	8121
#define ZANNET_VERSION_ACK		(ZANNET_VERSION_MINOR + 100)

#define	TRUE	1
#define FALSE	0

#define isdoschar(c) (dos_char_map[(c&0xff)] != 0)

/* Don't change the below strings! (the client will break) */

#define	ZANNET_CONNECT_STRING	"CONNECT"
#define ZANNET_LOGIN_STRING		"ZanNet login: "
#define ZANNET_LOGIN_PASSWORD	"Password: "
#define ZANNET_LOGIN_WELCOME	"Welcome to the ZanNet server >"
#define ZANNET_KEEPALIVE_STR	"[ZanNet Running]\n\n"

#define	ZANNET_MAX_READDIRS		1000

#define	ZANNET_MAX_TEXTCHARS	65536

#define	ZANNET_MAX_PORTTRIES	100

#ifndef _POSIX_PATH_MAX
#define _POSIX_PATH_MAX         255
#endif

#ifndef MAX_PATH
#define	MAX_PATH	_POSIX_PATH_MAX
#endif

#ifndef ESTALE
#define ESTALE		52
#endif

#define MAX_ERRORS ESTALE

/* Windows File System Operations */

#define	FS_MIN				FS_OPENFILE

#define FS_OPENFILE			0x5A32
#define	FS_CLOSEFILE		0x5A33
#define	FS_READFILE			0x5A34
#define	FS_WRITEFILE		0x5A35
#define	FS_FILESEEK			0x5A36
#define	FS_FINDFIRSTFILE	0x5A37
#define	FS_FINDNEXTFILE		0x5A38
#define	FS_FINDCLOSE		0x5A39
#define	FS_DELETEFILE		0x5A3A
#define	FS_DIR				0x5A3B
#define	FS_RENAMEFILE		0x5A3C
#define	FS_FILEATTRIBUTES	0x5A3D
#define	FS_GETDISKINFO		0x5A3E
#define	FS_LOCKFILE			0x5A3F

#define	FS_CONNNECTED		0x5A4F
#define	FS_CONFIGURE		0x5A50
#define	FS_PERMISSIONS		0x5A51

#define	FS_MAX				FS_PERMISSIONS

#define	ZANSERV_IN_BUFFER_SIZE		16384 + 1024 
#define	ZANSERV_OUT_BUFFER_SIZE		16384 + 1024

#define ERROR_OPEN_FAILED                110L

/* 
* Structures for protocol
*
* Note: Structure alignment must be 4 bytes
*/

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
} winio_generic;

/*
* The following are Windows request and ack structures 
*/

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	int		iFileHandle;
	char	Path[4];	/* more data after this */
} fs_close;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	short   rc;
	short	pad;
} fs_closeAck;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulAttribs;	/* has wildcards */
	short	sPathLen;
	short	pad;
	char	Path[4];	/* more data after this */
} fs_deletefile;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	short	rc;
	short	pad;
} fs_deletefileAck;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	ULONG	ulAttribs;
	short	sPathLen;
	char	Path[2];	/* more data after this */
} fs_dir;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	short	rc;
	short	pad;
	short	sPathLen;
	char	Path[2];	/* more data after this */
} fs_dirAck;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	ULONG	ulAttribs;
	time_t	NativeTime;
	short	sPathLen;
	short	pad;
	char	Path[4];	/* more data after this */
} fs_fileattributes;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	ULONG	ulAttribs;
	time_t	NativeTime;
	ULONG	ulFileSize;
	short	rc;
	short	pad;
} fs_fileattributesAck;

#define	ZANSERV_GET_ALL_PERMS		0x00000001
#define	ZANSERV_SET_PERMISSIONS		0x00000002
#define	ZANSERV_SET_OWNER			0x00000004
#define	ZANSERV_SET_GROUP			0x00000008
#define	ZANSERV_SET_TEXT			0x00000010
#define ZANSERV_UNIX_TEXT			0x00000020
#define ZANSERV_WINDOWS_TEXT		0x00000040

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	ULONG	ulPermissions;
	short	pad;
	short	sPathLen;
	short	sGroupLen;
	short	sOwnerLen;
	char	PathGroupOwner[4];	/* more data after this */
} fs_filepermissions;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	ULONG	ulPermissions;
	short	rc;
	short	pad;
	short	sGroupLen;
	short	sOwnerLen;
	char	GroupOwner[4];	/* more data after this */
} fs_filepermissionsAck;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	int		iFileHandle;
	int		lSeekOffset;
} fs_fileseek;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	int		lSeekOffset;
	short	rc;
	short	pad;
} fs_fileseekAck;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	int		iFindHandle;
} fs_findclose;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	short	rc;
	short	pad;
} fs_findcloseAck;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulAttrib;	/* has wildcards */
	ULONG	ulRetBufLen;
	short	sPathLen;
	short	pad;
	char	Path[2];	/* more data after this */
} fs_findfirstfile;

typedef struct {
	ULONG	ulAttrib;
	time_t	tCreate;
	time_t	tLastAccess;
	time_t	tLastWrite;
	ULONG	ulFileSize;
	short	sFileNameLen;
	short	pad;
	char	FileName[4];
} fs_findfileinfo;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	int		iFindContext;
	short	rc;
	USHORT	sNumberOfFiles;
	ULONG	ulRetBufLen;
	fs_findfileinfo	FindFiles;
} fs_findfirstfileAck;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;	/* has wildcards */
	int		iFindHandle;
	ULONG	ulRetBufLen;
	short	sPathLen;
	short	pad;
	char	Path[4];	/* more data after this */
} fs_findnextfile;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	short	rc;
	USHORT	sNumberOfFiles;
	ULONG	ulRetBufLen;
	fs_findfileinfo	FindFiles;
} fs_findnextfileAck;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
} fs_getdiskinfo;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	ULONG	ulDiskSpaceUsedBytes;
	short	rc;
	short	pad;
} fs_getdiskinfoAck;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	int		iFileHandle;
	ULONG	ulLockLength;
	ULONG	ulLockOffset;
} fs_lockfile;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	short	rc;
	short	pad;
} fs_lockfileAck;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	ULONG	ulAttribs;
	USHORT	usOptions;
	short	sPathLen;
	char	Path[4];	/* more data after this */
} fs_openfile;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	ULONG	ulAttribs;
	int		iFileHandle;
	time_t	LastAccess;
	ULONG	ulSize;
	short	rc;
	USHORT	usAction;
} fs_openfileAck;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	int		iFileHandle;
	int		iLength;
	int		lPosition;
} fs_readfile;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	int		iLength;
	int		lPosition;
	short	rc;
	short	pad;
	char	Data[4];
} fs_readfileAck;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulAttribs;	/* has wildcards */
	short	sPathLen1;
	short	sPathLen2;
	char	Paths[4];	/* more data after this */
} fs_renamefile;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	short	rc;
	short	pad;
} fs_renamefileAck;

#define	ZANSERV_FSWRITE_MOVE_EOF	0x00000001

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	int		iFileHandle;
	int		iLength;
	int		lPosition;
	char	WriteData[4];
} fs_writefile;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	int		iBytesWritten;
	int		lPosition;
	short	rc;
	short	pad;
} fs_writefileAck;

#define	ZANSERV_DEBUG_ON		0x00000001
#define	ZANSERV_SHUTDOWN		0x00000002
#define	ZANSERV_DEBUG_OFF		0x00000004
#define	ZANSERV_NEW_HOME		0x00000008
#define	ZANSERV_MAX_READDIRS	0x00000010
#define	ZANSERV_ATTRIBS			0x00000020
#define	ZANSERV_PING			0x00000040
#define	ZANSERV_KEEP_ALIVE		0x00000080
#define	ZANSERV_DEFAULT_HOME	0x00000100


typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	ULONG	ulFlags;
	ULONG	ulServerDefaultAttribs;
	ULONG	ulMaxReaddirs;
	short	sPathLen;
	short	pad;
	char	HomePath[4];	/* more data after this */

} fs_configure;

typedef struct {
	USHORT	usType;
	USHORT	usLen;
	ULONG	ulKey;
	USHORT	usVersionMajor;
	USHORT	usVersionMinor;
	ULONG	rc;

} fs_configureAck;

/* Memory object for memory linked list */

typedef struct _zn_memoryObject 
{
	void	*pvMem;
	int		handle;
	struct	_zn_memoryObject *pNext;

} zn_memoryObject;

/* 
* File object for file linked list. Note: this structure is variable length
* depending on the file name size--make sure it is allocated properly!!! 
*/

typedef struct _zn_fileObject
{
	struct	_zn_fileObject *pNext;

	fs_findfileinfo		FileInfo;

} zn_fileObject;


typedef struct _zn_DirectoryList
{
	zn_fileObject	*pFileList;

	void			*pDir;

} zn_DirectoryList;



/*********************** Windows IFS stuff **************************/

/* This section contains a condensed version of the 
Windows DDK file ifs.h and winerror.h */

#define NO_ERROR						 0L
#define ERROR_INVALID_FUNCTION           1L
#define ERROR_FILE_NOT_FOUND             2L
#define ERROR_INVALID_HANDLE             6L
#define ERROR_DEV_NOT_EXIST              55L
#define ERROR_UNEXP_NET_ERR              59L
#define ERROR_DISK_FULL                  112L
#define ERROR_ACCESS_DENIED              5L
#define ERROR_INVALID_ADDRESS            487L
#define ERROR_NETWORK_BUSY               54L
#define ERROR_FILE_EXISTS                80L
#define ERROR_DIRECTORY                  267L
#define ERROR_DIR_NOT_EMPTY              145L
#define ERROR_BAD_ARGUMENTS              160L
#define ERROR_TOO_MANY_OPEN_FILES        4L
#define ERROR_SEEK_ON_DEVICE             132L
#define ERROR_BROKEN_PIPE                109L
#define ERROR_POSSIBLE_DEADLOCK          1131L
#define ERROR_NOT_READY                  21L
#define ERROR_WRITE_PROTECT              19L
#define ERROR_NOT_DOS_DISK               26L
#define ERROR_LOCK_VIOLATION             33L
#define ERROR_PATH_NOT_FOUND             3L
#define ERROR_GEN_FAILURE                31L
#define ERROR_READ_FAULT                 30L
#define ERROR_WRITE_FAULT                29L
#define ERROR_NO_MORE_FILES              18L
#define ERROR_BAD_PATHNAME               161L
#define ERROR_ALREADY_EXISTS             183L
#define ERROR_INVALID_PARAMETER          87L    


/** FS_CLOSEFILE **/

#define CLOSE_HANDLE		0		/* only closing a handle */
#define CLOSE_FOR_PROCESS	1		/* last close of SFN for this process */
#define CLOSE_FINAL			2		/* final close of SFN for system */

#define FILE_NO_LAST_ACCESS_DATE	0x01	/* do not update last access date */
#define FILE_CLOSE_FOR_LEVEL4_LOCK	0x02	/* special close on a level 4 lock */
#define FILE_COMMIT_ASYNC			0x04	/* commit async instead of sync */

/** FS_DIR **/

#define CREATE_DIR		0
#define DELETE_DIR		1
#define CHECK_DIR		2
#define QUERY83_DIR		3
#define QUERYLONG_DIR	4

/** FS_LOCKFILE **/

#define LOCK_REGION		0			/* lock specified file region */
#define UNLOCK_REGION	1			/* unlock region */

#define LOCKF_MASK_RDWR	0x01	/* Read / write lock flag */
#define LOCKF_WR		0x00	/* bit 0 clear - write lock */
#define LOCKF_RD		0x01	/* bit 0 set - read lock(NW only) */

#define LOCKF_MASK_DOS_NW	0x02	/* DOS/Netware style lock flag */
#define LOCKF_DOS			0x00	/* bit 1 clear - DOS-style lock */
#define LOCKF_NW			0x02	/* bit 1 set - Netware-style lock */

/** FS_ENUMERATEHANDLE **/

#define ENUMH_GETFILEINFO	0		/* get fileinfo by handle */
#define ENUMH_GETFILENAME	1		/* get filename associated with handle */
#define ENUMH_GETFINDINFO	2		/* get info for resuming */
#define ENUMH_RESUMEFIND	3		/* resume find operation */
#define ENUMH_RESYNCFILEDIR	4		/* resync dir entry info for file */

#define RESYNC_INVALIDATEMETACACHE	0x01	/* invalidate meta cache on resync */


/** FS_FILEATTRIBUTES **/

#define GET_ATTRIBUTES					0	/* get attributes of file/dir         */
#define SET_ATTRIBUTES					1	/* set attributes of file/dir         */
#define GET_ATTRIB_COMP_FILESIZE		2	/* get compressed size of file        */


/** FS_FILEDATATIME **/

#define SET_ATTRIB_MODIFY_DATETIME		3	/* set date last written of file/dir  */ 
#define GET_ATTRIB_MODIFY_DATETIME		4 	/* get date last written of file/dir  */ 
#define SET_ATTRIB_LAST_ACCESS_DATETIME	5 	/* set date last accessed of file/dir */   
#define GET_ATTRIB_LAST_ACCESS_DATETIME	6	/* get date last accessed of file/dir */  
#define SET_ATTRIB_CREATION_DATETIME	7	/* set create date of file/dir        */
#define GET_ATTRIB_CREATION_DATETIME	8	/* get create date of file/dir        */

/** FS_GETDISKINFO **/

#define GDF_NORMAL			0x00	/* walk disk, if needed, to get free space */
#define GDF_NO_DISK_HIT		0x01	/* return current "hint", don't walk disk */

#define GET_MODIFY_DATETIME			0	/* get last modification date/time */
#define SET_MODIFY_DATETIME			1	/* set last modification date/time */
#define GET_LAST_ACCESS_DATETIME	4	/* get last access date/time */
#define SET_LAST_ACCESS_DATETIME	5	/* set last access date/time */
#define GET_CREATION_DATETIME		6	/* get creation date/time */
#define SET_CREATION_DATETIME		7	/* set creation date/time */

/** FS_FILESEEK **/

#define FILE_BEGIN	0				/* absolute posn from file beginning */
#define FILE_END	2				/* signed posn from file end */

/** FS_READFILE, FS_WRITEFILE **/

#define R0_NO_CACHE				0x0100	/* must not cache reads/writes */
#define R0_SWAPPER_CALL			0x1000	/* called by the swapper */
#define R0_MM_READ_WRITE		0x8000	/* indicates this is a MMF R0 i/o */
#define R0_SPLOPT_MASK			0xFF00	/* mask for ring 0 special options */

/** FS_OPENFILE **/

#define ACCESS_MODE_MASK	0x0007	/* Mask for access mode bits */
#define ACCESS_READONLY		0x0000	/* open for read-only access */
#define ACCESS_WRITEONLY	0x0001	/* open for write-only access */
#define ACCESS_READWRITE	0x0002	/* open for read and write access */
#define ACCESS_EXECUTE		0x0003	/* open for execute access */

#define SHARE_MODE_MASK		0x0070	/* Mask for share mode bits */
#define SHARE_COMPATIBILITY 0x0000	/* open in compatability mode */
#define SHARE_DENYREADWRITE 0x0010	/* open for exclusive access */
#define SHARE_DENYWRITE		0x0020	/* open allowing read-only access */
#define SHARE_DENYREAD		0x0030	/* open allowing write-only access */
#define SHARE_DENYNONE		0x0040	/* open allowing other processes access */
#define SHARE_FCB			0x0070	/* FCB mode open */

#define ACTION_MASK				0xff	/* Open Actions Mask */
#define ACTION_OPENEXISTING		0x01	/* open an existing file */
#define ACTION_REPLACEEXISTING	0x02	/* open existing file and set length */
#define ACTION_CREATENEW		0x10	/* create a new file, fail if exists */
#define ACTION_OPENALWAYS		0x11	/* open file, create if does not exist */
#define ACTION_CREATEALWAYS		0x12	/* create a new file, even if it exists */

#define ACTION_EXISTS_OPEN		0x01	// BIT: If file exists, open file
#define ACTION_TRUNCATE			0x02	// BIT: Truncate file
#define ACTION_NEXISTS_CREATE	0x10	// BIT: If file does not exist, create

#define OPEN_FLAGS_NOINHERIT	0x0080
#define OPEN_FLAGS_NO_CACHE		R0_NO_CACHE /* 0x0100 */
#define OPEN_FLAGS_NO_COMPRESS	0x0200
#define OPEN_FLAGS_ALIAS_HINT	0x0400
#define OPEN_FLAGS_NOCRITERR	0x2000
#define OPEN_FLAGS_COMMIT		0x4000
#define OPEN_FLAGS_REOPEN		0x0800	/* file is being reopened on vol lock */

#define ACTION_OPENED		1		/* existing file has been opened */
#define ACTION_CREATED		2		/* new file has been created */
#define ACTION_REPLACED		3		/* existing file has been replaced */

/** FS_SEARCHFILE **/

#define SEARCH_FIRST		0		/* findfirst operation */
#define SEARCH_NEXT			1		/* findnext operation */

/** FS_DELETFILE, FS_FILEATTRIBUTES, FS_FINDFIRSTFILE, FS_FINDNEXTFILE,
    FS_RENAMEFILE  **/ 

#ifndef FILE_ATTRIBUTE_READONLY
#define FILE_ATTRIBUTE_READONLY		0x01	/* read-only file */
#endif

#ifndef FILE_ATTRIBUTE_HIDDEN
#define FILE_ATTRIBUTE_HIDDEN		0x02	/* hidden file */
#endif

#ifndef FILE_ATTRIBUTE_SYSTEM
#define FILE_ATTRIBUTE_SYSTEM		0x04	/* system file */
#endif

#ifndef FILE_ATTRIBUTE_LABEL
#define FILE_ATTRIBUTE_LABEL		0x08	/* volume label */
#endif

#ifndef FILE_ATTRIBUTE_DIRECTORY
#define FILE_ATTRIBUTE_DIRECTORY	0x10	/* subdirectory */
#endif

#ifndef FILE_ATTRIBUTE_ARCHIVE
#define FILE_ATTRIBUTE_ARCHIVE		0x20	/* archived file/directory */
#endif


#define FILE_ATTRIBUTE_DEVICE		0x40	/* device */

#define FILE_ATTRIBUTE_MUSTMATCH	0x00003F00	/* 00ADVSHR Must Match */
#define FILE_ATTRIBUTE_EVERYTHING	0x0000003F	/* 00ADVSHR Find Everything */
#define FILE_ATTRIBUTE_INTERESTING	0x0000001E	/* 000DVSH0 Search bits */

#define	FIND_FLAG_PRI_NAME_LOSS			0x0001
#define	FIND_FLAG_ALT_NAME_LOSS			0x0002

#define FILE_FLAG_WILDCARDS	0x80000000	/* set if wildcards in name */
#define FILE_FLAG_HAS_STAR	0x40000000	/* set if *'s in name (PARSE_WILD also set) */
#define FILE_FLAG_LONG_PATH	0x20000000	/* set if any path element is not 8.3 */
#define FILE_FLAG_KEEP_CASE	0x10000000	/* set if FSD should use ir_uFName */
#define FILE_FLAG_HAS_DOT	0x08000000	/* set if last path element contains .'s */
#define FILE_FLAG_IS_LFN	0x04000000	/* set if last element is LFN */

